package com.tenqube.visual_scraper.request_interface.login;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.ValueCallback;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.tenqube.visual_scraper.R;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.utils.LogUtil;

import java.util.Timer;
import java.util.TimerTask;

import static com.tenqube.visual_scraper.utils.LogUtil.LOGI;

/**
 * Created by tenqube on 2018. 5. 18..cw.jeon
 */

public class WebViewLogin implements LoginRequest {
    private LoginRequest.OnResponse mResponse;
    private static ParsingRuleData mParsingRuleData;
    private ViewGroup viewGroup;
    private Handler handler;
    private WebView webView;
    private View webViewLayout;
    private boolean usedLoginScript;
    private boolean isLoginSuccess;
    private static final long TiMEOUT_TIMEMILLIS = 10000;
    private static WebViewLogin mInstance = null;
    private Timer timer;
    private TimerTask timerTask;
    private Activity mActivity;
    private static final String TAG = LogUtil.makeLogTag(WebViewLogin.class);

    @SuppressLint({"AddJavascriptInterface", "SetJavaScriptEnabled"})
    private WebViewLogin(Activity activity, ParsingRuleData parsingRuleData) {
        mParsingRuleData = parsingRuleData;
        mActivity = activity;
        this.handler = new Handler();

        init(activity);
    }

    public static WebViewLogin getInstance(Activity activity, ParsingRuleData parsingRuleData) {
        if (mInstance == null)
            mInstance = new WebViewLogin(activity, parsingRuleData);
        else {
            mInstance.init(activity);
            mParsingRuleData = parsingRuleData;
        }
        return mInstance;
    }

    private void init(final Activity activity) {

        this.timer = new Timer();
        this.timerTask = new TimerTask() {
            @Override
            public void run() {
                closeWebView();
                usedLoginScript = false;
                mResponse.onLoginFail(403, Constants.MESSAGES.TIMEOUT_FAIL);
            }
        };
        this.viewGroup = (ViewGroup) activity.getWindow().getDecorView().getRootView();


        LayoutInflater inflater = (LayoutInflater) activity.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        if (inflater != null) {
            webViewLayout = inflater.inflate(R.layout.web_view_layout, null);
            viewGroup.addView(webViewLayout);

            webView = webViewLayout.findViewById(R.id.visual_web_view);


            CookieManager.getInstance().setAcceptCookie(true);
            final CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
                CookieSyncManager.createInstance(activity);
            }
            cookieManager.setAcceptCookie(true);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                webView.getSettings().setSafeBrowsingEnabled(false);
            }
            webView.getSettings().setJavaScriptEnabled(true);
            webView.getSettings().setUserAgentString(Constants.USER_AGENT);
            webView.setWebViewClient(new WebViewClient() {
                @Override
                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);


                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                        LOGI(TAG, "예외코드개수 : " +mParsingRuleData.exceptScriptCode.size() +", 로그인 ddd스크립트 썻나 "+ usedLoginScript+" , 성공했나 "+ isLoginSuccess+ " , 기기등록 했나 "+PreferenceManager.getDefaultSharedPreferences(activity).getBoolean("usedExceptScriptCode", true));

                        if (usedLoginScript && cookieManager.getCookie(url) != null && mParsingRuleData.exceptScriptCode.size()==0) {
                            isLoginSuccess = invalidloginCheck(cookieManager.getCookie(url));

                            if (isLoginSuccess){
                                invalidUserLoginSuccess(cookieManager.getCookie(url));
                            }else{
                                invalidUserLoginFail();
                            }
                        }

                        //로그인 스크립트 실행
                        if (!usedLoginScript) {
                            setTimeout();
                            view.loadUrl(mParsingRuleData.webViewScriptCode, null);
                            usedLoginScript = true;

                            //예외화면 스크립트 실행
                        }
                        else if (mParsingRuleData.exceptScriptCode.size() > 0) {
                            view.loadUrl(mParsingRuleData.exceptScriptCode.get(0), null);
                            mParsingRuleData.exceptScriptCode.remove(0);
                            //로그인스크립트 초기화 플래그
                        }
                        else if (mParsingRuleData.exceptScriptCode.size() >= 0){
                            usedLoginScript = false;
                        }


                    }
                }


                //바뀐 페이지 로그


                @Override
                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                    return super.shouldOverrideUrlLoading(view, request);
                }
            });

        }
    }

    @Override
    public void doLogin() {
        try {


            handler.post(new Runnable() {
                @Override
                public void run() {
                    webView.loadUrl(mParsingRuleData.loginUrl);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    @Override
    public void setOnResponseCallbackListener(OnResponse responseCallbackListener) {
        this.mResponse = responseCallbackListener;

    }

    void closeWebView() {
        if (webView != null) {
            handler.post(new Runnable() {
                @Override
                public void run() {
                    webView.stopLoading();
                    webView.clearCache(true);
                    webView.clearHistory();


                    viewGroup.removeView(webViewLayout);
                    webViewLayout = null;
                    CookieManager cookieManager = CookieManager.getInstance();
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                        cookieManager.removeSessionCookies(new ValueCallback<Boolean>() {
                            @Override
                            public void onReceiveValue(Boolean value) {

                            }
                        });
                    } else {
                        cookieManager.removeSessionCookie();

                    }
                    cookieManager.removeAllCookie();


                }

            });
        }
    }

    private void invalidUserLoginFail() {
        new Thread(new Runnable() {
            @Override
            public void run() {

                mResponse.onLoginFail(403, Constants.MESSAGES.INVALID_USER_INFO);
            }
        }).start();
        cancelTimeout();
        closeWebView();
    }

    private void invalidUserLoginSuccess(final String cookie) {

        cancelTimeout();
        closeWebView();
        PreferenceManager
                .getDefaultSharedPreferences(mActivity)
                .edit()
                .putBoolean("usedExceptScriptCode", false)
                .apply();
        new Thread(new Runnable() {
            @Override
            public void run() {

                mResponse.onLoginSuccess(cookie);
            }
        }).start();
    }

    private boolean invalidloginCheck(final String cookie) {
        LOGI(TAG, cookie);
        for (String invalidKey : mParsingRuleData.validCookieKey) {
            if (!cookie.contains(invalidKey)) {
                return false;
            }

        }


        return true;

    }


    private void setTimeout() {
        if (timer!=null && timerTask!=null)
            timer.schedule(timerTask, TiMEOUT_TIMEMILLIS);
    }

    private void cancelTimeout() {
        if(timerTask != null){
            timerTask.cancel(); //타이머task를 timer 큐에서 지워버린다
            timerTask=null;
        }
        if(timer!=null){
            timer.cancel(); //스케쥴task과 타이머를 취소한다.
            timer.purge(); //task큐의 모든 task를 제거한다.
            timer=null;
        }

    }
}
