/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scraper;

import android.app.Activity;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.data.request_data.ScrapData;
import com.tenqube.visual_scraper.request_interface.login.ApiLogin;
import com.tenqube.visual_scraper.request_interface.login.LoginRequest;
import com.tenqube.visual_scraper.request_interface.login.WebViewLogin;
import com.tenqube.visual_scraper.request_interface.page.PageParser;
import com.tenqube.visual_scraper.request_interface.page.PurchaseRequest;
import com.tenqube.visual_scraper.request_interface.result.OnPurchaseResult;
import java.util.ArrayList;

public class ScrapingOnlineMall
implements LoginRequest.OnResponse,
PurchaseRequest.OnResponsePurchasePage {
    private PurchaseRequest mPurchaseRequest;
    private OnPurchaseResult mListener;
    private LoginRequest mLoginRequest;
    private String mCookie;
    public static Boolean SCRAPING_DEBUG_MODE = false;
    private static final String TAG = ScrapingOnlineMall.class.getSimpleName();

    public ScrapingOnlineMall(Activity activity, ParsingRuleData parsingRuleData, OnPurchaseResult listener, boolean debugMode) {
        SCRAPING_DEBUG_MODE = debugMode;
        this.mLoginRequest = parsingRuleData.isApiLogin == 0 ? new ApiLogin(parsingRuleData) : new WebViewLogin(activity, parsingRuleData);
        this.mListener = listener;
        this.mPurchaseRequest = new PageParser(this, parsingRuleData);
        this.mLoginRequest.setOnResponseCallbackListener(this);
    }

    public void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScrapingOnlineMall.this.mLoginRequest.doLogin();
            }
        }).start();
    }

    @Override
    public void onLoginSuccess(String cookie) {
        this.mCookie = cookie;
        this.mListener.onLoginSuccess("Success LoginPage");
        this.mListener.onPurchaseStart("Start scraping Purchase");
        this.mPurchaseRequest.doPurchasePageRequest(cookie);
    }

    @Override
    public void onLoginFail(int statusCode, String statusMessage) {
        this.mListener.onFail(statusCode, statusMessage);
    }

    @Override
    public void onPurchasePageResult(RequestDocumentData documents) {
        this.mListener.onPurchaseFinished("done", documents);
    }

    @Override
    public void onDetailPurchasePageResult(RequestDocumentData detailPurchaseDocuments) {
        this.mListener.onDetailPageScrapingFinished("done", detailPurchaseDocuments);
    }

    public void detailParsingStart(ArrayList<ScrapData> detailScrapDatas) {
        this.mListener.onDetailPageScrapingStart("Start scraping Purchase");
        this.mPurchaseRequest.doDetailPurchasePageRequest(this.mCookie, detailScrapDatas);
    }

    @Override
    public void onParsingFail(String message) {
        this.mListener.onFail(400, message);
    }
}

