/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.request_interface.page;

import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.request_data.RequestContent;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.data.request_data.ScrapData;
import com.tenqube.visual_scraper.request_interface.page.PurchaseRequest;
import com.tenqube.visual_scraper.scraper.ScrapingOnlineMall;
import com.tenqube.visual_scraper.utils.LogUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class PageParser
implements PurchaseRequest {
    private PurchaseRequest.OnResponsePurchasePage mListener;
    private ParsingRuleData mParsingRuleData;

    public PageParser(PurchaseRequest.OnResponsePurchasePage mListener, ParsingRuleData parsingRuleData) {
        this.mListener = mListener;
        this.mParsingRuleData = parsingRuleData;
    }

    private Connection.Response callGetRequest(String url, String cookie, Map<String, String> queryParams) {
        try {
            return Jsoup.connect((String)url).userAgent("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36").followRedirects(true).data(queryParams).timeout(6000).ignoreContentType(true).header("cookie", cookie).method(Connection.Method.GET).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Connection.Response callPostRequest(String url, String cookie, Map<String, String> postParams) {
        try {
            LogUtil.LOGI("PageParser", "REUQEST_URL" + url);
            LogUtil.LOGI("PageParser", "REUQEST_PARAMS" + postParams.toString());
            return Jsoup.connect((String)url).userAgent("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36").followRedirects(true).timeout(6000).ignoreContentType(true).header("cookie", cookie).method(Connection.Method.POST).data(postParams).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void doPurchasePageRequest(String cookie) {
        try {
            Connection.Response response;
            if (this.mParsingRuleData.purchaseMethodType == 0) {
                response = this.callGetRequest(this.mParsingRuleData.purchaseUrl, cookie, this.mParsingRuleData.purchaseParams);
                LogUtil.LOGI("PageParser", " get purchase BODY " + this.mParsingRuleData.purchaseParams.toString());
            } else {
                response = this.callPostRequest(this.mParsingRuleData.purchaseUrl, cookie, this.mParsingRuleData.purchaseParams);
                LogUtil.LOGI("PageParser", " post purchase BODY ");
            }
            if (response != null) {
                Document doc = response.parse();
                if (doc != null) {
                    RequestDocumentData requestDocumentData = new RequestDocumentData();
                    requestDocumentData.contents = new ArrayList();
                    RequestContent requestData = new RequestContent();
                    if (response.contentType().contains("application/json")) {
                        requestData.contentType = 1;
                        requestData.content = doc.select("body").html();
                    } else {
                        requestData.contentType = 0;
                        if (ScrapingOnlineMall.SCRAPING_DEBUG_MODE.booleanValue()) {
                            for (Element ele : doc.select(this.mParsingRuleData.purchaseDivCss)) {
                                LogUtil.LOGI("PageParser", "URL_ENCODED " + ele.html());
                            }
                        }
                        requestData.content = doc.select(this.mParsingRuleData.purchaseDivCss).outerHtml();
                    }
                    requestDocumentData.contents.add(requestData);
                    requestDocumentData.name = this.mParsingRuleData.name;
                    requestDocumentData.parsingType = 0;
                    LogUtil.LOGI("PageParser", " call URl " + response.url());
                    LogUtil.LOGI("PageParser", "purchase BODY ," + requestData.toString());
                    this.mListener.onPurchasePageResult(requestDocumentData);
                } else {
                    this.mListener.onParsingFail("request document null");
                }
            } else {
                this.mListener.onParsingFail("request response null");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doDetailPurchasePageRequest(String cookie, ArrayList<ScrapData> detailScrapData) {
        RequestDocumentData requestData = new RequestDocumentData();
        requestData.contents = new ArrayList();
        try {
            for (ScrapData scrapData : detailScrapData) {
                Connection.Response response = scrapData.methodType == 0 ? this.callGetRequest(scrapData.url, cookie, scrapData.params) : this.callPostRequest(scrapData.url, cookie, scrapData.params);
                if (response == null) continue;
                RequestContent requestContent = new RequestContent();
                Document detailPage = response.parse();
                requestContent.contentType = response.contentType().contains("application/json") ? 1 : 0;
                requestData.name = scrapData.name;
                requestData.parsingType = 1;
                if (detailPage == null) continue;
                requestContent.content = detailPage.select(scrapData.divCss).html();
                LogUtil.LOGI("PageParser", "purchase BODY ," + requestData.toString());
                requestData.contents.add(requestContent);
            }
            if (requestData.contents.size() > 0) {
                this.mListener.onDetailPurchasePageResult(requestData);
            } else {
                this.mListener.onParsingFail("Fail detail scraping");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void callParsingPurchase(ArrayList<ScrapData> detailScrapDatas) {
    }
}

