/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.table;

import android.content.ContentValues;
import android.database.Cursor;
import android.provider.BaseColumns;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.dto_data.DtoRuleData;
import com.tenqube.visual_scraper.db.table.AbstractTable;
import com.tenqube.visual_scraper.utils.LogUtil;
import com.tenqube.visual_scraper.utils.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class SyncRuleMallsTable
extends AbstractTable
implements BaseColumns {
    private static final String TAG = LogUtil.makeLogTag(SyncRuleMallsTable.class);
    public static final String TABLE_NAME = "sync_rule_malls";
    public static final String COLUMN_MALL_ID = "_id";
    public static final String COLUMN_MALL_NAME = "name";
    public static final String COLUMN_DISPLAY_NAME = "display_name";
    public static final String COLUMN_LOGIN_URL = "login_url";
    public static final String COLUMN_IS_API_LOGIN = "is_api_login";
    public static final String COLUMN_SCRIPT_CODE = "web_view_script_code";
    public static final String COLUMN_VALID_COOKIE_KEY = "valid_cookie_key";
    public static final String COLUMN_LOGIN_PARAMS = "login_params";
    public static final String COLUMN_EXCEPT_SCRIPT_CODE = "except_script_code";
    public static final String COLUMN_VERSION = "version";
    public static final String COLUMN_PURCHASE_URL = "purchase_url";
    public static final String COLUMN_PURCHASE_DIV_CSS = "purchase_div_css";
    public static final String COLUMN_PURCHASE_METHOD_TYPE = "purchase_method_type";
    public static final String COLUMN_PURCHASE_PURCHASE_PARAMS = "purchase_params";
    public static final String SQL_CREATE_TABLE = " CREATE TABLE IF NOT EXISTS sync_rule_malls(_id INTEGER  PRIMARY KEY  , name TEXT  NOT NULL  , display_name TEXT  , login_url TEXT  , is_api_login INTEGER  DEFAULT  0  , web_view_script_code TEXT  , valid_cookie_key TEXT  NOT NULL  , login_params TEXT  , purchase_url TEXT  NOT NULL  , purchase_method_type INTEGER  DEFAULT  0  NOT NULL  , purchase_div_css TEXT  DEFAULT  'none'  NOT NULL  , purchase_params TEXT  , version INTEGER  NOT NULL  , except_script_code TEXT )";
    public static final String indexing = "CREATE INDEX qlip_sync_rule_malls_idx ON sync_rule_malls (name )";
    public static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS sync_rule_malls";

    public static ParsingRuleData populateModel(Cursor c, String userID, String userPw, String lastSyncDate) {
        DtoRuleData.OnlineMall model = new DtoRuleData.OnlineMall();
        model.id = c.getInt(c.getColumnIndex(COLUMN_MALL_ID));
        model.name = c.getString(c.getColumnIndex(COLUMN_MALL_NAME));
        model.displayName = c.getString(c.getColumnIndex(COLUMN_DISPLAY_NAME));
        model.loginUrl = c.getString(c.getColumnIndex(COLUMN_LOGIN_URL));
        model.isWebviewLogin = c.getInt(c.getColumnIndex(COLUMN_IS_API_LOGIN));
        model.scriptCodes = c.getString(c.getColumnIndex(COLUMN_SCRIPT_CODE));
        model.validCookieKeys = c.getString(c.getColumnIndex(COLUMN_VALID_COOKIE_KEY));
        model.loginParams = c.getString(c.getColumnIndex(COLUMN_LOGIN_PARAMS));
        model.purchaseUrl = c.getString(c.getColumnIndex(COLUMN_PURCHASE_URL));
        model.purchaseMethodType = c.getInt(c.getColumnIndex(COLUMN_PURCHASE_METHOD_TYPE));
        model.purchasePageDivCss = c.getString(c.getColumnIndex(COLUMN_PURCHASE_DIV_CSS));
        model.purchaseParams = c.getString(c.getColumnIndex(COLUMN_PURCHASE_PURCHASE_PARAMS));
        model.version = c.getInt(c.getColumnIndex(COLUMN_VERSION));
        model.exceptionCodes = c.getString(c.getColumnIndex(COLUMN_EXCEPT_SCRIPT_CODE));
        LogUtil.LOGI(TAG, "DTO DATA : " + model.toString());
        return SyncRuleMallsTable.convertDtoData(model, userID, userPw, lastSyncDate);
    }

    public static ParsingRuleData convertDtoData(DtoRuleData.OnlineMall dtoParsingRuleData, String userId, String userPw, String lastSyncDate) {
        ParsingRuleData parsingRuleData = new ParsingRuleData();
        if (dtoParsingRuleData != null) {
            parsingRuleData.name = dtoParsingRuleData.name;
            parsingRuleData.displayName = dtoParsingRuleData.displayName;
            parsingRuleData.loginUrl = dtoParsingRuleData.loginUrl;
            parsingRuleData.isApiLogin = dtoParsingRuleData.isWebviewLogin;
            parsingRuleData.exceptScriptCode = new ArrayList();
            if (dtoParsingRuleData.isWebviewLogin == 1 && dtoParsingRuleData.scriptCodes != null) {
                parsingRuleData.webViewScriptCode = String.format(dtoParsingRuleData.scriptCodes, userId, userPw);
                if (dtoParsingRuleData.exceptionCodes != null && !dtoParsingRuleData.exceptionCodes.isEmpty()) {
                    parsingRuleData.exceptScriptCode.add(dtoParsingRuleData.exceptionCodes);
                }
            }
            parsingRuleData.validCookieKey = new ArrayList<String>(Arrays.asList(dtoParsingRuleData.validCookieKeys.split(";")));
            parsingRuleData.purchaseUrl = Validator.replaceDateParams(dtoParsingRuleData.purchaseUrl, lastSyncDate);
            parsingRuleData.purchaseDivCss = dtoParsingRuleData.purchasePageDivCss;
            parsingRuleData.purchaseMethodType = dtoParsingRuleData.purchaseMethodType;
            if (dtoParsingRuleData.purchaseParams != null && !dtoParsingRuleData.purchaseParams.isEmpty()) {
                parsingRuleData.purchaseParams = Validator.convertMapToString(dtoParsingRuleData.purchaseParams);
                for (String key : parsingRuleData.purchaseParams.keySet()) {
                    if (!parsingRuleData.purchaseParams.get(key).startsWith("dynamicDate")) continue;
                    String value = parsingRuleData.purchaseParams.get(key);
                    parsingRuleData.purchaseParams.put(key, Validator.replaceDateParams(value, lastSyncDate));
                }
            } else {
                parsingRuleData.purchaseParams = new HashMap<String, String>();
            }
            if (dtoParsingRuleData.loginParams != null && !dtoParsingRuleData.loginParams.isEmpty()) {
                parsingRuleData.loginParams = Validator.convertMapToString(dtoParsingRuleData.loginParams);
                for (String key : parsingRuleData.loginParams.keySet()) {
                    if (parsingRuleData.loginParams.get(key).contains("dynamicID")) {
                        parsingRuleData.loginParams.put(key, userId);
                        continue;
                    }
                    if (!parsingRuleData.loginParams.get(key).contains("dynamicPW")) continue;
                    parsingRuleData.loginParams.put(key, userPw);
                }
            }
        }
        LogUtil.LOGI(TAG, "ParsingRuleData : " + parsingRuleData.toString());
        return parsingRuleData;
    }

    public static ContentValues populateContent(DtoRuleData.OnlineMall parsingRuleData) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(COLUMN_MALL_NAME, parsingRuleData.name);
        contentValues.put(COLUMN_DISPLAY_NAME, parsingRuleData.displayName);
        contentValues.put(COLUMN_VALID_COOKIE_KEY, parsingRuleData.validCookieKeys);
        contentValues.put(COLUMN_EXCEPT_SCRIPT_CODE, parsingRuleData.exceptionCodes);
        contentValues.put(COLUMN_IS_API_LOGIN, Integer.valueOf(parsingRuleData.isWebviewLogin));
        contentValues.put(COLUMN_SCRIPT_CODE, parsingRuleData.scriptCodes);
        contentValues.put(COLUMN_LOGIN_PARAMS, parsingRuleData.loginParams);
        contentValues.put(COLUMN_LOGIN_URL, parsingRuleData.loginUrl);
        contentValues.put(COLUMN_PURCHASE_URL, parsingRuleData.purchaseUrl);
        contentValues.put(COLUMN_PURCHASE_METHOD_TYPE, Integer.valueOf(parsingRuleData.purchaseMethodType));
        contentValues.put(COLUMN_PURCHASE_PURCHASE_PARAMS, parsingRuleData.purchaseParams);
        contentValues.put(COLUMN_PURCHASE_DIV_CSS, parsingRuleData.purchasePageDivCss);
        contentValues.put(COLUMN_VERSION, Integer.valueOf(parsingRuleData.version));
        return contentValues;
    }
}

