package com.tenqube.visual_scraper.request_interface.result;

import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;

/**
 * Created by tenqube on 2018. 5. 21..
 */

public interface OnPurchaseResult {


        /**
         * 로그인 성공 리스너
         * @param message
         */
        void onLoginSuccess(String message);

        /**
         * 구매목록 가져오기 시작 리스너
         * @param message
         */
        void onPurchaseStart(String message);

        /**
         *  @param statusMessage statusMessage
         * @param purchaseHtml result 구매 내역 결과 list
         */
        void onPurchaseFinished(String statusMessage, RequestDocumentData purchaseHtml);

        /**
         *  @param statusMessage statusMessage
         *  상세목록 가져오기 시작 리스너
         */
        void onDetailPageScrapingStart(String statusMessage);
        /**
         *  @param statusMessage statusMessage
         * @param result result 구매 상세 내역 결과 list
         */
        void onDetailPageScrapingFinished(String statusMessage, RequestDocumentData result);

        /**
         *
         * @param statusCode statusCode
         * @param errorMessage errorMessage
         */
        void onFail(int statusCode,String errorMessage);

}
