package com.tenqube.visual_scraper.request_interface.page;

import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.data.request_data.ScrapData;

import java.util.ArrayList;

/**
 * Created by tenqube on 2018. 5. 18..
 */

public interface PurchaseRequest{

    /**
     * 구매내역 페이지 요청하기
     * @param cookie 로그인 된 쿠키
     */
    void doPurchasePageRequest( String cookie);

    /**
     * 상세페이지 요청하기
     * @param cookie 로그인 된 쿠키
     * @param detailScrapDatas 상세 페이지 접근 정보
     */
    void doDetailPurchasePageRequest(String cookie, ArrayList<ScrapData> detailScrapDatas);

    /**
     * 구매 페이지 파싱요청
     * @param detailPurchaseDocuments 구매페이지 Document
     */
    void callParsingPurchase(ArrayList<ScrapData> detailPurchaseDocuments);
    interface OnResponsePurchasePage{
        void onPurchasePageResult(RequestDocumentData documents);
        void onDetailPurchasePageResult(RequestDocumentData detailPurchaseDocuments);
        void onParsingFail(String message);
    }
}
