package com.tenqube.visual_scraper.db.table;

import android.content.ContentValues;
import android.database.Cursor;
import android.provider.BaseColumns;

import com.tenqube.visual_scraper.data.PurchaseData;
import com.tenqube.visual_scraper.utils.DateUtils;

/**
 * Created by tenqube on 2018. 4. 30..
 */

public class PurchaseTable extends AbstractTable implements BaseColumns{


    public static final String TABLE_NAME = " purchase";
    public static final String ALIAS = " purchase.";
    public static final String AS_ALIAS = " AS purchase ";


    public static final String COLUMN_SHOPPING_MALL_ID ="mall_id";

    //purchase
    public static final String COLUMN_PURCHANSE_ID="purchase_id_pk";
    public static final String COLUMN_PURCHASE_DATE="purchase_date";
    public static final String COLUMN_PURCHASE_HMS="purchase_hms";
    public static final String COLUMN_ORDER_NUMBER="order_number";
    public static final String COLUMN_MALL_USER_ID="mall_user_id";
    public static final String COLUMN_WHERE_TO_BUY="where_to_buy";
    public static final String COLUMN_ORDER_STATE ="order_state";

    //product
    public static final String COLUMN_PRODUCT_NAME="product_name";
    public static final String COLUMN_PRODUCT_PRICE="product_price";
    public static final String COLUMN_PRODUCT_CATEGORY="product_category";
    public static final String COLUMN_PRODUCT_IMG_DOMAIN="product_img_address";
    public static final String COLUMN_PRODUCT_QUANTITY="product_quantity";
    public static final String COLUMN_PRODUCT_OPTION="product_option";
    public static final String COLUMN_PRODUCT_RATING = "product_rating";
    //delivery
    public static final String COLUMN_DELEVERY_COMPANY="delivery_company";
    public static final String COLUMN_DELEVERY_PRICE="delivery_price";



    public static final String SQL_CREATE_TABLE =
            CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME + " (" +
                    COLUMN_PURCHANSE_ID + INTEGER_TYPE + PRIMARY_KEY + COMMA_SEP +
                    COLUMN_SHOPPING_MALL_ID + INTEGER_TYPE  + NOT_NULL+COMMA_SEP +
                    COLUMN_PURCHASE_DATE + TEXT_TYPE + NOT_NULL + COMMA_SEP +
                    COLUMN_PURCHASE_HMS + TEXT_TYPE  + COMMA_SEP +

                    COLUMN_MALL_USER_ID + TEXT_TYPE + NOT_NULL  + COMMA_SEP +
                    COLUMN_ORDER_NUMBER + TEXT_TYPE + NOT_NULL + COMMA_SEP +
                    COLUMN_WHERE_TO_BUY+TEXT_TYPE+DEFAULT_TEXT+COMMA_SEP+

                    COLUMN_PRODUCT_NAME + TEXT_TYPE + NOT_NULL  + COMMA_SEP +
                    COLUMN_PRODUCT_PRICE + INTEGER_TYPE + NOT_NULL + COMMA_SEP +
                    COLUMN_PRODUCT_CATEGORY + TEXT_TYPE +DEFAULT_TEXT + COMMA_SEP +
                    COLUMN_PRODUCT_OPTION + TEXT_TYPE +DEFAULT_TEXT + COMMA_SEP +
                    COLUMN_PRODUCT_QUANTITY + INTEGER_TYPE  + COMMA_SEP +
                    COLUMN_PRODUCT_IMG_DOMAIN + TEXT_TYPE + DEFAULT_TEXT + COMMA_SEP +
                    COLUMN_PRODUCT_RATING+REAL_TYPE+COMMA_SEP+
                    COLUMN_DELEVERY_COMPANY + TEXT_TYPE + DEFAULT_TEXT + COMMA_SEP +
                    COLUMN_DELEVERY_PRICE + TEXT_TYPE + DEFAULT_TEXT + COMMA_SEP +
                    COLUMN_ORDER_STATE + TEXT_TYPE + DEFAULT_TEXT+ COMMA_SEP+
                    " FOREIGN KEY("+ COLUMN_SHOPPING_MALL_ID +") REFERENCES " +
                    ShoppingMallTable.TABLE_NAME+"("+ShoppingMallTable.COLUMN_MALL_ID+")   ON DELETE CASCADE" + COMMA_SEP +

                    UNIQUE + "("+ COLUMN_SHOPPING_MALL_ID + COMMA_SEP + COLUMN_ORDER_NUMBER + COMMA_SEP+COLUMN_PURCHASE_DATE+")" + " )";

    public static final String indexing = "CREATE INDEX qlip_purchase_idx ON " + TABLE_NAME + " ("+COLUMN_ORDER_NUMBER +","+COLUMN_MALL_USER_ID+")";

    public static final String SQL_DELETE_ENTRIES =
            DROP_TABLE_IF_EXISTS + TABLE_NAME;

    /**
     *
     - 주문관련
     purchaseid; 구매 id
     purchaseDate; 구매 날짜
     orderNumber; 구매 주문번호
     whereTobuy; 구매 판매처
     shopping_mall_type; 몰 아이디
     user_id; 유저 아이디
     - 제품관련
     prdImgAddress; 제품 이미지 도메인
     prdTitle; 제품 이름
     prdCategory;제품 카테고리
     imgLoadSuccess;
     prdQuantity; 제품 수량
     prdOption; 제품 옵션
     prdPrice; 제품 가격
     -배송관련
     deliveryCompany; 배송업체
     deliveryPrice; 배송비
     orderState; 배송상태
     * @param  c 커서
     * @return PurchaseData
     */
    public static PurchaseData populateModel(Cursor c) {
        PurchaseData model = new PurchaseData();
//        model.p = c.getInt(c.getColumnIndex(COLUMN_PURCHANSE_ID));
        model.user_id = c.getString(c.getColumnIndex(COLUMN_MALL_USER_ID));
        model.shopping_mall_id = c.getInt(c.getColumnIndex(COLUMN_SHOPPING_MALL_ID));
        model.orderNumber = c.getString(c.getColumnIndex(COLUMN_ORDER_NUMBER));
        model.whereTobuy = c.getString(c.getColumnIndex(COLUMN_WHERE_TO_BUY));
        model.purchaseDate = c.getString(c.getColumnIndex(COLUMN_PURCHASE_DATE));
        model.hms = c.getString(c.getColumnIndex(COLUMN_PURCHASE_HMS));

        model.prdTitle = c.getString(c.getColumnIndex(COLUMN_PRODUCT_NAME));
        model.prdImgAddress = c.getString(c.getColumnIndex(COLUMN_PRODUCT_IMG_DOMAIN));
        model.prdPrice = c.getInt(c.getColumnIndex(COLUMN_PRODUCT_PRICE));
        model.prdCategory = c.getString(c.getColumnIndex(COLUMN_PRODUCT_CATEGORY));
        model.prdQuantity = c.getInt(c.getColumnIndex(COLUMN_PRODUCT_QUANTITY));
        model.prdOption = c.getString(c.getColumnIndex(COLUMN_PRODUCT_OPTION));
        model.prdRating = c.getDouble(c.getColumnIndex(COLUMN_PRODUCT_RATING));

        model.deliveryCompany = c.getString(c.getColumnIndex(COLUMN_DELEVERY_COMPANY));
        model.deliveryPrice = c.getString(c.getColumnIndex(COLUMN_DELEVERY_PRICE));
        model.orderState = c.getString(c.getColumnIndex(COLUMN_ORDER_STATE));
        return model;
    }

    public static ContentValues populateContent(PurchaseData model) {
        ContentValues values = new ContentValues();
        values.put(COLUMN_SHOPPING_MALL_ID, model.shopping_mall_id);
        values.put(COLUMN_PURCHASE_DATE, model.purchaseDate==null? DateUtils.getTodayDate():model.purchaseDate);
        values.put(COLUMN_MALL_USER_ID, model.user_id);
        values.put(COLUMN_ORDER_NUMBER, model.orderNumber==null?"":model.orderNumber);
        values.put(COLUMN_WHERE_TO_BUY, model.whereTobuy==null?"":model.whereTobuy);
        values.put(COLUMN_ORDER_STATE, model.orderState ==null?"":model.orderState);
        values.put(COLUMN_PRODUCT_NAME, model.prdTitle);
        values.put(COLUMN_PRODUCT_PRICE, model.prdPrice);
        values.put(COLUMN_PRODUCT_CATEGORY, model.prdCategory==null?"":model.prdCategory);
        values.put(COLUMN_PRODUCT_OPTION, model.prdOption==null?"":model.prdOption);
        values.put(COLUMN_PRODUCT_QUANTITY, model.prdQuantity);
        values.put(COLUMN_PRODUCT_IMG_DOMAIN, model.prdImgAddress ==null?"":model.prdImgAddress);
        values.put(COLUMN_DELEVERY_COMPANY, model.deliveryCompany==null?"":model.deliveryCompany);
        values.put(COLUMN_DELEVERY_PRICE, model.deliveryPrice==null?"":model.deliveryPrice);
        values.put(COLUMN_PRODUCT_RATING,model.prdRating);
        values.put(COLUMN_PURCHASE_HMS,model.hms);
        return values;
    }


}
