/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.AppLifecycle;
import com.tencent.xcast.SurfaceTextureHolder;
import com.tencent.xcast.VideoCaptureContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class VideoCapture
implements VideoCaptureContext.CaptureThreadCallback,
AppLifecycle.LifecycleObserver {
    private static final int MSG_OPEN_CAMERA = 1;
    private static final int MSG_CONFIG_CAMERA = 2;
    private static final int MSG_STOP_CAMERA = 3;
    private static final int CAPTURE_BUFFER_COUNT = 2;
    static final Object sLock;
    static final /* synthetic */ boolean $assertionsDisabled;
    private Context mContext;
    private long mNativeCapture;
    private VideoCaptureContext mCaptureCtx;
    private int mCameraId;
    private Camera mCamera;
    private CapturePreviewCallback mPreviewCallback;
    private final Object mLock = new Object();
    private Camera.CameraInfo mCameraInfo;
    private int mWidth;
    private int mHeight;
    private int mFps;
    private int mPreviewFormat;
    private List<byte[]> mCaptureBuffers;
    private int mFrameCount;
    private long mLastFrameElapsedTimeMs;
    private double mAvgFrameDurationMs;
    private AppLifecycle mAppLifecycle;
    private boolean mPaused;
    private volatile boolean mStop;
    private SurfaceTextureHolder mCaptureTextureHolder;
    private final boolean mUseSurfaceTexture;
    private int mAsyncResult = -1;
    private long mStartTs;
    private long mStartPreviewTs;

    public static void getCameraInfos(Context context, long l2) {
        Camera.CameraInfo cameraInfo;
        int n2 = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                int n3 = i2;
                Camera.getCameraInfo((int)n3, (Camera.CameraInfo)cameraInfo2);
                VideoCapture.onCaptureEnum(l2, String.valueOf(n3), cameraInfo2.facing);
                continue;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = i2;
                Platform.logError(String.format(Locale.CHINA, "fail to get camera info %d", objectArray2));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void onPreviewFrame(byte[] var1_2, Camera var2_3) {
        block41: {
            block45: {
                block46: {
                    block42: {
                        block43: {
                            block40: {
                                if (this.mUseSurfaceTexture) {
                                    return;
                                }
                                if (!this.mStop) break block40;
                                if (Platform.isDebugLevel()) {
                                    Platform.logDebug(String.format(Locale.CHINA, "fast stop return %d", new Object[]{var1_2.length}));
                                }
                                return;
                            }
                            if (!this.mCaptureCtx.isCaptureThread()) break block41;
                            if (var1_2 != null) break block42;
                            v0 = this;
                            Platform.logInfo("no enough buffer.");
                            var3_4 = v0.getBufferSize(v0.mPreviewFormat, this.mWidth, this.mHeight);
                            var4_6 = new byte[var3_4];
                            for (var5_7 = (v89120).mCaptureBuffers.size() - 1; var5_7 >= 0; --var5_7) {
                                if (this.mCaptureBuffers.get(var5_7).length >= var3_4) continue;
                                this.mCaptureBuffers.remove(var5_7);
                            }
                            v1 = var2_3;
                            v1.addCallbackBuffer(var4_6);
                            if (v1 == null || var1_2 == null) break block43;
                            var2_3.addCallbackBuffer(var1_2);
                        }
                        return;
                    }
                    if (var2_3 == null) {
                        block44: {
                            this = this.mCamera;
                            if (this == null || var1_2 == null) break block44;
                            this.addCallbackBuffer(var1_2);
                        }
                        return;
                    }
                    if (var2_3 != this.mCamera) break block45;
                    if (this.mFrameCount != 0) ** GOTO lbl57
                    var3_5 = SystemClock.elapsedRealtime() - this.mStartPreviewTs;
                    v2 = Locale.CHINA;
                    v3 = new Object[2];
                    v3[0] = this.mCameraId;
                    v3[1] = var3_5;
                    Platform.logInfo(String.format(v2, "cap.%s.first.frame.%dms", v3));
lbl57:
                    // 2 sources

                    v4 = this;
                    v5 = v4;
                    v6 = v4;
                    v7 = v4.mFrameCount;
                    v6.mFrameCount = v7 + 1;
                    var3_5 = SystemClock.elapsedRealtime();
                    if (v5.mFrameCount <= 0) ** GOTO lbl93
                    v8 = this;
                    v9 = v8;
                    v10 = v8;
                    var5_8 = var3_5 - this.mLastFrameElapsedTimeMs;
                    var7_9 = 0.9;
                    v11 = v9.mAvgFrameDurationMs;
                    v10.mAvgFrameDurationMs = v11 * var7_9 + var5_8 * 0.1;
                    if (!Platform.isDebugBuild) ** GOTO lbl93
                    v12 = this.mFrameCount;
                    if (v12 % 100 != 0) ** GOTO lbl93
                    v13 = Locale.CHINA;
                    v14 = new Object[3];
                    v14[0] = var3_5;
                    v14[1] = (int)var5_8;
                    v15 = 1000.0 / this.mAvgFrameDurationMs;
                    v14[2] = (int)(v15 + 0.5);
                    Platform.logDebug(String.format(v13, "Camera TS %dms,Duration: %dms,FPS: %d", v14));
lbl93:
                    // 4 sources

                    this.mLastFrameElapsedTimeMs = var3_5;
                    VideoCapture.onCaptureFrame(this.mNativeCapture, var1_2, var1_2.length, this.mWidth, this.mHeight, this.getRotate(), this.mPreviewFormat);
                    if (var2_3 == null || var1_2 == null) break block46;
                    var2_3.addCallbackBuffer(var1_2);
                }
                return;
            }
            throw new RuntimeException("Unexpected camera in callback!");
        }
        try {
            throw new RuntimeException("Camera callback not on camera thread");
        }
        finally {
            if (var2_3 != null && var1_2 != null) {
                var2_3.addCallbackBuffer(var1_2);
            }
        }
    }

    private VideoCapture(Context context, long l2, boolean bl) {
        this.mContext = context;
        this.mNativeCapture = l2;
        this.mUseSurfaceTexture = bl;
    }

    private Camera.Size getOptimalPreviewSize(Camera.Parameters objectArray3, int n2, int n3) {
        Object[] objectArray2 = objectArray3;
        objectArray3 = null;
        List list = objectArray2.getSupportedPreviewSizes();
        Collections.sort(list, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size size, Camera.Size size2) {
                return size.width - size2.width;
            }
        });
        for (Object[] objectArray3 : list) {
            if (objectArray3.width < n2 || objectArray3.height < n3) continue;
        }
        int n4 = objectArray3 != null ? objectArray3.width : 0;
        int n5 = objectArray3 != null ? objectArray3.height : 0;
        Object[] objectArray4 = objectArray3;
        Object[] objectArray5 = new Object[4];
        objectArray3 = objectArray5;
        objectArray3[0] = n2;
        objectArray3[1] = n3;
        objectArray3[2] = n4;
        objectArray5[3] = n5;
        Platform.logInfo(String.format(Locale.CHINA, "size: %dx%d, best match: %dx%d", objectArray3));
        return objectArray4;
    }

    private int getOptimalFpsRate(Camera.Parameters parameters, int n2) {
        int n3;
        Object object = parameters.getSupportedPreviewFrameRates();
        if (object != null) {
            Collections.sort(object);
            object = object.iterator();
            n3 = n2;
            while (object.hasNext()) {
                Integer n4 = (Integer)object.next();
                n3 = n4;
                if (n4 < n2) continue;
                break;
            }
        } else {
            n3 = n2;
        }
        Object[] objectArray = new Object[2];
        object = objectArray;
        object[0] = n2;
        objectArray[1] = n3;
        Platform.logInfo(String.format(Locale.CHINA, "fps.%d.act.fps.%d", object));
        return n3;
    }

    private List<byte[]> genCaptureBuffers(List<byte[]> arrayList, int n2) {
        if (arrayList == null) {
            ArrayList<byte[]> arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<byte[]>(2);
        }
        for (int i2 = 0; i2 < 2; ++i2) {
            if (i2 < arrayList.size()) {
                if (n2 <= ((byte[])arrayList.get(i2)).length) continue;
                arrayList.set(i2, new byte[n2]);
                continue;
            }
            arrayList.add(new byte[n2]);
        }
        return arrayList;
    }

    private void updateCameraParameters(Camera camera, Camera.Parameters parameters) {
        int n2 = 17;
        Object object = parameters.getSupportedPreviewFormats();
        Platform.logInfo(Arrays.toString(object.toArray()));
        if (!object.contains(17)) {
            object = object.iterator();
            while (object.hasNext()) {
                Integer n3 = (Integer)object.next();
                if (n3 != 842094169) continue;
                n2 = n3;
                break;
            }
        }
        VideoCapture videoCapture = this;
        Camera.Parameters parameters2 = parameters;
        parameters2.setPreviewFormat(n2);
        this.mPreviewFormat = parameters2.getPreviewFormat();
        Object[] objectArray = this.getOptimalPreviewSize(parameters, this.mWidth, this.mHeight);
        parameters.setPreviewSize(objectArray.width, objectArray.height);
        videoCapture.mWidth = objectArray.width;
        videoCapture.mHeight = objectArray.height;
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = parameters.isVideoStabilizationSupported();
        Platform.logInfo(String.format(Locale.CHINA, "isVideoStabilizationSupported: %b", objectArray));
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (-1 != parameters.getSupportedFocusModes().indexOf("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        Camera.Parameters parameters3 = parameters;
        parameters3.setPreviewFrameRate(this.getOptimalFpsRate(parameters, this.mFps));
        this.mFps = parameters3.getPreviewFrameRate();
        camera.setParameters(parameters);
    }

    private int getBufferSize(int n2, int n3, int n4) {
        if (n2 == 842094169) {
            int n5 = (int)Math.ceil((double)n3 / 16.0) << 4;
            int n6 = (int)Math.ceil((double)(n5 >> 1) / 16.0) << 4;
            return n5 * n4 + n6 * n4 / 2 << 1;
        }
        return n3 * n4 * ImageFormat.getBitsPerPixel((int)n2) / 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private int startCaptureInternal() {
        Object object;
        Exception exception2;
        int n2;
        Camera.Size size;
        block23: {
            VideoCapture videoCapture;
            long l2;
            block22: {
                size = null;
                n2 = -1;
                l2 = SystemClock.elapsedRealtime();
                if (!$assertionsDisabled && ((VideoCapture)object).mCamera != null) {
                    throw new AssertionError();
                }
                try {
                    VideoCapture videoCapture2 = object;
                    videoCapture2.mCamera = Camera.open((int)videoCapture2.mCameraId);
                    if (videoCapture2.mCamera != null) break block22;
                }
                catch (RuntimeException runtimeException) {
                    Platform.logError(Platform.getTrace(runtimeException));
                    return n2;
                }
                Object[] objectArray = new Object[1];
                size = objectArray;
                objectArray[0] = ((VideoCapture)object).mCameraId;
                Platform.logError(String.format(Locale.CHINA, "Camera.open returned null for camera %s", (Object[])size));
                return n2;
            }
            Object[] objectArray = ((VideoCapture)object).mCaptureTextureHolder;
            if (((VideoCapture)object).mCaptureTextureHolder != null) {
                objectArray.release();
            }
            try {
                VideoCapture videoCapture3 = object;
                videoCapture = videoCapture3;
                videoCapture3.mCaptureTextureHolder = new SurfaceTextureHolder(((VideoCapture)object).mWidth, ((VideoCapture)object).mHeight, new SurfaceTextureHolder.EventCallback(){

                    @Override
                    public void onFrameAvailable(SurfaceTextureHolder surfaceTextureHolder, SurfaceTexture surfaceTexture) {
                        if (VideoCapture.this.mUseSurfaceTexture) {
                            VideoCapture.onCaptureFrameSurface(VideoCapture.this.mNativeCapture, surfaceTextureHolder, VideoCapture.this.mWidth, VideoCapture.this.mHeight, VideoCapture.this.getRotate());
                        }
                    }

                    @Override
                    public void onRelease(SurfaceTextureHolder surfaceTextureHolder) {
                    }
                }, new SurfaceTextureHolder.HandlerDestructorRunner(((VideoCapture)object).mCaptureCtx.getHandler()));
                videoCapture3.mCamera.setPreviewTexture(((VideoCapture)object).mCaptureTextureHolder.getSurfaceTexture());
            }
            catch (RuntimeException exception2) {
                break block23;
            }
            catch (IOException exception2) {
                // empty catch block
                break block23;
            }
            try {
                objectArray = videoCapture.mCamera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                Platform.logError(Platform.getTrace(runtimeException));
                objectArray = size;
            }
            if (objectArray == null) {
                Object object2 = object;
                Object[] objectArray2 = new Object[1];
                size = objectArray2;
                objectArray2[0] = ((VideoCapture)object).mCameraId;
                Platform.logError(String.format(Locale.CHINA, "Camera.getParameters returned null for camera %s", (Object[])size));
                ((VideoCapture)object2).mCamera.release();
                ((VideoCapture)object2).mCamera = null;
                object = ((VideoCapture)object2).mCaptureTextureHolder;
                if (object != null) {
                    ((SurfaceTextureHolder)object).release();
                }
                return n2;
            }
            try {
                Object object3 = object;
                super.updateCameraParameters(((VideoCapture)object3).mCamera, (Camera.Parameters)objectArray);
            }
            catch (RuntimeException runtimeException) {
                size = Platform.getTrace(runtimeException);
                Object object4 = object;
                Platform.logError((String)size);
                size = objectArray.getPreviewSize();
                ((VideoCapture)object4).mWidth = size.width;
                ((VideoCapture)object4).mHeight = size.height;
                ((VideoCapture)object).mPreviewFormat = objectArray.getPreviewFormat();
                ((VideoCapture)object).mFps = objectArray.getPreviewFrameRate();
            }
            Object object5 = object;
            int n3 = super.getBufferSize(((VideoCapture)object5).mPreviewFormat, ((VideoCapture)object).mWidth, ((VideoCapture)object).mHeight);
            ((VideoCapture)object5).mCaptureBuffers = super.genCaptureBuffers(((VideoCapture)object5).mCaptureBuffers, n3);
            for (n3 = 0; n3 < 2; ++n3) {
                ((VideoCapture)object).mCamera.addCallbackBuffer(((VideoCapture)object).mCaptureBuffers.get(n3));
            }
            Object object6 = object;
            Object[] objectArray3 = ((VideoCapture)object6).mLock;
            synchronized (((VideoCapture)object6).mLock) {
                block24: {
                    double d2;
                    if (((VideoCapture)object6).mPreviewCallback != null) {
                        ((VideoCapture)object).mPreviewCallback.clear();
                    }
                    Object object7 = object;
                    Object object8 = object7;
                    Object object9 = object7;
                    Object object10 = object7;
                    Object object11 = object7;
                    Object object12 = object;
                    ((VideoCapture)object).mPreviewCallback = (VideoCapture)object12.new CapturePreviewCallback((VideoCapture)object12);
                    // ** MonitorExit[var1_3] (shouldn't be in output)
                    ((VideoCapture)object7).mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)((VideoCapture)object).mPreviewCallback);
                    try {
                        ((VideoCapture)object9).mCamera.startPreview();
                        n2 = 0;
                        ((VideoCapture)object10).mFrameCount = 0;
                        d2 = 1000.0f / (float)((VideoCapture)object).mFps;
                    }
                    catch (RuntimeException runtimeException) {
                        Platform.logError(Platform.getTrace(runtimeException));
                        super.stopCaptureInternal();
                        break block24;
                    }
                    {
                        ((VideoCapture)object11).mAvgFrameDurationMs = d2;
                        ((VideoCapture)object8).mStartPreviewTs = SystemClock.elapsedRealtime();
                    }
                }
                Object[] objectArray4 = new Object[3];
                objectArray3 = objectArray4;
                objectArray3[0] = object;
                objectArray4[1] = n2;
                objectArray4[2] = SystemClock.elapsedRealtime() - l2;
                Platform.logInfo(String.format(Locale.CHINA, "%h.started.%d.dur.%dms", objectArray3));
                return n2;
            }
        }
        size = Platform.getTrace(exception2);
        VideoCapture videoCapture = object;
        Platform.logError((String)size);
        videoCapture.mCamera.release();
        videoCapture.mCamera = null;
        object = videoCapture.mCaptureTextureHolder;
        if (object != null) {
            ((SurfaceTextureHolder)object).release();
        }
        return n2;
    }

    private void stopCaptureInternal() {
        long l2 = SystemClock.elapsedRealtime();
        Platform.logInfo("stop capture");
        if (this.mCamera != null) {
            VideoCapture videoCapture = this;
            Platform.logInfo("stop preview start");
            videoCapture.mCamera.stopPreview();
            videoCapture.mCamera.setPreviewCallbackWithBuffer(null);
            Camera camera = videoCapture.mCamera;
            try {
                camera.setPreviewTexture(null);
            }
            catch (IOException iOException) {
                Platform.logInfo(Platform.getTrace(iOException));
            }
            this.mCamera.release();
            this.mCamera = null;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this;
        objectArray[1] = SystemClock.elapsedRealtime() - l2;
        Platform.logInfo(String.format(Locale.CHINA, "%h stop done spend %dms", objectArray2));
    }

    @WorkerThread
    private int startOnCaptureThread() {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = SystemClock.elapsedRealtime() - this.mStartTs;
        Platform.logInfo(String.format(Locale.CHINA, "start on camera thread wait %d", objectArray2));
        return this.startCaptureInternal();
    }

    @WorkerThread
    private int configOnCameraThread(int n2, int n3, int n4) {
        int n5;
        block5: {
            int n6;
            block4: {
                Camera.Size size;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = objectArray7.mCamera;
                Platform.logInfo(String.format("configCaptureOnCameraThread mCamera %h ", objectArray2));
                n6 = -1;
                Camera camera = objectArray7.mCamera;
                if (camera == null) break block4;
                try {
                    camera = camera.getParameters();
                    size = camera.getPreviewSize();
                }
                catch (RuntimeException runtimeException) {
                    objectArray7.mWidth = n2;
                    objectArray7.mHeight = n3;
                    objectArray7.mFps = n4;
                    return n6;
                }
                Camera.Size size2 = objectArray7.getOptimalPreviewSize((Camera.Parameters)camera, n2, n3);
                int n7 = camera.getPreviewFrameRate();
                int n8 = objectArray7.getOptimalFpsRate((Camera.Parameters)camera, n4);
                if (size.equals((Object)size2) && n7 == n8) {
                    n5 = 0;
                } else {
                    Object[] objectArray3 = objectArray7;
                    Object[] objectArray4 = objectArray7;
                    Object[] objectArray5 = objectArray7;
                    Object[] objectArray6 = new Object[6];
                    Object[] objectArray7 = objectArray6;
                    objectArray7[0] = n7;
                    objectArray7[1] = n8;
                    objectArray7[2] = size.width;
                    objectArray7[3] = size.height;
                    objectArray7[4] = size2.width;
                    objectArray6[5] = size2.height;
                    Platform.logInfo(String.format(Locale.CHINA, "oldFps: %d, optimalFps: %d, old size: (%d, %d), opt size: (%d, %d)", objectArray7));
                    super.stopCaptureInternal();
                    objectArray4.mWidth = n2;
                    objectArray3.mHeight = n3;
                    objectArray7.mFps = n4;
                    n5 = super.startCaptureInternal();
                }
                break block5;
            }
            objectArray7.mWidth = n2;
            objectArray7.mHeight = n3;
            objectArray7.mFps = n4;
            n5 = n6;
        }
        return n5;
    }

    @WorkerThread
    private void stopOnCaptureThread(VideoCaptureContext objectArray) {
        VideoCapture videoCapture = this;
        videoCapture.stopCaptureInternal();
        objectArray = videoCapture.mCaptureBuffers;
        if (objectArray != null) {
            objectArray.clear();
            this.mCaptureBuffers = null;
        }
        if ((objectArray = this.mCaptureTextureHolder) != null) {
            objectArray.release();
        }
        this.mPaused = false;
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = this.mFrameCount;
        Platform.logInfo(String.format(Locale.CHINA, "frame count %d", objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean start(String object) {
        if (object != null && ((String)object).length() != 0) {
            Object object2 = sLock;
            synchronized (object2) {
                Params params;
                block10: {
                    this.mStartTs = SystemClock.elapsedRealtime();
                    try {
                        this.mCameraId = Integer.parseInt((String)object);
                        if (this.mCameraInfo == null) {
                            this.mCameraInfo = new Camera.CameraInfo();
                            Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)this.mCameraInfo);
                        }
                        if (this.mCaptureCtx != null) break block10;
                    }
                    catch (RuntimeException runtimeException) {
                        VideoCapture videoCapture = this;
                        videoCapture.mCameraId = 0;
                        videoCapture.mCameraInfo = null;
                        String string2 = "camera.id.%s.invalid";
                        Object[] objectArray = new Object[1];
                        objectArray[0] = object;
                        Platform.logError(String.format(string2, objectArray));
                        return false;
                    }
                    this.mCaptureCtx = VideoCaptureContext.create(this.mContext);
                }
                if (this.mAppLifecycle == null) {
                    VideoCapture videoCapture = this;
                    videoCapture.mAppLifecycle = AppLifecycle.create(videoCapture.mContext, this.mCaptureCtx.getHandler());
                    videoCapture.mAppLifecycle.addObserver(this);
                }
                object = params;
                new Params().what = 1;
                this.mStop = false;
                boolean bl = false;
                boolean bl2 = this.mCaptureCtx.runOnCaptureThread(this, object, true) ? this.mAsyncResult == 0 : bl;
                return bl2;
            }
        }
        Platform.logError("camera.id.null");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean stop() {
        Params params;
        Object object = sLock;
        // MONITORENTER : object
        if (this.mCaptureCtx == null) {
            // MONITOREXIT : object
            return false;
        }
        long l2 = SystemClock.elapsedRealtime();
        if (this.mAppLifecycle != null) {
            this.mAppLifecycle.destroy();
            this.mAppLifecycle = null;
        }
        VideoCapture videoCapture = this;
        VideoCapture videoCapture2 = videoCapture;
        Params params2 = params;
        new Params().what = 3;
        videoCapture.mStop = true;
        Object object2 = videoCapture.mLock;
        // MONITORENTER : object2
        if (videoCapture2.mPreviewCallback != null) {
            this.mPreviewCallback.clear();
        }
        VideoCapture videoCapture3 = this;
        // MONITOREXIT : object2
        boolean bl = videoCapture3.mCaptureCtx.runOnCaptureThread(this, params2, true);
        Object object3 = object;
        VideoCapture videoCapture4 = this;
        VideoCapture videoCapture5 = videoCapture4;
        VideoCapture videoCapture6 = videoCapture4;
        Locale locale = Locale.CHINA;
        String string2 = "stop wait %dms";
        Object[] objectArray = new Object[1];
        long l3 = SystemClock.elapsedRealtime();
        objectArray[0] = l3 - l2;
        Platform.logInfo(String.format(locale, string2, objectArray));
        videoCapture5.mCaptureCtx.destroy();
        videoCapture6.mCaptureCtx = null;
        // MONITOREXIT : object3
        return bl;
        catch (Throwable throwable) {
            // MONITOREXIT : object2
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean config(int n2, int n3, int n4) {
        Object object = sLock;
        synchronized (object) {
            void var3_7;
            void var2_6;
            boolean bl;
            if (!this.mStop && this.mCaptureCtx != null) {
                void var0_4;
                Params params;
                Params params2 = params;
                params2();
                params2.what = 2;
                params2.w = bl;
                params2.h = var2_6;
                params.f = var3_7;
                bl = false;
                if (this.mCaptureCtx.runOnCaptureThread(this, params2, true)) {
                    if (this.mAsyncResult == 0) {
                        boolean bl2 = true;
                    } else {
                        boolean bl3 = false;
                    }
                } else {
                    boolean bl4 = bl;
                }
                return (boolean)var0_4;
            }
            this.mWidth = bl;
            this.mHeight = var2_6;
            this.mFps = var3_7;
            return true;
        }
    }

    private int getRotate() {
        int n2 = this.mCaptureCtx.isDeviceAutoRotate() ? this.mCaptureCtx.getDeviceOrientation() : 0;
        if (this.mCameraInfo.facing == 0) {
            n2 = 360 - n2;
        }
        return (this.mCameraInfo.orientation + n2) % 360 / 90;
    }

    private static native void onCaptureEnum(long var0, String var2, int var3);

    private static native void onCaptureFrame(long var0, byte[] var2, int var3, int var4, int var5, int var6, int var7);

    private static native void onCaptureFrame2(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7, ByteBuffer var8, int var9, int var10, int var11, int var12, int var13, int var14);

    private static native void onCaptureFrameSurface(long var0, SurfaceTextureHolder var2, int var3, int var4, int var5);

    static {
        $assertionsDisabled = VideoCapture.class.desiredAssertionStatus() ^ true;
        sLock = new Object();
    }

    @Override
    @WorkerThread
    public void onCaptureThreadCallback(VideoCaptureContext videoCaptureContext, Object object) {
        object = (Params)object;
        int n2 = ((Params)object).what;
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 == 3) {
                    this.stopOnCaptureThread(videoCaptureContext);
                }
            } else {
                this.mAsyncResult = this.configOnCameraThread(((Params)object).w, ((Params)object).h, ((Params)object).f);
            }
        } else {
            this.mAsyncResult = this.startOnCaptureThread();
        }
    }

    @Override
    @WorkerThread
    public void onAppBackgrounded() {
        if (this.mCamera == null) {
            Platform.logInfo("onAppBackgrounded camera is not running");
        } else if (!this.mPaused) {
            this.stopCaptureInternal();
            this.mPaused = true;
            Platform.logInfo("onAppBackgrounded pause camera");
        } else {
            Platform.logInfo("onAppBackgrounded camera is already paused");
        }
    }

    @Override
    @WorkerThread
    public void onAppForegrounded() {
        if (this.mCamera != null) {
            Platform.logInfo("onAppForegrounded camera is running");
        } else if (this.mPaused) {
            int n2 = this.startCaptureInternal();
            this.mPaused = false;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n2;
            Platform.logInfo(String.format(Locale.CHINA, "onAppForegrounded resume camera %d", objectArray2));
        } else {
            Platform.logInfo("onAppForegrounded camera is not running");
        }
    }

    private class CapturePreviewCallback
    implements Camera.PreviewCallback {
        @Nullable
        VideoCapture mCapture;

        CapturePreviewCallback(VideoCapture videoCapture2) {
            this.mCapture = videoCapture2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            CapturePreviewCallback capturePreviewCallback = this;
            synchronized (capturePreviewCallback) {
                Object[] objectArray = new Object[1];
                objectArray[0] = this.mCapture;
                Platform.logError(String.format("clear capture %h", objectArray));
                capturePreviewCallback.mCapture = null;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @WorkerThread
        public void onPreviewFrame(byte[] byArray, Camera camera) {
            CapturePreviewCallback capturePreviewCallback = this;
            synchronized (capturePreviewCallback) {
                if (capturePreviewCallback.mCapture == null) {
                    if (Platform.isDebugLevel()) {
                        Platform.logDebug(String.format(Locale.CHINA, "fast stop return %d", byArray.length));
                    }
                    if (camera != null && byArray != null) {
                        camera.addCallbackBuffer(byArray);
                    }
                    // ** MonitorExit[this] (shouldn't be in output)
                    return;
                }
                CapturePreviewCallback capturePreviewCallback2 = this;
                capturePreviewCallback2.mCapture.onPreviewFrame(byArray, camera);
                // ** MonitorExit[v1] (shouldn't be in output)
                return;
            }
        }
    }

    static class Params {
        int what;
        int w;
        int h;
        int f;

        Params() {
        }
    }
}

