/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import android.util.DisplayMetrics;
import android.view.Choreographer;
import android.view.Display;
import android.view.WindowManager;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.SurfaceTextureHolder;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=21)
public final class ScreenCapture
implements Choreographer.FrameCallback {
    protected static final String TAG = "ScreenCapture";
    private static final int MAX_IMAGES = 5;
    private static final int MSG_START_CAPTURE = 3;
    private static final int MSG_STOP_CAPTURE = 4;
    private static final int MSG_DETECT_ORIENTATION = 5;
    private static final int VIRTUAL_DISPLAY_CREATE_FAIL = -2;
    private static AtomicBoolean sSupportConfigureChanged = new AtomicBoolean(false);
    private MediaProjection mMediaProjection;
    private VirtualDisplay mVirtualDisplay;
    private int mDisplayIndex;
    private MediaProjectionManager mMediaProjectionManager;
    private Context mContext;
    private final Object mImageReaderLock = new Object();
    private final boolean mUseSurfaceTexture;
    private SurfaceTextureHolder mSurfaceTextureHolder = null;
    private boolean mTextureFrameAvailable = false;
    private ImageReader mImageReader = null;
    private Image mLastImage = null;
    private InternalImageReaderListener mReaderListener;
    private WindowManager mWindowMgr;
    private Point mScreenSize = new Point();
    private DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    private ConfigurationChangedReceiver mReceiver;
    private HandlerThread mImageHandlerThread;
    private Handler mImageHandler;
    private long mNativePtr;
    private int mCapWidth;
    private int mCapHeight;
    private int mCapFps = 15;
    private int mOrientation = 0;
    private final Object mScreenSizeLock = new Object();
    private long mFpsFrameCount;
    private long mFpsLastFrameCount;
    private long mFpsLastFrameTimeNS;
    private long mFpsFirstFrameCost;
    private long mFpsTotalActualDelay;
    private long mFpsTotalFrameCount;
    private long mFpsLastPrintTickNS = 0L;
    private long mFpsMaxActualDelay;
    private long mFpsMinActualDelay = Integer.MAX_VALUE;
    private long mImageAvailableFrameCount;
    private long mImageAvailableFirstFrameCost;
    private long mDisplayCreateTime;
    private boolean mCaptureHasInit = false;
    private volatile boolean mCapturing = false;
    private int mPermissionRetCode;
    private Intent mPermissionRetData = null;
    private Handler mMainLooper;
    private int mMismatchFrameCount = 0;
    private Runnable mOrientationChangeRunnable = new Runnable(){

        @Override
        public void run() {
            ScreenCapture.this.onConfigurationChanged();
        }
    };
    private MediaProjection.Callback mMediaProjCallback = new MediaProjection.Callback(){

        @WorkerThread
        public void onStop() {
            Platform.logInfo("MediaProjection.onStop");
            ScreenCapture.this.onMediaProjectionStop();
        }
    };

    private boolean isAppForeground() {
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        if (activityManager == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : activityManager.getRunningAppProcesses()) {
            if (runningAppProcessInfo.importance != 100 || !runningAppProcessInfo.processName.equals(this.mContext.getApplicationInfo().processName)) continue;
            return true;
        }
        return false;
    }

    private void releaseVirtualDisplay(VirtualDisplay virtualDisplay) {
        try {
            virtualDisplay.setSurface(null);
        }
        catch (Exception exception) {
            Platform.log(3, exception.toString());
        }
        try {
            virtualDisplay.release();
        }
        catch (Exception exception) {
            Platform.log(3, exception.toString());
        }
    }

    private synchronized void onMediaProjectionStop() {
        VirtualDisplay virtualDisplay = this.mVirtualDisplay;
        if (virtualDisplay != null) {
            this.releaseVirtualDisplay(virtualDisplay);
            this.mVirtualDisplay = null;
            Platform.logInfo("virtual.display.stop");
        }
        if ((virtualDisplay = this.mMediaProjection) != null) {
            VirtualDisplay virtualDisplay2 = virtualDisplay;
            this.mMediaProjection = null;
            virtualDisplay2.unregisterCallback(this.mMediaProjCallback);
            virtualDisplay2.stop();
            ScreenCapture.onCaptureStop(this.mNativePtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private ScreenCapture(Context object, long l2, boolean bl) {
        this.mContext = object;
        this.mNativePtr = l2;
        this.mUseSurfaceTexture = bl;
        this.mWindowMgr = (WindowManager)object.getSystemService("window");
        this.mMediaProjectionManager = (MediaProjectionManager)object.getSystemService("media_projection");
        this.mReaderListener = new InternalImageReaderListener();
        object = this.mScreenSizeLock;
        synchronized (object) {
            this.refreshScreenSizeAndOrientation();
        }
        this.mMainLooper = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    private void onConfigurationChanged() {
        ScreenCapture screenCapture = this;
        Object object = screenCapture.mScreenSizeLock;
        ScreenCapture screenCapture2 = this;
        // MONITORENTER : object
        screenCapture2.refreshScreenSizeAndOrientation();
        int n4 = screenCapture2.mScreenSize.x;
        int n3 = screenCapture2.mScreenSize.y;
        int n2 = screenCapture2.mOrientation;
        // MONITOREXIT : object
        Platform.logInfo(String.format(Locale.getDefault(), "orien.%d.cap.%dx%d.scr.%dx%d.start", n2, this.mCapWidth, this.mCapHeight, n4, n3));
        if (screenCapture.mVirtualDisplay != null) {
            int n5;
            if (n4 > n3 && this.mCapWidth > this.mCapHeight || n4 < n3 && this.mCapWidth < this.mCapHeight) {
                ScreenCapture screenCapture3 = this;
                n5 = screenCapture3.mCapWidth;
                n4 = screenCapture3.mCapHeight;
            } else {
                ScreenCapture screenCapture4 = this;
                n5 = screenCapture4.mCapHeight;
                n4 = screenCapture4.mCapWidth;
            }
            if (this.configNoLock(n5, n4) == -2) {
                Platform.log(3, "config.fail.while.scr.changed");
            }
            Platform.logDebug(String.format(Locale.getDefault(), "orien.changed.%dx%d", this.mCapWidth, this.mCapHeight));
        }
        // MONITOREXIT : this
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void detectOrientation(boolean var1_1) {
        v0 = var1_1;
        v1 = this;
        var1_1 = v1.mContext.getResources().getConfiguration().orientation;
        var2_2 = v1.mScreenSizeLock;
        synchronized (var2_2) {
            if (v0 != 0) ** GOTO lbl19
            if (var1_1 != this.mOrientation) ** GOTO lbl19
            v3 = Locale.getDefault();
            v4 = new Object[1];
            v4[0] = var1_1;
            Platform.logDebug(String.format(v3, "orien.%d.not.change", v4));
            ** GOTO lbl30
lbl19:
            // 2 sources

            v5 = this;
            v6 = Locale.getDefault();
            v7 = new Object[2];
            v7[0] = var1_1;
            v7[1] = this.mOrientation;
            Platform.logInfo(String.format(v6, "orien.%d.change.to.%d", v7));
            v5.mMainLooper.post(this.mOrientationChangeRunnable);
lbl30:
            // 2 sources

            return;
        }
    }

    private void refreshScreenSizeAndOrientation() {
        int n2 = this.mContext.getResources().getConfiguration().orientation;
        if (n2 == this.mOrientation) {
            return;
        }
        this.mOrientation = n2;
        Display display = this.mWindowMgr.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealSize(this.mScreenSize);
        } else {
            display.getSize(this.mScreenSize);
        }
    }

    @AnyThread
    private int configNoLock(int n2, int n3) {
        Object[] objectArray;
        int n4 = 0;
        if (n2 >= 1 && n3 >= 1) {
            if (n2 == objectArray.mCapWidth && n3 == objectArray.mCapHeight) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = n2;
                objectArray2[1] = n3;
                Platform.logInfo(String.format(Locale.getDefault(), "sz.%dx%d.not.changed", objectArray));
                return n4;
            }
            if (objectArray.mCaptureHasInit && objectArray.mMediaProjection != null) {
                objectArray.mCapWidth = n2;
                objectArray.mCapHeight = n3;
                if (objectArray.mImageHandler != null) {
                    n4 = super.createVirtualDisplay();
                }
                Object[] objectArray3 = new Object[2];
                objectArray = objectArray3;
                objectArray[0] = n2;
                objectArray3[1] = n3;
                Platform.logDebug(String.format(Locale.getDefault(), "config.sz.%dx%d", objectArray));
                return n4;
            }
            Platform.logInfo("config.uninited.or.no.permission");
            return -1;
        }
        Object[] objectArray4 = new Object[2];
        objectArray = objectArray4;
        objectArray[0] = n2;
        objectArray4[1] = n3;
        Platform.logInfo(String.format(Locale.getDefault(), "invalid.sz.%dx%d", objectArray));
        return n4;
    }

    private boolean createMediaProjection(int n2, Intent intent) {
        if (n2 == this.mPermissionRetCode && this.mPermissionRetData == intent && this.mMediaProjection != null) {
            Platform.log(5, "use.same.permission");
            return true;
        }
        if (intent == null) {
            return false;
        }
        MediaProjection mediaProjection = this.mMediaProjection;
        if (mediaProjection != null) {
            mediaProjection.stop();
            this.mMediaProjection.unregisterCallback(this.mMediaProjCallback);
            this.mMediaProjection = null;
        }
        try {
            this.mMediaProjection = this.mMediaProjectionManager.getMediaProjection(n2, intent);
        }
        catch (Exception exception) {
            Platform.log(3, exception.toString());
        }
        if (this.mMediaProjection == null) {
            Platform.log(3, "get.media.projection.failed");
            return false;
        }
        this.mPermissionRetCode = n2;
        this.mPermissionRetData = intent;
        return true;
    }

    private synchronized int setPermissionResult(int n2, Intent intent) {
        if (this.createMediaProjection(n2, intent)) {
            return 0;
        }
        return -1;
    }

    /*
     * Exception decompiling
     */
    private int createVirtualDisplay() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [12 : 103->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @AnyThread
    private synchronized int config(int n2, int n3) {
        return this.configNoLock(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private void stopCapture() {
        Object object;
        block8: {
            ScreenCapture screenCapture = this;
            object = screenCapture.mImageReaderLock;
            synchronized (object) {
                this.mCapturing = false;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : object
                object = screenCapture.mImageHandler;
                if (object == null) break block8;
            }
            object.sendEmptyMessage(4);
        }
        if ((object = this.mVirtualDisplay) != null) {
            this.releaseVirtualDisplay((VirtualDisplay)object);
            this.mVirtualDisplay = null;
        }
        if ((object = this.mMediaProjection) != null) {
            Object object2 = object;
            this.mMediaProjection = null;
            object2.unregisterCallback(this.mMediaProjCallback);
            object2.stop();
        }
        if ((object = this.mImageHandlerThread) != null) {
            try {
                object.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            ScreenCapture screenCapture = this;
            screenCapture.mImageHandlerThread = null;
            screenCapture.mImageHandler = null;
        }
        ScreenCapture screenCapture = this;
        screenCapture.mCapHeight = 0;
        screenCapture.mCapWidth = 0;
        screenCapture.mImageAvailableFrameCount = 0L;
        screenCapture.mFpsTotalActualDelay = 0L;
        screenCapture.mFpsTotalFrameCount = 0L;
        screenCapture.mFpsMinActualDelay = Integer.MAX_VALUE;
        screenCapture.mFpsMaxActualDelay = 0L;
    }

    @WorkerThread
    private static native void onCaptureFramesAvailable(long var0, ByteBuffer var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    @WorkerThread
    private static native void onCaptureFrameSurface(long var0, SurfaceTextureHolder var2, int var3, int var4, int var5, int var6, int var7);

    @WorkerThread
    private static native void onCaptureStop(long var0);

    static /* synthetic */ long access$402(ScreenCapture screenCapture, long l2) {
        screenCapture.mImageAvailableFirstFrameCost = l2;
        return l2;
    }

    static /* synthetic */ Image access$1002(ScreenCapture screenCapture, Image image) {
        screenCapture.mLastImage = image;
        return image;
    }

    static /* synthetic */ long access$608(ScreenCapture screenCapture) {
        long l2 = screenCapture.mImageAvailableFrameCount;
        screenCapture.mImageAvailableFrameCount = l2 + 1L;
        return l2;
    }

    static /* synthetic */ boolean access$902(ScreenCapture screenCapture, boolean bl) {
        screenCapture.mCapturing = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1402(ScreenCapture screenCapture, boolean bl) {
        screenCapture.mTextureFrameAvailable = bl;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public void doFrame(long var1_1) {
        block33: {
            v0 = this;
            var3_2 = v0.mImageReaderLock;
            synchronized (var3_2) {
                if (!v0.mCapturing) {
                    return;
                }
                v1 = this;
                v2 = v1;
                v3 = v1;
            }
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
            var3_3 = System.nanoTime();
            var5_4 = v2.mCapFps;
            var5_4 = 1000000000L / var5_4;
            if (v3.mFpsLastFrameTimeNS + var5_4 > var3_3) {
                return;
            }
            v4 = this;
            var5_5 = v4.mScreenSizeLock;
            v5 = this;
            synchronized (var5_5) {
                v5.refreshScreenSizeAndOrientation();
                var6_8 = v5.mScreenSize.x;
                var7_9 = v5.mScreenSize.y;
                // MONITOREXIT @DISABLED, blocks:[1, 13] lbl26 : MonitorExitStatement: MONITOREXIT : var5_5
                var5_6 = false;
                var8_12 = v4.mImageReaderLock;
            }
            synchronized (var8_12) {
                block35: {
                    block34: {
                        if (v4.mUseSurfaceTexture && this.mSurfaceTextureHolder != null) {
                            if (this.mTextureFrameAvailable) {
                                v6 = this;
                                ScreenCapture.onCaptureFrameSurface(v6.mNativePtr, this.mSurfaceTextureHolder, this.mCapWidth, this.mCapHeight, this.mOrientation, var6_8, var7_9);
                                ++v6.mFpsFrameCount;
                                v6.mTextureFrameAvailable = false;
                            }
                            break block33;
                        }
                        var9_13 = this.mLastImage;
                        this.mLastImage = null;
                        if (var9_13 == null) {
                            break block33;
                        }
                        var10_15 = var9_13.getWidth();
                        if ((var10_15 <= (var11_16 = var9_13.getHeight()) || var6_8 >= var7_9) && (var10_15 >= var11_16 || var6_8 <= var7_9)) break block34;
                        var9_13.close();
                        Platform.logInfo(String.format(Locale.getDefault(), "%h.image.sz.%dx%d.mismatch.scr.%dx%d", new Object[]{this, var10_15, var11_16, var6_8, var7_9}));
                        this.mMismatchFrameCount = this.mMismatchFrameCount + 1;
                        if (this.mMismatchFrameCount > 2) {
                            this.mMismatchFrameCount = 0;
                            var5_6 = true;
                        }
                        break block33;
                    }
                    this.mMismatchFrameCount = 0;
                    if (this.mFpsFirstFrameCost != 0L) break block35;
                    v7 = this;
                    v8 = System.currentTimeMillis() - this.mDisplayCreateTime;
                    v7.mFpsFirstFrameCost = v8;
                    v9 = Locale.getDefault();
                    v10 = "%h.first.frame.%dms";
                    v11 = new Object[2];
                    v11[0] = this;
                    v11[1] = this.mFpsFirstFrameCost;
                    Platform.logInfo(String.format(v9, v10, v11));
                }
                v12 = var9_13;
                v13 = this;
                v14 = var9_13.getPlanes()[0];
                var12_18 = v14.getBuffer();
                var13_19 = v14.getPixelStride();
                var14_20 = v14.getRowStride();
                ScreenCapture.onCaptureFramesAvailable(v13.mNativePtr, var12_18, var10_15, var11_16, var13_19, var14_20, 0, var6_8, var7_9);
                ++v13.mFpsFrameCount;
                ** break block36
            }
        }
        if (var5_6) {
            this.detectOrientation(true);
        }
        var5_7 = 0L;
        var7_10 = System.nanoTime();
        var9_14 = var7_10 - var3_3;
        var11_17 = this.mFpsLastFrameTimeNS;
        if (var11_17 > 0L) {
            var5_7 = (var3_3 - var11_17) / 1000000L;
            if (var5_7 > this.mFpsMaxActualDelay) {
                this.mFpsMaxActualDelay = var5_7;
            }
            if (var5_7 < this.mFpsMinActualDelay) {
                this.mFpsMinActualDelay = var5_7;
            }
            v15 = this;
            v15.mFpsTotalActualDelay += var5_7;
            ++v15.mFpsTotalFrameCount;
        }
        if (var7_10 - this.mFpsLastPrintTickNS > 10000000000L) {
            this.mFpsLastPrintTickNS = var7_10;
            v16 = new Object[5];
            var7_11 = v16;
            var7_11[0] = this;
            var7_11[1] = var9_14 / 1000000L;
            var7_11[2] = var5_7;
            var7_11[3] = (var3_3 - var1_1) / 1000000L;
            v16[4] = this.mFpsFrameCount;
            Platform.logInfo(String.format(Locale.getDefault(), "%h.dur.%dms.act.%dms.vsync.%d.ms.frm_cnt.%d", var7_11));
        }
        this.mFpsLastFrameTimeNS = var1_1;
        return;
        {
            catch (Throwable v17) {}
        }
        {
            catch (Throwable v18) {
                throw v18;
            }
        }
        {
            catch (Throwable v19) {
                throw v19;
            }
        }
lbl-1000:
        // 1 sources

        {
lbl110:
            // 2 sources

            while (true) {
                ** try [egrp 9[TRYBLOCK] [36 : 433->442)] { 
lbl112:
                // 1 sources

                v12.close();
                break;
            }
            {
                catch (Throwable v20) {
                }
                catch (RuntimeException v21) {}
                {
                    v12 = var9_13;
                    Platform.logError(v21.toString());
                    ** continue;
                }
            }
            var9_13.close();
            throw v20;
lbl122:
            // 1 sources

            ** finally { 
        }
    }

    @WorkerThread
    public synchronized int init() {
        if (!this.mCaptureHasInit) {
            IntentFilter intentFilter;
            IntentFilter intentFilter2 = intentFilter;
            intentFilter = new IntentFilter("android.intent.action.CONFIGURATION_CHANGED");
            this.mReceiver = new ConfigurationChangedReceiver();
            this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, intentFilter2);
            this.mCaptureHasInit = true;
        }
        return 0;
    }

    public synchronized void setFps(int n2) {
        this.mCapFps = Math.max(n2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public synchronized void uninit() {
        ConfigurationChangedReceiver configurationChangedReceiver = this.mReceiver;
        if (configurationChangedReceiver != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)configurationChangedReceiver);
            this.mReceiver = null;
        }
        ScreenCapture screenCapture = this;
        screenCapture.stopCapture();
        Object object = screenCapture.mImageReaderLock;
        synchronized (object) {
            if (screenCapture.mSurfaceTextureHolder != null) {
                if (Platform.isDebugBuild) {
                    int n2 = this.mSurfaceTextureHolder.release();
                    Platform.logInfo(String.format(Locale.getDefault(), "holder.release.cnt.%d", n2));
                } else {
                    this.mSurfaceTextureHolder.release();
                }
                this.mSurfaceTextureHolder = null;
            }
            this.mCapturing = false;
            if (this.mLastImage != null) {
                this.mLastImage.close();
                this.mLastImage = null;
            }
            if (this.mImageReader != null) {
                ScreenCapture screenCapture2 = this;
                screenCapture2.mImageReader.setOnImageAvailableListener(null, null);
                screenCapture2.mImageReader.close();
            }
            ScreenCapture screenCapture3 = this;
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl27 : MonitorExitStatement: MONITOREXIT : var1_2
            screenCapture3.mNativePtr = 0L;
            screenCapture3.mImageHandlerThread = null;
            screenCapture3.mImageHandler = null;
            screenCapture3.mCaptureHasInit = false;
            screenCapture3.mPermissionRetData = null;
            return;
        }
    }

    @WorkerThread
    public synchronized int start() {
        Intent intent = objectArray2.mPermissionRetData;
        if (intent == null) {
            return -1;
        }
        if (objectArray2.mMediaProjection == null && !objectArray2.createMediaProjection(objectArray2.mPermissionRetCode, intent)) {
            return -2;
        }
        objectArray2.mImageHandlerThread = new HandlerThread(ScreenCapture.class.getSimpleName(), 0);
        objectArray2.mImageHandlerThread.start();
        objectArray2.mImageHandler = (ScreenCapture)objectArray2.new ImageThreadHandler(objectArray2.mImageHandlerThread.getLooper());
        objectArray2.mMediaProjection.registerCallback(objectArray2.mMediaProjCallback, objectArray2.mImageHandler);
        int n2 = objectArray2.createVirtualDisplay();
        if (n2 != 0) {
            objectArray2.stopCapture();
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n2;
            Platform.logError(String.format(Locale.getDefault(), "createVirtualDisplay.failed.%d", objectArray2));
            return n2;
        }
        if (!sSupportConfigureChanged.get()) {
            objectArray2.mImageHandler.sendEmptyMessage(5);
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray3 = objectArray;
        objectArray3[0] = objectArray2.mCapWidth;
        objectArray[1] = objectArray2.mCapWidth;
        Platform.logDebug(String.format(Locale.getDefault(), "start.succ.%dx%d", objectArray3));
        return 0;
    }

    @WorkerThread
    public synchronized void stop() {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mFpsMinActualDelay;
        objectArray2[1] = this.mFpsTotalActualDelay / Math.max(this.mFpsTotalFrameCount, 1L);
        objectArray2[2] = this.mFpsFrameCount;
        objectArray[3] = this.mImageAvailableFrameCount;
        Platform.logInfo(String.format(Locale.getDefault(), "stop.min.%dms.avg.%dms.frame.count.%d.avail.count.%d", objectArray2));
        this.stopCapture();
    }

    private class SurfaceTextureHandler
    implements SurfaceTextureHolder.EventCallback {
        private SurfaceTextureHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameAvailable(SurfaceTextureHolder object, SurfaceTexture surfaceTexture) {
            object = ScreenCapture.this.mImageReaderLock;
            SurfaceTextureHandler surfaceTextureHandler = this;
            synchronized (object) {
                ScreenCapture screenCapture = surfaceTextureHandler.ScreenCapture.this;
                ScreenCapture.access$1402(screenCapture, true);
                ScreenCapture.access$608(surfaceTextureHandler.ScreenCapture.this);
                return;
            }
        }

        @Override
        public void onRelease(SurfaceTextureHolder surfaceTextureHolder) {
        }
    }

    private class ImageThreadHandler
    extends Handler {
        ImageThreadHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void handleMessage(Message message) {
            int n2 = message.what;
            if (n2 != 3) {
                if (n2 != 4) {
                    if (n2 == 5) {
                        if (!sSupportConfigureChanged.get()) {
                            ImageThreadHandler imageThreadHandler = this;
                            imageThreadHandler.ScreenCapture.this.detectOrientation(false);
                            imageThreadHandler.sendEmptyMessageDelayed(5, 500L);
                        } else {
                            Platform.logInfo("remove.orientation.detector");
                        }
                    }
                } else {
                    ImageThreadHandler imageThreadHandler = this;
                    Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)ScreenCapture.this);
                    imageThreadHandler.removeMessages(5);
                    imageThreadHandler.ScreenCapture.this.mImageHandlerThread.quitSafely();
                    Object object = imageThreadHandler.ScreenCapture.this.mImageReaderLock;
                    synchronized (object) {
                        ScreenCapture screenCapture = ScreenCapture.this;
                        ScreenCapture.access$902(screenCapture, false);
                    }
                }
            } else {
                Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)ScreenCapture.this);
            }
        }
    }

    private class InternalImageReaderListener
    implements ImageReader.OnImageAvailableListener {
        private long mLastAvailableTime = 0L;

        private InternalImageReaderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @WorkerThread
        public void onImageAvailable(ImageReader imageReader) {
            ScreenCapture screenCapture;
            Object[] objectArray;
            if (ScreenCapture.this.mImageAvailableFirstFrameCost == 0L) {
                ScreenCapture.access$402(ScreenCapture.this, System.currentTimeMillis() - ScreenCapture.this.mDisplayCreateTime);
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                screenCapture = ScreenCapture.this;
                objectArray2[0] = screenCapture;
                objectArray2[1] = screenCapture.mImageAvailableFirstFrameCost;
                Platform.logInfo(String.format(Locale.getDefault(), "%h.first.image.avail.%dms", objectArray));
            }
            if (Platform.isDebugBuild && Platform.isLogLevel(5) && ScreenCapture.this.mImageAvailableFrameCount % 100L == 0L) {
                long l2 = System.currentTimeMillis();
                Object[] objectArray3 = new Object[1];
                Object[] objectArray4 = objectArray3;
                objectArray3[0] = (l2 - this.mLastAvailableTime) / 100L;
                Platform.logInfo(String.format(Locale.getDefault(), "avg.%dms", objectArray4));
                this.mLastAvailableTime = l2;
            }
            InternalImageReaderListener internalImageReaderListener = this;
            objectArray = internalImageReaderListener.ScreenCapture.this.mImageReaderLock;
            synchronized (objectArray) {
                if (internalImageReaderListener.ScreenCapture.this.mImageReader == imageReader && ScreenCapture.this.mCapturing) {
                    if (ScreenCapture.this.mLastImage != null) {
                        ScreenCapture.this.mLastImage.close();
                    }
                    imageReader = null;
                    try {
                        screenCapture = ScreenCapture.this.mImageReader.acquireLatestImage();
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        screenCapture = imageReader;
                    }
                    ScreenCapture.access$1002(ScreenCapture.this, (Image)screenCapture);
                    if (screenCapture != null) {
                        ScreenCapture.access$608(ScreenCapture.this);
                    }
                    return;
                }
                return;
            }
        }
    }

    private static class InternalVirtualDisplayCallback
    extends VirtualDisplay.Callback {
        String mDisplayName;

        InternalVirtualDisplayCallback(String string2, ScreenCapture screenCapture) {
            this.mDisplayName = String.valueOf(string2);
        }

        public void onPaused() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mDisplayName;
            Platform.logInfo(String.format("virtual.display.%s.paused", objectArray2));
        }

        public void onResumed() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mDisplayName;
            Platform.logInfo(String.format("virtual.display.%s.resumed", objectArray2));
        }

        public void onStopped() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mDisplayName;
            Platform.logInfo(String.format("virtual.display.%s.stopped", objectArray2));
        }
    }

    private class ConfigurationChangedReceiver
    extends BroadcastReceiver {
        private ConfigurationChangedReceiver() {
        }

        @MainThread
        public void onReceive(Context objectArray, Intent intent) {
            if ("android.intent.action.CONFIGURATION_CHANGED".equals(intent.getAction())) {
                if (!sSupportConfigureChanged.get() && !ScreenCapture.this.isAppForeground()) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = sSupportConfigureChanged.get();
                    Platform.logInfo(String.format("SupportConfigureChanged.%b", objectArray));
                    sSupportConfigureChanged.set(true);
                }
                ScreenCapture.this.onConfigurationChanged();
            }
        }
    }
}

