package com.tencent.wecast.sender.cloud.utils

import android.util.Base64
import java.io.ByteArrayOutputStream
import java.io.IOException
import java.security.KeyFactory
import java.security.interfaces.RSAPublicKey
import java.security.spec.X509EncodedKeySpec
import java.util.*
import javax.crypto.Cipher

object RSAUtils {
    private const val ONCE_ENCRYPT_SIZE = 117

    fun encryptRsa(publicKeyStr: String, content: String): ByteArray? {
        var bos: ByteArrayOutputStream? = null
        try {
            val publicKey = loadPublicKey(publicKeyStr)
            val cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding")
            cipher.init(Cipher.ENCRYPT_MODE, publicKey)

            val bytes = content.toByteArray()
            var start = 0
            bos = ByteArrayOutputStream()
            var bundle: ByteArray
            while (start + ONCE_ENCRYPT_SIZE < bytes.size) {
                bundle = Arrays.copyOfRange(bytes, start, start + ONCE_ENCRYPT_SIZE)
                bos.write(cipher.doFinal(bundle))
                start += ONCE_ENCRYPT_SIZE
            }

            if (start < bytes.size) {
                bundle = Arrays.copyOfRange(bytes, start, bytes.size)
                bos.write(cipher.doFinal(bundle))
            }

            return bos.toByteArray()
        } catch (e: Throwable) {
            return null
        } finally {
            if (bos != null) {
                try {
                    bos.close()
                } catch (e: IOException) {
                    e.printStackTrace()
                }

            }
        }
    }

    private fun loadPublicKey(publicKeyStr: String): RSAPublicKey? {
        return try {
            val rsaPublicKey = publicKeyStr
                    .replace("-----BEGIN PUBLIC KEY-----\n", "")
                    .replace("\n-----END PUBLIC KEY-----", "")
            val keyBytes = Base64.decode(rsaPublicKey, Base64.DEFAULT)
            val keyFactory = KeyFactory.getInstance("RSA")
            val keySpec = X509EncodedKeySpec(keyBytes)
            keyFactory.generatePublic(keySpec) as RSAPublicKey
        } catch (e: Throwable) {
            null
        }

    }
}