package com.tencent.wecast.sender.cloud.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.BaseAdapter
import android.widget.RelativeLayout
import android.widget.TextView
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.sender.cloud.bean.FunctionItemInfo

class FunctionListAdapter(context: Context, private val mFunctionItemList: List<FunctionItemInfo>) : BaseAdapter() {
    private val mContext = context

    override fun getItem(position: Int): Any? {
        return if (mFunctionItemList.isNotEmpty()) {
            mFunctionItemList[position]
        } else {
            null
        }
    }

    override fun getItemId(position: Int): Long {
        return position.toLong()
    }

    override fun getCount(): Int {
        return mFunctionItemList.size
    }

    override fun getView(position: Int, convertView: View?, parent: ViewGroup?): View {
        var rootView: View? = null
        val viewHolder: ViewHolder
        if (rootView == null) {
            rootView = LayoutInflater.from(mContext).inflate(R.layout.wecast_function_list_item, parent, false)
            viewHolder = ViewHolder()
            viewHolder.rlFunctionItemRootView = rootView?.findViewById(R.id.rl_function_item)
            viewHolder.tvFunctionItemTitle = rootView?.findViewById(R.id.tv_function_title_item)
            rootView?.tag = viewHolder
        } else {
            viewHolder = rootView.tag as ViewHolder
        }
        viewHolder.rlFunctionItemRootView?.setOnClickListener {
            if (mFunctionItemList[position].clickFunc != null) {
                mFunctionItemList[position].clickFunc!!()
            }
        }
        viewHolder.tvFunctionItemTitle?.text = mFunctionItemList[position].title
        return rootView!!
    }

    private class ViewHolder {
        var rlFunctionItemRootView: RelativeLayout? = null
        var tvFunctionItemTitle: TextView? = null
    }
}