/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast.audio;

import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.util.Log;
import com.tencent.xcast.audio.ContextUtils;
import java.util.Arrays;
import java.util.List;

public final class WebRtcAudioUtils {
    private static final String TAG = "WebRtcAudioUtils";
    private static final String[] BLACKLISTED_OPEN_SL_ES_MODELS = new String[0];
    private static final String[] BLACKLISTED_AEC_MODELS = new String[0];
    private static final String[] BLACKLISTED_NS_MODELS = new String[0];
    private static final int DEFAULT_SAMPLE_RATE_HZ = 16000;
    private static int defaultSampleRateHz = 16000;
    private static boolean isDefaultSampleRateOverridden;
    private static boolean useWebRtcBasedAcousticEchoCanceler;
    private static boolean useWebRtcBasedNoiseSuppressor;

    public static synchronized void setWebRtcBasedAcousticEchoCanceler(boolean bl) {
        useWebRtcBasedAcousticEchoCanceler = bl;
    }

    public static synchronized void setWebRtcBasedNoiseSuppressor(boolean bl) {
        useWebRtcBasedNoiseSuppressor = bl;
    }

    public static synchronized void setWebRtcBasedAutomaticGainControl(boolean bl) {
        Log.w((String)TAG, (String)"setWebRtcBasedAutomaticGainControl() is deprecated");
    }

    public static synchronized boolean useWebRtcBasedAcousticEchoCanceler() {
        if (useWebRtcBasedAcousticEchoCanceler) {
            Log.w((String)TAG, (String)"Overriding default behavior; now using WebRTC AEC!");
        }
        return useWebRtcBasedAcousticEchoCanceler;
    }

    public static synchronized boolean useWebRtcBasedNoiseSuppressor() {
        if (useWebRtcBasedNoiseSuppressor) {
            Log.w((String)TAG, (String)"Overriding default behavior; now using WebRTC NS!");
        }
        return useWebRtcBasedNoiseSuppressor;
    }

    public static synchronized boolean useWebRtcBasedAutomaticGainControl() {
        return true;
    }

    public static boolean isAutomaticGainControlSupported() {
        return false;
    }

    public static synchronized void setDefaultSampleRateHz(int n2) {
        isDefaultSampleRateOverridden = true;
        defaultSampleRateHz = n2;
    }

    public static synchronized boolean isDefaultSampleRateOverridden() {
        return isDefaultSampleRateOverridden;
    }

    public static synchronized int getDefaultSampleRateHz() {
        return defaultSampleRateHz;
    }

    public static List<String> getBlackListedModelsForAecUsage() {
        return Arrays.asList(BLACKLISTED_AEC_MODELS);
    }

    public static List<String> getBlackListedModelsForNsUsage() {
        return Arrays.asList(BLACKLISTED_NS_MODELS);
    }

    public static String getThreadInfo() {
        return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
    }

    public static boolean runningOnEmulator() {
        return Build.HARDWARE.equals("goldfish") && Build.BRAND.startsWith("generic_");
    }

    public static boolean deviceIsBlacklistedForOpenSLESUsage() {
        return Arrays.asList(BLACKLISTED_OPEN_SL_ES_MODELS).contains(Build.MODEL);
    }

    static void logDeviceInfo(String string2) {
        Log.d((String)string2, (String)("Android SDK: " + Build.VERSION.SDK_INT + ", Release: " + Build.VERSION.RELEASE + ", Brand: " + Build.BRAND + ", Device: " + Build.DEVICE + ", Id: " + Build.ID + ", Hardware: " + Build.HARDWARE + ", Manufacturer: " + Build.MANUFACTURER + ", Model: " + Build.MODEL + ", Product: " + Build.PRODUCT));
    }

    static void logAudioState(String string2) {
        String string3 = string2;
        WebRtcAudioUtils.logDeviceInfo(string3);
        AudioManager audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        WebRtcAudioUtils.logAudioStateBasic(string2, audioManager);
        WebRtcAudioUtils.logAudioStateVolume(string2, audioManager);
        WebRtcAudioUtils.logAudioDeviceInfo(string3, audioManager);
    }

    private static void logAudioStateBasic(String string2, AudioManager audioManager) {
        Log.d((String)string2, (String)("Audio State: audio mode: " + WebRtcAudioUtils.modeToString(audioManager.getMode()) + ", has mic: " + WebRtcAudioUtils.hasMicrophone() + ", mic muted: " + audioManager.isMicrophoneMute() + ", music active: " + audioManager.isMusicActive() + ", speakerphone: " + audioManager.isSpeakerphoneOn() + ", BT SCO: " + audioManager.isBluetoothScoOn()));
    }

    private static boolean isVolumeFixed(AudioManager audioManager) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return audioManager.isVolumeFixed();
    }

    private static void logAudioStateVolume(String string2, AudioManager audioManager) {
        int[] nArray = new int[6];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 3;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 1;
        Log.d((String)string2, (String)"Audio State: ");
        int n2 = WebRtcAudioUtils.isVolumeFixed(audioManager);
        Log.d((String)string2, (String)("  fixed volume=" + (n2 != 0)));
        if (n2 == 0) {
            n2 = nArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                StringBuilder stringBuilder;
                String string3 = string2;
                int n3 = nArray2[i2];
                StringBuilder stringBuilder2 = stringBuilder;
                new StringBuilder().append("  " + WebRtcAudioUtils.streamTypeToString(n3) + ": ");
                stringBuilder2.append("volume=").append(audioManager.getStreamVolume(n3));
                stringBuilder2.append(", max=").append(audioManager.getStreamMaxVolume(n3));
                WebRtcAudioUtils.logIsStreamMute(string3, audioManager, n3, stringBuilder2);
                Log.d((String)string3, (String)stringBuilder2.toString());
            }
        }
    }

    private static void logIsStreamMute(String string2, AudioManager audioManager, int n2, StringBuilder stringBuilder) {
        if (Build.VERSION.SDK_INT >= 23) {
            stringBuilder.append(", muted=").append(audioManager.isStreamMute(n2));
        }
    }

    private static void logAudioDeviceInfo(String string2, AudioManager audioDeviceInfoArray) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if ((audioDeviceInfoArray = audioDeviceInfoArray.getDevices(3)).length == 0) {
            return;
        }
        Log.d((String)string2, (String)"Audio Devices: ");
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            new StringBuilder().append("  ").append(WebRtcAudioUtils.deviceTypeToString(audioDeviceInfo.getType()));
            String string3 = audioDeviceInfo.isSource() ? "(in): " : "(out): ";
            stringBuilder2.append(string3);
            if (audioDeviceInfo.getChannelCounts().length > 0) {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append("channels=").append(Arrays.toString(audioDeviceInfo.getChannelCounts()));
                stringBuilder3.append(", ");
            }
            if (audioDeviceInfo.getEncodings().length > 0) {
                StringBuilder stringBuilder4 = stringBuilder2;
                stringBuilder4.append("encodings=").append(Arrays.toString(audioDeviceInfo.getEncodings()));
                stringBuilder4.append(", ");
            }
            if (audioDeviceInfo.getSampleRates().length > 0) {
                StringBuilder stringBuilder5 = stringBuilder2;
                stringBuilder5.append("sample rates=").append(Arrays.toString(audioDeviceInfo.getSampleRates()));
                stringBuilder5.append(", ");
            }
            StringBuilder stringBuilder6 = stringBuilder2;
            stringBuilder6.append("id=").append(audioDeviceInfo.getId());
            Log.d((String)string2, (String)stringBuilder6.toString());
        }
    }

    static String modeToString(int n2) {
        switch (n2) {
            default: {
                return "MODE_INVALID";
            }
            case 3: {
                return "MODE_IN_COMMUNICATION";
            }
            case 2: {
                return "MODE_IN_CALL";
            }
            case 1: {
                return "MODE_RINGTONE";
            }
            case 0: 
        }
        return "MODE_NORMAL";
    }

    private static String streamTypeToString(int n2) {
        switch (n2) {
            default: {
                return "STREAM_INVALID";
            }
            case 5: {
                return "STREAM_NOTIFICATION";
            }
            case 4: {
                return "STREAM_ALARM";
            }
            case 3: {
                return "STREAM_MUSIC";
            }
            case 2: {
                return "STREAM_RING";
            }
            case 1: {
                return "STREAM_SYSTEM";
            }
            case 0: 
        }
        return "STREAM_VOICE_CALL";
    }

    private static String deviceTypeToString(int n2) {
        switch (n2) {
            default: {
                return "TYPE_UNKNOWN";
            }
            case 21: {
                return "TYPE_BUS";
            }
            case 20: {
                return "TYPE_IP";
            }
            case 19: {
                return "TYPE_AUX_LINE";
            }
            case 18: {
                return "TYPE_TELEPHONY";
            }
            case 17: {
                return "TYPE_TV_TUNER";
            }
            case 16: {
                return "TYPE_FM_TUNER";
            }
            case 15: {
                return "TYPE_BUILTIN_MIC";
            }
            case 14: {
                return "TYPE_FM";
            }
            case 13: {
                return "TYPE_DOCK";
            }
            case 12: {
                return "TYPE_USB_ACCESSORY";
            }
            case 11: {
                return "TYPE_USB_DEVICE";
            }
            case 10: {
                return "TYPE_HDMI_ARC";
            }
            case 9: {
                return "TYPE_HDMI";
            }
            case 8: {
                return "TYPE_BLUETOOTH_A2DP";
            }
            case 7: {
                return "TYPE_BLUETOOTH_SCO";
            }
            case 6: {
                return "TYPE_LINE_DIGITAL";
            }
            case 5: {
                return "TYPE_LINE_ANALOG";
            }
            case 4: {
                return "TYPE_WIRED_HEADPHONES";
            }
            case 3: {
                return "TYPE_WIRED_HEADSET";
            }
            case 2: {
                return "TYPE_BUILTIN_SPEAKER";
            }
            case 1: {
                return "TYPE_BUILTIN_EARPIECE";
            }
            case 0: 
        }
        return "TYPE_UNKNOWN";
    }

    private static boolean hasMicrophone() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.microphone");
    }
}

