/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast.audio;

import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.Log;
import com.tencent.xcast.audio.ContextUtils;
import com.tencent.xcast.audio.QLog;
import com.tencent.xcast.audio.TelephoneObserver;
import com.tencent.xcast.audio.TraeAudioManager;
import com.tencent.xcast.audio.TraeAudioSession;
import com.tencent.xcast.audio.WebRtcAudioUtils;
import java.util.Timer;
import java.util.TimerTask;

public class WebRtcAudioManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioManager";
    private static final boolean blacklistDeviceForAAudioUsage = true;
    private static boolean useStereoOutput;
    private static boolean useStereoInput;
    private static boolean blacklistDeviceForOpenSLESUsage;
    private static boolean blacklistDeviceForOpenSLESUsageIsOverridden;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;
    private static String[] mDeviceList;
    public static final int OUTPUT_MODE_HEADSET = 1;
    public static final int OUTPUT_MODE_SPEAKER = 0;
    private final long nativeAudioManager;
    private final AudioManager audioManager;
    private boolean initialized;
    private int nativeSampleRate;
    private int nativeChannels;
    private boolean hardwareAEC;
    private boolean hardwareAGC;
    private boolean hardwareNS;
    private boolean lowLatencyOutput;
    private boolean lowLatencyInput;
    private boolean proAudio;
    private boolean aAudio;
    private int sampleRate;
    private int outputChannels;
    private int inputChannels;
    private int outputBufferSize;
    private int inputBufferSize;
    private final VolumeLogger volumeLogger;
    private TraeAudioSession _asAudioManager;
    private int switchState;
    private String deviceConnectedName;

    public static synchronized void setBlacklistDeviceForOpenSLESUsage(boolean bl) {
        blacklistDeviceForOpenSLESUsageIsOverridden = true;
        blacklistDeviceForOpenSLESUsage = bl;
    }

    public static synchronized void setStereoOutput(boolean bl) {
        Log.w((String)TAG, (String)("Overriding default output behavior: setStereoOutput(" + bl + ')'));
        useStereoOutput = bl;
    }

    public static synchronized void setStereoInput(boolean bl) {
        Log.w((String)TAG, (String)("Overriding default input behavior: setStereoInput(" + bl + ')'));
        useStereoInput = bl;
    }

    public static synchronized boolean getStereoOutput() {
        return useStereoOutput;
    }

    public static synchronized boolean getStereoInput() {
        return useStereoInput;
    }

    WebRtcAudioManager(long l2) {
        WebRtcAudioManager webRtcAudioManager = this;
        this._asAudioManager = null;
        this.switchState = 0;
        this.deviceConnectedName = "";
        Log.d((String)TAG, (String)("ctor" + WebRtcAudioUtils.getThreadInfo()));
        webRtcAudioManager.nativeAudioManager = l2;
        webRtcAudioManager.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        webRtcAudioManager.volumeLogger = new VolumeLogger(this.audioManager);
        webRtcAudioManager.storeAudioParameters();
        webRtcAudioManager.nativeCacheAudioParameters(webRtcAudioManager.sampleRate, this.outputChannels, this.inputChannels, this.hardwareAEC, this.hardwareAGC, this.hardwareNS, this.lowLatencyOutput, this.lowLatencyInput, this.proAudio, this.aAudio, this.outputBufferSize, this.inputBufferSize, l2);
        WebRtcAudioUtils.logAudioState(TAG);
    }

    private boolean init() {
        Log.d((String)TAG, (String)("init" + WebRtcAudioUtils.getThreadInfo()));
        if (this.initialized) {
            return true;
        }
        Log.d((String)TAG, (String)("audio mode is: " + WebRtcAudioUtils.modeToString(this.audioManager.getMode())));
        this.initialized = true;
        this.volumeLogger.start();
        return true;
    }

    private void dispose() {
        Log.d((String)TAG, (String)("dispose" + WebRtcAudioUtils.getThreadInfo()));
        if (!this.initialized) {
            return;
        }
        this.volumeLogger.stop();
    }

    private int InitSetting(int n2) {
        if (n2 == 1) {
            TraeAudioManager.IsMusicScene = true;
            TraeAudioManager.IsEarPhoneSupported = false;
        } else {
            TraeAudioManager.IsMusicScene = false;
            TraeAudioManager.IsEarPhoneSupported = true;
        }
        TraeAudioManager.IsUpdateSceneFlag = true;
        TraeAudioManager.nSceneMode = n2;
        QLog.w(TAG, "InitSetting: sceneMode:" + n2);
        return 0;
    }

    private boolean isCommunicationModeEnabled() {
        return this.audioManager.getMode() == 3;
    }

    private boolean isDeviceBlacklistedForOpenSLESUsage() {
        boolean bl = blacklistDeviceForOpenSLESUsageIsOverridden ? blacklistDeviceForOpenSLESUsage : WebRtcAudioUtils.deviceIsBlacklistedForOpenSLESUsage();
        if (bl) {
            Log.d((String)TAG, (String)(Build.MODEL + " is blacklisted for OpenSL ES usage!"));
        }
        return bl;
    }

    private void storeAudioParameters() {
        int n2 = WebRtcAudioManager.getStereoOutput() ? 2 : 1;
        this.outputChannels = n2;
        n2 = WebRtcAudioManager.getStereoInput() ? 2 : 1;
        WebRtcAudioManager webRtcAudioManager = this;
        webRtcAudioManager.inputChannels = n2;
        webRtcAudioManager.sampleRate = webRtcAudioManager.getNativeOutputSampleRate();
        webRtcAudioManager.hardwareAEC = true;
        webRtcAudioManager.hardwareAGC = false;
        webRtcAudioManager.hardwareNS = true;
        webRtcAudioManager.lowLatencyOutput = webRtcAudioManager.isLowLatencyOutputSupported();
        webRtcAudioManager.lowLatencyInput = webRtcAudioManager.isLowLatencyInputSupported();
        webRtcAudioManager.proAudio = webRtcAudioManager.isProAudioSupported();
        webRtcAudioManager.aAudio = webRtcAudioManager.isAAudioSupported();
        n2 = webRtcAudioManager.lowLatencyOutput ? this.getLowLatencyOutputFramesPerBuffer() : WebRtcAudioManager.getMinOutputFrameSize(this.sampleRate, this.outputChannels);
        this.outputBufferSize = n2;
        n2 = this.lowLatencyInput ? this.getLowLatencyInputFramesPerBuffer() : WebRtcAudioManager.getMinInputFrameSize(this.sampleRate, this.inputChannels);
        this.inputBufferSize = n2;
    }

    private boolean hasEarpiece() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private boolean isLowLatencyOutputSupported() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    private boolean isProAudioSupported() {
        return Build.VERSION.SDK_INT >= 23 && ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.pro");
    }

    private boolean isAAudioSupported() {
        Log.w((String)TAG, (String)"AAudio support is currently disabled on all devices!");
        return false;
    }

    private int getNativeOutputSampleRate() {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Log.d((String)TAG, (String)"Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        if (WebRtcAudioUtils.isDefaultSampleRateOverridden()) {
            Log.d((String)TAG, (String)("Default sample rate is overriden to " + WebRtcAudioUtils.getDefaultSampleRateHz() + " Hz"));
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        int n2 = this.getSampleRateForApiLevel();
        Log.d((String)TAG, (String)("Sample rate is set to " + n2 + " Hz"));
        return n2;
    }

    private int getSampleRateForApiLevel() {
        if (Build.VERSION.SDK_INT < 17) {
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        String string2 = ((WebRtcAudioManager)((Object)string2)).audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return string2 == null ? WebRtcAudioUtils.getDefaultSampleRateHz() : Integer.parseInt(string2);
    }

    private int getLowLatencyOutputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(((WebRtcAudioManager)((Object)string2)).isLowLatencyOutputSupported());
        if (Build.VERSION.SDK_INT < 17) {
            return 256;
        }
        String string2 = ((WebRtcAudioManager)((Object)string2)).audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return string2 == null ? 256 : Integer.parseInt(string2);
    }

    private static int getMinOutputFrameSize(int n2, int n3) {
        int n4 = n3;
        n3 = n4 * 2;
        int n5 = n4 == 1 ? 4 : 12;
        return AudioTrack.getMinBufferSize((int)n2, (int)n5, (int)2) / n3;
    }

    private int getLowLatencyInputFramesPerBuffer() {
        WebRtcAudioManager webRtcAudioManager = this;
        WebRtcAudioManager.assertTrue(webRtcAudioManager.isLowLatencyInputSupported());
        return webRtcAudioManager.getLowLatencyOutputFramesPerBuffer();
    }

    private static int getMinInputFrameSize(int n2, int n3) {
        int n4 = n3;
        n3 = n4 * 2;
        int n5 = n4 == 1 ? 16 : 12;
        return AudioRecord.getMinBufferSize((int)n2, (int)n5, (int)2) / n3;
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private native void nativeCacheAudioParameters(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, int var12, long var13);

    private native void nativeNotifyAudioRouteSwitch(String var1, int var2, long var3);

    private void setAudioManagerMode(int n2, int n3) {
        Log.d((String)TAG, (String)("setAudioManagerMode, setMode: " + n2 + ", isStop:" + n3));
        if (n3 == 0 && TelephoneObserver.getPhoneInterruptFlag()) {
            this.startTRAEService();
        }
        WebRtcAudioManager webRtcAudioManager = this;
        webRtcAudioManager.audioManager.setMode(n2);
        if (webRtcAudioManager._asAudioManager != null && n3 == 0) {
            this.reConnectDevice();
            if (TelephoneObserver.getPhoneInterruptFlag()) {
                TelephoneObserver.resetPhoneInterruptFlag();
            }
            this._asAudioManager.getDeviceList();
        }
        if (n3 == 1 && TelephoneObserver.getPhoneInterruptFlag()) {
            this.stopTRAEService();
        }
    }

    private void onOutputChanage(String string2, String string3) {
        if (TelephoneObserver.getPhoneInterruptFlag()) {
            QLog.w(TAG, "phoneInterrupt do nothing, onOutputChanage:" + string2);
            return;
        }
        QLog.w(TAG, " onOutputChanage:" + string2);
        if (string2.equals("DEVICE_EARPHONE")) {
            this.switchState = 1;
        } else if (string2.equals("DEVICE_SPEAKERPHONE")) {
            this.switchState = 2;
        } else if (string2.equals("DEVICE_WIREDHEADSET")) {
            this.switchState = 3;
        } else if (string2.equals("DEVICE_BLUETOOTHHEADSET")) {
            this.switchState = 4;
            if (!string3.equals("")) {
                this.deviceConnectedName = string3;
            }
        } else {
            this.switchState = 0;
        }
        if (this.switchState != 4 && !string3.equals("")) {
            this.deviceConnectedName = string2;
        }
        WebRtcAudioManager webRtcAudioManager = this;
        webRtcAudioManager.nativeNotifyAudioRouteSwitch(webRtcAudioManager.deviceConnectedName, this.switchState, this.nativeAudioManager);
    }

    private void initTRAEAudioManager() {
        if (ContextUtils.getApplicationContext() != null) {
            TraeAudioManager.init(ContextUtils.getApplicationContext());
            QLog.w(TAG, "initTRAEAudioManager , TraeAudioSession create");
            if (this._asAudioManager == null) {
                this._asAudioManager = new TraeAudioSession(ContextUtils.getApplicationContext(), new TraeAudioSession.ITraeAudioCallback(){

                    @Override
                    public void onServiceStateUpdate(boolean bl) {
                    }

                    @Override
                    public void onDeviceListUpdate(String[] stringArray, String string2, String string3, String string4) {
                        WebRtcAudioManager.access$202(stringArray);
                        WebRtcAudioManager.this.onOutputChanage(string2, string4);
                    }

                    @Override
                    public void onDeviceChangabledUpdate(boolean bl) {
                    }

                    @Override
                    public void onGetDeviceListRes(int n2, String[] stringArray, String string2, String string3, String string4) {
                        WebRtcAudioManager.access$202(stringArray);
                        WebRtcAudioManager.this.onOutputChanage(string2, string4);
                    }

                    @Override
                    public void onConnectDeviceRes(int n2, String string2, boolean bl) {
                    }

                    @Override
                    public void onIsDeviceChangabledRes(int n2, boolean bl) {
                    }

                    @Override
                    public void onGetConnectedDeviceRes(int n2, String string2) {
                    }

                    @Override
                    public void onGetConnectingDeviceRes(int n2, String string2) {
                    }

                    @Override
                    public void onRingCompletion(int n2, String string2) {
                    }

                    @Override
                    public void onStreamTypeUpdate(int n2) {
                    }

                    @Override
                    public void onGetStreamTypeRes(int n2, int n3) {
                    }

                    @Override
                    public void onVoicecallPreprocessRes(int n2) {
                    }

                    @Override
                    public void onAudioRouteSwitchStart(String string2, String string3) {
                    }

                    @Override
                    public void onAudioRouteSwitchEnd(String string2, long l2) {
                    }
                });
            }
            this._asAudioManager.startService("DEVICE_EARPHONE;DEVICE_SPEAKERPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;");
        }
    }

    private int startService(String string2) {
        QLog.w(TAG, "TraeAudioSession startService: " + (Object)((Object)((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager) + " deviceConfig:" + string2);
        TraeAudioSession traeAudioSession = ((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager;
        if (traeAudioSession != null) {
            return traeAudioSession.startService(string2);
        }
        return -1;
    }

    private int stopService() {
        QLog.w(TAG, "TraeAudioSession stopService: " + (Object)((Object)((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager));
        TraeAudioSession traeAudioSession = ((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager;
        if (traeAudioSession != null) {
            return traeAudioSession.stopService();
        }
        return -1;
    }

    private int startTRAEService() {
        String string2 = "DEVICE_EARPHONE;DEVICE_SPEAKERPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;";
        QLog.w(TAG, "TraeAudioSession startTRAEService: " + (Object)((Object)((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager) + " deviceConfig:" + string2);
        TraeAudioSession traeAudioSession = ((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager;
        if (traeAudioSession != null) {
            return traeAudioSession.startService(string2);
        }
        return -1;
    }

    private int stopTRAEService() {
        QLog.w(TAG, "TraeAudioSession stopTRAEService: " + (Object)((Object)((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager));
        TraeAudioSession traeAudioSession = ((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager;
        if (traeAudioSession != null) {
            return traeAudioSession.stopService();
        }
        return -1;
    }

    private int reConnectDevice() {
        int n2 = ((WebRtcAudioManager)((Object)traeAudioSession)).switchState;
        String string2 = n2 == 1 ? "DEVICE_EARPHONE" : (n2 == 2 ? "DEVICE_SPEAKERPHONE" : (n2 == 3 ? "DEVICE_WIREDHEADSET" : (n2 == 4 ? "DEVICE_BLUETOOTHHEADSET" : "DEVICE_NONE")));
        QLog.w(TAG, "TraeAudioSession reConnectDevice: " + string2);
        TraeAudioSession traeAudioSession = ((WebRtcAudioManager)((Object)traeAudioSession))._asAudioManager;
        if (traeAudioSession != null) {
            return traeAudioSession.forceConnectDevice(string2);
        }
        return -1;
    }

    private void uninitTRAEAudioManager() {
        if (ContextUtils.getApplicationContext() != null) {
            QLog.w(TAG, "uninitTRAEAudioManager , stopService");
            TraeAudioSession traeAudioSession = this._asAudioManager;
            if (traeAudioSession != null) {
                traeAudioSession.stopService();
                this._asAudioManager.release();
                this._asAudioManager = null;
            }
            TraeAudioManager.IsUpdateSceneFlag = false;
        } else {
            QLog.w(TAG, "uninitTRAEAudioManager , context null");
        }
    }

    private int SetAudioOutputMode(int n2) {
        QLog.w("TRAE", "TraeAudioSession SetAudioOutputMode: " + n2);
        if (1 == n2) {
            if (mDeviceList != null && object._asAudioManager != null) {
                n2 = 0;
                block0: do {
                    String[] stringArray;
                    int n3 = 0;
                    while (true) {
                        stringArray = mDeviceList;
                        if (n3 >= mDeviceList.length || n2 != 0) break;
                        if ("DEVICE_WIREDHEADSET".equals(stringArray[n3])) {
                            object._asAudioManager.connectDevice("DEVICE_WIREDHEADSET");
                            n2 = 1;
                            break;
                        }
                        ++n3;
                    }
                    n3 = 0;
                    while (true) {
                        stringArray = mDeviceList;
                        if (n3 >= mDeviceList.length || n2 != 0) break;
                        if ("DEVICE_BLUETOOTHHEADSET".equals(stringArray[n3])) {
                            object._asAudioManager.connectDevice("DEVICE_BLUETOOTHHEADSET");
                            n2 = 1;
                            break;
                        }
                        ++n3;
                    }
                    n3 = 0;
                    while (true) {
                        stringArray = mDeviceList;
                        if (n3 >= mDeviceList.length || n2 != 0) continue block0;
                        if ("DEVICE_EARPHONE".equals(stringArray[n3])) {
                            object._asAudioManager.connectDevice("DEVICE_EARPHONE");
                            n2 = 1;
                            continue block0;
                        }
                        ++n3;
                    }
                } while (n2 == 0);
                return 0;
            }
            return -1;
        }
        if (n2 == 0) {
            Object object = object._asAudioManager;
            if (object == null) {
                return -1;
            }
            ((TraeAudioSession)((Object)object)).connectDevice("DEVICE_SPEAKERPHONE");
            return 0;
        }
        return -1;
    }

    static /* synthetic */ String[] access$202(String[] stringArray) {
        mDeviceList = stringArray;
        return stringArray;
    }

    public boolean isLowLatencyInputSupported() {
        return Build.VERSION.SDK_INT >= 21 && this.isLowLatencyOutputSupported();
    }

    public int getAudioRouteSwitchState() {
        return this.switchState;
    }

    private static class VolumeLogger {
        private static final String THREAD_NAME = "WebRtcVolumeLevelLoggerThread";
        private static final int TIMER_PERIOD_IN_SECONDS = 30;
        private final AudioManager audioManager;
        @Nullable
        private Timer timer;

        public VolumeLogger(AudioManager audioManager) {
            this.audioManager = audioManager;
        }

        private void stop() {
            Timer timer = this.timer;
            if (timer != null) {
                timer.cancel();
                this.timer = null;
            }
        }

        public void start() {
            this.timer = new Timer(THREAD_NAME);
            VolumeLogger volumeLogger = this;
            this.timer.schedule((TimerTask)volumeLogger.new LogVolumeTask(volumeLogger.audioManager.getStreamMaxVolume(2), this.audioManager.getStreamMaxVolume(0)), 0L, 30000L);
        }

        private class LogVolumeTask
        extends TimerTask {
            private final int maxRingVolume;
            private final int maxVoiceCallVolume;

            LogVolumeTask(int n2, int n3) {
                this.maxRingVolume = n2;
                this.maxVoiceCallVolume = n3;
            }

            @Override
            public void run() {
                int n2 = VolumeLogger.this.audioManager.getMode();
                if (n2 == 1) {
                    Log.d((String)WebRtcAudioManager.TAG, (String)("STREAM_RING stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(2) + " (max=" + this.maxRingVolume + ")"));
                } else if (n2 == 3) {
                    Log.d((String)WebRtcAudioManager.TAG, (String)("VOICE_CALL stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(0) + " (max=" + this.maxVoiceCallVolume + ")"));
                }
            }
        }
    }
}

