/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.annotation.TargetApi;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLCore10;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.RefCountDelegate;
import java.util.Locale;

@RequiresApi(value=17)
class EGLCore14
extends RefCountDelegate
implements EGLCoreContext {
    private static final boolean isAndroidPresentationTimeAvailable = Build.VERSION.SDK_INT >= 18;
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLSurface mEGLSurface = EGL14.EGL_NO_SURFACE;
    private EGLContext mEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;
    private boolean mIsOffscreen = false;

    EGLCore14(int n2) {
        EGLCore10.CONTEXT_ATTR[1] = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createContext(EGLCoreContext eGLContext, boolean bl) {
        if (eGLContext != null && !(eGLContext instanceof EGLCore14)) {
            Platform.logError("create.shared.context.type.error");
            return false;
        }
        EGLCore14 eGLCore14 = this;
        eGLCore14.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        Object object = new int[2];
        EGL14.eglInitialize((EGLDisplay)eGLCore14.mEGLDisplay, (int[])object, (int)0, (int[])object, (int)1);
        object = new EGLConfig[1];
        int[] nArray = new int[1];
        EGLDisplay eGLDisplay = eGLCore14.mEGLDisplay;
        int[] nArray2 = bl ? EGLCore10.CONFIG_RGBA : EGLCore10.CONFIG_RGB;
        int n2 = ((int[])object).length;
        if (EGL14.eglChooseConfig((EGLDisplay)eGLDisplay, (int[])nArray2, (int)0, (EGLConfig[])object, (int)0, (int)n2, (int[])nArray, (int)0) && nArray[0] != 0) {
            this.mEGLConfig = (EGLConfig)object[0];
            eGLContext = eGLContext != null ? ((EGLCore14)eGLContext).mEGLContext : EGL14.EGL_NO_CONTEXT;
            Object object2 = EGLCore.sLock;
            object = object2;
            synchronized (object) {
                block6: {
                    EGLDisplay eGLDisplay2 = this.mEGLDisplay;
                    EGLConfig eGLConfig = this.mEGLConfig;
                    EGLContext eGLContext2 = eGLContext;
                    int[] nArray3 = EGLCore10.CONTEXT_ATTR;
                    this.mEGLContext = EGL14.eglCreateContext((EGLDisplay)eGLDisplay2, (EGLConfig)eGLConfig, (EGLContext)eGLContext2, (int[])nArray3, (int)0);
                    // ** MonitorExit[v1] (shouldn't be in output)
                    if (!EGLCore.LOG_EGL) break block6;
                    EGLContext eGLContext3 = new Object[3];
                    eGLContext = eGLContext3;
                    eGLContext[0] = this;
                    eGLContext3[1] = this.mEGLContext;
                    eGLContext3[2] = Thread.currentThread().getId();
                    Platform.logInfo(String.format(Locale.CHINA, "%h.createContext.ctx.%h.tid.%d", (Object[])eGLContext));
                }
                return this.hasContext();
            }
        }
        Platform.logError("no.config.found");
        return false;
    }

    @Override
    public void destroyContext() {
        if (EGLCore.LOG_EGL) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this;
            objectArray[1] = this.mEGLContext;
            objectArray[2] = Thread.currentThread().getId();
            Platform.logInfo(String.format(Locale.CHINA, "%h.destroyContext.ctx.%h.tid.%d", objectArray2));
        }
        if (this.hasContext()) {
            EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglReleaseThread();
            this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        }
        if (!this.mEGLDisplay.equals((Object)EGL14.EGL_NO_DISPLAY)) {
            EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
            this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        }
        this.mEGLConfig = null;
    }

    @Override
    public boolean createSurface(Object objectArray) {
        if (!this.hasContext()) {
            Platform.logError("mEGLContext.not.initialized");
            return false;
        }
        this.destroySurface();
        if (objectArray != null) {
            Object[] objectArray2;
            try {
                int[] nArray = objectArray2 = new int[1];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray3 = new Object[2];
                objectArray2 = objectArray3;
                objectArray2[0] = (int)this;
                objectArray3[1] = illegalArgumentException.toString();
                Platform.logError(String.format(Locale.CHINA, "%h.eglCreateWindowSurface.%s", objectArray2));
                return false;
            }
            nArray[0] = 12344;
            EGLDisplay eGLDisplay = this.mEGLDisplay;
            EGLConfig eGLConfig = this.mEGLConfig;
            this.mEGLSurface = EGL14.eglCreateWindowSurface((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (Object)objectArray, (int[])objectArray2, (int)0);
            this.mIsOffscreen = false;
        } else {
            int[] nArray = new int[7];
            objectArray = nArray;
            nArray[0] = 12375;
            nArray[1] = 1;
            nArray[2] = 12374;
            nArray[3] = 1;
            nArray[4] = 12376;
            nArray[5] = 1;
            nArray[6] = 12344;
            this.mEGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (int[])objectArray, (int)0);
            this.mIsOffscreen = true;
        }
        if (EGLCore.LOG_EGL) {
            Object[] objectArray4 = new Object[4];
            objectArray = objectArray4;
            objectArray[0] = this;
            objectArray[1] = this.mEGLContext;
            objectArray4[2] = this.mEGLSurface;
            objectArray4[3] = Thread.currentThread().getId();
            Platform.logInfo(String.format(Locale.CHINA, "%h.createSurface.ctx.%h.sf.%h.tid.%d", objectArray));
        }
        if (this.hasSurface() && this.makeCurrent() == 12288) {
            EGL14.eglSwapInterval((EGLDisplay)this.mEGLDisplay, (int)1);
        }
        return true;
    }

    @Override
    public void destroySurface() {
        if (EGLCore.LOG_EGL) {
            Object[] objectArray = new Object[4];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this;
            objectArray2[1] = this.mEGLContext;
            objectArray[2] = this.mEGLSurface;
            objectArray[3] = Thread.currentThread().getId();
            Platform.logInfo(String.format(Locale.CHINA, "%h.destroySurface.ctx.%h.sf.%h.tid.%d", objectArray2));
        }
        if (this.hasSurface()) {
            EGLCore14 eGLCore14 = this;
            eGLCore14.detachCurrent();
            EGL14.eglDestroySurface((EGLDisplay)eGLCore14.mEGLDisplay, (EGLSurface)this.mEGLSurface);
            eGLCore14.mEGLSurface = EGL14.EGL_NO_SURFACE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int makeCurrent() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            block4: {
                if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (EGLSurface)this.mEGLSurface, (EGLContext)this.mEGLContext)) break block4;
                return 12288;
            }
            return EGL14.eglGetError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachCurrent() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            return;
        }
    }

    @Override
    public boolean isCurrentContext() {
        return this.mEGLContext.equals((Object)EGL14.eglGetCurrentContext()) && this.mEGLSurface.equals((Object)EGL14.eglGetCurrentSurface((int)12377));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int swapBuffers() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            int n2;
            block7: {
                block6: {
                    if (this.mIsOffscreen) break block6;
                    if (EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface)) break block6;
                    n2 = EGL14.eglGetError();
                    break block7;
                }
                n2 = 12288;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=18)
    public int swapBuffers(long l2) {
        if (isAndroidPresentationTimeAvailable) {
            Object object = EGLCore.sLock;
            synchronized (object) {
                EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (long)l2);
            }
        }
        return this.swapBuffers();
    }

    @Override
    public boolean hasContext() {
        return this.mEGLContext.equals((Object)EGL14.EGL_NO_CONTEXT) ^ true;
    }

    @Override
    public boolean hasSurface() {
        return this.mEGLSurface.equals((Object)EGL14.EGL_NO_SURFACE) ^ true;
    }

    @Override
    public String eglQueryString(int n2) {
        return EGL14.eglQueryString((EGLDisplay)this.mEGLDisplay, (int)n2);
    }

    @Override
    public int eglGetError() {
        return EGL14.eglGetError();
    }

    @Override
    public int release() {
        int n2 = super.release();
        if (n2 == 0) {
            EGLCore14 eGLCore14 = this;
            eGLCore14.destroySurface();
            eGLCore14.destroyContext();
        }
        return n2;
    }
}

