package com.tencent.wecast.utils;

import android.text.TextUtils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class NetWorkDiagnosisUtil {

    private static final String TAG = "NetWorkDiagnosisUtil";

    /**
     * 计数器 第10次才调用一次ping
     * 10次以上 间隔xx 秒 才调用一次ping
     */
    private static int sCounter = 0;

    /**
     * 第一次允许ping的计数器的值
     */
    private static final int FIRST_ALLOW_PING_COUNTER = 10;

    /**
     * 10次以上 满足间隔的时间才允许ping
     */
    private static final long TIME_ALLOW_PING_INTERVAL = 10 * 60 * 1000;

    private static long sLastPingTime = 0;

    /**
     * 要ping的内网网址
     */
    private static final String PING_INTRANET_URL = "www.qq.com";

    /**
     * FIXME:(域名要为实际用的account域名) 要ping的服务器网址
     */
    private static String PING_SERVER_URL_1 = "";

    private static String PING_SERVER_URL_2 = "";

    /**
     * 上一次获取的ip的Log信息
     */
    private static String sLastIpInfo = "";

    /**
     * 上一次PING的内网，服务器的Log信息
     */
    private static String sLastPingIntranetInfo = "";
    private static String sLastPingServer1Info = "";
    private static String sLastPingServer2Info = "";

    /**
     * 提供给外部获取网络诊断信息的info
     */
    private static String sNetWorkDiagnosisInfo = ""; // "暂无网络诊断信息";

    private static Executor mExecutorService = Executors.newCachedThreadPool();


    /**
     * 提供给外部获取网络诊断信息的方法
     */
    public static String getNetWorkDiagnosisInfo() {
        return sNetWorkDiagnosisInfo;
    }

    /**
     * 获取网络诊断Log结果的方法
     *
     * @return 返回网络诊断结果的方法
     */
    private static String setNetWorkDiagnosisInfo() {
        try {
            Date date = new Date(sLastPingTime);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String lastPingTime = simpleDateFormat.format(date);
            StringBuilder netWorkDiagnosisInfo = new StringBuilder();
            netWorkDiagnosisInfo
                    .append("--------------------------------").append('\n')
                    .append("上一次ping的时刻为:").append(lastPingTime).append('\n')
                    .append("得到的IP Log信息为:").append(sLastIpInfo).append('\n')
                    .append("Ping ").append(PING_INTRANET_URL).append("的Log信息为:").append('\n').append(sLastPingIntranetInfo).append('\n')
                    .append("Ping ").append(PING_SERVER_URL_1).append("的Log信息为:").append('\n').append(sLastPingServer1Info).append('\n')
                    .append("Ping ").append(PING_SERVER_URL_2).append("的Log信息为:").append('\n').append(sLastPingServer2Info).append('\n')
                    .append("--------------------------------").append('\n');
            Logger.t(TAG).d(netWorkDiagnosisInfo.toString());
            return netWorkDiagnosisInfo.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    /**
     * 是否需要网络诊断接口
     *
     * @param isNeedNetWorkDiagnosis true则计数器+1 计数器满10次才进行网络诊断
     *                               false则将计数器置回0
     */
    public static void needNetWorkDiagnosis(boolean isNeedNetWorkDiagnosis) {
        if (isNeedNetWorkDiagnosis) {
            sCounter += 1;
            /** 达到连续10次重连 **/
            if (sCounter == FIRST_ALLOW_PING_COUNTER) {
                Logger.t(TAG).d("重连第10次进行的ping");
                sLastPingTime = System.currentTimeMillis();
                mExecutorService.execute(new Runnable() {
                    @Override
                    public void run() {
                        /** 获取IP的Log信息 */
                        sLastIpInfo = getIpAddress();
                        /** 获取ping的log信息 */
                        sLastPingIntranetInfo = ping(4, 5, PING_INTRANET_URL);
                        sLastPingServer1Info = ping(4, 5, PING_SERVER_URL_1);
                        sLastPingServer2Info = ping(4, 5, PING_SERVER_URL_2);

                        sNetWorkDiagnosisInfo = setNetWorkDiagnosisInfo();
                    }
                });
            }
            /** 10次重连以上 满足间隔的时间才允许ping **/
            if (sCounter > FIRST_ALLOW_PING_COUNTER) {
                long currentTimeMillis = System.currentTimeMillis();
                if (currentTimeMillis - sLastPingTime >= TIME_ALLOW_PING_INTERVAL) {
                    Logger.t(TAG).d("重连10次以上的ping");
                    sLastPingTime = currentTimeMillis;
                    mExecutorService.execute(new Runnable() {
                        @Override
                        public void run() {
                            /** 获取IP的Log信息 */
                            sLastIpInfo = getIpAddress();
                            /** 获取ping的log信息 */
                            sLastPingIntranetInfo = ping(4, 5, PING_INTRANET_URL);
                            sLastPingServer1Info = ping(4, 5, PING_SERVER_URL_1);
                            sLastPingServer2Info = ping(4, 5, PING_SERVER_URL_2);

                            sNetWorkDiagnosisInfo = setNetWorkDiagnosisInfo();
                        }
                    });
                }
            }
            Logger.t(TAG).d("当前网络诊断计数器的值为:" + sCounter);
        } else {
            sCounter = 0;
            Logger.t(TAG).d("网络连通时，将网络诊断的计数器重置回0");
        }
    }

    /**
     * ping指定的ip地址
     *
     * @param frequency 发包的数据
     * @param timeOut   超时时间
     * @param ip        要ping的ip地址
     * @return 返回的log信息
     */
    private static String ping(int frequency, int timeOut, String ip) {
        /** ping的log信息的stringBuilder */
        StringBuilder pingInfoStringBuilder = new StringBuilder();
        String successPingInfo, errorPingInfo;
        Process process;
        try {
            if (!TextUtils.isEmpty(ip)) {

                String cmd = "ping -c " + frequency + " -w " + timeOut + " " + ip;
                pingInfoStringBuilder.append("执行的命令为:").append(cmd).append('\n');
                Logger.t(TAG).d("执行的命令为:" + cmd);

                process = Runtime.getRuntime().exec(cmd);
                /** 挂起子进程 */
                int status = process.waitFor();

                /** ping能发包的数据流接收（回包成功或者超时都是从该流获取的） */
                InputStream input = process.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(input));
                StringBuilder successStringBuilder = new StringBuilder();
                String successLine;
                while ((successLine = bufferedReader.readLine()) != null) {
                    successStringBuilder.append(successLine).append('\n');
                }
                successPingInfo = successStringBuilder.toString();
                if (!TextUtils.isEmpty(successPingInfo)) {
                    pingInfoStringBuilder.append("ping的Return -------------").append(successPingInfo);
                    Logger.t(TAG).d("ping的Return -------------" + successPingInfo);
                }
                /** ping不了的回传（如网络无连接） */
                InputStream errorStream = process.getErrorStream();
                BufferedReader errorBufferReader = new BufferedReader(new InputStreamReader(errorStream));
                StringBuilder errorStringBuilder = new StringBuilder();
                String errorLine;
                while ((errorLine = errorBufferReader.readLine()) != null) {
                    errorStringBuilder.append(errorLine);
                }

                errorPingInfo = errorStringBuilder.toString();
                if (!TextUtils.isEmpty(errorPingInfo)) {
                    pingInfoStringBuilder.append("ping的Return -------------").append(errorPingInfo);
                    Logger.t(TAG).d("ping的Return -------------" + errorPingInfo);
                }

                // 销毁子进程
                process.destroy();
            } else {
                pingInfoStringBuilder.append("要ping的对象为空");
                Logger.t(TAG).e("要ping的对象为空");
            }
        } catch (IOException e) {
            e.printStackTrace();
            pingInfoStringBuilder.append("IOException error ").append(e);
            Logger.t(TAG).e("IOException error " + e);
        } catch (InterruptedException e) {
            e.printStackTrace();
            pingInfoStringBuilder.append("InterruptedException error ").append(e);
            Logger.t(TAG).e("InterruptedException error " + e);
        }
        return pingInfoStringBuilder.toString();
    }

    /**
     * 获取本机IPv4地址
     *
     * @return 返回ip的log信息
     */
    private static String getIpAddress() {
        try {
            NetworkInterface networkInterface;
            InetAddress inetAddress;
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            if (en != null) {
                while (en.hasMoreElements()) {
                    networkInterface = en.nextElement();
                    for (Enumeration<InetAddress> enumIpAddr = networkInterface.getInetAddresses(); enumIpAddr.hasMoreElements(); ) {
                        inetAddress = enumIpAddr.nextElement();
                        if (!inetAddress.isLoopbackAddress() && inetAddress instanceof Inet4Address) {
                            String logInfo = "返回的ip地址为:" + inetAddress.getHostAddress();
                            Logger.t(TAG).d(logInfo);
                            return logInfo;
                        }
                    }
                }
            }

            String errorLogInfo = "无网络连接，返回的ip为空";
            Logger.t(TAG).e(errorLogInfo);
            return errorLogInfo;
        } catch (Exception ex) {
            String errorLogInfo = ex.toString();
            Logger.t(TAG).e(errorLogInfo);
            return errorLogInfo;
        }
    }


    /**
     * 获取 webSocket相关的域名地址
     */
    public static void setPingCastServer(String accountDomain, String connectionDomain) {
        PING_SERVER_URL_1 = accountDomain;
        PING_SERVER_URL_2 = connectionDomain;
    }

}