package com.tencent.wecast.sender.cloud.bean

import com.tencent.wecast.sender.cloud.WeCast

class WeCastInfo {
    companion object {
        val instance by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            WeCastInfo()
        }
    }

    interface OnCastStateChangeListener {
        fun onChanged(state: Int)
    }

    internal var mStateChangeListener: OnCastStateChangeListener? = null
    internal var isRunning = false
    internal var isCasting = false
    internal var isWeCastApp = false
    internal var isUsingCastingNotification = false
    internal var castingBackAnim: Int = 0

    var enableUpdate = true   // 是否启用sdk的升级
    var authCode: String = ""
    var corpId: String = ""
    var usingMirror = true
    var languageType: Int = WeCast.LANGUAGE_ZH_CN
    var corpName: String = ""
}