package com.tencent.wecast;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.TextView;

import com.tencent.wecast.jni.JniHelper;
import com.tencent.wecast.jni.ParamsPackage;
import com.tencent.wecast.utils.Logger;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class WeCastBaseActivity extends AppCompatActivity {

    private Map<String, Integer> mBindViewId = null;

    protected void BindViewById(String viewIdStr, int viewId) {
        if (mBindViewId == null) {
            mBindViewId = new TreeMap<>();
        }
        mBindViewId.put(viewIdStr, viewId);
    }

    public <T extends View> T findViewByIdStr(String viewIdStr) {
        if (mBindViewId != null && mBindViewId.containsKey(viewIdStr)) {
            return findViewById(mBindViewId.get(viewIdStr));
        }
        return null;
    }

    public void callJniViewFunc(String funcName, Object... args) {
        JniHelper.callJniFunc(getClass().getName() + funcName, args);
    }

    @Override
    protected void onStart() {
        super.onStart();
        registerService4Jni();
    }

    @Override
    protected void onStop() {
        super.onStop();
        unregisterService();
    }

    private String getViewContent(String viewIdStr) {
        View view = findViewByIdStr(viewIdStr);
        if (view instanceof TextView) {
            return ((TextView) view).getText().toString();
        }
        return "";
    }

    private void setViewContent(String viewIdStr, boolean viewGone, String content) {
        View view = findViewByIdStr(viewIdStr);
        if (viewGone) {
            view.setVisibility(View.GONE);
            return;
        } else {
            view.setVisibility(View.VISIBLE);
        }

        if (view instanceof TextView) {
            ((TextView) view).setText(content);
        } else {
            Logger.kp().d("Not support view type: " + view.toString());
        }
    }

    private void startActivity(String classSignature) {
        try {
            Intent intent = new Intent(this, Class.forName(classSignature));
            startActivity(intent);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void registerService4Jni() {
        JniHelper.registerFunc4Cpp(getJFunSignature("getViewContent"), new JniHelper.OnCppCall() {
            @Override
            public ParamsPackage.ParamsToCpp handle(ParamsPackage.ParamsFromCpp params) {
                try {
                    ParamsPackage.ParamsToCpp retParam = new ParamsPackage.ParamsToCpp();
                    retParam.addString(getViewContent((String) params.getNext()));
                    return retParam;
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });

        JniHelper.registerFunc4Cpp(getJFunSignature("setViewContent"), new JniHelper.OnCppCall() {
            @Override
            public ParamsPackage.ParamsToCpp handle(ParamsPackage.ParamsFromCpp params) {
                try {
                    setViewContent((String) params.getNext(), (Boolean) params.getNext(), (String) params.getNext());
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });

        JniHelper.registerFunc4Cpp(getJFunSignature("startActivity"), new JniHelper.OnCppCallOnUI() {
            @Override
            public ParamsPackage.ParamsToCpp handle(ParamsPackage.ParamsFromCpp params) {
                try {
                    startActivity((String) params.getNext());
                    return null;
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });

        JniHelper.registerFunc4Cpp(getJFunSignature("finish"), new JniHelper.OnCppCallOnUI() {
            @Override
            public ParamsPackage.ParamsToCpp handle(ParamsPackage.ParamsFromCpp params) {
                finish();
                return null;
            }
        });
    }

    private void unregisterService() {
        JniHelper.unregister(getJFunSignature("getViewContent"));
        JniHelper.unregister(getJFunSignature("startActivity"));
        JniHelper.unregister(getJFunSignature("finish"));
    }

    private String getJFunSignature(String funcName) {
        return getClass().getName() + funcName;
    }
}
