/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.graphics.Rect;
import android.os.SystemClock;
import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.tencent.xcast.GLCanvas;
import com.tencent.xcast.GLRoot;
import com.tencent.xcast.GLRootImpl;
import com.tencent.xcast.Log;
import com.tencent.xcast.NativeObject;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 r2\u00020\u0001:\u0001rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0000H\u0007J\u0010\u0010?\u001a\u00020=2\u0006\u0010@\u001a\u00020\u0007H\u0007J\u0010\u0010A\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0000H\u0007J\u0010\u0010B\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0000H\u0007J\u0010\u0010C\u001a\u00020=2\u0006\u0010D\u001a\u00020\tH\u0002J\u001a\u0010E\u001a\u0004\u0018\u00010\u00002\u0006\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020\tH\u0007J\b\u0010H\u001a\u00020=H\u0007J\u000e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LJ0\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020\t2\u0006\u0010>\u001a\u00020\u00002\u0006\u0010M\u001a\u00020JH\u0014J\u0012\u0010N\u001a\u0004\u0018\u00010\u00002\u0006\u0010O\u001a\u00020\tH\u0007J\u0006\u0010P\u001a\u00020=J(\u0010Q\u001a\u00020=2\u0006\u0010R\u001a\u00020\t2\u0006\u0010S\u001a\u00020\t2\u0006\u0010T\u001a\u00020\t2\u0006\u0010U\u001a\u00020\tH\u0007J\u001d\u0010V\u001a\u00020=2\u0006\u0010W\u001a\u00020\t2\u0006\u0010X\u001a\u00020\tH\u0001\u00a2\u0006\u0002\bYJ\u0010\u0010Z\u001a\u00020=2\u0006\u0010@\u001a\u00020\u0007H\u0014J\b\u0010[\u001a\u00020=H\u0014J0\u0010\\\u001a\u00020=2\u0006\u0010]\u001a\u00020J2\u0006\u0010R\u001a\u00020\t2\u0006\u0010S\u001a\u00020\t2\u0006\u0010T\u001a\u00020\t2\u0006\u0010U\u001a\u00020\tH\u0015J\u0018\u0010^\u001a\u00020=2\u0006\u0010W\u001a\u00020\t2\u0006\u0010X\u001a\u00020\tH\u0015J\u0010\u0010_\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0014J\u0010\u0010`\u001a\u00020=2\u0006\u00107\u001a\u00020\tH\u0014J\b\u0010a\u001a\u00020=H\u0007J\u0010\u0010b\u001a\u00020J2\u0006\u0010>\u001a\u00020\u0000H\u0007J\u0010\u0010c\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0000H\u0003J\u0010\u0010d\u001a\u00020=2\u0006\u0010e\u001a\u00020fH\u0017J\u0010\u0010g\u001a\u00020=2\u0006\u0010e\u001a\u00020fH\u0015J\u001a\u0010h\u001a\u00020=2\u0006\u0010e\u001a\u00020f2\b\u0010>\u001a\u0004\u0018\u00010\u0000H\u0015J\u0006\u0010i\u001a\u00020=J(\u0010j\u001a\u00020J2\u0006\u0010R\u001a\u00020\t2\u0006\u0010S\u001a\u00020\t2\u0006\u0010T\u001a\u00020\t2\u0006\u0010U\u001a\u00020\tH\u0003J\u0010\u0010k\u001a\u00020=2\u0006\u0010D\u001a\u00020\tH\u0002J\u000e\u0010l\u001a\u00020=2\u0006\u0010R\u001a\u00020\tJ\u0018\u0010m\u001a\u00020=2\u0006\u0010:\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0005J\u000e\u0010n\u001a\u00020=2\u0006\u0010S\u001a\u00020\tJ\u0010\u0010o\u001a\u00020=2\u0006\u0010p\u001a\u00020\u0000H\u0007J\u0010\u0010q\u001a\u00020=2\u0006\u0010p\u001a\u00020\u0000H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010#\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000b\"\u0004\b%\u0010\rR$\u0010&\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u000b\"\u0004\b(\u0010\rR\u0010\u0010)\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010*\u001a\u0004\u0018\u00010\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R$\u00107\u001a\u00020\t2\u0006\u00107\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010\u000b\"\u0004\b9\u0010\rR\u0011\u0010:\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u000b\u00a8\u0006s"}, d2={"Lcom/tencent/xcast/GLView;", "Lcom/tencent/xcast/NativeObject;", "()V", "_bounds", "Landroid/graphics/Rect;", "_glRoot", "Ljava/lang/ref/WeakReference;", "Lcom/tencent/xcast/GLRoot;", "backgroundColor", "", "getBackgroundColor", "()I", "setBackgroundColor", "(I)V", "bounds", "getBounds", "()Landroid/graphics/Rect;", "componentCount", "getComponentCount", "components", "Ljava/util/ArrayList;", "glRoot", "getGlRoot", "()Lcom/tencent/xcast/GLRoot;", "height", "getHeight", "lastHeightSpec", "lastWidthSpec", "<set-?>", "Landroid/view/ViewGroup$LayoutParams;", "layoutParams", "getLayoutParams", "()Landroid/view/ViewGroup$LayoutParams;", "setLayoutParams", "(Landroid/view/ViewGroup$LayoutParams;)V", "measuredHeight", "getMeasuredHeight", "setMeasuredHeight", "measuredWidth", "getMeasuredWidth", "setMeasuredWidth", "motionTarget", "parent", "getParent", "()Lcom/tencent/xcast/GLView;", "setParent", "(Lcom/tencent/xcast/GLView;)V", "viewFlags", "Ljava/util/concurrent/atomic/AtomicInteger;", "viewId", "", "getViewId", "()Ljava/lang/String;", "setViewId", "(Ljava/lang/String;)V", "visibility", "getVisibility", "setVisibility", "width", "getWidth", "addComponent", "", "component", "attachToRoot", "root", "bringToBack", "bringToFront", "clearFlag", "flag", "componentsHitTest", "x", "y", "detachFromRoot", "dispatchTouchEvent", "", "event", "Landroid/view/MotionEvent;", "checkBounds", "getComponent", "index", "invalidate", "layout", "left", "top", "right", "bottom", "measure", "w", "h", "measure$libxcast_release", "onAttachToRoot", "onDetachFromRoot", "onLayout", "changeSize", "onMeasure", "onTouch", "onVisibilityChanged", "removeAllComponents", "removeComponent", "removeOneComponent", "render", "canvas", "Lcom/tencent/xcast/GLCanvas;", "renderBackground", "renderChild", "requestLayout", "setBounds", "setFlag", "setLeft", "setMeasuredSize", "setTop", "switchWithBack", "v", "switchWithFront", "Companion", "libxcast_release"})
public class GLView
extends NativeObject {
    private static final String TAG = "GLView";
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 1;
    private static final int FLAG_INVISIBLE = 1;
    private static final int FLAG_SET_MEASURED_SIZE = 2;
    private static final int FLAG_LAYOUT_REQUESTED = 4;
    public static final Companion Companion = new Companion(null);
    private final Rect _bounds = new Rect();
    private WeakReference<GLRoot> _glRoot = new WeakReference<Object>(null);
    @Nullable
    private GLView parent;
    @NotNull
    private ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
    private ArrayList<GLView> components;
    private GLView motionTarget;
    private final AtomicInteger viewFlags = new AtomicInteger(0);
    private int measuredWidth;
    private int measuredHeight;
    private int lastWidthSpec = -1;
    private int lastHeightSpec = -1;
    private int backgroundColor;
    @NotNull
    private String viewId = "video-render";

    private final void setFlag(int n2) {
        int n3;
        int n4;
        GLView gLView;
        do {
            gLView = this;
        } while (!gLView.viewFlags.compareAndSet(n4 = gLView.viewFlags.get(), n3 = n4 | n2));
    }

    private final void clearFlag(int n2) {
        int n3;
        int n4;
        GLView gLView;
        do {
            gLView = this;
        } while (!gLView.viewFlags.compareAndSet(n4 = gLView.viewFlags.get(), n3 = n4 & ~n2));
    }

    @MainThread
    private final void removeOneComponent(GLView gLView) {
        GLRootImpl.Companion.lockUpdate$libxcast_release(true);
        GLRoot gLRoot = (GLRoot)this._glRoot.get();
        if (gLRoot != null) {
            gLRoot.lockRenderThread();
        }
        try {
            if (this.motionTarget == gLView) {
                long l2 = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l2, (long)l2, (int)3, (float)0.0f, (float)0.0f, (int)0);
                Intrinsics.checkExpressionValueIsNotNull((Object)motionEvent, (String)"cancelEvent");
                this.dispatchTouchEvent(motionEvent);
                motionEvent.recycle();
            }
            GLRoot gLRoot2 = gLRoot;
            gLView.onDetachFromRoot();
            gLView.parent = null;
            return;
        }
        finally {
            if (gLRoot != null) {
                gLRoot.unlockRenderThread();
            }
            GLRootImpl.Companion.lockUpdate$libxcast_release(false);
        }
    }

    @WorkerThread
    private final boolean setBounds(int n2, int n3, int n4, int n5) {
        Locale locale = Locale.CHINA;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.CHINA");
        Object[] objectArray = new Object[5];
        Rect rect = objectArray;
        rect[0] = this;
        rect[1] = n2;
        rect[2] = n3;
        rect[3] = n4;
        objectArray[4] = n5;
        rect = String.format(locale, "render.setBounds.%h.l.%d.t.%d.r.%d.b.%d", Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"java.lang.String.format(locale, format, *args)");
        Log.INSTANCE.d(TAG, (String)rect);
        rect = this._bounds;
        boolean bl = n4 - n2 != rect.right - rect.left || n5 - n3 != rect.bottom - rect.top;
        this._bounds.set(n2, n3, n4, n5);
        return bl;
    }

    @Nullable
    public final GLRoot getGlRoot() {
        return (GLRoot)this._glRoot.get();
    }

    @Nullable
    protected final GLView getParent() {
        return this.parent;
    }

    protected final void setParent(@Nullable GLView gLView) {
        this.parent = gLView;
    }

    @NotNull
    public final ViewGroup.LayoutParams getLayoutParams() {
        return this.layoutParams;
    }

    protected final void setLayoutParams(@NotNull ViewGroup.LayoutParams layoutParams) {
        ViewGroup.LayoutParams layoutParams2 = layoutParams;
        Intrinsics.checkParameterIsNotNull((Object)layoutParams2, (String)"<set-?>");
        this.layoutParams = layoutParams2;
    }

    public final int getMeasuredWidth() {
        return this.measuredWidth;
    }

    protected final void setMeasuredWidth(int n2) {
        this.measuredWidth = n2;
    }

    public final int getMeasuredHeight() {
        return this.measuredHeight;
    }

    protected final void setMeasuredHeight(int n2) {
        this.measuredHeight = n2;
    }

    public final int getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(int n2) {
        this.backgroundColor = n2;
    }

    @NotNull
    public final String getViewId() {
        return this.viewId;
    }

    public final void setViewId(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"<set-?>");
        this.viewId = string3;
    }

    public final int getVisibility() {
        return (this.viewFlags.get() & 1) == 0 ? 0 : 1;
    }

    public final void setVisibility(int n2) {
        int n3 = n2;
        if (n3 == n3) {
            return;
        }
        if (n2 == 0) {
            this.clearFlag(1);
        } else {
            this.setFlag(1);
        }
        GLView gLView = this;
        gLView.onVisibilityChanged(n2);
        gLView.invalidate();
    }

    @AnyThread
    public final int getComponentCount() {
        int n2;
        ArrayList<GLView> arrayList = ((GLView)((Object)arrayList)).components;
        if (arrayList == null) {
            n2 = 0;
        } else {
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            n2 = arrayList.size();
        }
        return n2;
    }

    public final int getWidth() {
        GLView gLView = gLView._bounds;
        return ((Rect)gLView).right - ((Rect)gLView).left;
    }

    public final int getHeight() {
        GLView gLView = gLView._bounds;
        return ((Rect)gLView).bottom - ((Rect)gLView).top;
    }

    @AnyThread
    @NotNull
    public final Rect getBounds() {
        return this._bounds;
    }

    @MainThread
    public final void attachToRoot(@NotNull GLRoot gLRoot) {
        Intrinsics.checkParameterIsNotNull((Object)gLRoot, (String)"root");
        boolean bl = this.parent == null && this.getGlRoot() == null;
        if (_Assertions.ENABLED && !bl) {
            throw new AssertionError((Object)"Assertion failed");
        }
        this.onAttachToRoot(gLRoot);
    }

    @MainThread
    public final void detachFromRoot() {
        boolean bl = this.parent == null && this.getGlRoot() != null;
        if (_Assertions.ENABLED && !bl) {
            throw new AssertionError((Object)"Assertion failed");
        }
        this.onDetachFromRoot();
    }

    @AnyThread
    @Nullable
    public final GLView getComponent(int n2) {
        ArrayList<GLView> arrayList = ((GLView)((Object)arrayList)).components;
        if (arrayList != null) {
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            return (GLView)arrayList.get(n2);
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void addComponent(@NotNull GLView gLView) {
        GLView gLView2 = gLView;
        Intrinsics.checkParameterIsNotNull((Object)gLView2, (String)"component");
        if (gLView2.parent != null) {
            throw new IllegalStateException();
        }
        if (this.components == null) {
            this.components = new ArrayList();
        }
        GLRootImpl.Companion.lockUpdate$libxcast_release(true);
        GLRoot gLRoot = (GLRoot)this._glRoot.get();
        if (gLRoot != null) {
            gLRoot.lockRenderThread();
        }
        try {
            ArrayList<GLView> arrayList = this.components;
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            arrayList.add(gLView);
            gLView.parent = this;
            if (gLRoot != null) {
                gLView.onAttachToRoot(gLRoot);
            }
            this.requestLayout();
            if (gLRoot != null) {
                gLRoot.unlockRenderThread();
            }
            GLRootImpl.Companion.lockUpdate$libxcast_release(false);
            return;
        }
        catch (Throwable throwable) {
            if (gLRoot != null) {
                gLRoot.unlockRenderThread();
            }
            GLRootImpl.Companion.lockUpdate$libxcast_release(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final boolean removeComponent(@NotNull GLView gLView) {
        Intrinsics.checkParameterIsNotNull((Object)gLView, (String)"component");
        GLRootImpl.Companion.lockUpdate$libxcast_release(true);
        GLRoot gLRoot = (GLRoot)this._glRoot.get();
        if (gLRoot != null) {
            gLRoot.lockRenderThread();
        }
        try {
            if (this.components == null) {
                boolean bl = false;
                if (gLRoot != null) {
                    gLRoot.unlockRenderThread();
                }
                GLRootImpl.Companion.lockUpdate$libxcast_release(false);
                return bl;
            }
            ArrayList<GLView> arrayList = this.components;
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            if (arrayList.remove(gLView)) {
                GLView gLView2 = this;
                gLView2.removeOneComponent(gLView);
                gLView2.requestLayout();
                boolean bl = true;
                if (gLRoot != null) {
                    gLRoot.unlockRenderThread();
                }
                GLRootImpl.Companion.lockUpdate$libxcast_release(false);
                return bl;
            }
            this.requestLayout();
            boolean bl = false;
            if (gLRoot != null) {
                gLRoot.unlockRenderThread();
            }
            GLRootImpl.Companion.lockUpdate$libxcast_release(false);
            return bl;
        }
        catch (Throwable throwable) {
            if (gLRoot != null) {
                gLRoot.unlockRenderThread();
            }
            GLRootImpl.Companion.lockUpdate$libxcast_release(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void removeAllComponents() {
        GLRootImpl.Companion.lockUpdate$libxcast_release(true);
        GLRoot gLRoot = (GLRoot)this._glRoot.get();
        if (gLRoot != null) {
            gLRoot.lockRenderThread();
        }
        try {
            if (this.components == null) {
                if (gLRoot != null) {
                    gLRoot.unlockRenderThread();
                }
                GLRootImpl.Companion.lockUpdate$libxcast_release(false);
                return;
            }
            int n2 = 0;
            ArrayList<GLView> arrayList = this.components;
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            int n3 = arrayList.size();
            while (n2 < n3) {
                ArrayList<GLView> arrayList2 = this.components;
                if (arrayList2 == null) {
                    Intrinsics.throwNpe();
                }
                GLView gLView = arrayList2.get(n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)gLView, (String)"components!![i]");
                this.removeOneComponent(gLView);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            if (gLRoot != null) {
                gLRoot.unlockRenderThread();
            }
            GLRootImpl.Companion.lockUpdate$libxcast_release(false);
            throw throwable;
        }
        ArrayList<GLView> arrayList = this.components;
        if (arrayList == null) {
            Intrinsics.throwNpe();
        }
        arrayList.clear();
        this.requestLayout();
        if (gLRoot != null) {
            gLRoot.unlockRenderThread();
        }
        GLRootImpl.Companion.lockUpdate$libxcast_release(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    @Nullable
    public final GLView componentsHitTest(int n2, int n3) {
        if (!gLView._bounds.contains(n2, n3)) {
            return null;
        }
        GLRoot gLRoot = (GLRoot)gLView._glRoot.get();
        if (gLRoot != null) {
            gLRoot.lockRenderThread();
        }
        try {
            ArrayList<GLView> arrayList;
            block14: {
                if (gLView.components == null) {
                    GLView gLView = null;
                    if (gLRoot != null) {
                        gLRoot.unlockRenderThread();
                    }
                    return gLView;
                }
                ArrayList<GLView> arrayList2 = gLView.components;
                if (arrayList2 == null) {
                    Intrinsics.throwNpe();
                }
                for (int i2 = arrayList2.size() + -1; i2 >= 0; --i2) {
                    arrayList = gLView.components;
                    if (arrayList == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((arrayList = ((GLView)arrayList.get(i2)).componentsHitTest(n2, n3)) == null) {
                        continue;
                    }
                    break block14;
                }
                arrayList = gLView;
            }
            gLView.requestLayout();
            if (gLRoot != null) {
                gLRoot.unlockRenderThread();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            if (gLRoot != null) {
                gLRoot.unlockRenderThread();
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void switchWithFront(@NotNull GLView gLView) {
        Intrinsics.checkParameterIsNotNull((Object)gLView, (String)"v");
        GLRoot gLRoot = (GLRoot)this._glRoot.get();
        if (gLRoot != null) {
            gLRoot.lockRenderThread();
        }
        try {
            if (this.components != null) {
                ArrayList<GLView> arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                if (arrayList.size() >= 2) {
                    ArrayList<GLView> arrayList2;
                    ArrayList<GLView> arrayList3;
                    int n2;
                    arrayList = this.components;
                    if (arrayList == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((n2 = arrayList.indexOf(gLView)) < 0) {
                        if (gLRoot != null) {
                            gLRoot.unlockRenderThread();
                        }
                        return;
                    }
                    arrayList = this.components;
                    if (arrayList == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((arrayList3 = this.components) == null) {
                        Intrinsics.throwNpe();
                    }
                    GLView gLView2 = arrayList.get(arrayList3.size() - 1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)gLView2, (String)"components!![components!!.size - 1]");
                    arrayList = gLView2;
                    arrayList3 = this.components;
                    if (arrayList3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((arrayList2 = this.components) == null) {
                        Intrinsics.throwNpe();
                    }
                    int n3 = arrayList2.size() - 1;
                    ArrayList<GLView> arrayList4 = this.components;
                    if (arrayList4 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList3.set(n3, arrayList4.get(n2));
                    arrayList3 = this.components;
                    if (arrayList3 == null) {
                        Intrinsics.throwNpe();
                    }
                    arrayList3.set(n2, (GLView)((Object)arrayList));
                    this.requestLayout();
                    if (gLRoot != null) {
                        gLRoot.unlockRenderThread();
                    }
                    return;
                }
            }
            return;
        }
        finally {
            if (gLRoot != null) {
                gLRoot.unlockRenderThread();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void switchWithBack(@NotNull GLView gLView) {
        GLRoot gLRoot;
        block16: {
            GLView gLView2;
            GLView gLView3;
            int n2;
            ArrayList<GLView> arrayList;
            Intrinsics.checkParameterIsNotNull((Object)gLView, (String)"v");
            gLRoot = (GLRoot)this._glRoot.get();
            if (gLRoot != null) {
                gLRoot.lockRenderThread();
            }
            try {
                if (this.components == null) break block16;
                arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                if (arrayList.size() < 2) break block16;
                arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                if ((n2 = arrayList.indexOf(gLView)) < 0) {
                    if (gLRoot != null) {
                        gLRoot.unlockRenderThread();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                if (gLRoot != null) {
                    gLRoot.unlockRenderThread();
                }
                throw throwable;
            }
            {
                arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                gLView3 = this;
                gLView2 = arrayList.get(0);
            }
            {
                Intrinsics.checkExpressionValueIsNotNull((Object)gLView2, (String)"components!![0]");
                arrayList = gLView2;
                ArrayList<GLView> arrayList2 = gLView3.components;
                if (arrayList2 == null) {
                    Intrinsics.throwNpe();
                }
                int n3 = 0;
                ArrayList<GLView> arrayList3 = this.components;
                if (arrayList3 == null) {
                    Intrinsics.throwNpe();
                }
                arrayList2.set(n3, arrayList3.get(n2));
                arrayList2 = this.components;
                if (arrayList2 == null) {
                    Intrinsics.throwNpe();
                }
                arrayList2.set(n2, (GLView)((Object)arrayList));
                this.requestLayout();
                if (gLRoot != null) {
                    gLRoot.unlockRenderThread();
                }
                return;
            }
        }
        if (gLRoot != null) {
            gLRoot.unlockRenderThread();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void bringToFront(@NotNull GLView gLView) {
        GLRoot gLRoot;
        block13: {
            ArrayList<GLView> arrayList;
            Intrinsics.checkParameterIsNotNull((Object)gLView, (String)"component");
            gLRoot = (GLRoot)this._glRoot.get();
            if (gLRoot != null) {
                gLRoot.lockRenderThread();
            }
            try {
                if (this.components == null) break block13;
                arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                if (arrayList.size() < 2) break block13;
                arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                if (arrayList.indexOf(gLView) < 0) {
                    if (gLRoot != null) {
                        gLRoot.unlockRenderThread();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                if (gLRoot != null) {
                    gLRoot.unlockRenderThread();
                }
                throw throwable;
            }
            {
                arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                arrayList.remove(gLView);
                arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                arrayList.add(gLView);
                this.requestLayout();
                if (gLRoot != null) {
                    gLRoot.unlockRenderThread();
                }
                return;
            }
        }
        if (gLRoot != null) {
            gLRoot.unlockRenderThread();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void bringToBack(@NotNull GLView gLView) {
        GLRoot gLRoot;
        block13: {
            ArrayList<GLView> arrayList;
            Intrinsics.checkParameterIsNotNull((Object)gLView, (String)"component");
            gLRoot = (GLRoot)this._glRoot.get();
            if (gLRoot != null) {
                gLRoot.lockRenderThread();
            }
            try {
                if (this.components == null) break block13;
                arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                if (arrayList.size() < 2) break block13;
                arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                if (arrayList.indexOf(gLView) < 0) {
                    if (gLRoot != null) {
                        gLRoot.unlockRenderThread();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                if (gLRoot != null) {
                    gLRoot.unlockRenderThread();
                }
                throw throwable;
            }
            {
                arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                arrayList.remove(gLView);
                arrayList = this.components;
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                arrayList.add(0, gLView);
                this.requestLayout();
                if (gLRoot != null) {
                    gLRoot.unlockRenderThread();
                }
                return;
            }
        }
        if (gLRoot != null) {
            gLRoot.unlockRenderThread();
        }
    }

    public final void setLeft(int n2) {
        GLView gLView = this;
        int n3 = gLView.getWidth();
        Rect rect = gLView._bounds;
        rect.left = n2;
        gLView._bounds.right = n2 + n3;
    }

    public final void setTop(int n2) {
        GLView gLView = this;
        int n3 = gLView.getHeight();
        Rect rect = gLView._bounds;
        rect.top = n2;
        gLView._bounds.bottom = n2 + n3;
    }

    public final void invalidate() {
        GLRoot gLRoot = (GLRoot)((GLView)((Object)gLRoot))._glRoot.get();
        if (gLRoot != null) {
            gLRoot.requestRender();
        }
    }

    public final void requestLayout() {
        GLView gLView = string2;
        gLView.setFlag(4);
        gLView.lastHeightSpec = -1;
        gLView.lastWidthSpec = -1;
        Locale locale = Locale.CHINA;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.CHINA");
        Object[] objectArray = new Object[3];
        Object object = objectArray;
        object[0] = string2;
        object[1] = ((GLView)((Object)string2)).measuredWidth;
        objectArray[2] = ((GLView)((Object)string2)).measuredHeight;
        object = String.format(locale, "render.requestLayout.start.%h.w.%d.h.%d", Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"java.lang.String.format(locale, format, *args)");
        Log.INSTANCE.d(TAG, (String)object);
        object = gLView.parent;
        if (object != null) {
            if (object == null) {
                Intrinsics.throwNpe();
            }
            ((GLView)object).requestLayout();
        } else {
            object = (GLRoot)((GLView)((Object)string2))._glRoot.get();
            if (object != null) {
                object.requestLayoutContentPane();
            }
        }
        Locale locale2 = Locale.CHINA;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.CHINA");
        Object[] objectArray2 = new Object[3];
        object = objectArray2;
        object[0] = string2;
        object[1] = ((GLView)((Object)string2)).measuredWidth;
        objectArray2[2] = ((GLView)((Object)string2)).measuredHeight;
        String string2 = String.format(locale2, "render.requestLayout.end.%h.w.%d.h.%d", Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        Log.INSTANCE.d(TAG, string2);
    }

    @WorkerThread
    public void render(@NotNull GLCanvas gLCanvas) {
        GLCanvas gLCanvas2 = gLCanvas;
        Intrinsics.checkParameterIsNotNull((Object)gLCanvas2, (String)"canvas");
        this.renderBackground(gLCanvas2);
        gLCanvas.save();
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.renderChild(gLCanvas, this.getComponent(i2));
        }
        gLCanvas.restore();
    }

    @WorkerThread
    protected void renderBackground(@NotNull GLCanvas gLCanvas) {
        GLView gLView = this;
        Intrinsics.checkParameterIsNotNull((Object)gLCanvas, (String)"canvas");
        int n2 = gLView.getWidth();
        int n3 = gLView.getHeight();
        int n4 = gLView.backgroundColor;
        if (n4 != 0) {
            float f2 = n2;
            float f3 = n3;
            gLCanvas.fillRect(0.0f, 0.0f, f2, f3, n4);
        }
    }

    @WorkerThread
    protected void renderChild(@NotNull GLCanvas gLCanvas, @Nullable GLView gLView) {
        Intrinsics.checkParameterIsNotNull((Object)gLCanvas, (String)"canvas");
        if (gLView == null) {
            Intrinsics.throwNpe();
        }
        if (gLView.getVisibility() != 0) {
            return;
        }
        GLCanvas gLCanvas2 = gLCanvas;
        Rect rect = gLView._bounds;
        int n2 = rect.left;
        int n3 = rect.top;
        gLCanvas2.translate(n2, n3);
        gLView.render(gLCanvas2);
        gLCanvas.translate(-n2, -n3);
    }

    protected boolean onTouch(@NotNull MotionEvent motionEvent) {
        Intrinsics.checkParameterIsNotNull((Object)motionEvent, (String)"event");
        return false;
    }

    protected boolean dispatchTouchEvent(@NotNull MotionEvent motionEvent, int n2, int n3, @NotNull GLView gLView, boolean bl) {
        GLView gLView2 = gLView;
        Intrinsics.checkParameterIsNotNull((Object)motionEvent, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)gLView2, (String)"component");
        GLView gLView3 = gLView2._bounds;
        int n4 = ((Rect)gLView3).left;
        int n5 = ((Rect)gLView3).top;
        if (!bl || gLView3.contains(n2, n3)) {
            MotionEvent motionEvent2 = motionEvent;
            motionEvent2.offsetLocation((float)(-n4), (float)(-n5));
            if (gLView.dispatchTouchEvent(motionEvent2)) {
                motionEvent.offsetLocation((float)n4, (float)n5);
                return true;
            }
            motionEvent.offsetLocation((float)n4, (float)n5);
        }
        return false;
    }

    public final boolean dispatchTouchEvent(@NotNull MotionEvent motionEvent) {
        MotionEvent motionEvent2 = motionEvent;
        Intrinsics.checkParameterIsNotNull((Object)motionEvent2, (String)"event");
        int n2 = (int)motionEvent2.getX();
        int n3 = (int)motionEvent2.getY();
        int n4 = motionEvent2.getAction();
        GLView gLView = this.motionTarget;
        if (gLView != null) {
            if (n4 == 0) {
                MotionEvent motionEvent3;
                MotionEvent motionEvent4 = motionEvent3 = MotionEvent.obtain((MotionEvent)motionEvent);
                Intrinsics.checkExpressionValueIsNotNull((Object)motionEvent4, (String)"cancel");
                motionEvent4.setAction(3);
                this.dispatchTouchEvent(motionEvent3, n2, n3, gLView, false);
                this.motionTarget = null;
            } else {
                this.dispatchTouchEvent(motionEvent, n2, n3, gLView, false);
                if (n4 == 3 || n4 == 1) {
                    this.motionTarget = null;
                }
                return true;
            }
        }
        if (n4 == 0) {
            for (n4 = this.getComponentCount() - 1; n4 >= 0; --n4) {
                gLView = this.getComponent(n4);
                if (gLView == null) {
                    Intrinsics.throwNpe();
                }
                if (gLView.getVisibility() != 0 || !this.dispatchTouchEvent(motionEvent, n2, n3, gLView, true)) continue;
                this.motionTarget = gLView;
                return true;
            }
        }
        return this.onTouch(motionEvent);
    }

    @WorkerThread
    public final void layout(int n2, int n3, int n4, int n5) {
        GLView gLView = this;
        Locale locale = Locale.CHINA;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.CHINA");
        Object[] objectArray = new Object[5];
        Object object = objectArray;
        object[0] = this;
        object[1] = n2;
        object[2] = n3;
        object[3] = n4;
        objectArray[4] = n5;
        object = String.format(locale, "render.layout.%h.l.%d.t.%d.r.%d.b.%d", Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"java.lang.String.format(locale, format, *args)");
        Log.INSTANCE.d(TAG, (String)object);
        boolean bl = gLView.setBounds(n2, n3, n4, n5);
        this.clearFlag(4);
        gLView.onLayout(bl, n2, n3, n4, n5);
    }

    @WorkerThread
    public final void measure$libxcast_release(int n2, int n3) {
        n2 = View.MeasureSpec.getSize((int)n2);
        n3 = View.MeasureSpec.getSize((int)n3);
        if (n2 == ((GLView)((Object)string2)).lastWidthSpec && n3 == ((GLView)((Object)string2)).lastHeightSpec && (((GLView)((Object)string2)).viewFlags.get() & 4) == 0) {
            Locale locale = Locale.CHINA;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.CHINA");
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string2;
            objectArray2[1] = n2;
            objectArray[2] = n3;
            String string2 = String.format(locale, "render.measure.%h.widthSpec.%d.heightSpec.%d.return", Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            Log.INSTANCE.d(TAG, string2);
            return;
        }
        GLView gLView = string2;
        Locale locale = Locale.CHINA;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.CHINA");
        Object[] objectArray = new Object[5];
        Object object = objectArray;
        object[0] = string2;
        object[1] = n2;
        object[2] = n3;
        object[3] = ((GLView)((Object)string2)).measuredWidth;
        objectArray[4] = ((GLView)((Object)string2)).measuredHeight;
        object = String.format(locale, "render.measure.start.%h.widthSpec.%d.heightSpec.%d.w.%d.h.%d", Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"java.lang.String.format(locale, format, *args)");
        Log.INSTANCE.d(TAG, (String)object);
        ((GLView)((Object)string2)).lastWidthSpec = n2;
        ((GLView)((Object)string2)).lastHeightSpec = n3;
        ((GLView)((Object)string2)).clearFlag(2);
        gLView.onMeasure(n2, n3);
        Locale locale2 = Locale.CHINA;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.CHINA");
        Object[] objectArray3 = new Object[5];
        object = objectArray3;
        object[0] = string2;
        object[1] = n2;
        object[2] = n3;
        object[3] = ((GLView)((Object)string2)).measuredWidth;
        objectArray3[4] = ((GLView)((Object)string2)).measuredHeight;
        String string3 = String.format(locale2, "render.measure.end.%h.widthSpec.%d.heightSpec.%d.w.%d.h.%d", Arrays.copyOf(objectArray3, objectArray3.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        Log.INSTANCE.d(TAG, string3);
        if ((gLView.viewFlags.get() & 2) != 0) {
            return;
        }
        throw new IllegalStateException(string2.getClass().getName() + " should call setMeasuredSize() in onMeasure()");
    }

    @WorkerThread
    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.getComponentCount();
        for (n4 = 0; n4 < n7; ++n4) {
            int n8;
            GLView gLView = this.getComponent(n4);
            if (gLView != null) {
                GLView gLView2 = gLView;
                gLView2.measure$libxcast_release(n2, n3);
                n8 = gLView2.measuredWidth;
                if (n5 > n8) {
                    n8 = n5;
                }
                if (n6 > (n5 = gLView.measuredHeight)) {
                    n5 = n6;
                }
            } else {
                int n9 = n5;
                n5 = n6;
                n8 = n9;
            }
            n6 = n5;
            n5 = n8;
        }
        n4 = this.layoutParams.width;
        if (n4 <= 0) {
            n4 = n4 == -2 ? n5 : n2;
        }
        if ((n2 = this.layoutParams.height) <= 0) {
            n2 = n2 == -2 ? n6 : n3;
        }
        this.setMeasuredSize(n4, n2);
    }

    @WorkerThread
    protected final void setMeasuredSize(int n2, int n3) {
        this.setFlag(2);
        this.measuredWidth = n2;
        this.measuredHeight = n3;
    }

    @WorkerThread
    protected void onLayout(boolean n2, int n3, int n4, int n5, int n6) {
        n3 = this.getComponentCount();
        for (n2 = 0; n2 < n3; ++n2) {
            GLView gLView = this.getComponent(n2);
            if (gLView != null) {
                GLView gLView2 = gLView;
                Rect rect = gLView2.getBounds();
                n6 = rect.left;
                int n7 = rect.top;
                gLView2.layout(n6, n7, n6 + gLView.measuredWidth, n7 + gLView.measuredHeight);
                continue;
            }
            return;
        }
    }

    protected void onVisibilityChanged(int n2) {
        int n3 = this.getComponentCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            GLView gLView = this.getComponent(i2);
            if (gLView == null) {
                Intrinsics.throwNpe();
            }
            if (gLView.getVisibility() != 0) continue;
            gLView.onVisibilityChanged(n2);
        }
    }

    protected void onAttachToRoot(@NotNull GLRoot gLRoot) {
        Intrinsics.checkParameterIsNotNull((Object)gLRoot, (String)"root");
        this._glRoot = new WeakReference<GLRoot>(gLRoot);
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            GLView gLView = this.getComponent(i2);
            if (gLView == null) {
                Intrinsics.throwNpe();
            }
            gLView.onAttachToRoot(gLRoot);
        }
    }

    protected void onDetachFromRoot() {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            GLView gLView = this.getComponent(i2);
            if (gLView == null) {
                Intrinsics.throwNpe();
            }
            gLView.onDetachFromRoot();
        }
        this._glRoot = new WeakReference<Object>(null);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/tencent/xcast/GLView$Companion;", "", "()V", "FLAG_INVISIBLE", "", "FLAG_LAYOUT_REQUESTED", "FLAG_SET_MEASURED_SIZE", "INVISIBLE", "TAG", "", "VISIBLE", "libxcast_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

