package com.tencent.wecast.sender.cloud.utils

import android.content.Context
import android.text.TextUtils
import android.util.Base64
import android.util.Log
import com.google.gson.Gson
import com.google.gson.GsonBuilder
import com.google.gson.JsonObject
import com.tencent.wecast.WeCastAppContext
import com.tencent.wecast.WeCastConstant
import com.tencent.wecast.WeCastEnv
import com.tencent.wecast.sender.cloud.bean.ChooseCorpInfo
import com.tencent.wecast.sender.cloud.bean.ChooseCorpTicketInfo
import com.tencent.wecast.sender.cloud.bean.CorpAuthRequestInfo
import com.tencent.wecast.sender.cloud.bean.CorpAuthTicketInfo
import com.tencent.wecast.sender.eb.SenderEvents
import com.tencent.wecast.utils.EventBusUtil
import com.tencent.wecast.utils.GsonUtil
import com.tencent.wecast.utils.Logger
import org.greenrobot.eventbus.EventBus
import java.io.*
import java.net.HttpURLConnection
import java.net.URL
import java.util.*

open class NetworkOriginRequestUtils {
    companion object {
        private const val TAG = "NetworkUtil"
        private const val REQUEST_CORP_AUTH_URL_PRE_RELEASE = "https://configprep.cloud.wecast.qq.com/tools/get_corp_auth_secure"
        private const val REQUEST_CORP_AUTH_URL_RELEASE = "https://config.cloud.wecast.qq.com/tools/get_corp_auth_secure"
        private const val REQUEST_CORP_AUTH_URL_DEVELOP = "https://configdev.cloud.wecast.qq.com/tools/get_corp_auth_secure"
        private const val REQUEST_CENTER_URL_DEV = "https://configurationcenterdev.wmp.avlab.qq.com"
        private const val REQUEST_CENTER_URL_PRE = "https://configurationcenterprep.wmp.avlab.qq.com"
        private const val REQUEST_CENTER_URL_RELEASE = "https://configurationcenter.wmp.avlab.qq.com"
        private const val CORP_AUTH_URL = "corpAuthUrl"
        private const val CONFIG_CENTER_URL = "configCenterUrl"
        private const val PRIVATE_FLAG = "privateFlag"
        const val REQUEST_CORP_ID_PATH = "/corp/get"
        const val REQUEST_FORBID_PATH = "/version/forbid"
        const val REQUEST_CHOOSE_CORP = "/corp/choose"
        const val REQUEST_JOIN_CORP_VERIFY = "/corp/join/verify"
        private var mInstance: NetworkOriginRequestUtils? = null

        private var mPrivateCorpAuthUrl: String? = null
        private var mPrivateConfigCenterUrl: String? = null
        private var mClickChangeCorp = false
        //是否是私有化企业
        private var mPrivateCorpFlag: Boolean? = null

        private const val PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----\n" +
                "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCooVF38/WM9am6RepYmycWkCw2\n" +
                "J0bU9hoKp+N+wmQ/c6hCJNBmxQbwaiO0+fmyaorQvLM3B59pexKQ+EAta8zNf413\n" +
                "WDJV4oVfeQ04riumj2S4PVdakLfWstRDaNxwJZNn2yz/RZvyQLC1AYXaTQJ17Gxd\n" +
                "bq0cztpSOtTL6VWUIQIDAQAB\n" +
                "-----END PUBLIC KEY-----"

        private const val PRIVATE_KEY = "-----BEGIN PUBLIC KEY-----\n" +
                "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDCWlQn81+FYDl9HBwSmW6qRySz\n" +
                "5d6Kr2CUThwc5fY4N1RjlHM+p3TV2IFO9ygEO9rRH6LisayCgjEGmTANoSM4Ouaq\n" +
                "jAiwY8ri1g0whVk78HxFOa5keqhtp14+OirxVzxtEc6AlEIFa0YA+33zct4AspSb\n" +
                "bqKHcKFO9TmNyUpm/wIDAQAB\n" +
                "-----END PUBLIC KEY-----"

        fun getInstance(): NetworkOriginRequestUtils {
            if (mInstance == null) {
                synchronized(NetworkOriginRequestUtils::class.java) {
                    if (mInstance == null) {
                        mInstance = NetworkOriginRequestUtils()
                        mPrivateCorpAuthUrl = WeCastAppContext.get().getSharedPreferences(CORP_AUTH_URL, Context.MODE_PRIVATE)
                                .getString(CORP_AUTH_URL, null)
                        mPrivateConfigCenterUrl = WeCastAppContext.get().getSharedPreferences(CONFIG_CENTER_URL, Context.MODE_PRIVATE)
                                .getString(CONFIG_CENTER_URL, null)
                        mPrivateCorpFlag = WeCastAppContext.get().getSharedPreferences(PRIVATE_FLAG, Context.MODE_PRIVATE)
                                .getBoolean(PRIVATE_FLAG, false)
                    }
                    return mInstance!!
                }
            } else {
                return mInstance!!
            }
        }
    }

    internal fun requestChooseCorp(context: Context, corpToken: String?, tokenKey: String, requestListener: NetworkRequestListener) {
        val url = getConfigCenterUrl() + REQUEST_CHOOSE_CORP
        sendRequest(url, createChooseCorpBody(context, corpToken, tokenKey), requestListener)
    }

    fun requestAuthCode(corpId: String, isChangeCorp: Boolean, isNewCorp: Boolean = true) {
        requestCorpAuth(WeCastAppContext.get(), corpId, object : OnRequestAuthCodeListener {
            override fun onRequestSuccess(authCode: String, corpName: String) {
                Logger.t(TAG).d("AuthCode:$authCode")
                val event = SenderEvents.ERequestAuthCode()
                event.eventCode = event.SUCCESS
                event.authCode = authCode
                event.corpId = corpId
                event.corpName = corpName
                event.isChangeCorp = isChangeCorp
                event.isNewCorp = isNewCorp
                EventBus.getDefault().postSticky(event)
                EventBusUtil.unregister(this)
            }

            override fun onRequestFail(retCode: Int?) {
                Logger.t(TAG).d("AuthCode onRequestFail")
                val event = SenderEvents.ERequestAuthCode()
                event.eventCode = event.ERROR
                event.corpId = corpId
                event.requestCode = retCode
                EventBus.getDefault().postSticky(event)
            }
        })
    }

    fun requestCorpAuth(appContext: Context, corpId: String, onRequestAuthCodeListener: OnRequestAuthCodeListener?) {
        val ticketInfo = CorpAuthTicketInfo()
        ticketInfo.corpId = corpId
        ticketInfo.nonce = getRandomString()
        val gson = GsonBuilder().disableHtmlEscaping().create()
        val rsaTicket = RSAUtils.encryptRsa(getCorpAuthPublicKey(), gson.toJson(ticketInfo))
        if (rsaTicket != null) {
            val rsaTicketStr = Base64.encodeToString(rsaTicket, Base64.NO_WRAP)
            val requestInfo = CorpAuthRequestInfo()
            requestInfo.corpId = corpId
            requestInfo.ticket = rsaTicketStr
            sendCorpAuthRequest(appContext, gson.toJson(requestInfo), onRequestAuthCodeListener)
        } else {
            Logger.t(TAG).d("Get AuthCode Fail Ticket Null")
            onRequestAuthCodeListener?.onRequestFail(null)
        }
    }

    private fun getCorpAuthPublicKey(): String {
        return if (getPrivateFlag())
            "-----BEGIN PUBLIC KEY-----\n" +
                    "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCzq7YmZ88G1UtybuTeK75h958h\n" +
                    "MiSSOwBL4y4jLCGaEKYVrZN5C6anCX68vqh9Pg9dEbqv01KR4AbZac1sjUNIX1CP\n" +
                    "gHGieFBXu85tfCBpes1ddFguS9LWa+e5Xb+NBfGFocj0iUniWYkIMOMAnmxIo4Ss\n" +
                    "QTW4ONX6qztnQ20bWwIDAQAB\n" +
                    "-----END PUBLIC KEY-----"//私有化公钥
        else "-----BEGIN PUBLIC KEY-----\n" +
                "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDWNJ78jOp2g/WAH/6WlQVvr3yR\n" +
                "RvUPWfV8vqiPZHXLH5IqODYSl00oJT9yaOOC44Hn3XxkODYbX5pU7ELY0+mnjHS2\n" +
                "RNceXMvmPq8sHVsb0vcx2Jt1ho4Ov8bfLpMzabnYmVhQ+m+t/Zfwd6ZvwN4poVBB\n" +
                "uWSL/FMBomC8Ca6cvwIDAQAB\n" +
                "-----END PUBLIC KEY-----"//公有化公钥
    }

    /**
     * 请求AuthCode回调
     */
    interface OnRequestAuthCodeListener {
        fun onRequestSuccess(authCode: String, corpName: String)
        fun onRequestFail(retCode: Int?)
    }

    /**
     * 请求AuthCode
     *@param corpAuthJson {corp_id: ,ticket :}
     *@param onRequestAuthCodeListener 请求AuthCode回调
     */
    private fun sendCorpAuthRequest(appContext: Context, corpAuthJson: String, onRequestAuthCodeListener: OnRequestAuthCodeListener?) {
        WeCastAppContext.init(appContext)
        WeCastEnv.initEnv()
        val requestUrl = getInstance().getCorpAuthUrl()
        Logger.t(TAG).d("corpAuth url:$requestUrl  corpAuthJson:$corpAuthJson")
        sendRequest(requestUrl, corpAuthJson, object : NetworkRequestListener {
            override fun onSuccess(resultJson: String?) {
                Logger.t(TAG).d("resultJson:$resultJson")
                val jsonObject = Gson().fromJson(resultJson, JsonObject::class.java)
                val retCode = jsonObject.get("retcode").asInt
                if (retCode == ErrorCodeUtil.SUCCESS) {
                    val corpName = jsonObject.get("corp_info").asJsonObject.get("corp_name").asString
                    onRequestAuthCodeListener?.onRequestSuccess(jsonObject.get("result").asString, corpName)
                } else {
                    onRequestAuthCodeListener?.onRequestFail(retCode)
                }
            }

            override fun onFailed() {
                onRequestAuthCodeListener?.onRequestFail(null)
            }
        })
    }

    private fun getRandomString(): String {
        val randomInt = Random().nextInt()
        return randomInt.toString()
    }


    fun getCorpAuthUrl(): String {
        if (mInstance == null) {
            getInstance()
        }
        return if (!TextUtils.isEmpty(mPrivateCorpAuthUrl) && !mClickChangeCorp) {
            mPrivateCorpAuthUrl!!
        } else {
            when (WeCastEnv.getCurrentEnv()) {
                WeCastEnv.ENV_DEVELOP -> REQUEST_CORP_AUTH_URL_DEVELOP
                WeCastEnv.ENV_PRE_RELEASE -> REQUEST_CORP_AUTH_URL_PRE_RELEASE
                else -> REQUEST_CORP_AUTH_URL_RELEASE
            }
        }
    }

    fun getConfigCenterUrl(): String {
        if (mInstance == null) {
            getInstance()
        }
        return if (!TextUtils.isEmpty(mPrivateConfigCenterUrl) && !mClickChangeCorp) {
            mPrivateConfigCenterUrl!!
        } else {
            when (WeCastEnv.getCurrentEnv()) {
                WeCastEnv.ENV_DEVELOP -> REQUEST_CENTER_URL_DEV
                WeCastEnv.ENV_PRE_RELEASE -> REQUEST_CENTER_URL_PRE
                else -> REQUEST_CENTER_URL_RELEASE
            }
        }
    }

    fun setClickChangeCorp(clickChangeCorp: Boolean) {
        mClickChangeCorp = clickChangeCorp
    }

    fun getClickChangeCorp(): Boolean {
        return mClickChangeCorp
    }

    fun setPrivateConfigCenterUrl(url: String?) {
        mPrivateCorpFlag = url != null
        mPrivateConfigCenterUrl = url
    }

    fun setPrivateCorpAuthUrl(url: String?) {
        mPrivateCorpFlag = url != null
        mPrivateCorpAuthUrl = url
    }

    fun savePrivateUrl(context: Context) {
        if (!mClickChangeCorp && mPrivateConfigCenterUrl != null && mPrivateCorpAuthUrl != null) {
            context.getSharedPreferences(CONFIG_CENTER_URL, Context.MODE_PRIVATE)
                    .edit().putString(CONFIG_CENTER_URL, mPrivateCorpAuthUrl).apply()
            context.getSharedPreferences(CORP_AUTH_URL, Context.MODE_PRIVATE)
                    .edit().putString(CORP_AUTH_URL, mPrivateCorpAuthUrl).apply()
            context.getSharedPreferences(PRIVATE_FLAG, Context.MODE_PRIVATE)
                    .edit().putBoolean(PRIVATE_FLAG, true).apply()
        } else {
            mPrivateCorpAuthUrl = null
            mPrivateConfigCenterUrl = null
            mPrivateCorpFlag = false
            WeCastAppContext.get().getSharedPreferences(CONFIG_CENTER_URL, Context.MODE_PRIVATE).edit()
                    .putString(CONFIG_CENTER_URL, null).apply()
            WeCastAppContext.get().getSharedPreferences(CORP_AUTH_URL, Context.MODE_PRIVATE).edit()
                    .putString(CORP_AUTH_URL, null).apply()
            WeCastAppContext.get().getSharedPreferences(PRIVATE_FLAG, Context.MODE_PRIVATE).edit()
                    .putBoolean(PRIVATE_FLAG, false).apply()
        }
    }

    fun clearPrivateUrl() {
        mPrivateCorpAuthUrl = WeCastAppContext.get().getSharedPreferences(CORP_AUTH_URL, Context.MODE_PRIVATE)
                .getString(CORP_AUTH_URL, null)
        mPrivateConfigCenterUrl = WeCastAppContext.get().getSharedPreferences(CONFIG_CENTER_URL, Context.MODE_PRIVATE)
                .getString(CONFIG_CENTER_URL, null)
        mPrivateCorpFlag = mPrivateCorpAuthUrl != null && mPrivateConfigCenterUrl != null
    }

    /**
     * 网络请求回调接口
     */
    interface NetworkRequestListener {
        fun onSuccess(resultJson: String?)
        fun onFailed()
    }

    fun createChooseCorpBody(context: Context, corpToken: String?, tokenKey: String): String {
        if (corpToken != null) {
            val chooseCorpTicketInfo = ChooseCorpTicketInfo()
            chooseCorpTicketInfo.corpToken = corpToken
            chooseCorpTicketInfo.timestamp = System.currentTimeMillis().toString()
            chooseCorpTicketInfo.versionInt = WeCastConstant.WECAST_VERSION_CODE
            chooseCorpTicketInfo.tokenKey = tokenKey
            val gson = GsonBuilder().disableHtmlEscaping().create()
            Logger.t(TAG).d("ChooseCorpTicketInfo:${gson.toJson(chooseCorpTicketInfo)}")
            val rsaTicket = RSAUtils.encryptRsa(getRsaKey(context), gson.toJson(chooseCorpTicketInfo))
            val rsaTicketStr = Base64.encodeToString(rsaTicket, Base64.NO_WRAP)
            val chooseCorpInfo = ChooseCorpInfo()
            chooseCorpInfo.seq = Random().nextInt()
            chooseCorpInfo.ticket = rsaTicketStr
            Logger.t(TAG).d("Url:${getInstance().getCorpAuthUrl()}  ChooseCorpInfo:${GsonUtil.getGson().toJson(chooseCorpInfo)}")
            return GsonUtil.getGson().toJson(chooseCorpInfo)
        } else {
            Logger.t(TAG).e("corp token null")
            return ""
        }
    }

    fun getRsaKey(context: Context): String {
        if (mPrivateCorpFlag == null) {
            mPrivateCorpFlag = context.getSharedPreferences(PRIVATE_FLAG, Context.MODE_PRIVATE)
                    .getBoolean(PRIVATE_FLAG, false)
        }
        return if (mPrivateCorpFlag!!) {
            PRIVATE_KEY
        } else {
            PUBLIC_KEY
        }
    }

    private fun sendRequest(urlStr: String, bodyJson: String, networkRequestListener: NetworkRequestListener?) {
        val sendHttpRequestThread = object : Thread() {
            override fun run() {
                // Maintain http url connection.
                var httpConn: HttpURLConnection? = null
                // Read text input stream.
                var isReader: InputStreamReader? = null
                // Read text into buffer.
                var bufReader: BufferedReader? = null
                // Save server response text.
                val readTextBuf = StringBuilder()
                try {
                    // Create a URL object use page url.
                    val url = URL(urlStr)
                    // Open http connection to web server.
                    httpConn = url.openConnection() as HttpURLConnection
                    // Set http request method to get.
                    httpConn.requestMethod = "POST"  // 设定请求方式为"POST"，默认为"GET"
                    httpConn.doOutput = true     // 设置是否向HttpUrlConnction输出，因为这个是POST请求，参数要放在http正文内，因此需要设为true，默认情况下是false
                    httpConn.doInput = true    // 设置是否向HttpUrlConnection读入，默认情况下是true
                    httpConn.useCaches = false // POST请求不能使用缓存（POST不能被缓存）
                    httpConn.instanceFollowRedirects = true
                    httpConn.setRequestProperty("Content-Type", "application/json")
                    // Set connection timeout and read timeout value.
                    httpConn.connectTimeout = 5000
                    httpConn.readTimeout = 5000

                    val outputStream = httpConn.outputStream
                    val outputStreamWriter = OutputStreamWriter(outputStream)
                    val bufferedWriter = BufferedWriter(outputStreamWriter)
                    bufferedWriter.write(bodyJson)
                    bufferedWriter.flush()
                    bufferedWriter.close()

                    val responseCode = httpConn.responseCode
                    if (responseCode == HttpURLConnection.HTTP_OK) {
                        // Get input stream from web url connection.
                        val inputStream = httpConn.inputStream
                        // Create input stream reader based on url connection input stream.
                        isReader = InputStreamReader(inputStream)
                        // Create buffered reader.
                        bufReader = BufferedReader(isReader)
                        // Read line of text from server response.
                        var line: String? = bufReader.readLine()
                        // Loop while return line is not null.
                        while (line != null) {
                            // Append the text to string buffer.
                            readTextBuf.append(line)
                            // Continue to read text line.
                            line = bufReader.readLine()
                        }

                        val result = readTextBuf.toString()
                        val resultJson = Gson().fromJson(result, JsonObject::class.java)
                        if (resultJson != null) {
                            networkRequestListener?.onSuccess(resultJson.toString())
                        } else {
                            networkRequestListener?.onFailed()
                        }

                    } else {
                        networkRequestListener?.onFailed()
                    }
                } catch (ex: IOException) {
                    Log.e(TAG, ex.message, ex)
                    networkRequestListener?.onFailed()
                } finally {
                    try {
                        bufReader?.close()

                        isReader?.close()

                        httpConn?.disconnect()
                    } catch (ex: IOException) {
                        Log.e(TAG, ex.message, ex)
                    }

                }
            }
        }
        // Start the child thread to request web page.
        sendHttpRequestThread.start()
    }

    fun getPrivateFlag(): Boolean {
        if (mPrivateCorpFlag != null) {
            return mPrivateCorpFlag!!
        }
        return false
    }

}