package com.tencent.wecast.sender.cloud.widget

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.View
import android.widget.Button
import android.widget.TextView
import com.tencent.wecast.sender.cloud.R

class WeCastDialog private constructor(context: Context) : Dialog(context, R.style.WeCastDialog) {
    private var mTitleTv: TextView? = null
    private var mMsgTv: TextView? = null
    private var mCancelBtn: Button? = null
    private var mConfirmBtn: Button? = null
    private var mSplitLineView: View? = null

    companion object {
        fun showWeCastDialog(context: Context, title: String, message: String, positiveText: String?, positiveFunc: (() -> Unit)?
                             , negativeText: String?, negativeFunc: (() -> Unit)?): WeCastDialog {
            val weCastDialog = WeCastDialog(context)
            weCastDialog.show()
            weCastDialog.setTitle(title)
            weCastDialog.setMessage(message)
            weCastDialog.setCancelable(false)
            if (positiveText != null) {
                weCastDialog.setConfirmFunc(positiveText, View.OnClickListener {
                    weCastDialog.dismiss()
                    positiveFunc?.invoke()
                })
            }
            if (negativeText != null) {
                weCastDialog.setCancelFunc(negativeText, View.OnClickListener {
                    weCastDialog.dismiss()
                    negativeFunc?.invoke()
                })
            }
            if (positiveText != null && negativeText != null) {
                weCastDialog.setSplitLineVisible(View.VISIBLE)
            } else {
                weCastDialog.setSplitLineVisible(View.GONE)
            }
            return weCastDialog
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.wecast_dialog)
        initView()
    }

    private fun initView() {
        mTitleTv = findViewById(R.id.wecast_dialog_title_tv)
        mMsgTv = findViewById(R.id.wecast_dialog_msg_tv)
        mCancelBtn = findViewById(R.id.wecast_dialog_cancel_btn)
        mConfirmBtn = findViewById(R.id.wecast_dialog_confirm_btn)
        mSplitLineView = findViewById(R.id.wecast_dialog_split_line_view)
    }

    fun setTitle(title: String) {
        mTitleTv?.text = title
    }

    fun setMessage(msg: String) {
        mMsgTv?.text = msg
    }

    fun setCancelFunc(cancelText: String, onClickListener: View.OnClickListener) {
        mCancelBtn?.visibility = View.VISIBLE
        mCancelBtn?.text = cancelText
        mCancelBtn?.setOnClickListener(onClickListener)
    }

    fun setConfirmFunc(confirmText: String, onClickListener: View.OnClickListener) {
        mConfirmBtn?.visibility = View.VISIBLE
        mConfirmBtn?.text = confirmText
        mConfirmBtn?.setOnClickListener(onClickListener)
    }

    fun setSplitLineVisible(visible: Int) {
        mSplitLineView?.visibility = visible
    }
}