package com.tencent.wecast.sender.cloud.utils

import android.app.DownloadManager
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Environment
import android.os.Handler
import android.os.Looper
import android.support.v4.content.FileProvider
import android.text.TextUtils
import com.tencent.wecast.sender.eb.SenderEvents
import com.tencent.wecast.utils.Logger
import org.greenrobot.eventbus.EventBus
import java.io.File

object DownloadApkUtils {
    private const val TAG = "DownloadAppUtils"
    private var downloadUpdateApkId: Long = -1//下载更新Apk 下载任务对应的Id
    private var downloadUpdateApkFilePath: String? = null//下载更新Apk 文件路径
    private var downloadManager: DownloadManager? = null
    private const val DOWNLOAD_PATH = "/apk/"
    private var fileMd5 = ""
    private var mCancel = false

    fun setFileMd5(fileMd5: String) {
        this.fileMd5 = fileMd5
    }

    interface WeCastDownloadApkListener {
        fun onDownloadFailed()
    }

    interface WeCastDownloadApkProgressListener {
        fun onProgressChange(progress: Int)
    }

    fun getIsCancel(): Boolean {
        return mCancel
    }

    fun setIsCancel(isCancel: Boolean) {
        mCancel = isCancel
    }

    fun getDownloadFileId(): Long {
        return downloadUpdateApkId
    }

    /**
     * 下载更新apk包
     * @param context
     * @param url
     */
    fun downloadForAutoInstall(context: Context, url: String, fileName: String, title: String
                               , weCastDownloadListener: WeCastDownloadApkListener) {
        if (TextUtils.isEmpty(url)) {
            return
        }
        mCancel = false

        val uri = Uri.parse(url)
        downloadManager = context
                .getSystemService(Context.DOWNLOAD_SERVICE) as DownloadManager
        val request = DownloadManager.Request(uri)
        //在通知栏中显示
        request.setVisibleInDownloadsUi(true)
        request.setTitle(title)
        var filePath: String? = null
        if (Environment.getExternalStorageState() == Environment.MEDIA_MOUNTED) {//外部存储卡
            filePath = Environment.getExternalStorageDirectory().absolutePath + DOWNLOAD_PATH
        } else {
            Logger.t(TAG).d("Download Fail:SD Card is not exists")
            weCastDownloadListener.onDownloadFailed()
            return
        }
        downloadUpdateApkFilePath = if (fileName.endsWith(".apk")) {
            filePath + File.separator + fileName
        } else {
            filePath + File.separator + fileName + ".apk"
        }
        if (downloadUpdateApkFilePath != null) {
            val path = downloadUpdateApkFilePath!!
            val file = File(path)
            // 若存在，则删除
            if (file.exists()) {
                file.delete()
            }
        }
        val fileUri = Uri.parse("file://$downloadUpdateApkFilePath")
        request.setDestinationUri(fileUri)
        if (downloadManager != null) {
            downloadUpdateApkId = downloadManager!!.enqueue(request)
            Logger.t(TAG).d("download update api task id: $downloadUpdateApkId")
        }
    }

    fun setDownloadProgressListener(context: Context, progressListener: WeCastDownloadApkProgressListener) {
        if (downloadUpdateApkId != -1L) {
            val downloadManager = context
                    .getSystemService(Context.DOWNLOAD_SERVICE) as DownloadManager
            val query = DownloadManager.Query().setFilterById(downloadUpdateApkId)
            val handle = Handler(Looper.myLooper())
            var queryTask: Runnable? = null
            var progress = 0
            queryTask = Runnable {
                Logger.t(TAG).d("download progress: $progress")
                handle.removeCallbacks(queryTask)
                if (progress < 100 && !mCancel) {
                    val c = downloadManager.query(query)
                    if (c != null && c.moveToFirst()) {
                        val downloadBytesIdx = c.getColumnIndexOrThrow(
                                DownloadManager.COLUMN_BYTES_DOWNLOADED_SO_FAR)
                        val totalBytesIdx = c.getColumnIndexOrThrow(
                                DownloadManager.COLUMN_TOTAL_SIZE_BYTES)
                        val totalBytes = c.getLong(totalBytesIdx)
                        val downloadBytes = c.getLong(downloadBytesIdx)
                        progress = (downloadBytes * 100 / totalBytes).toInt()
                        progressListener.onProgressChange(progress)
                    }
                    handle.postDelayed(queryTask, 1000)
                } else if(progress >= 100) {
                    Logger.t(TAG).d("download app process 100%.")
                }
            }
            handle.postDelayed(queryTask, 1000)
        }
    }

    fun cancelDownload() {
        if (downloadUpdateApkId != -1L) {
            downloadManager?.remove(downloadUpdateApkId)
            downloadUpdateApkId = -1L
            mCancel = true
        }
    }

    private fun queryDownloadedApk(): File? {
        var targetApkFile: File? = null
        if (downloadUpdateApkId != -1L) {
            val query = DownloadManager.Query()
            query.setFilterById(downloadUpdateApkId)
            query.setFilterByStatus(DownloadManager.STATUS_SUCCESSFUL)
            val cur = downloadManager?.query(query)
            if (cur != null) {
                if (cur.moveToFirst()) {
                    val uriString = cur.getString(cur.getColumnIndex(DownloadManager.COLUMN_LOCAL_URI))
                    targetApkFile = File(Uri.parse(uriString).path)
                }
                cur.close()
            }
        }
        return targetApkFile
    }

    fun installApk(context: Context) {
        val i = Intent(Intent.ACTION_VIEW)
        i.flags = Intent.FLAG_ACTIVITY_NEW_TASK
        i.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)
        val apkFile = queryDownloadedApk()
        if (fileMd5.isNotEmpty()
                && fileMd5.toUpperCase() != FileMd5Util.getFileMD5(apkFile).toUpperCase()) {
            Logger.t(TAG).d("File MD5 ERROR...  MD5:${FileMd5Util.getFileMD5(apkFile)}")
            val event = SenderEvents.EStopSplashEvent()
            event.eventCode = event.ERROR
            EventBus.getDefault().post(event)
            return
        }
        if (apkFile != null && apkFile.exists()) {
            i.setDataAndType(Uri.fromFile(apkFile), "application/vnd.android.package-archive")
            i.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            context.startActivity(i)
        } else {
            Logger.t(TAG).d("Install Fail Apk Not Found")
            val event = SenderEvents.EStopSplashEvent()
            event.eventCode = event.ERROR
            EventBus.getDefault().post(event)
        }
    }

    fun installApkForAndroidN(context: Context) {
        if (getDownloadFileId() != -1L) {
            val query = DownloadManager.Query()
            query.setFilterById(getDownloadFileId())
            query.setFilterByStatus(DownloadManager.STATUS_SUCCESSFUL)
            val cur = downloadManager?.query(query)
            if (cur != null) {
                if (cur.moveToFirst()) {
                    val i = Intent(Intent.ACTION_VIEW)
                    val file = File(downloadUpdateApkFilePath)
                    if (fileMd5.isNotEmpty()
                            && fileMd5.toUpperCase() != FileMd5Util.getFileMD5(file).toUpperCase()) {
                        Logger.t(TAG).d("File MD5 ERROR...  MD5:${FileMd5Util.getFileMD5(file)}")
                        val event = SenderEvents.EStopSplashEvent()
                        event.eventCode = event.ERROR
                        EventBus.getDefault().post(event)
                        return
                    }
                    i.flags = Intent.FLAG_ACTIVITY_NEW_TASK
                    i.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)
                    i.setDataAndType(FileProvider.getUriForFile(context,
                            "com.tencent.wecast.sender.cloud.provider", file),
                            "application/vnd.android.package-archive")
                    context.startActivity(i)
                }
                cur.close()
            }
        }
    }

}