package com.tencent.wecast.jni;

import android.content.Context;
import android.util.Log;

import java.io.IOException;

class JCallCppMgr {
    private final static String TAG = "JCallCppMgr";

    native static void init(Context appContext);

    native static byte[] callJniFunc(String funcName, byte[] params);

    static ParamsPackage.ParamsFromCpp callJniFunc(String funcName,
                                                   ParamsPackage.ParamsToCpp paramsPkg) {
        try {
            byte[] params;
            if (paramsPkg == null) {
                params = ParamsPackage.voidPkg();
            } else {
                params = paramsPkg.build();
            }
            Log.i(TAG, "Java call c++ function: " + funcName);
            byte[] bytes = callJniFunc(funcName, params);
            return ParamsPackage.fromBytes(bytes);
        } catch (IOException e) {
            Log.e(TAG, "Java call c++ function error: ", e);
            e.printStackTrace();
        }
        return null;
    }
}
