/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast.audio;

import android.media.AudioRecord;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import android.util.Log;
import com.tencent.xcast.audio.ThreadUtils;
import com.tencent.xcast.audio.WebRtcAudioUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_AUDIO_SOURCE;
    private static int audioSource;
    private static volatile boolean microphoneMute;
    @Nullable
    private static WebRtcAudioRecordErrorCallback errorCallback;
    @Nullable
    private static WebRtcAudioRecordSamplesReadyCallback audioSamplesReadyCallback;
    private final long nativeAudioRecord;
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioRecordThread audioThread;
    private byte[] emptyBytes;

    public static void setErrorCallback(WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback) {
        Log.d((String)TAG, (String)"Set error callback");
        errorCallback = webRtcAudioRecordErrorCallback;
    }

    public static void setOnAudioSamplesReady(WebRtcAudioRecordSamplesReadyCallback webRtcAudioRecordSamplesReadyCallback) {
        audioSamplesReadyCallback = webRtcAudioRecordSamplesReadyCallback;
    }

    WebRtcAudioRecord(long l2) {
        Log.d((String)TAG, (String)("[android-jni.capture] ctor" + WebRtcAudioUtils.getThreadInfo()));
        this.nativeAudioRecord = l2;
    }

    private int initRecording(int n2, int n3) {
        Log.d((String)TAG, (String)("initRecording(sampleRate=" + n2 + ", channels=" + n3 + ")"));
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        int n4 = n3;
        WebRtcAudioRecord webRtcAudioRecord = this;
        int n5 = n3 * 2;
        n3 = n2 / 100;
        webRtcAudioRecord.byteBuffer = ByteBuffer.allocateDirect(n5 * n3);
        Log.d((String)TAG, (String)("byteBuffer.capacity: " + this.byteBuffer.capacity()));
        webRtcAudioRecord.emptyBytes = new byte[webRtcAudioRecord.byteBuffer.capacity()];
        webRtcAudioRecord.nativeCacheDirectBufferAddress(webRtcAudioRecord.byteBuffer, this.nativeAudioRecord);
        int n6 = this.channelCountToConfiguration(n4);
        int n7 = AudioRecord.getMinBufferSize((int)n2, (int)n6, (int)2);
        if (n7 != -1 && n7 != -2) {
            int n8;
            AudioRecord audioRecord;
            AudioRecord audioRecord2;
            Log.d((String)TAG, (String)("AudioRecord.getMinBufferSize: " + n7));
            n7 = Math.max(n7 * 2, this.byteBuffer.capacity());
            Log.d((String)TAG, (String)("bufferSizeInBytes: " + n7));
            try {
                AudioRecord audioRecord3;
                audioRecord2 = audioRecord3;
                audioRecord = audioRecord3;
                n8 = audioSource;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WebRtcAudioRecord webRtcAudioRecord2 = this;
                webRtcAudioRecord2.reportWebRtcAudioRecordInitError("AudioRecord ctor error: " + illegalArgumentException.getMessage());
                webRtcAudioRecord2.releaseAudioResources();
                return -1;
            }
            audioRecord2(n8, n2, n6, 2, n7);
            AudioRecord audioRecord4 = this.audioRecord = audioRecord;
            if (audioRecord4 != null && audioRecord4.getState() == 1) {
                WebRtcAudioRecord webRtcAudioRecord3 = this;
                webRtcAudioRecord3.logMainParameters();
                webRtcAudioRecord3.logMainParametersExtended();
                return n3;
            }
            WebRtcAudioRecord webRtcAudioRecord4 = this;
            webRtcAudioRecord4.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance");
            webRtcAudioRecord4.releaseAudioResources();
            return -1;
        }
        this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + n7);
        return -1;
    }

    private boolean startRecording() {
        block2: {
            Log.d((String)TAG, (String)"startRecording");
            WebRtcAudioRecord.assertTrue(this.audioRecord != null);
            WebRtcAudioRecord.assertTrue(this.audioThread == null);
            try {
                WebRtcAudioRecord webRtcAudioRecord = this;
                webRtcAudioRecord.audioRecord.startRecording();
                if (webRtcAudioRecord.audioRecord.getRecordingState() == 3) break block2;
            }
            catch (IllegalStateException illegalStateException) {
                this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + illegalStateException.getMessage());
                return false;
            }
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState());
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopRecording() {
        Log.d((String)TAG, (String)"stopRecording");
        WebRtcAudioRecord.assertTrue(this.audioThread != null);
        WebRtcAudioRecord webRtcAudioRecord = this;
        webRtcAudioRecord.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(webRtcAudioRecord.audioThread, 2000L)) {
            Log.e((String)TAG, (String)"Join of AudioRecordJavaThread timed out");
        }
        this.audioThread = null;
        this.releaseAudioResources();
        return true;
    }

    private void setAudioSource(int n2) {
        Log.w((String)TAG, (String)("Audio source is changed from: " + audioSource + " to " + n2));
        audioSource = n2;
    }

    private void logMainParameters() {
        Log.d((String)TAG, (String)("AudioRecord: channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate()));
    }

    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            Log.d((String)TAG, (String)("AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames()));
        }
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n2) {
        return n2 == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    private static int getDefaultAudioSource() {
        return 7;
    }

    public static void setMicrophoneMute(boolean bl) {
        Log.w((String)TAG, (String)("setMicrophoneMute(" + bl + ")"));
        microphoneMute = bl;
    }

    private void releaseAudioResources() {
        Log.d((String)TAG, (String)"releaseAudioResources");
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.release();
            this.audioRecord = null;
        }
    }

    private void reportWebRtcAudioRecordInitError(String string2) {
        Log.e((String)TAG, (String)("Init recording error: " + string2));
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordInitError(string2);
        }
    }

    private void reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode audioRecordStartErrorCode, String string2) {
        Log.e((String)TAG, (String)("Start recording error: " + (Object)((Object)audioRecordStartErrorCode) + ". " + string2));
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordStartError(audioRecordStartErrorCode, string2);
        }
    }

    private void reportWebRtcAudioRecordError(String string2) {
        Log.e((String)TAG, (String)("Run-time recording error: " + string2));
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordError(string2);
        }
    }

    static {
        audioSource = DEFAULT_AUDIO_SOURCE = WebRtcAudioRecord.getDefaultAudioSource();
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String string2) {
            super(string2);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            block7: {
                Process.setThreadPriority((int)-19);
                Log.d((String)WebRtcAudioRecord.TAG, (String)("AudioRecordThread" + WebRtcAudioUtils.getThreadInfo()));
                WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
                System.nanoTime();
                while (this.keepAlive) {
                    int n2 = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                    if (n2 == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                        if (microphoneMute) {
                            AudioRecordThread audioRecordThread = this;
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.clear();
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                        }
                        if (this.keepAlive) {
                            WebRtcAudioRecord webRtcAudioRecord = WebRtcAudioRecord.this;
                            webRtcAudioRecord.nativeDataIsRecorded(n2, webRtcAudioRecord.nativeAudioRecord);
                        }
                        if (audioSamplesReadyCallback == null) continue;
                        byte[] byArray = Arrays.copyOf(WebRtcAudioRecord.this.byteBuffer.array(), WebRtcAudioRecord.this.byteBuffer.capacity());
                        audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new AudioSamples(WebRtcAudioRecord.this.audioRecord, byArray));
                        continue;
                    }
                    String string2 = "AudioRecord.read failed: " + n2;
                    Log.e((String)WebRtcAudioRecord.TAG, (String)string2);
                    if (n2 != -3) continue;
                    this.keepAlive = false;
                    WebRtcAudioRecord.this.reportWebRtcAudioRecordError(string2);
                }
                if (WebRtcAudioRecord.this.audioRecord == null) break block7;
                try {
                    WebRtcAudioRecord.this.audioRecord.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    Log.e((String)WebRtcAudioRecord.TAG, (String)("AudioRecord.stop failed: " + illegalStateException.getMessage()));
                }
            }
        }

        public void stopThread() {
            Log.d((String)WebRtcAudioRecord.TAG, (String)"stopThread");
            this.keepAlive = false;
        }
    }

    public static interface WebRtcAudioRecordSamplesReadyCallback {
        public void onWebRtcAudioRecordSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        private final int audioFormat;
        private final int channelCount;
        private final int sampleRate;
        private final byte[] data;

        private AudioSamples(AudioRecord audioRecord, byte[] byArray) {
            this.audioFormat = audioRecord.getAudioFormat();
            this.channelCount = audioRecord.getChannelCount();
            this.sampleRate = audioRecord.getSampleRate();
            this.data = byArray;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface WebRtcAudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    public static enum AudioRecordStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }
}

