package com.tencent.wecast.sender.cloud.receiver

import android.app.DownloadManager
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.os.Build
import com.tencent.wecast.sender.cloud.utils.DownloadApkUtils
import com.tencent.wecast.sender.eb.SenderEvents
import com.tencent.wecast.utils.Logger
import org.greenrobot.eventbus.EventBus


/**
 * 用于Apk下载完成后跳转安装界面
 */
class UpdateAppReceiver : BroadcastReceiver() {

    companion object {
        private const val TAG = "UpdateAppReceiver"
    }

    override fun onReceive(context: Context, intent: Intent?) {
        if (intent?.action.equals(DownloadManager.ACTION_DOWNLOAD_COMPLETE)) {
            if (!DownloadApkUtils.getIsCancel() && DownloadApkUtils.getDownloadFileId() != -1L) {
                tryInstallApk(context)
            }
            DownloadApkUtils.setIsCancel(false)
        }
    }

    private fun tryInstallApk(context: Context) {
        try {
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.N) {
                DownloadApkUtils.installApk(context)
            } else {
                DownloadApkUtils.installApkForAndroidN(context)
            }
            val event = SenderEvents.EStopSplashEvent()
            event.eventCode = event.SUCCESS
            EventBus.getDefault().post(event)
        } catch (e: Exception) {
            Logger.t(TAG).d("Install Fail:" + e.message)
            val event = SenderEvents.EStopSplashEvent()
            event.eventCode = event.ERROR
            EventBus.getDefault().post(event)
            e.printStackTrace()
        }
    }
}