package com.tencent.wecast.sender.cloud.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.support.v4.content.ContextCompat
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.tencent.wecast.WeCastUIConfigManager
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.sender.cloud.activity.CloudWebViewActivity.Companion.PRIVACY_POLICY
import com.tencent.wecast.sender.cloud.activity.CloudWebViewActivity.Companion.SERVICE_AGREEMENT
import com.tencent.wecast.sender.cloud.utils.StatusBarUtils
import com.tencent.wecast.utils.Logger

class CloudAboutUsActivity : BaseActivity(), View.OnClickListener {

    companion object {
        private const val TAG = "CloudAboutUsActivity"
    }

    private var mTvVersion: TextView? = null
    private var mTvServiceAgreement: TextView? = null
    private var mTvPrivacyProtocol: TextView? = null
    private var mBtnClose: ImageView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        StatusBarUtils.setWindowStatusBarColor(this@CloudAboutUsActivity,
                WeCastUIConfigManager.getInstance().getStatusBarColor(ContextCompat.getColor(applicationContext, R.color.wecast_about_us_bg_color)))
        StatusBarUtils.setStatusBarLightMode(this@CloudAboutUsActivity, true)
        setContentView(R.layout.wecast_activity_about_us)
        initView()
    }

    private fun initView() {
        mTvVersion = findViewById(R.id.tv_about_us_version)
        mTvServiceAgreement = findViewById(R.id.tv_about_us_service_agreement)
        mTvPrivacyProtocol = findViewById(R.id.tv_about_us_privacy_protocol)
        mBtnClose = findViewById(R.id.btn_close)
        mTvVersion?.text = String.format(baseContext.getString(R.string.wecast_version), getAppVersionName(baseContext))
        mTvServiceAgreement?.setOnClickListener(this)
        mTvPrivacyProtocol?.setOnClickListener(this)
        mBtnClose?.setOnClickListener(this)
    }

    private fun getAppVersionName(context: Context): String {
        return try {
            val pkg = context.packageManager
                    .getPackageInfo(context.applicationContext.packageName, 0)
            pkg.versionName
        } catch (e: Exception) {
            Logger.t(TAG).e("getAppVersionName e = $e")
            "0.0.0.0"
        }

    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.tv_about_us_service_agreement -> {
                val intent = Intent(this@CloudAboutUsActivity, CloudWebViewActivity::class.java)
                intent.putExtra(CloudWebViewActivity.TITLE, getString(R.string.wecast_service_agreement))
                intent.putExtra(CloudWebViewActivity.WEB_URL, SERVICE_AGREEMENT)
                startActivity(intent)
            }
            R.id.tv_about_us_privacy_protocol -> {
                val intent = Intent(this@CloudAboutUsActivity, CloudWebViewActivity::class.java)
                intent.putExtra(CloudWebViewActivity.TITLE, getString(R.string.wecast_privacy_protocol))
                intent.putExtra(CloudWebViewActivity.WEB_URL, PRIVACY_POLICY)
                startActivity(intent)
            }
            R.id.btn_close -> {
                onBackPressed()
            }
        }
    }

}