/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import android.util.DisplayMetrics;
import android.view.Choreographer;
import android.view.Display;
import android.view.WindowManager;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.SurfaceTextureHolder;
import java.nio.ByteBuffer;
import java.util.Locale;

@TargetApi(value=21)
public final class ScreenCapture
implements Choreographer.FrameCallback {
    protected static final String TAG = "ScreenCapture";
    private static final int MAX_IMAGES = 5;
    private static final int MSG_START_CAPTURE = 3;
    private static final int MSG_STOP_CAPTURE = 4;
    private static final int MSG_DETECT_ROTATE = 5;
    private static final int VIRTUAL_DISPLAY_CREATE_FAIL = -2;
    private MediaProjection mMediaProjection;
    private VirtualDisplay mVirtualDisplay;
    private int mDisplayIndex;
    private MediaProjectionManager mMediaProjectionManager;
    private Context mContext;
    private final Object mImageReaderLock = new Object();
    private final boolean mUseSurfaceTexture;
    private SurfaceTextureHolder mSurfaceTextureHolder = null;
    private boolean mTextureFrameAvailable = false;
    private ImageReader mImageReader = null;
    private Image mLastImage = null;
    private InternalImageReaderListener mReaderListener;
    private WindowManager mWindowMgr;
    private Point mScreenSize = new Point();
    private DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    private ConfigurationChangedReceiver mReceiver;
    private HandlerThread mImageHandlerThread;
    private Handler mImageHandler;
    private long mNativePtr;
    private int mCapWidth;
    private int mCapHeight;
    private int mCapFps = 15;
    private int mRotate;
    private final Object mRotateLock = new Object();
    private long mFpsFrameCount;
    private long mFpsLastFrameCount;
    private long mFpsLastFrameTimeNS;
    private long mFpsFirstFrameCost;
    private long mFpsTotalActualDelay;
    private long mFpsTotalFrameCount;
    private long mFpsMaxActualDelay;
    private long mFpsMinActualDelay = Integer.MAX_VALUE;
    private long mImageAvailableFrameCount;
    private long mImageAvailableFirstFrameCost;
    private long mDisplayCreateTime;
    private boolean mCaptureHasInit = false;
    private volatile boolean mCapturing = false;
    private int mPermissionRetCode;
    private Intent mPermissionRetData = null;
    private final Object mConfigureChangedLock = new Object();
    private Handler mMainLooper;
    private boolean mSupportConfigureChanged = false;
    private MediaProjection.Callback mMediaProjCallback = new MediaProjection.Callback(){

        @WorkerThread
        public void onStop() {
            Platform.logInfo("MediaProjection.onStop");
            ScreenCapture.this.onMediaProjectionStop();
        }
    };

    private boolean isAppForeground() {
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        if (activityManager == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : activityManager.getRunningAppProcesses()) {
            if (runningAppProcessInfo.importance != 100 || !runningAppProcessInfo.processName.equals(this.mContext.getApplicationInfo().processName)) continue;
            return true;
        }
        return false;
    }

    private void releaseVirtualDisplay(VirtualDisplay virtualDisplay) {
        try {
            virtualDisplay.setSurface(null);
        }
        catch (Exception exception) {
            Platform.log(3, exception.toString());
        }
        try {
            virtualDisplay.release();
        }
        catch (Exception exception) {
            Platform.log(3, exception.toString());
        }
    }

    private synchronized void onMediaProjectionStop() {
        VirtualDisplay virtualDisplay = this.mVirtualDisplay;
        if (virtualDisplay != null) {
            this.releaseVirtualDisplay(virtualDisplay);
            this.mVirtualDisplay = null;
            Platform.logInfo("virtual.display.stop");
        }
        if ((virtualDisplay = this.mMediaProjection) != null) {
            VirtualDisplay virtualDisplay2 = virtualDisplay;
            this.mMediaProjection = null;
            virtualDisplay2.unregisterCallback(this.mMediaProjCallback);
            virtualDisplay2.stop();
        }
    }

    @WorkerThread
    private ScreenCapture(Context context, long l2, boolean bl) {
        this.mContext = context;
        this.mNativePtr = l2;
        this.mUseSurfaceTexture = bl;
        this.mWindowMgr = (WindowManager)context.getSystemService("window");
        this.mMediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
        this.mReaderListener = new InternalImageReaderListener();
        this.mRotate = this.mWindowMgr.getDefaultDisplay().getRotation();
        this.mMainLooper = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    private void onConfigurationChanged() {
        ScreenCapture screenCapture = this;
        Object object = screenCapture.mRotateLock;
        synchronized (object) {
            int n2;
            int n3 = n2 = screenCapture.refreshScreenSizeAndRotate();
            Platform.logDebug(String.format(Locale.CHINA, "config.changed.%dx%d.screen.%dx%d.start", this.mCapWidth, this.mCapHeight, this.mScreenSize.x, this.mScreenSize.y));
            ScreenCapture.onCaptureRotateChanged(this.mNativePtr, this.mRotate, n2);
            screenCapture.mRotate = n3;
            if (screenCapture.mVirtualDisplay != null) {
                int n4;
                int n5;
                if (this.mScreenSize.x > this.mScreenSize.y && this.mCapWidth > this.mCapHeight || this.mScreenSize.x < this.mScreenSize.y && this.mCapWidth < this.mCapHeight) {
                    ScreenCapture screenCapture2 = this;
                    n5 = screenCapture2.mCapWidth;
                    n4 = screenCapture2.mCapHeight;
                } else {
                    ScreenCapture screenCapture3 = this;
                    n5 = screenCapture3.mCapHeight;
                    n4 = screenCapture3.mCapWidth;
                }
                if (this.config(n5, n4) == -2) {
                    Platform.log(3, "config.fail.while.screen.changed");
                }
            }
            Platform.logDebug(String.format(Locale.CHINA, "config.changed.%dx%d.screen.%dx%d.rotate.%d", this.mCapWidth, this.mCapHeight, this.mScreenSize.x, this.mScreenSize.y, n2));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void detectRotate() {
        ScreenCapture screenCapture = this;
        Object object = screenCapture.mRotateLock;
        synchronized (object) {
            if (screenCapture.mWindowMgr.getDefaultDisplay().getRotation() != this.mRotate) {
                Platform.logInfo("detect.rotate.changed");
                this.mMainLooper.post(new Runnable(){

                    @Override
                    public void run() {
                        ScreenCapture.this.onConfigurationChanged();
                    }
                });
            }
            return;
        }
    }

    private int refreshScreenSizeAndRotate() {
        Display display = this.mWindowMgr.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealSize(this.mScreenSize);
        } else {
            display.getSize(this.mScreenSize);
        }
        return display.getRotation();
    }

    private boolean createMediaProjection(int n2, Intent intent) {
        if (intent == null) {
            return false;
        }
        MediaProjection mediaProjection = this.mMediaProjection;
        if (mediaProjection != null) {
            mediaProjection.stop();
            this.mMediaProjection.unregisterCallback(this.mMediaProjCallback);
            this.mMediaProjection = null;
        }
        try {
            this.mMediaProjection = this.mMediaProjectionManager.getMediaProjection(n2, intent);
        }
        catch (Exception exception) {
            Platform.log(3, exception.toString());
        }
        if (this.mMediaProjection == null) {
            Platform.log(3, "get.media.projection.failed");
            return false;
        }
        return true;
    }

    private synchronized int setPermissionResult(int n2, Intent intent) {
        if (this.createMediaProjection(n2, intent)) {
            this.mPermissionRetCode = n2;
            this.mPermissionRetData = intent;
            return 0;
        }
        return -1;
    }

    /*
     * Exception decompiling
     */
    private int createVirtualDisplay() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [12 : 103->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @AnyThread
    private synchronized int config(int n2, int n3) {
        Object[] objectArray;
        int n4 = 0;
        if (n2 >= 1 && n3 >= 1) {
            if (n2 == objectArray.mCapWidth && n3 == objectArray.mCapHeight) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = n2;
                objectArray2[1] = n3;
                Platform.logInfo(String.format(Locale.CHINA, "size.%dx%d.not.changed", objectArray));
                return n4;
            }
            if (objectArray.mCaptureHasInit && objectArray.mMediaProjection != null) {
                Display display = objectArray.mWindowMgr.getDefaultDisplay();
                if (Build.VERSION.SDK_INT >= 17) {
                    display.getRealMetrics(objectArray.mDisplayMetrics);
                } else {
                    display.getMetrics(objectArray.mDisplayMetrics);
                }
                objectArray.mCapWidth = n2;
                objectArray.mCapHeight = n3;
                if (objectArray.mImageHandler != null) {
                    n4 = super.createVirtualDisplay();
                }
                Object[] objectArray3 = new Object[3];
                objectArray = objectArray3;
                objectArray[0] = n2;
                objectArray[1] = n3;
                objectArray3[2] = display.getRotation();
                Platform.logDebug(String.format(Locale.CHINA, "config.new.size.%dx%d.rotate.%d", objectArray));
                return n4;
            }
            Platform.logInfo("config.uninited.or.no.permission");
            return -1;
        }
        Object[] objectArray4 = new Object[2];
        objectArray = objectArray4;
        objectArray[0] = n2;
        objectArray4[1] = n3;
        Platform.logInfo(String.format(Locale.CHINA, "invalid.capture.size.%d.%d", objectArray));
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private void stopCapture() {
        Object object;
        block8: {
            ScreenCapture screenCapture = this;
            object = screenCapture.mImageReaderLock;
            synchronized (object) {
                this.mCapturing = false;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : object
                object = screenCapture.mImageHandler;
                if (object == null) break block8;
            }
            object.sendEmptyMessage(4);
        }
        if ((object = this.mVirtualDisplay) != null) {
            this.releaseVirtualDisplay((VirtualDisplay)object);
            this.mVirtualDisplay = null;
        }
        if ((object = this.mMediaProjection) != null) {
            Object object2 = object;
            this.mMediaProjection = null;
            object2.unregisterCallback(this.mMediaProjCallback);
            object2.stop();
        }
        if ((object = this.mImageHandlerThread) != null) {
            try {
                object.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            ScreenCapture screenCapture = this;
            screenCapture.mImageHandlerThread = null;
            screenCapture.mImageHandler = null;
        }
        ScreenCapture screenCapture = this;
        screenCapture.mCapHeight = 0;
        screenCapture.mCapWidth = 0;
        screenCapture.mImageAvailableFrameCount = 0L;
        screenCapture.mFpsTotalActualDelay = 0L;
        screenCapture.mFpsTotalFrameCount = 0L;
        screenCapture.mFpsMinActualDelay = Integer.MAX_VALUE;
        screenCapture.mFpsMaxActualDelay = 0L;
    }

    @WorkerThread
    private static native void onCaptureFramesAvailable(long var0, ByteBuffer var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private static native void onCaptureFrameSurface(long var0, SurfaceTextureHolder var2, int var3, int var4, int var5, int var6, int var7);

    private static native void onCaptureRotateChanged(long var0, int var2, int var3);

    static /* synthetic */ boolean access$102(ScreenCapture screenCapture, boolean bl) {
        screenCapture.mSupportConfigureChanged = bl;
        return bl;
    }

    static /* synthetic */ long access$502(ScreenCapture screenCapture, long l2) {
        screenCapture.mImageAvailableFirstFrameCost = l2;
        return l2;
    }

    static /* synthetic */ Image access$1102(ScreenCapture screenCapture, Image image) {
        screenCapture.mLastImage = image;
        return image;
    }

    static /* synthetic */ long access$708(ScreenCapture screenCapture) {
        long l2 = screenCapture.mImageAvailableFrameCount;
        screenCapture.mImageAvailableFrameCount = l2 + 1L;
        return l2;
    }

    static /* synthetic */ boolean access$1002(ScreenCapture screenCapture, boolean bl) {
        screenCapture.mCapturing = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1502(ScreenCapture screenCapture, boolean bl) {
        screenCapture.mTextureFrameAvailable = bl;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    public void doFrame(long var1_1) {
        v0 = this;
        var3_2 = v0.mImageReaderLock;
        synchronized (var3_2) {
            if (v0.mCapturing) ** GOTO lbl8
            return;
lbl8:
            // 1 sources

            v1 = this;
            v2 = v1;
            v3 = v1;
        }
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        var3_3 = System.nanoTime();
        var5_4 = v2.mCapFps;
        var5_4 = 1000000000L / var5_4;
        if (v3.mFpsLastFrameTimeNS + var5_4 > var3_3) {
            return;
        }
        v4 = this;
        v4.refreshScreenSizeAndRotate();
        var5_5 = v4.mImageReaderLock;
        synchronized (var5_5) {
            block35: {
                block37: {
                    block36: {
                        if (!v4.mUseSurfaceTexture) ** GOTO lbl48
                        if (this.mSurfaceTextureHolder == null) ** GOTO lbl48
                        if (this.mTextureFrameAvailable) ** GOTO lbl32
                        break block35;
lbl32:
                        // 1 sources

                        v6 = this;
                        v7 = v6;
                        v8 = v6;
                        v9 = v6;
                        v10 = v6.mNativePtr;
                        v11 = this.mSurfaceTextureHolder;
                        v12 = this.mCapWidth;
                        v13 = this.mCapHeight;
                        ScreenCapture.onCaptureFrameSurface(v10, v11, v12, v13, 0, this.mScreenSize.x, this.mScreenSize.y);
                        v14 = v7.mFpsFrameCount;
                        v8.mFpsFrameCount = v14 + 1L;
                        v9.mTextureFrameAvailable = false;
                        break block35;
lbl48:
                        // 2 sources

                        v15 = var6_7 /* !! */  = this.mLastImage;
                        this.mLastImage = null;
                        if (v15 != null) ** GOTO lbl54
                        break block35;
lbl54:
                        // 1 sources

                        var7_8 = var6_7 /* !! */ .getWidth();
                        if (var7_8 <= (var8_10 = var6_7 /* !! */ .getHeight())) break block36;
                        if (this.mScreenSize.x < this.mScreenSize.y) break block37;
                    }
                    if (var7_8 >= var8_10) ** GOTO lbl80
                    if (this.mScreenSize.x <= this.mScreenSize.y) ** GOTO lbl80
                }
                v16 = var5_5;
                var6_7 /* !! */ .close();
                v17 = Locale.CHINA;
                v18 = new Object[4];
                v18[0] = var7_8;
                v18[1] = var8_10;
                v18[2] = this.mScreenSize.x;
                v18[3] = this.mScreenSize.y;
                Platform.logDebug(String.format(v17, "image.size.%dx%d.mismatch.screen.%dx%d", v18));
                // ** MonitorExit[v16] (shouldn't be in output)
                break block35;
lbl80:
                // 2 sources

                if (this.mFpsFirstFrameCost != 0L) ** GOTO lbl92
                v19 = this;
                v20 = System.currentTimeMillis() - this.mDisplayCreateTime;
                v19.mFpsFirstFrameCost = v20;
                v21 = Locale.CHINA;
                v22 = new Object[1];
                v22[0] = this.mFpsFirstFrameCost;
                Platform.logInfo(String.format(v21, "first.frame.cost.%dms", v22));
lbl92:
                // 2 sources

                v23 = var6_7 /* !! */ ;
                v24 = this;
                v25 = v24;
                v26 = v24;
                v27 = v24;
                v28 = var6_7 /* !! */ .getPlanes();
                v29 = v28[0];
                var6_7 /* !! */  = v29.getBuffer();
                var9_11 = v29.getPixelStride();
                var10_14 = v29.getRowStride();
                v30 = v26.mNativePtr;
                ScreenCapture.onCaptureFramesAvailable(v30, (ByteBuffer)var6_7 /* !! */ , var7_8, var8_10, var9_11, var10_14, 0, this.mScreenSize.x, this.mScreenSize.y);
                v31 = v27.mFpsFrameCount;
                v25.mFpsFrameCount = v31 + 1L;
                v23.close();
            }
            var5_6 = 0L;
            var7_9 = System.nanoTime() - var3_3;
            var9_12 = this.mFpsLastFrameTimeNS;
            if (var9_12 > 0L) {
                var5_6 = (var3_3 - var9_12) / 1000000L;
                if (var5_6 > this.mFpsMaxActualDelay) {
                    this.mFpsMaxActualDelay = var5_6;
                }
                if (var5_6 < this.mFpsMinActualDelay) {
                    this.mFpsMinActualDelay = var5_6;
                }
                v32 = this;
                v32.mFpsTotalActualDelay += var5_6;
                ++v32.mFpsTotalFrameCount;
            }
            if (Platform.isDebugBuild && this.mFpsTotalFrameCount % 100L == 0L) {
                v33 = new Object[4];
                var9_13 = v33;
                var9_13[0] = var7_9 / 1000000L;
                var9_13[1] = var5_6;
                var9_13[2] = (var3_3 - var1_1) / 1000000L;
                v33[3] = this.mCapFps;
                Platform.logDebug(String.format(Locale.CHINA, "cost.%dms.actual_delay.%dms.vysnc_delay.%d.ms.fps.%d", var9_13));
            }
            this.mFpsLastFrameTimeNS = var1_1;
            return;
        }
        {
            catch (Throwable v34) {
                throw v34;
            }
        }
    }

    @WorkerThread
    public synchronized int init() {
        if (!this.mCaptureHasInit) {
            IntentFilter intentFilter;
            IntentFilter intentFilter2 = intentFilter;
            intentFilter = new IntentFilter("android.intent.action.CONFIGURATION_CHANGED");
            this.mReceiver = new ConfigurationChangedReceiver();
            this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, intentFilter2);
            this.mCaptureHasInit = true;
        }
        return 0;
    }

    public synchronized void setFps(int n2) {
        this.mCapFps = Math.max(n2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public synchronized void uninit() {
        ConfigurationChangedReceiver configurationChangedReceiver = this.mReceiver;
        if (configurationChangedReceiver != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)configurationChangedReceiver);
            this.mReceiver = null;
        }
        ScreenCapture screenCapture = this;
        screenCapture.stopCapture();
        Object object = screenCapture.mImageReaderLock;
        synchronized (object) {
            if (screenCapture.mSurfaceTextureHolder != null) {
                if (Platform.isDebugBuild) {
                    int n2 = this.mSurfaceTextureHolder.release();
                    Platform.logInfo(String.format(Locale.CHINA, "mSurfaceTextureHolder.release.count.%d", n2));
                } else {
                    this.mSurfaceTextureHolder.release();
                }
                this.mSurfaceTextureHolder = null;
            }
            this.mCapturing = false;
            if (this.mLastImage != null) {
                this.mLastImage.close();
                this.mLastImage = null;
            }
            if (this.mImageReader != null) {
                ScreenCapture screenCapture2 = this;
                screenCapture2.mImageReader.setOnImageAvailableListener(null, null);
                screenCapture2.mImageReader.close();
            }
            ScreenCapture screenCapture3 = this;
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl27 : MonitorExitStatement: MONITOREXIT : var1_2
            screenCapture3.mNativePtr = 0L;
            screenCapture3.mImageHandlerThread = null;
            screenCapture3.mImageHandler = null;
            screenCapture3.mCaptureHasInit = false;
            screenCapture3.mPermissionRetData = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public synchronized int start() {
        Intent intent = objectArray2.mPermissionRetData;
        if (intent == null) {
            return -1;
        }
        if (objectArray2.mMediaProjection == null && !objectArray2.createMediaProjection(objectArray2.mPermissionRetCode, intent)) {
            return -2;
        }
        objectArray2.mImageHandlerThread = new HandlerThread(ScreenCapture.class.getSimpleName(), 0);
        objectArray2.mImageHandlerThread.start();
        objectArray2.mImageHandler = (ScreenCapture)objectArray2.new ImageThreadHandler(objectArray2.mImageHandlerThread.getLooper());
        objectArray2.mMediaProjection.registerCallback(objectArray2.mMediaProjCallback, objectArray2.mImageHandler);
        int n2 = objectArray2.createVirtualDisplay();
        if (n2 != 0) {
            objectArray2.stopCapture();
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n2;
            Platform.logError(String.format(Locale.CHINA, "createVirtualDisplay.failed.%d", objectArray2));
            return n2;
        }
        Object[] objectArray = objectArray2.mConfigureChangedLock;
        synchronized (objectArray2.mConfigureChangedLock) {
            block6: {
                // ** MonitorExit[var1_3] (shouldn't be in output)
                if (objectArray2.mSupportConfigureChanged) break block6;
                objectArray2.mImageHandler.sendEmptyMessage(5);
            }
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = objectArray2.mCapWidth;
            objectArray3[1] = objectArray2.mCapWidth;
            Platform.logDebug(String.format(Locale.CHINA, "start.succ.%dx%d", objectArray));
            return 0;
        }
    }

    @WorkerThread
    public synchronized void stop() {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mFpsMinActualDelay;
        objectArray2[1] = this.mFpsTotalActualDelay / Math.max(this.mFpsTotalFrameCount, 1L);
        objectArray2[2] = this.mFpsFrameCount;
        objectArray[3] = this.mImageAvailableFrameCount;
        Platform.logInfo(String.format(Locale.CHINA, "stop.min.delay.%dms.avg.delay.%dms.frame.count.%d.frame.available.count.%d", objectArray2));
        this.stopCapture();
    }

    private class SurfaceTextureHandler
    implements SurfaceTextureHolder.EventCallback {
        private SurfaceTextureHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameAvailable(SurfaceTextureHolder object, SurfaceTexture surfaceTexture) {
            object = ScreenCapture.this.mImageReaderLock;
            SurfaceTextureHandler surfaceTextureHandler = this;
            synchronized (object) {
                ScreenCapture screenCapture = surfaceTextureHandler.ScreenCapture.this;
                ScreenCapture.access$1502(screenCapture, true);
                ScreenCapture.access$708(surfaceTextureHandler.ScreenCapture.this);
                return;
            }
        }

        @Override
        public void onRelease(SurfaceTextureHolder surfaceTextureHolder) {
        }
    }

    private class ImageThreadHandler
    extends Handler {
        ImageThreadHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @WorkerThread
        public void handleMessage(Message message) {
            int n2 = message.what;
            if (n2 == 3) {
                Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)ScreenCapture.this);
                return;
            }
            if (n2 != 4) {
                block9: {
                    ImageThreadHandler imageThreadHandler;
                    if (n2 != 5) {
                        return;
                    }
                    ImageThreadHandler imageThreadHandler2 = this;
                    Object object = imageThreadHandler2.ScreenCapture.this.mConfigureChangedLock;
                    synchronized (object) {
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 8] lbl12 : MonitorExitStatement: MONITOREXIT : object
                        if (imageThreadHandler2.ScreenCapture.this.mSupportConfigureChanged) break block9;
                        imageThreadHandler = this;
                    }
                    imageThreadHandler.ScreenCapture.this.detectRotate();
                    imageThreadHandler.sendEmptyMessageDelayed(5, 500L);
                    return;
                }
                Platform.logInfo("remove.rotate.detector");
                return;
            }
            ImageThreadHandler imageThreadHandler = this;
            Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)ScreenCapture.this);
            imageThreadHandler.removeMessages(5);
            imageThreadHandler.ScreenCapture.this.mImageHandlerThread.quitSafely();
            Object object = imageThreadHandler.ScreenCapture.this.mImageReaderLock;
            synchronized (object) {
                ScreenCapture.access$1002(ScreenCapture.this, false);
                return;
            }
        }
    }

    private class InternalImageReaderListener
    implements ImageReader.OnImageAvailableListener {
        private long mLastAvailableTime = 0L;

        private InternalImageReaderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @WorkerThread
        public void onImageAvailable(ImageReader imageReader) {
            Object[] objectArray;
            if (ScreenCapture.this.mImageAvailableFirstFrameCost == 0L) {
                ScreenCapture.access$502(ScreenCapture.this, System.currentTimeMillis() - ScreenCapture.this.mDisplayCreateTime);
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = ScreenCapture.this.mImageAvailableFirstFrameCost;
                Platform.logInfo(String.format(Locale.CHINA, "first.frame.cost.%dms", objectArray));
            }
            if (Platform.isDebugBuild && Platform.isLogLevel(5) && ScreenCapture.this.mImageAvailableFrameCount % 100L == 0L) {
                long l2 = System.currentTimeMillis();
                Object[] objectArray3 = new Object[1];
                Object[] objectArray4 = objectArray3;
                objectArray3[0] = l2 - this.mLastAvailableTime;
                Platform.logInfo(String.format(Locale.CHINA, "actual.delay.%dms", objectArray4));
                this.mLastAvailableTime = l2;
            }
            InternalImageReaderListener internalImageReaderListener = this;
            objectArray = internalImageReaderListener.ScreenCapture.this.mImageReaderLock;
            synchronized (objectArray) {
                if (internalImageReaderListener.ScreenCapture.this.mImageReader == imageReader && ScreenCapture.this.mCapturing) {
                    Image image;
                    if (ScreenCapture.this.mLastImage != null) {
                        ScreenCapture.this.mLastImage.close();
                    }
                    imageReader = null;
                    try {
                        image = ScreenCapture.this.mImageReader.acquireLatestImage();
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        image = imageReader;
                    }
                    ScreenCapture.access$1102(ScreenCapture.this, image);
                    if (image != null) {
                        ScreenCapture.access$708(ScreenCapture.this);
                    }
                    return;
                }
                return;
            }
        }
    }

    private static class InternalVirtualDisplayCallback
    extends VirtualDisplay.Callback {
        String mDisplayName;

        InternalVirtualDisplayCallback(String string2, ScreenCapture screenCapture) {
            this.mDisplayName = String.valueOf(string2);
        }

        public void onPaused() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mDisplayName;
            Platform.logInfo(String.format("virtual.display.%s.paused", objectArray2));
        }

        public void onResumed() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mDisplayName;
            Platform.logInfo(String.format("virtual.display.%s.resumed", objectArray2));
        }

        public void onStopped() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mDisplayName;
            Platform.logInfo(String.format("virtual.display.%s.stopped", objectArray2));
        }
    }

    private class ConfigurationChangedReceiver
    extends BroadcastReceiver {
        private ConfigurationChangedReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onReceive(Context object, Intent intent) {
            block6: {
                block7: {
                    if (!"android.intent.action.CONFIGURATION_CHANGED".equals(intent.getAction())) break block6;
                    if (ScreenCapture.this.mSupportConfigureChanged) break block7;
                    ConfigurationChangedReceiver configurationChangedReceiver = this;
                    object = configurationChangedReceiver.ScreenCapture.this.mConfigureChangedLock;
                    synchronized (object) {
                        if (configurationChangedReceiver.ScreenCapture.this.isAppForeground()) break block7;
                        Object[] objectArray = new Object[1];
                        objectArray[0] = ScreenCapture.this.mSupportConfigureChanged;
                        Platform.logInfo(String.format("SupportConfigureChanged.%b", objectArray));
                        ScreenCapture screenCapture = ScreenCapture.this;
                        ScreenCapture.access$102(screenCapture, true);
                    }
                }
                ScreenCapture.this.onConfigurationChanged();
            }
        }
    }
}

