package com.tencent.wecast.utils;

import android.content.Context;
import android.content.Intent;

import java.util.HashMap;
import java.util.Map;

/**
 * 发送广播的封装类
 */
public class SendBroadCastUtil {

    private static final String TAG = "SendBroadCastUtil";

    // Receiver的心跳广播
    private final static String ACTION_HEARTBEAT = ".ACTION_HEARTBEAT";
    private final static String RECEIVER_HEART_BEAT_KEY = "casting";
    private static long mSendHeartBeatCount = 0L;

    // 唤起会议的广播
    private final static String ACTION_AROUSE_WEMEET_BOX = "com.tencent.wecast.receiver.ACTION_AROUSE_WEMEET_BOX";

    // 关闭会议广播
    private final static String ACTION_CLOSE_WEMEET_BOX = "com.tencent.wecast.receiver.ACTION_CLOSE_WEMEET_BOX";


    public static void sendReceiverHeartBeatBroadCast(Context context, Boolean isCasting) {
        mSendHeartBeatCount++;
        if (mSendHeartBeatCount >= 50L) {
            Logger.t(TAG).d("sendReceiverHeartBeatBroadCast");
            mSendHeartBeatCount = 0L;
        }
        sendBroadcast(context,
                context.getPackageName() + ACTION_HEARTBEAT,
                RECEIVER_HEART_BEAT_KEY,
                isCasting);
    }

    public static void sendArouseWeMeetBoxBroadCast(Context context, String value) {
        Logger.kp().d("interactKP: sendArouseWeMeetBox broadCast data: " + value);
        sendBroadcast(context, ACTION_AROUSE_WEMEET_BOX, "data", value);
    }

    public static void sendCloseWeMeetBoxBroadCast(Context context) {
        Logger.kp().d("sendCloseWeMeetBox broadCast.");
        sendBroadcast(context, ACTION_CLOSE_WEMEET_BOX, null, null);
    }

    private static void sendBroadcast(Context context, String action, String key, Object value) {
        try {
            Intent intent = new Intent(action);
            if (value != null) {
                if (value instanceof String) {
                    intent.putExtra(key, (String) value);
                } else if (value instanceof Boolean) {
                    intent.putExtra(key, (Boolean) value);
                } else if (value instanceof Integer) {
                    intent.putExtra(key, (Integer) value);
                }
            }
            context.sendBroadcast(intent);
        } catch (Exception e) {
            Logger.t(TAG).e("sendBroadcast Exception:" + e.toString());
        }
    }
}