package com.tencent.wecast.sender.cloud.utils

import android.app.DownloadManager
import android.content.Context
import android.net.Uri
import android.os.Environment
import android.text.TextUtils
import android.util.Log
import com.tencent.wecast.utils.Logger
import java.io.File
import java.io.FileInputStream
import java.io.IOException
import java.io.InputStream

object DownloadApkUtils {
    private const val TAG = "DownloadAppUtils"
    var downloadUpdateApkId: Long = -1//下载更新Apk 下载任务对应的Id
    var downloadUpdateApkFilePath: String? = null//下载更新Apk 文件路径
    var downloadManager: DownloadManager? = null
    private const val DOWNLOAD_PATH = "/apk/"
    var fileMd5 = ""
    var mCancel = false

    interface WeCastDownloadApkListener {
        fun onDownloadFailed()
    }

    interface WeCastDownloadApkProgressListener {
        fun onProgressChange(progress: Int)
    }

    /**
     * 下载更新apk包
     * @param context
     * @param url
     */
    fun downloadForAutoInstall(context: Context, url: String, fileName: String, title: String
                               , weCastDownloadListener: WeCastDownloadApkListener) {
        if (TextUtils.isEmpty(url)) {
            return
        }

        val uri = Uri.parse(url)
        downloadManager = context
                .getSystemService(Context.DOWNLOAD_SERVICE) as DownloadManager
        val request = DownloadManager.Request(uri)
        //在通知栏中显示
        request.setVisibleInDownloadsUi(true)
        request.setTitle(title)
        var filePath: String? = null
        if (Environment.getExternalStorageState() == Environment.MEDIA_MOUNTED) {//外部存储卡
            filePath = Environment.getExternalStorageDirectory().absolutePath + DOWNLOAD_PATH
        } else {
            Logger.t(TAG).d("Download Fail:SD Card is not exists")
            weCastDownloadListener.onDownloadFailed()
            return
        }
        downloadUpdateApkFilePath = if (fileName.endsWith(".apk")) {
            filePath + File.separator + fileName
        } else {
            filePath + File.separator + fileName + ".apk"
        }
        if (downloadUpdateApkFilePath != null) {
            val path = downloadUpdateApkFilePath!!
            val file = File(path)
            // 若存在，则删除
            if (file.exists()) {
                file.delete()
            }
        }
        val fileUri = Uri.parse("file://$downloadUpdateApkFilePath")
        request.setDestinationUri(fileUri)
        if (downloadManager != null) {
            downloadUpdateApkId = downloadManager!!.enqueue(request)
        }
    }

    fun setDownloadProgressListener(context: Context, progressListener: WeCastDownloadApkProgressListener) {
        if (downloadUpdateApkId != -1L) {
            val downloadManager = context
                    .getSystemService(Context.DOWNLOAD_SERVICE) as DownloadManager
            val query = DownloadManager.Query().setFilterById(downloadUpdateApkId)
            Thread {
                var progress = 0
                while (progress < 100 && !mCancel) {
                    val c = downloadManager.query(query)
                    if (c != null && c.moveToFirst()) {
                        val downloadBytesIdx = c.getColumnIndexOrThrow(
                                DownloadManager.COLUMN_BYTES_DOWNLOADED_SO_FAR)
                        val totalBytesIdx = c.getColumnIndexOrThrow(
                                DownloadManager.COLUMN_TOTAL_SIZE_BYTES)
                        val totalBytes = c.getLong(totalBytesIdx)
                        val downloadBytes = c.getLong(downloadBytesIdx)
                        progress = (downloadBytes * 100 / totalBytes).toInt()
                        progressListener.onProgressChange(progress)
                        Thread.sleep(1000)
                    }
                }
            }.start()
        }
    }

    fun cancelDownload() {
        if (downloadUpdateApkId != -1L) {
            downloadManager?.remove(downloadUpdateApkId)
            downloadUpdateApkId = -1L
            mCancel = true
        }
    }

}