package com.tencent.wecast.sender.cloud.receiver

import android.app.DownloadManager
import android.app.DownloadManager.STATUS_SUCCESSFUL
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Build
import android.support.v4.content.FileProvider
import com.tencent.wecast.sender.cloud.utils.DownloadApkUtils
import com.tencent.wecast.sender.cloud.utils.DownloadApkUtils.downloadManager
import com.tencent.wecast.sender.cloud.utils.FileMd5Util
import com.tencent.wecast.sender.eb.SenderEvents
import com.tencent.wecast.utils.Logger
import org.greenrobot.eventbus.EventBus
import java.io.File


/**
 * 用于Apk下载完成后跳转安装界面
 */
class UpdateAppReceiver : BroadcastReceiver() {

    companion object {
        private const val TAG = "UpdateAppReceiver"
    }

    override fun onReceive(context: Context, intent: Intent?) {
        if (intent?.action.equals(DownloadManager.ACTION_DOWNLOAD_COMPLETE)) {
            if (!DownloadApkUtils.mCancel && DownloadApkUtils.downloadUpdateApkId != -1L) {
                installApk(context)
            }
            DownloadApkUtils.mCancel = false
        }
    }

    // 安装Apk
    private fun installApk(context: Context) {
        try {
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.N) {
                val i = Intent(Intent.ACTION_VIEW)
                i.flags = Intent.FLAG_ACTIVITY_NEW_TASK
                i.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)
                val apkFile = queryDownloadedApk()
                if (DownloadApkUtils.fileMd5.isNotEmpty()
                        && DownloadApkUtils.fileMd5.toUpperCase() != FileMd5Util.getFileMD5(apkFile).toUpperCase()) {
                    Logger.t(TAG).d("File MD5 ERROR...  MD5:${FileMd5Util.getFileMD5(apkFile)}")
                    val event = SenderEvents.EStopSplashEvent()
                    event.eventCode = event.ERROR
                    EventBus.getDefault().post(event)
                    return
                }
                if (apkFile != null && apkFile.exists()) {
                    i.setDataAndType(Uri.fromFile(apkFile), "application/vnd.android.package-archive")
                    i.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                    context.startActivity(i)
                } else {
                    Logger.t(TAG).d("Install Fail Apk Not Found")
                    val event = SenderEvents.EStopSplashEvent()
                    event.eventCode = event.ERROR
                    EventBus.getDefault().post(event)
                }
            } else {
                if (DownloadApkUtils.downloadUpdateApkId != -1L) {
                    val query = DownloadManager.Query()
                    query.setFilterById(DownloadApkUtils.downloadUpdateApkId)
                    query.setFilterByStatus(STATUS_SUCCESSFUL)
                    val cur = downloadManager?.query(query)
                    if (cur != null) {
                        if (cur.moveToFirst()) {
                            val i = Intent(Intent.ACTION_VIEW)
                            val file = File(DownloadApkUtils.downloadUpdateApkFilePath)
                            if (DownloadApkUtils.fileMd5.isNotEmpty()
                                    && DownloadApkUtils.fileMd5.toUpperCase() != FileMd5Util.getFileMD5(file).toUpperCase()) {
                                Logger.t(TAG).d("File MD5 ERROR...  MD5:${FileMd5Util.getFileMD5(file)}")
                                val event = SenderEvents.EStopSplashEvent()
                                event.eventCode = event.ERROR
                                EventBus.getDefault().post(event)
                                return
                            }
                            i.flags = Intent.FLAG_ACTIVITY_NEW_TASK
                            i.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)

                            val providerName = "${context.applicationContext.packageName}.provider"
                            i.setDataAndType(FileProvider.getUriForFile(context,
                                    providerName, file),
                                    "application/vnd.android.package-archive")
                            context.startActivity(i)
                        }
                        cur.close()
                    }
                }
            }
            val event = SenderEvents.EStopSplashEvent()
            event.eventCode = event.SUCCESS
            EventBus.getDefault().post(event)
        } catch (e: Exception) {
            Logger.t(TAG).d("Install Fail:" + e.message)
            val event = SenderEvents.EStopSplashEvent()
            event.eventCode = event.ERROR
            EventBus.getDefault().post(event)
            e.printStackTrace()
        }
    }


    private fun queryDownloadedApk(): File? {
        var targetApkFile: File? = null
        if (DownloadApkUtils.downloadUpdateApkId != -1L) {
            val query = DownloadManager.Query()
            query.setFilterById(DownloadApkUtils.downloadUpdateApkId)
            query.setFilterByStatus(STATUS_SUCCESSFUL)
            val cur = downloadManager?.query(query)
            if (cur != null) {
                if (cur.moveToFirst()) {
                    val uriString = cur.getString(cur.getColumnIndex(DownloadManager.COLUMN_LOCAL_URI))
                    targetApkFile = File(Uri.parse(uriString).path)
                }
                cur.close()
            }
        }
        return targetApkFile
    }
}