package com.tencent.wecast.sender.cloud.activity

import android.annotation.SuppressLint
import android.os.Bundle
import android.webkit.WebSettings
import android.webkit.WebView
import android.webkit.WebViewClient
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import com.tencent.wecast.sender.cloud.R


class CloudWebViewActivity : BaseActivity() {

    companion object {
        const val TITLE = "title"
        const val WEB_URL = "webUrl"
        const val PRIVACY_POLICY = "https://tcd.tencent.com/privacypolicy.html"
        const val SERVICE_AGREEMENT = "https://tcd.tencent.com/eula.html"
        const val FEEDBACK = "https://support.qq.com/products/41782"
    }

    private var mBtnClose: ImageView? = null
    private var mTvTitle: TextView? = null
    private var mWebView: WebView? = null
    private var mUrl: String? = null

    private var mPageFinish = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.wecast_activity_webview)
        initView()
    }

    @SuppressLint("SetJavaScriptEnabled")
    private fun initView() {
        mBtnClose = findViewById(R.id.btn_wv_close)
        mTvTitle = findViewById(R.id.tv_webview_title)
        mWebView = findViewById(R.id.wv_wecast)
        mUrl = intent.getStringExtra(WEB_URL)
        mTvTitle?.text = intent.getStringExtra(TITLE)
        mBtnClose?.setOnClickListener {
            this.onBackPressed()
        }
        // 设置可以支持缩放
        mWebView?.settings?.setSupportZoom(true)
        // 设置出现缩放工具
        mWebView?.settings?.builtInZoomControls = false
        //扩大比例的缩放
        mWebView?.settings?.useWideViewPort = true
        //自适应屏幕
        mWebView?.settings?.layoutAlgorithm = WebSettings.LayoutAlgorithm.SINGLE_COLUMN
        mWebView?.settings?.loadWithOverviewMode = true
        //支持js
        mWebView?.settings?.javaScriptEnabled = true
        mWebView?.settings?.domStorageEnabled = true
        val appCachePath = applicationContext.cacheDir.absolutePath
        mWebView?.settings?.setAppCachePath(appCachePath)
        mWebView?.settings?.setAppCacheEnabled(true)
        mWebView?.webViewClient = object : WebViewClient() {
            @Override
            override fun shouldOverrideUrlLoading(view: WebView?, url: String?): Boolean {
                return false
            }

            override fun onPageFinished(view: WebView?, url: String?) {
                super.onPageFinished(view, url)
                mPageFinish = true
            }
        }
        mWebView?.loadUrl(mUrl)
    }

    override fun onBackPressed() {
        val originalUrl = mWebView?.copyBackForwardList()?.currentItem?.originalUrl
        if (mWebView != null && mWebView!!.canGoBack() && mPageFinish
                && !originalUrl.equals(mUrl)) {
            mWebView?.goBack()
        } else {
            super.onBackPressed()
        }
    }
}