package com.tencent.wecast.sender.cloud.activity

import android.app.Activity
import android.app.Dialog
import android.content.*
import android.media.projection.MediaProjectionManager
import android.os.Build
import android.os.Bundle
import android.support.v4.content.ContextCompat
import android.support.v7.app.AlertDialog
import android.text.Html
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.view.inputmethod.InputMethodManager
import android.widget.*
import com.google.gson.JsonArray
import com.tencent.wecast.WeCastConstant
import com.tencent.wecast.WeCastEnv
import com.tencent.wecast.WeCastUIConfigManager
import com.tencent.wecast.c2c.C2CPauseXCastMsg
import com.tencent.wecast.c2c.WeCastC2CUtil
import com.tencent.wecast.jni.JniHelper
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.sender.cloud.WeCast
import com.tencent.wecast.sender.cloud.adapter.UserListAdapter
import com.tencent.wecast.sender.cloud.bean.FunctionItemInfo
import com.tencent.wecast.sender.cloud.bean.MemberInfo
import com.tencent.wecast.sender.cloud.bean.WeCastInfo
import com.tencent.wecast.sender.cloud.service.NotificationService
import com.tencent.wecast.sender.cloud.utils.*
import com.tencent.wecast.sender.cloud.widget.FunctionDialog
import com.tencent.wecast.sender.cloud.widget.PinCodeEditText
import com.tencent.wecast.sender.cloud.widget.WeCastAlert
import com.tencent.wecast.sender.eb.SenderEvents
import com.tencent.wecast.utils.*
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode

/**
 * 公网MainActivity
 */
class CloudMainActivity2 : BaseActivity(), View.OnClickListener {

    companion object {

        private const val TAG = "CloudMainActivity2"

        /**
         * 等待
         */
        private const val UI_STATE_WAITING = 0

        /**
         * 进房中
         */
        private const val UI_STATE_ENTERING = 1

        /**
         * 投屏中
         */
        private const val UI_STATE_IN_ROOM = 2

        /**
         * 退房中
         */
        private const val UI_STATE_EXITING = 3

        /**
         * 添加投屏中
         */
        private const val UI_STATE_ADDING = 4

        /**
         * 申请投屏权限
         */
        private const val REQUEST_MEDIA_PROJECTION = 10001

        // 30分钟自动关闭重连对话框
        private const val AUTO_CLOSE_RECOVERY_DLG_TIME = 30 * 60 * 1000L


        /** 键盘最低高度 **/
        private const val KEYBOARD_MIN_HEIGHT = 200

        /** 键盘相关操作延迟毫秒数 **/
        private const val KEYBOARD_ACTION_DELAYED = 200L

        private const val ALERT_TYPE_NORMAL = 0
        private const val ALERT_TYPE_NET_BAD = 10
        private const val ALERT_TYPE_NET_DISCONNECTED = 20

        /** 息屏提示相关 **/
        private const val SENDER_MAIN_SP = "sender_main_sp"
        private const val KEY_SCREEN_OUT_ALERT_FIRST_SHOW = "key_screen_out_alert_first_show"

        /**
         * 房间成员信息
         */
        private var userInfoList: MutableList<MemberInfo> = arrayListOf()

        private const val CORP_ID = "CorpId"

        const val SHOW_BIND_CORP_SUCCESS = "showBindCorpSuccess"
    }

    private var mCurrentUIState = UI_STATE_WAITING


    private var mSuccessDialog: Dialog? = null

    /**
     * 输入页面
     */
    private var mLayoutInputPin: ViewGroup? = null

    /**
     * 投屏页面
     */
    private var mLayoutInRoom: ViewGroup? = null

    private var mTvWelcome: View? = null

    private var mBtnClose: ImageView? = null
    private var mEtPinCode: PinCodeEditText? = null
    private var mBtnConfirm: Button? = null
    private var mBtnConfirmTxt: String? = null

    private var mLayoutFooter: ViewGroup? = null

    private var mWcaAlert: WeCastAlert? = null
    private var mWcaAlertInRoom: WeCastAlert? = null

    private var mTvCasting: View? = null
    private var mTvNotice: TextView? = null

    private var mBtnExit: Button? = null
    private var mLayoutAdd: View? = null

    private var mLvUserList: ListView? = null
    private var mImgBtnInRoomBack: ImageButton? = null
    private var mBtnFunction: ImageView? = null

    /**
     * tips相关
     */
    private var mSvTips: ScrollView? = null
    private var mTvQualityTips: TextView? = null
    private var mNativeTips = ""

    private var mFatalDialog: AlertDialog? = null

    /**
     * tips显示标志
     */
    private var mShowTipsFlag: Boolean = false
    private var mLastTapTimeMs: Long = 0
    private var mTapTimes: Int = 0

    /**
     * 环境切换标志
     */
    private var mLastChangeEnvTapTimeMs: Long = 0
    private var mChangeEnvTapTimes: Int = 0


    private var mUserListAdapter: UserListAdapter? = null

    /**
     * PIN 码输入完成标志
     */
    private var mInputCompleteFlag: Boolean = false

    private lateinit var mScreenOutSettingInfo: SettingUtils.ScreenOutSettingInfo

    private var mMainSP: SharedPreferences? = null

    private var mSoftInputHeight: Int = 0

    // 发送端恢复进房（进程被杀等造成接收端还在房间，发送端再次进入时仍然会加到原房间）
    private var mIsRecover = false
    private var mScreenOffReceiver: BroadcastReceiver? = null
    private var disconnectDialog: AlertDialog? = null
    private var mFunctionDialog: FunctionDialog? = null
    private var mAddCastErrorRunnable = Runnable { hideAlert(ALERT_TYPE_NORMAL) }

    private var mRecoveryDialog: AlertDialog? = null
    private var mScreenOutDialog: AlertDialog? = null

    private var mNotificationServerIntent: Intent? = null

    private var mBindCorpDialog: Dialog? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        applicationContext.setTheme(R.style.WeCastAppThemeBlue)
        super.onCreate(savedInstanceState)
        val rootView = WeCastUIConfigManager.getInstance().getLayoutRootView(
                WeCastUIConfigManager.ActivityLabel.SENDER_MAIN_2, applicationContext)
        if (null == rootView) {
            Logger.t(TAG).e("rootView is null.")
            finish()
            return
        }
        WeCastUIConfigManager.getInstance().applyUIConfig(WeCastUIConfigManager.ActivityLabel.SENDER_MAIN_2, rootView)
        StatusBarUtils.setWindowStatusBarColor(this@CloudMainActivity2,
                WeCastUIConfigManager.getInstance().getStatusBarColor(ContextCompat.getColor(applicationContext, R.color.wecast_colorPrimary2)))
        StatusBarUtils.setStatusBarLightMode(this@CloudMainActivity2, false)
        window.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON)
        setContentView(rootView)

        if (intent.getBooleanExtra(SHOW_BIND_CORP_SUCCESS, false)) {
            mBindCorpDialog = Dialog(this@CloudMainActivity2, R.style.WeCastLoadingDialog)
            mBindCorpDialog?.setContentView(R.layout.wecast_dialog_bind_corp_success)
            mBindCorpDialog?.setCancelable(false)
            mBindCorpDialog?.show()
            mBaseHandler?.postDelayed({
                mBindCorpDialog?.dismiss()
            }, 2000)
        }

        mLayoutInputPin = findViewById(R.id.layout_input_pin)
        mLayoutInRoom = findViewById(R.id.layout_in_room)

        /**
         * 关闭按钮
         */
        mBtnClose = findViewById(R.id.btn_close)
        mBtnClose?.setOnClickListener(this)
        if (WeCastInfo.instance.isWeCastApp) {
            mBtnClose?.visibility = View.GONE
        }

        mTvWelcome = findViewById(R.id.tv_welcome)
        mTvWelcome?.setOnClickListener(this)

        mImgBtnInRoomBack = findViewById(R.id.btn_in_room_close)
        mImgBtnInRoomBack?.setOnClickListener(this)

        /**
         * 功能按钮
         */
        mBtnFunction = findViewById(R.id.btn_function)
        mBtnFunction?.setOnClickListener(this)
        setFunctionBtnVisibility(true)

        /**
         * PIN 码输入框
         */
        mEtPinCode = findViewById(R.id.et_pin_code)
        mEtPinCode?.setInputListener(object : PinCodeEditText.InputListener {
            override fun inputComplete(completeFlag: Boolean) {
                mInputCompleteFlag = completeFlag
                mBaseHandler?.post {
                    setBtnConfirmEnable(NetworkUtil.isNetworkConnected(applicationContext))
                }
            }
        })
        mEtPinCode?.textAlignment = View.TEXT_ALIGNMENT_CENTER
        mEtPinCode?.requestFocus()

        /**
         * 错误提示
         */
        mWcaAlert = findViewById(R.id.wca_alert)

        mTvCasting = findViewById(R.id.tv_casting)
        mTvNotice = findViewById(R.id.tv_notice)
        mWcaAlertInRoom = findViewById(R.id.wca_alert_in_room)

        /**
         * 确认按钮
         */
        mBtnConfirm = findViewById(R.id.btn_confirm)
        mBtnConfirm?.setOnClickListener(this)
        mBtnConfirm?.isEnabled = false
        mBtnConfirmTxt = mBtnConfirm?.text.toString()

        /**
         * 底部footer
         */
        mLayoutFooter = findViewById(R.id.layout_footer)

        /**
         * 退出投屏按钮
         */
        mBtnExit = findViewById(R.id.btn_exit)
        mBtnExit?.setOnClickListener(this)

        /**
         * tips 显示
         */
        mSvTips = findViewById(R.id.sv_tips)
        mTvQualityTips = findViewById(R.id.tv_quality_tips)
        mTvQualityTips?.setOnClickListener(this)

        /**
         * 投屏接收方列表
         */
        mLvUserList = findViewById(R.id.lv_user_list)

        /**
         * 列表的添加投屏
         */
        val addView = WeCastUIConfigManager.getInstance().getLayoutRootView(
                WeCastUIConfigManager.ActivityLabel.SENDER_USER_ADD, applicationContext)
        WeCastUIConfigManager.getInstance().applyUIConfig(WeCastUIConfigManager.ActivityLabel.SENDER_USER_ADD, addView)
        mLayoutAdd = addView.findViewById(R.id.layout_add_cast)
        mLayoutAdd?.setOnClickListener(this)

        mLvUserList?.addFooterView(addView)

        /**
         * 为了显示上下分割线，再增加一个顶部View
         */
        mLvUserList?.addHeaderView(View(this))

        mUserListAdapter = UserListAdapter(this, userInfoList)
        mLvUserList?.adapter = mUserListAdapter

        /**
         * 进房时上方的logo
         */
        val inRoomLogo = findViewById<View>(R.id.iv_in_room_logo)
        inRoomLogo?.setOnClickListener(this)

        /**
         * 防息屏提示
         */
        val layoutSetting = findViewById<View>(R.id.layout_setting)
        layoutSetting?.setOnClickListener(this)

        registerScreenOffBroadCast()

        setBtnConfirmEnable(NetworkUtil.isNetworkConnected(this))
        setVersionAndEnv()

        /** 处理键盘拉起事件 **/
        KeyboardUtils.registerSoftInputChangedListener(this, object : KeyboardUtils.OnSoftInputChangedListener {
            override fun onSoftInputChanged(height: Int) {
                try {
                    Logger.t(TAG).d("onSoftInputChanged height = $height")
                    mSoftInputHeight = height
                    refreshUI()
                } catch (e: Exception) {
                }
            }
        })

        /**
         * 息屏提示相关
         */
        mScreenOutSettingInfo = SettingUtils.getScreenOutSettingInfo(this)

        mMainSP = getSharedPreferences(SENDER_MAIN_SP, Context.MODE_PRIVATE)

        if (WeCastInfo.instance.isCasting) {
            setUIState(UI_STATE_IN_ROOM)
            if (NetworkUtil.getNetType(baseContext) == "unknown") {
                val netTips = getString(R.string.wecast_alert_abnormal_net_text)
                showAlertInRoom(WeCastAlert.WeCastAlertInfo(ALERT_TYPE_NET_DISCONNECTED,
                        netTips))
            }
        }

        EventBusUtil.register(this)
    }

    public override fun onResume() {
        if (!WeCastInfo.instance.isRunning) {
            WeCastInfo.instance.mStateChangeListener?.onChanged(WeCast.CAST_STATE_READY)
        }
        WeCastInfo.instance.isRunning = true
        super.onResume()
    }

    override fun finish() {
        super.finish()
        if (mCurrentUIState == UI_STATE_IN_ROOM) {
            overridePendingTransition(0, WeCastInfo.instance.castingBackAnim)
        } else {
            overridePendingTransition(0, 0)
        }
    }

    override fun onDestroy() {
        super.onDestroy()

        EventBusUtil.unregister(this)

        mSoftInputHeight = 0
        KeyboardUtils.hideSoftInput(this)
        KeyboardUtils.registerSoftInputChangedListener(this, null)

        mFatalDialog?.dismiss()
        mFatalDialog = null

        mSuccessDialog?.dismiss()
        mSuccessDialog = null

        WeCastInfo.instance.isRunning = WeCastInfo.instance.isCasting
        if (mCurrentUIState == UI_STATE_WAITING) {
            WeCastInfo.instance.mStateChangeListener?.onChanged(WeCast.CAST_STATE_CLOSED)
        }
        try {
            unregisterReceiver(mScreenOffReceiver)
        } catch (ignore: Exception) {
        }
    }

    override fun onBackPressed() {
        Logger.kp().d("Click back button, currentUIState = %d", mCurrentUIState)
        when (mCurrentUIState) {
            UI_STATE_WAITING -> {
                /** 等待状态，退出应用  */
                CloudUtil.JniMethod.unInitSender()
                finish()
            }
            UI_STATE_ADDING -> {
                mEtPinCode?.setText("")
                /** 添加投屏状态  */
                setUIState(UI_STATE_IN_ROOM)
            }
            UI_STATE_IN_ROOM -> {
                if (ActivityTaskUtil.isBottomActivity(this@CloudMainActivity2)) {
                    val intent = Intent(Intent.ACTION_MAIN)
                    intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK
                    intent.addCategory(Intent.CATEGORY_HOME)
                    startActivity(intent)
                } else {
                    finish()
                }
            }
            else -> {
                /** 其他状态，暂不处理  */
                return
            }
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        if (requestCode == REQUEST_MEDIA_PROJECTION) {
            Logger.kp().i("Request screen capture permission: $resultCode")
            if (resultCode != Activity.RESULT_OK) {
                Toast.makeText(this, getString(R.string.wecast_screen_permission_failed), Toast.LENGTH_LONG).show()
                if (mIsRecover) {
                    CloudUtil.JniMethod.recoverCast(true)
                }
            } else {
                WeCastUtil.setCapturePermission(resultCode, data)
                if (!mIsRecover) {
                    enterCast()
                } else {
                    CloudUtil.JniMethod.recoverCast(false)
                }
            }
            mIsRecover = false
            mBaseHandler?.post {
                setBtnConfirmEnable(true)
            }
        }
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.btn_confirm -> {
                mBtnConfirm?.isEnabled = false
                if (mCurrentUIState == UI_STATE_WAITING) {
                    tryEnterCast()
                } else {
                    addCast()
                }
            }
            R.id.btn_exit -> {
                exitCast()
                setUIState(UI_STATE_WAITING)
                WeCastInfo.instance.mStateChangeListener?.onChanged(WeCast.CAST_STATE_READY)
            }
            R.id.layout_add_cast -> {
                mEtPinCode?.setText("")
                setUIState(UI_STATE_ADDING)
            }
            R.id.btn_close -> {
                if (mCurrentUIState == UI_STATE_WAITING) {
                    CloudUtil.JniMethod.unInitSender()
                    finish()
                } else {
                    mEtPinCode?.setText("")
                    setUIState(UI_STATE_IN_ROOM)
                }
            }
            R.id.iv_in_room_logo -> {
                tryShowTips()
            }
            R.id.tv_quality_tips -> {
                mSvTips?.visibility = View.GONE
                mShowTipsFlag = false
            }
            R.id.tv_welcome -> {
                /**
                 * 5秒10下切换环境
                 */
                val currentTimeMs = System.currentTimeMillis()
                if (currentTimeMs - mLastChangeEnvTapTimeMs > 5 * 1000) {
                    mLastChangeEnvTapTimeMs = currentTimeMs
                    mChangeEnvTapTimes = 0
                } else {
                    mChangeEnvTapTimes++
                }

                if (mChangeEnvTapTimes >= 9) {
                    mLastChangeEnvTapTimeMs = 0
                    mChangeEnvTapTimes = 0

                    Thread(Runnable {
                        WeCastEnv.changeNextEnv()
                        val resultStr = WeCastEnv.getCurrentEnvDesc()
                        mBaseHandler?.post {
                            Toast.makeText(this, resultStr, Toast.LENGTH_LONG).show()
                        }
                    }).start()
                }
            }
            R.id.layout_setting -> {
                ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_SCREEN_OUT_CLICK_BAR, 0, "")
                showScreenOutSettingDialog()
            }
            R.id.btn_in_room_close -> {
                onBackPressed()
            }
            R.id.btn_function -> {
                showOrHideFunctionDialog()
            }
            else -> {
            }
        }
    }

    /**
     * 添加投屏
     */
    private fun addCast() {
        showEnteringTips(false)
        CloudUtil.JniMethod.addCast(mEtPinCode?.getPinCode().toString())
        Logger.kp().d("Add another cast: ${mEtPinCode?.getPinCode()}")
    }

    /**
     * 设置确认按钮的可点击状态
     */
    private fun setBtnConfirmEnable(isConnected: Boolean) {
        mBtnConfirm?.isEnabled = (mInputCompleteFlag && isConnected)
    }

    private fun setVersionAndEnv() = try {
        val tvVersionAndEnv = findViewById<TextView>(R.id.tv_version_and_env)
        tvVersionAndEnv?.text = WeCastUtil.getVersionAndEnv()
    } catch (e: Exception) {
    }

    private fun tryEnterCast() {
        if (!NetworkUtil.isUsingWifi(applicationContext)) {
            showNotUsingWiFiDialog()
            return
        }
        setCapturePermission()
    }


    private fun enterCast() {
        userInfoList.clear()
        CloudUtil.JniMethod.enterCast(mEtPinCode?.getPinCode().toString())
        Logger.kp().d("Enter cast: ${mEtPinCode?.getPinCode()}")
    }

    private fun exitCast() {
        userInfoList.clear()
        CloudUtil.JniMethod.exitCast(0)
        mIsXCastPause = false
        mIsRecover = false
        WeCastInfo.instance.isCasting = false
    }

    private fun recoveryCast(isCancel: Boolean) {
        if (!isCancel && !WeCastUtil.hasCapturePermission()) {
            setCapturePermission()
        } else {
            CloudUtil.JniMethod.recoverCast(isCancel)
            mIsRecover = false
        }
    }

    private fun setUIState(uiState: Int) {
        mCurrentUIState = uiState

        notifyUserChange()
        if (mCurrentUIState == UI_STATE_WAITING) {
            setFunctionBtnVisibility(true)
            showDisconnectDialog(false)
        }

        if (mCurrentUIState == UI_STATE_IN_ROOM) {
            hideAlert(ALERT_TYPE_NORMAL)
            if (KeyboardUtils.isSoftInputVisible(this)) {
                KeyboardUtils.hideSoftInput(this)
            }
            mBaseHandler?.removeCallbacks(mAutoCloseRecoveryRunnable)
        }

        if (mCurrentUIState == UI_STATE_ADDING) {
            setFunctionBtnVisibility(false)
            mBaseHandler?.postDelayed({
                mEtPinCode?.requestFocus()
                if (mEtPinCode != null) {
                    val imm = getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
                    imm.showSoftInput(mEtPinCode, InputMethodManager.SHOW_IMPLICIT)
                }
            }, KEYBOARD_ACTION_DELAYED)
        }

        refreshUI()
    }


    private fun refreshUI() {
        if (mCurrentUIState == UI_STATE_WAITING || mCurrentUIState == UI_STATE_ENTERING
                || mCurrentUIState == UI_STATE_EXITING || mCurrentUIState == UI_STATE_ADDING) {
            /**
             * 显示 PIN 码输入界面
             * 隐藏正在投屏页面
             */
            mLayoutInputPin?.visibility = View.VISIBLE
            mLayoutInRoom?.visibility = View.GONE
            /** 处理版本环境 */
            val tvVersionAndEnv = findViewById<View>(R.id.tv_version_and_env)
            tvVersionAndEnv.visibility = if (mSoftInputHeight > KEYBOARD_MIN_HEIGHT)
                View.GONE else View.VISIBLE
            /** 处理欢迎文字 */
            val lpTvWelcome = mTvWelcome?.layoutParams as RelativeLayout.LayoutParams?
            lpTvWelcome?.topMargin = if (mSoftInputHeight > KEYBOARD_MIN_HEIGHT) {
                resources.getDimensionPixelSize(R.dimen.wecast_main_welcome_margin_top_with_keyboard)
                +resources.getDimensionPixelSize(R.dimen.wecast_toolbar_height)
            } else {
                resources.getDimensionPixelSize(R.dimen.wecast_main_welcome_margin_top)
            }
            mTvWelcome?.layoutParams = lpTvWelcome
            /** 处理关闭按钮 */
            val lpBtnClose = mBtnClose?.layoutParams as RelativeLayout.LayoutParams?
            if (!WeCastInfo.instance.isWeCastApp || mCurrentUIState == UI_STATE_ADDING) {
                mBtnClose?.visibility = View.VISIBLE
            } else {
                mBtnClose?.visibility = View.GONE
            }
            if (mCurrentUIState == UI_STATE_ADDING) {
                /** 添加页面，显示关闭按钮 **/
                lpBtnClose?.topMargin = resources.getDimensionPixelSize(R.dimen.wecast_main_btn_close_margin_top)
            } else {
                /** 其他页面，弹起键盘的时候，不显示关闭按钮 **/
                lpBtnClose?.topMargin =
                        if (mSoftInputHeight > KEYBOARD_MIN_HEIGHT) {
                            resources.getDimensionPixelSize(R.dimen.wecast_main_btn_close_margin_top_with_keyboard)
                        } else {
                            resources.getDimensionPixelSize(R.dimen.wecast_main_btn_close_margin_top)
                        }
            }
            /** 处理底部文案 */
            if (mCurrentUIState == UI_STATE_ADDING) {
                mLayoutFooter?.visibility = View.GONE
            } else {
                mLayoutFooter?.visibility =
                        if (mSoftInputHeight > KEYBOARD_MIN_HEIGHT) {
                            View.GONE
                        } else {
                            View.VISIBLE
                        }
            }
        } else { // UI_STATE_IN_ROOM
            mEtPinCode?.clearFocus()
            KeyboardUtils.hideSoftInput(this)
            mLayoutInputPin?.visibility = View.GONE
            mLayoutInRoom?.visibility = View.VISIBLE
            mBaseHandler?.postDelayed({
                mEtPinCode?.clearFocus()
                KeyboardUtils.hideSoftInput(this)
            }, KEYBOARD_ACTION_DELAYED)

            /** 第一次息屏的提示 **/
            val setView = findViewById<View>(R.id.layout_setting)
            if (setView.visibility == View.VISIBLE) {
                tryShowScreenOutSettingDialogFirst()
            }
        }
    }

    private fun setFunctionBtnVisibility(isShow: Boolean) {
        if (!isShow || !WeCastInfo.instance.isWeCastApp) {
            mBtnFunction?.visibility = View.GONE
        } else if (isShow && WeCastInfo.instance.isWeCastApp) {
            mBtnFunction?.visibility = View.VISIBLE
        }
    }

    private fun showEnteringTips(firstEnter: Boolean) {
        showLoading(if (firstEnter) getString(R.string.wecast_entering_cast) else getString(R.string.wecast_adding_cast))
    }

    private fun hideEnteringTips() {
        hideLoading()
    }

    private fun showNormalAlert(text: String) {
        showAlert(WeCastAlert.WeCastAlertInfo(ALERT_TYPE_NORMAL,
                text))
    }

    private fun hideNormalAlert() {
        hideAlert(ALERT_TYPE_NORMAL)
    }

    private fun showNetDisconnectedAlert(showFlag: Boolean) {
        if (showFlag) {
            val netTips = getString(R.string.wecast_alert_abnormal_net_text)
            showAlertInRoom(WeCastAlert.WeCastAlertInfo(ALERT_TYPE_NET_DISCONNECTED,
                    netTips))
        } else {
            hideAlertInRoom(ALERT_TYPE_NET_DISCONNECTED)
        }
    }


    private fun showAlert(alertInfo: WeCastAlert.WeCastAlertInfo) {
        mWcaAlert?.addAlert(alertInfo)
    }

    private fun hideAlert(alertType: Int) {
        mWcaAlert?.removeAlert(alertType)
    }

    private fun showAlertInRoom(alertInfo: WeCastAlert.WeCastAlertInfo) {
        mWcaAlertInRoom?.addAlert(alertInfo)

        if (mWcaAlertInRoom != null && mWcaAlertInRoom!!.hasAlert()) {
            mTvCasting?.visibility = View.INVISIBLE
        } else {
            mTvCasting?.visibility = View.VISIBLE
        }
    }

    private fun hideAlertInRoom(alertType: Int) {
        mWcaAlertInRoom?.removeAlert(alertType)

        if (mWcaAlertInRoom != null && mWcaAlertInRoom!!.hasAlert()) {
            mTvCasting?.visibility = View.INVISIBLE
        } else {
            mTvCasting?.visibility = View.VISIBLE
        }
    }

    private fun dealExitOrDisconnect() {
        mShowTipsFlag = false
        mSvTips?.visibility = View.GONE
    }

    private fun notifyUserChange() {
        mUserListAdapter?.notifyDataSetChanged()
    }

    private fun setCapturePermission() {
        if (WeCastInfo.instance.usingMirror) {
            /** 从 assets 中拷贝 xcast 流控配置文件 到 sdcard 中  **/
            WeCastUtil.copyXcastConfFromAssets2SDCard(JniHelper.getAppContext())

            val mMediaProjectionManager = getSystemService(Context.MEDIA_PROJECTION_SERVICE) as MediaProjectionManager
            val reqIntent = mMediaProjectionManager.createScreenCaptureIntent()
            startActivityForResult(reqIntent, REQUEST_MEDIA_PROJECTION)
        } else {
            if (!mIsRecover) {
                enterCast()
            } else {
                CloudUtil.JniMethod.recoverCast(false)
            }
            mIsRecover = false
        }
    }

    /**
     * 非WIFI网络下提示弹框
     */
    private fun showNotUsingWiFiDialog() {
        val dialog: AlertDialog = AlertDialog.Builder(this@CloudMainActivity2)
                .setMessage(getString(R.string.wecast_not_wifi_tips))
                .setPositiveButton(getString(R.string.wecast_continue_text)) { _, _ ->
                    setCapturePermission()
                }
                .setNegativeButton(getString(R.string.wecast_cancel_text)) { dialog, _ ->
                    dialog.dismiss()
                }
                .setCancelable(false)
                .create()
        dialog.show()
        dialog.getButton(Dialog.BUTTON_POSITIVE)?.setTextColor(
                ContextCompat.getColor(applicationContext,
                        R.color.wecast_common_font_color_1))
        dialog.getButton(Dialog.BUTTON_NEGATIVE)?.setTextColor(
                ContextCompat.getColor(applicationContext,
                        R.color.wecast_lock_screen_bg_blue_color))
    }

    /**
     * 网络断开dialog
     */
    private fun showDisconnectDialog(isShow: Boolean) {
        if (isShow) {
            disconnectDialog = AlertDialog.Builder(this@CloudMainActivity2)
                    .setTitle(getString(R.string.wecast_net_not_available))
                    .setMessage(getString(R.string.wecast_check_net_tips))
                    .setPositiveButton(getString(R.string.wecast_confirm_text)) { _, _ ->
                        mFatalDialog?.dismiss()
                    }
                    .setCancelable(false)
                    .create()
            disconnectDialog?.show()
            disconnectDialog?.getButton(Dialog.BUTTON_POSITIVE)?.setTextColor(
                    ContextCompat.getColor(applicationContext,
                            R.color.wecast_common_font_color_1))
        } else {
            if (disconnectDialog != null && disconnectDialog!!.isShowing) {
                disconnectDialog?.dismiss()
            }
        }
    }

    /**
     * Recovery dialog
     */
    private fun showRecoveryDialog(isShow: Boolean, deviceName: String, hideDelay: Long) {
        if (isShow) {
            if (mRecoveryDialog == null) {
                mRecoveryDialog = AlertDialog.Builder(this@CloudMainActivity2)
                        .setTitle(getString(R.string.wecast_reconnect_device))
                        .setPositiveButton(getString(R.string.wecast_reconnect_text)) { dg, _ ->
                            Logger.kp().d("do recovery by user click.")
                            recoveryCast(false)
                            dg.dismiss()
                        }
                        .setNegativeButton(getString(R.string.wecast_close_text)) { dg, _ ->
                            Logger.kp().d("cancel recovery by user click.")
                            recoveryCast(true)
                            dg.dismiss()
                        }
                        .setCancelable(false)
                        .create()
            }

            if (!mRecoveryDialog!!.isShowing) {
                val recoveryMsg = String.format(getString(R.string.wecast_detected_disconnect_tips), deviceName)
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                    mRecoveryDialog?.setMessage(Html.fromHtml(recoveryMsg, Html.FROM_HTML_MODE_LEGACY))
                } else {
                    mRecoveryDialog?.setMessage(Html.fromHtml(recoveryMsg))
                }
                mRecoveryDialog?.show()
                mRecoveryDialog?.getButton(Dialog.BUTTON_POSITIVE)?.setTextColor(
                        ContextCompat.getColor(applicationContext,
                                R.color.wecast_lock_screen_bg_blue_color))
                mRecoveryDialog?.getButton(Dialog.BUTTON_NEGATIVE)?.setTextColor(
                        ContextCompat.getColor(applicationContext,
                                R.color.wecast_common_font_color_1))
                if (mRecoveryDialog != null && mRecoveryDialog!!.isShowing) {
                    if (hideDelay > 0) {
                        mBaseHandler?.postDelayed({
                            if (mRecoveryDialog != null && mRecoveryDialog!!.isShowing) {
                                Logger.t(TAG).d("auto close mRecoveryDialog success.")
                                mRecoveryDialog?.dismiss()
                                mIsRecover = false
                            }
                        }, hideDelay)
                    }
                }
            }
        } else {
            if (mRecoveryDialog != null && mRecoveryDialog!!.isShowing) {
                mRecoveryDialog?.dismiss()
            }
        }
    }

    private val mAutoCloseRecoveryRunnable: Runnable = Runnable {
        Logger.t(TAG).d("auto close mRecoveryDialog after 30 min.")
        if (mRecoveryDialog != null && mRecoveryDialog!!.isShowing) {
            Logger.t(TAG).d("auto close mRecoveryDialog success.")
            mRecoveryDialog?.dismiss()
        }
    }

    /**
     * 息屏设置提示
     */
    private fun tryShowScreenOutSettingDialogFirst() {
        try {
            if (!(mMainSP!!.getBoolean(KEY_SCREEN_OUT_ALERT_FIRST_SHOW, false))) {
                mMainSP!!.edit().putBoolean(KEY_SCREEN_OUT_ALERT_FIRST_SHOW, true).apply()
                ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_SCREEN_OUT_FIRST_FORCE_SHOW_DIALOG, 0, "")
                showScreenOutSettingDialog()
            }
        } catch (e: Exception) {
            Logger.t(TAG).e("tryShowScreenOutSettingDialogFirst e = $e")
        }
    }

    private fun showOrHideFunctionDialog() {
        if (mFunctionDialog == null) {
            mFunctionDialog = FunctionDialog(this@CloudMainActivity2, createFunctionInfo(),
                    WeCastInfo.instance.corpName)
            mFunctionDialog?.setCancelable(true)
        }
        if (mFunctionDialog!!.isShowing) {
            mFunctionDialog?.dismiss()
        } else {
            mFunctionDialog?.show()
        }
    }

    private fun createFunctionInfo(): ArrayList<FunctionItemInfo> {
        val functionItemList = ArrayList<FunctionItemInfo>()
        if (WeCastInfo.instance.isWeCastApp) {
            val functionChangeCorp = FunctionItemInfo()
            functionChangeCorp.clickFunc = {
                val className = "com.tencent.wecast.sender.cloud.app.activity.WeCastBindCorpActivity"
                val activityClass = Class.forName(className)
                val intent = Intent(this@CloudMainActivity2, activityClass)
                intent.putExtra("changeCrop", true)
                startActivity(intent)
                finish()
                if (mFunctionDialog != null && mFunctionDialog!!.isShowing) {
                    mFunctionDialog?.dismiss()
                }
            }
            functionChangeCorp.title = getString(R.string.wecast_change_corp)
            functionItemList.add(functionChangeCorp)
        }
        val functionAboutUs = FunctionItemInfo()
        functionAboutUs.clickFunc = {
            val intent = Intent(this@CloudMainActivity2, CloudAboutUsActivity::class.java)
            startActivity(intent)
            if (mFunctionDialog != null && mFunctionDialog!!.isShowing) {
                mFunctionDialog?.dismiss()
            }
        }
        functionAboutUs.title = getString(R.string.wecast_about_us)
        functionItemList.add(functionAboutUs)
        val functionFeedBack = FunctionItemInfo()
        functionFeedBack.clickFunc = {
            val intent = Intent(this@CloudMainActivity2, CloudWebViewActivity::class.java)
            intent.putExtra(CloudWebViewActivity.TITLE, getString(R.string.wecast_feedback))
            intent.putExtra(CloudWebViewActivity.WEB_URL, CloudWebViewActivity.FEEDBACK)
            startActivity(intent)
            if (mFunctionDialog != null && mFunctionDialog!!.isShowing) {
                mFunctionDialog?.dismiss()
            }
        }
        functionFeedBack.title = getString(R.string.wecast_feedback)
        functionItemList.add(functionFeedBack)
        return functionItemList
    }

    private fun showScreenOutSettingDialog() {
        ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_SCREEN_OUT_SHOW_DIALOG, 0, "")
        if (mScreenOutDialog == null) {
            mScreenOutDialog = AlertDialog.Builder(this@CloudMainActivity2)
                    .setMessage(mScreenOutSettingInfo.message)
                    .setPositiveButton(if (mScreenOutSettingInfo.intentType == SettingUtils.ScreenOutSettingInfo.INTENT_TYPE_NONE)
                        getText(R.string.wecast_confirm_text) else getString(R.string.wecast_go_setting)
                    ) { dialog, _ ->
                        dialog.dismiss()
                        if (mScreenOutSettingInfo.intentType != SettingUtils.ScreenOutSettingInfo.INTENT_TYPE_NONE) {
                            jumpScreenOutSetting()
                        }
                    }
                    .setNegativeButton(getText(R.string.wecast_cancel_text)
                    ) { dialog, _ ->
                        dialog.dismiss()
                    }
                    .setCancelable(true)
                    .create()
        }
        mScreenOutDialog?.show()
        mScreenOutDialog?.getButton(Dialog.BUTTON_POSITIVE)?.setTextColor(ContextCompat.getColor(applicationContext, R.color.wecast_lock_screen_bg_blue_color))
        mScreenOutDialog?.getButton(Dialog.BUTTON_NEGATIVE)?.setTextColor(ContextCompat.getColor(applicationContext, R.color.wecast_lock_screen_bg_blue_color))
    }

    private fun jumpScreenOutSetting() {
        try {
            ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_SCREEN_OUT_DIALOG_CLICK_SETTING, 0, "")
            startActivity(mScreenOutSettingInfo.intent)
        } catch (t: Throwable) {
            Logger.t(TAG).e("jumpScreenOutSetting t = $t")
        }
    }

    private fun getSdkTips(): String? {
        return mNativeTips +
                "\n======= NetWork Diagnosis Tips =======\n" +
                NetWorkDiagnosisUtil.getNetWorkDiagnosisInfo()
    }

    private fun showTipsUI(showFlag: Boolean) {
        mShowTipsFlag = showFlag

        if (showFlag) {
            mTvQualityTips?.text = getSdkTips()
        }
        mSvTips?.visibility = if (showFlag) View.VISIBLE else View.GONE
    }

    private fun tryShowTips() {
        if (mShowTipsFlag) {
            showTipsUI(false)
        } else {
            /**
             * 3秒5下开启tips
             */
            val currentTimeMs = System.currentTimeMillis()
            if (currentTimeMs - mLastTapTimeMs > 3 * 1000) {
                mLastTapTimeMs = currentTimeMs
                mTapTimes = 0
            } else {
                mTapTimes++
            }

            if (mTapTimes >= 4) {
                mLastTapTimeMs = 0
                mTapTimes = 0
                showTipsUI(true)
            }
        }
    }

    private fun registerScreenOffBroadCast() {
        try {
            /** 注册息屏事件 当在房间中 屏幕熄灭触发**/
            val filter = IntentFilter()
            filter.addAction(Intent.ACTION_SCREEN_OFF)
            mScreenOffReceiver = object : BroadcastReceiver() {
                override fun onReceive(context: Context?, intent: Intent?) {
                    if (intent != null) {
                        val action = intent.action
                        if (Intent.ACTION_SCREEN_OFF == action) {
                            if (mCurrentUIState == UI_STATE_IN_ROOM) {
                                Logger.t(TAG).d("screenOffReceiver action = $action")
                                ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_SCREEN_OUT, 0, "")
                            }
                        }
                    }
                }
            }
            applicationContext.registerReceiver(mScreenOffReceiver, filter)
        } catch (e: Exception) {
            Logger.t(TAG).e("Exception: $e")
        }
    }

    private fun startNotificationServer() {
        if (mNotificationServerIntent == null) {
            mNotificationServerIntent = Intent(this@CloudMainActivity2,
                    NotificationService::class.java)
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            startForegroundService(mNotificationServerIntent)
        } else {
            startService(mNotificationServerIntent)
        }
    }

    private fun stopNotificationServer() {
        if (mNotificationServerIntent != null) {
            stopService(mNotificationServerIntent)
            mNotificationServerIntent = null
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onEnterLoadingEvent(event: SenderEvents.EEnterLoading) {
        Logger.t(TAG).d("onEnterLoadingEvent isLoading = ${event.isLoading}")

        if (event.isLoading) {
            showEnteringTips(true)
        } else {
            hideEnteringTips()
            mBtnConfirm?.isEnabled = true
        }
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    fun onShowErrorEvent(event: SenderEvents.EShowError) {
        Logger.t(TAG).d("onShowErrorEvent errorCode = ${event.errorCode}")
        mBtnConfirm?.isEnabled = true
        if (event.errorCode != 0) {
            showNormalAlert(ErrorUtils.getErrorMsg(baseContext, event.errorCode))
        } else {
            hideNormalAlert()
            hideAlertInRoom(ALERT_TYPE_NET_DISCONNECTED)
        }
        setBtnConfirmEnable(event.errorCode == 0)
        EventBusUtil.removeStick(event)
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onPushToCastingEvent(event: SenderEvents.EPushToCastingView) {
        Logger.t(TAG).d("onPushToCastingEvent")
        if (!WeCastInfo.instance.isCasting) {
            WeCastInfo.instance.mStateChangeListener?.onChanged(WeCast.CAST_STATE_CASTING)
            WeCastInfo.instance.isCasting = true
        }
        mEtPinCode?.setText("")
        setUIState(UI_STATE_IN_ROOM)
        startNotificationServer()
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    fun onExitCastViewEvent(event: SenderEvents.EExitCastView) {
        Logger.kp().i("Exit casting: ${event.exitReason}")
        if (mScreenOutDialog != null && mScreenOutDialog!!.isShowing) {
            mScreenOutDialog?.dismiss()
        }
        setUIState(UI_STATE_WAITING)
        // 仅异常退出时才会回到pin码页面，触发ready回调
        if (event.exitReason == WeCastConstant.WeCastExitType.HEARTBEAT_TIMEOUT
                && WeCastInfo.instance.isCasting) {
            WeCastInfo.instance.mStateChangeListener?.onChanged(WeCast.CAST_STATE_READY)
        }
        WeCastInfo.instance.isCasting = false
        dealExitOrDisconnect()
        mIsXCastPause = false
        mIsRecover = false
        EventBusUtil.removeStick(event)
        stopNotificationServer()
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onAddCastSuccessEvent(event: SenderEvents.EAddCastSuccess) {
        Logger.t(TAG).d("onAddCastSuccessEvent")
        setUIState(UI_STATE_IN_ROOM)
        mEtPinCode?.setText("")
        hideEnteringTips()
        mBtnConfirm?.isEnabled = true
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onAddCastFailedEvent(event: SenderEvents.EAddCastFailed) {
        Logger.t(TAG).d("onAddCastFailedEvent error code:" + event.errorCode)
        showNormalAlert(ErrorUtils.getErrorMsg(baseContext, event.errorCode))
        hideEnteringTips()
        mBtnConfirm?.isEnabled = true
        mBaseHandler?.removeCallbacks(mAddCastErrorRunnable)
        mBaseHandler?.postDelayed(mAddCastErrorRunnable, 3000)
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onEditFocusEvent(event: SenderEvents.EEditFocus) {
        Logger.t(TAG).d("onEditFocusEvent")
        mEtPinCode?.requestFocus()
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onClearEditEvent(event: SenderEvents.EClearEdit) {
        Logger.t(TAG).d("onClearEditEvent")
        mEtPinCode?.setText("")
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onNetWorkStateTipsEvent(event: SenderEvents.ENetWorkStateTips) {
        Logger.t(TAG).d("onNetWorkStateTipsEvent isDisconnected = ${event.isDisconnected}")

        if (event.isDisconnected) {
            showNetDisconnectedAlert(true)
        } else {
            showNetDisconnectedAlert(false)
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onDisconnectPopupEvent(event: SenderEvents.EDisconnectPopup) {
        Logger.t(TAG).d("onDisconnectPopupEvent msg = ${event.msg}")
        showDisconnectDialog(true)
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onStreamReconnectEvent(event: SenderEvents.EStreamReconnect) { // 断网25s-60s 进程没有改变
        Logger.kp().d("onStreamReconnectEvent msg = ${event.msg}")
        showDisconnectDialog(false)

        Logger.kp().d("auto reconnect stream wih toast")
        Toast.makeText(applicationContext, getString(R.string.wecast_cast_reconnected), Toast.LENGTH_LONG).show()
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    fun onUpdateReceiverMemberEvent(event: SenderEvents.EUpdateReceiverMember) {
        Logger.t(TAG).d("onUpdateReceiverMemberEvent memberListJsonStr = ${event.memberListJsonStr}")
        if (WeCastInfo.instance.isCasting) {
            try {
                var receiverNum = 0
                userInfoList.clear()
                val memberListJson = GsonUtil.getGson().fromJson(event.memberListJsonStr, JsonArray::class.java)
                for (member in memberListJson) {
                    receiverNum++
                    val userInfo = MemberInfo()
                    userInfo.userName = member.asJsonObject.get("device_name").asString
                    userInfoList.add(userInfo)
                }
                if (receiverNum == 0) {
                    exitCast()
                } else {
                    showDisconnectDialog(false)
                }
                notifyUserChange()
            } catch (e: Exception) {
                Logger.t(TAG).e("Exception:$e")
            }
        } else {
            EventBusUtil.removeStick(event)
        }
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    fun onCanRecoverEvent(event: SenderEvents.ECanRecover) { // 触发倒计时: 1. 进程改变了,不管多少s 2. 60s以上断网 回调该方法
        val curMillis = System.currentTimeMillis()
        val deltaTime = curMillis - event.lastExitTime

        Logger.kp().d("onCanRecoverEvent: reInvite:${event.reInvite}, " +
                "inviteeId:${event.inviteeId}, " +
                "inviteeDeviceName:${event.inviteeDeviceName}, " +
                "lastExitTime: ${event.lastExitTime}, " +
                "deltaTime:${deltaTime / 1000}s")

        mIsRecover = true
        showDisconnectDialog(false)

        if (event.reInvite) {
            // 60s以上断网超时退房 > 退了房就弹框重连
            showRecoveryDialog(true, event.inviteeDeviceName, AUTO_CLOSE_RECOVERY_DLG_TIME - deltaTime)
        } else {
            // 进程改变了,不管多少s
            // 没退房 则25s以上弹框重连
            if (deltaTime <= 25 * 1000) {
                // 小于25s自动重连
                recoveryCast(false)
            } else if (25 * 1000 < deltaTime && deltaTime <= 30 * 60 * 1000) {
                // 25s-30min 弹框提示是否重连
                showRecoveryDialog(true,
                        event.inviteeDeviceName,
                        AUTO_CLOSE_RECOVERY_DLG_TIME - deltaTime)
            }
        }
        EventBusUtil.removeStick(event)
    }

    private var mIsXCastPause = false
    @Subscribe(sticky = false, threadMode = ThreadMode.MAIN)
    fun onC2CMessageEvent(event: SenderEvents.EC2CMessage) {
        Logger.kp().d("Handle C2C message > ${event.cmd}:${event.data}")
        val c2cMessage = WeCastC2CUtil.parse(event.cmd, event.data)
        if (c2cMessage is C2CPauseXCastMsg) {
            if ((c2cMessage.isPause && !mIsXCastPause)
                    || (!c2cMessage.isPause && mIsXCastPause)) {
                mIsXCastPause = !mIsXCastPause
                Logger.t(TAG).d("pause xcast > $mIsXCastPause")
                JniHelper.callJniFunc("pauseXCast")
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onShowTips(event: SenderEvents.EShowTips) {
        mNativeTips = event.tips
        if (mSvTips?.visibility == View.VISIBLE) {
            showTipsUI(true)
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onStopCast(event: SenderEvents.EStopCast) {
        finish()
    }

}
