package com.tencent.wecast.sender.cloud.activity

import android.app.Dialog
import android.content.Context
import android.content.res.Configuration
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.os.Message
import android.text.TextUtils
import android.view.MenuItem
import android.widget.TextView
import com.tencent.wecast.WeCastBaseActivity
import com.tencent.wecast.WeCastConfigManager
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.sender.cloud.utils.CommonUtils
import com.tencent.wecast.utils.Logger


open class BaseActivity : WeCastBaseActivity() {

    companion object {
        private val TAG = "WeCastBaseActivity"
    }

    /**
     * 构造一个主线程的Handler，用于投递消息
     */
    protected var mBaseHandler: Handler? = null

    protected var mLoadingDialog: Dialog? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        supportActionBar?.setHomeButtonEnabled(true)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        mBaseHandler = object : Handler(Looper.getMainLooper()) {
            override fun handleMessage(msg: Message) {
                baseHandleMessage(msg)
            }
        }
    }

    override fun onResume() {
        Logger.t(TAG).d("onResume > $localClassName")
        super.onResume()
    }

    override fun onPause() {
        Logger.t(TAG).d("onPause > $localClassName")
        super.onPause()
    }

    override fun onDestroy() {
        Logger.t(TAG).d("onDestroy > $localClassName")
        super.onDestroy()
        mLoadingDialog?.dismiss()
        mLoadingDialog = null

        mBaseHandler?.removeCallbacksAndMessages(null)
        mBaseHandler = null
    }


    /**
     * 界面公共部分
     */
    fun showLoading(text: String) {
        if (mLoadingDialog == null) {
            mLoadingDialog = CommonUtils.createLoadingDialog(this)
        }

        val textView = mLoadingDialog?.findViewById(R.id.loading_dialog_text) as TextView?
        textView?.text = if (TextUtils.isEmpty(text)) "" else text
        mLoadingDialog?.show()
    }

    fun hideLoading() {
        mLoadingDialog?.dismiss()
        mLoadingDialog = null
    }

    /**
     * 子类重写此方法，进行MSG处理
     *
     * @param msg
     */
    fun baseHandleMessage(msg: Message) {

    }

    fun getConfValue(id: Int, defaultValue: Boolean): Boolean {
        return try {
            resources.getBoolean(id)
        } catch (e: Exception) {
            Logger.t(TAG).e("getConfValue e =" + e)
            defaultValue
        }
    }

    override fun attachBaseContext(newBase: Context?) {
        val config = Configuration(newBase?.resources?.configuration)
        config.setLocale(WeCastConfigManager.getInstance().languageLocale)
        super.attachBaseContext(newBase?.createConfigurationContext(config))
    }
}