package com.tencent.wecast.sender;

import com.tencent.wecast.jni.BaseJ2CppService;
import com.tencent.wecast.jni.JniHelper;
import com.tencent.wecast.jni.ParamsPackage;
import com.tencent.wecast.sender.eb.SenderEventsHandle;
import com.tencent.wecast.utils.DeviceInfoUtil;
import com.tencent.wecast.utils.Logger;
import com.tencent.wecast.utils.WeCastUtil;

import java.io.IOException;

public class SenderJ2CppService extends BaseJ2CppService {
    private final static String TAG = "SenderJ2CppService";

    // 获取用户信息
    private static final int TYPE_GET_USER_NAME = 0;
    private static final int TYPE_GET_USER_PWD = 1;
    private static final int TYPE_GET_USER_NICK = 2;

    private static final SenderJ2CppService ourInstance = new SenderJ2CppService();

    public static SenderJ2CppService getInstance() {
        return ourInstance;
    }

    private SenderJ2CppService() {
        super();
    }

    @Override
    protected void registerEBHandle() {
        new SenderEventsHandle().registerHandle();
    }

    @Override
    protected void registerImpl() {
        super.registerImpl();

        // 发送端需要注册给c++使用的单独
        JniHelper.registerFunc4Cpp("GetUserInfo", new JniHelper.OnCppCall() {
            @Override
            public ParamsPackage.ParamsToCpp handle(ParamsPackage.ParamsFromCpp params) {
                try {
                    int type = (int) params.getNext();
                    final ParamsPackage.ParamsToCpp ret = new ParamsPackage.ParamsToCpp();
                    switch (type) {
                        case TYPE_GET_USER_NAME:
                            String userName = WeCastUtil.genUUID();
                            Logger.t(TAG).d("new user name = " + userName);
                            ret.addString(userName);
                            break;
                        case TYPE_GET_USER_PWD:
                            String pwd = WeCastUtil.genUUID();
                            Logger.t(TAG).d("new pwd = " + pwd);
                            ret.addString(pwd);
                            break;
                        case TYPE_GET_USER_NICK:
                            String nickName = DeviceInfoUtil.getDeviceName();
                            Logger.t(TAG).d("new nick name = " + nickName);
                            ret.addString(nickName);

                            break;
                        default:
                            ret.addString("unknown");
                            break;
                    }
                    return ret;
                } catch (IOException e) {
                    Logger.t(TAG).e("[device] GetUserInfo exception: ", e);
                    e.printStackTrace();
                }
                return null;
            }
        });

        JniHelper.registerFunc4Cpp("getDeviceInfo", new JniHelper.OnCppCall() {
            @Override
            public ParamsPackage.ParamsToCpp handle(ParamsPackage.ParamsFromCpp params) {
                ParamsPackage.ParamsToCpp ret = null;
                try {
                    int type = (int) params.getNext();
                    ret = getDeviceInfoParams(type);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return ret;
            }
        });
    }

}
