package com.tencent.wecast.c2c;

import android.text.TextUtils;

import com.google.gson.JsonObject;
import com.tencent.wecast.utils.GsonUtil;
import com.tencent.wecast.utils.Logger;

/**
 * DLNA/Gcast等的更新信息
 * {dataType:"3",data:{"dlna":"xxx","googlecast":"xxx"}}
 */
public class C2CPushUpdateMsg extends C2CMessage {
    private String mUpdateData;
    private String mUpdateType;

    // 用于封装数据
    public C2CPushUpdateMsg(String updateType, String data) {
        mUpdateType = updateType;
        if (mUpdateType.equalsIgnoreCase("dlna")) {
            JsonObject jo = new JsonObject();
            jo.addProperty("dlna", data);
            mUpdateData = GsonUtil.getGson().toJson(jo);
        } else if (mUpdateType.equalsIgnoreCase("googlecast")) {
            JsonObject jo = new JsonObject();
            jo.addProperty("googlecast", data);
            mUpdateData = GsonUtil.getGson().toJson(jo);
        }
    }

    // 用于解析数据
    public C2CPushUpdateMsg(String data) {
        JsonObject jo = GsonUtil.getGson().fromJson(data, JsonObject.class);
        if (jo.get("dlna") != null && !TextUtils.isEmpty(jo.get("dlna").getAsString())) {
            mUpdateData = jo.get("dlna").getAsString();
            mUpdateType = "dlna";
        } else if (jo.get("googlecast") != null && !TextUtils.isEmpty(jo.get("googlecast").getAsString())) {
            mUpdateData = jo.get("googlecast").getAsString();
            mUpdateType = "googlecast";
        }
    }

    @Override
    public C2CMsgType type() {
        return C2CMsgType.C2C_R2S_PUSH_UPDATE;
    }

    @Override
    public String getData() {
        return mUpdateData;
    }

    @Override
    public String toString() {
        return "C2CPushUpdateMsg:{" +
                "dataType:" + type().getCmd() +
                ", data:" + mUpdateData +
                '}';
    }

    public String getUpdateType() {
        return this.mUpdateType;
    }
}
