/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.tencent.avlab.sdk.Platform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AppLifecycle
implements Runnable {
    private static final String TAG = "AppLifecycle";
    private final Object mObj;
    private List<LifecycleObserver> mObservers;
    private AppLifecycleListener mListener;
    private boolean mIsForeground;
    private Handler mHandler;
    private Application mApp;
    private ActivityManager mActivityManager;
    private String mProcessName;
    private ScreenBroadcastReceiver mReceiver;

    public static AppLifecycle create(Context context, Handler handler) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            Platform.logDebug("called int none main thread");
        }
        context = (Application)context.getApplicationContext();
        return new AppLifecycle((Application)context, handler);
    }

    private AppLifecycle(Application application, Handler handler) {
        IntentFilter intentFilter;
        AppLifecycle appLifecycle = appLifecycle3;
        Application application2 = application;
        AppLifecycle appLifecycle2 = appLifecycle3;
        appLifecycle3.mObj = new Object();
        appLifecycle2.mApp = application;
        appLifecycle2.mObservers = new ArrayList<LifecycleObserver>();
        appLifecycle2.mListener = appLifecycle3.new AppLifecycleListener();
        appLifecycle3.mHandler = handler;
        application2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)appLifecycle3.mListener);
        appLifecycle3.mActivityManager = (ActivityManager)application2.getSystemService("activity");
        appLifecycle.mProcessName = String.valueOf(application.getApplicationInfo().processName);
        appLifecycle.mIsForeground = AppLifecycle.isAppForeground(appLifecycle.mActivityManager, appLifecycle3.mProcessName);
        appLifecycle.mReceiver = appLifecycle3.new ScreenBroadcastReceiver();
        AppLifecycle appLifecycle3 = intentFilter;
        new IntentFilter().addAction("android.intent.action.SCREEN_OFF");
        application.registerReceiver((BroadcastReceiver)appLifecycle.mReceiver, (IntentFilter)appLifecycle3);
    }

    public static boolean isAppForeground(ActivityManager object, String string2) {
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : object.getRunningAppProcesses()) {
            if (runningAppProcessInfo.importance != 100 || !runningAppProcessInfo.processName.equals(string2)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean access$402(AppLifecycle appLifecycle, boolean bl) {
        appLifecycle.mIsForeground = bl;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addObserver(LifecycleObserver lifecycleObserver) {
        AppLifecycle appLifecycle = this;
        Object object = appLifecycle.mObj;
        synchronized (object) {
            if (appLifecycle.mObservers != null) {
                return this.mObservers.add(lifecycleObserver);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeObserver(LifecycleObserver lifecycleObserver) {
        AppLifecycle appLifecycle = this;
        Object object = appLifecycle.mObj;
        synchronized (object) {
            if (appLifecycle.mObservers != null) {
                this.mObservers.remove(lifecycleObserver);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mObj;
        AppLifecycle appLifecycle = this;
        synchronized (object) {
            appLifecycle.mApp.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mListener);
            appLifecycle.mApp.unregisterReceiver((BroadcastReceiver)this.mReceiver);
            appLifecycle.mObservers.clear();
            appLifecycle.mListener = null;
            appLifecycle.mActivityManager = null;
            appLifecycle.mObservers = null;
            appLifecycle.mHandler = null;
            appLifecycle.mApp = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        AppLifecycle appLifecycle = this;
        Object object = appLifecycle.mObj;
        synchronized (object) {
            boolean bl;
            if (appLifecycle.mActivityManager != null && (bl = AppLifecycle.isAppForeground(((AppLifecycle)this).mActivityManager, ((AppLifecycle)this).mProcessName)) != ((AppLifecycle)this).mIsForeground) {
                ((AppLifecycle)this).mIsForeground = bl;
                for (LifecycleObserver lifecycleObserver : ((AppLifecycle)this).mObservers) {
                    if (bl) {
                        lifecycleObserver.onAppForegrounded();
                        continue;
                    }
                    lifecycleObserver.onAppBackgrounded();
                }
            }
            return;
        }
    }

    public class AppLifecycleListener
    implements Application.ActivityLifecycleCallbacks {
        public void onActivityCreated(Activity activity, Bundle bundle) {
            if (Platform.isDebugLevel()) {
                Platform.logInfo("onActivityCreated:" + activity.getLocalClassName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onActivityStarted(Activity object) {
            AppLifecycleListener appLifecycleListener = this;
            Platform.logInfo("onActivityStarted:" + object.getLocalClassName());
            Object object2 = appLifecycleListener.AppLifecycle.this.mObj;
            synchronized (object2) {
                if (appLifecycleListener.AppLifecycle.this.mHandler != null) {
                    AppLifecycle.this.mHandler.post((Runnable)AppLifecycle.this);
                }
                return;
            }
        }

        public void onActivityResumed(Activity activity) {
            if (Platform.isDebugLevel()) {
                Platform.logInfo("onActivityResumed:" + activity.getLocalClassName());
            }
        }

        public void onActivityPaused(Activity activity) {
            if (Platform.isDebugLevel()) {
                Platform.logInfo("onActivityPaused:" + activity.getLocalClassName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onActivityStopped(Activity object) {
            AppLifecycleListener appLifecycleListener = this;
            Platform.logInfo("onActivityStopped:" + object.getLocalClassName());
            Object object2 = appLifecycleListener.AppLifecycle.this.mObj;
            synchronized (object2) {
                if (appLifecycleListener.AppLifecycle.this.mHandler != null) {
                    AppLifecycle.this.mHandler.post((Runnable)AppLifecycle.this);
                }
                return;
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (Platform.isDebugLevel()) {
                Platform.logDebug("onActivityDestroyed:" + activity.getLocalClassName());
            }
        }
    }

    private class ScreenBroadcastReceiver
    extends BroadcastReceiver
    implements Runnable {
        private ScreenBroadcastReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context object, Intent intent) {
            block4: {
                if (!"android.intent.action.SCREEN_OFF".equals(intent.getAction())) break block4;
                ScreenBroadcastReceiver screenBroadcastReceiver = this;
                Platform.logInfo("receive screen off");
                object = screenBroadcastReceiver.AppLifecycle.this.mObj;
                synchronized (object) {
                    if (screenBroadcastReceiver.AppLifecycle.this.mHandler == null) break block4;
                    AppLifecycle.this.mHandler.post((Runnable)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ScreenBroadcastReceiver screenBroadcastReceiver = iterator;
            Object object = screenBroadcastReceiver.AppLifecycle.this.mObj;
            synchronized (object) {
                if (screenBroadcastReceiver.AppLifecycle.this.mActivityManager != null) {
                    if (((ScreenBroadcastReceiver)((Object)iterator)).AppLifecycle.this.mIsForeground) {
                        ScreenBroadcastReceiver screenBroadcastReceiver2 = iterator;
                        Platform.logInfo("notify background");
                        AppLifecycle.access$402(screenBroadcastReceiver2.AppLifecycle.this, false);
                        Iterator iterator = screenBroadcastReceiver2.AppLifecycle.this.mObservers.iterator();
                        while (iterator.hasNext()) {
                            ((LifecycleObserver)iterator.next()).onAppBackgrounded();
                        }
                    } else {
                        Platform.logInfo("already background");
                    }
                }
                return;
            }
        }
    }

    public static interface LifecycleObserver {
        public void onAppBackgrounded();

        public void onAppForegrounded();
    }
}

