/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.view.Surface;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.EGLUtil;
import com.tencent.xcast.GLES20IdImpl;
import com.tencent.xcast.GLId;
import com.tencent.xcast.RefCountDelegate;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;

public class SurfaceTextureHolder
extends RefCountDelegate {
    private static final GLId GLID = new GLES20IdImpl();
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private int[] mOesTextureId;
    private final EGLCoreContext mContext;
    private EventCallback mEventCallback;
    private TextureDestructorRunner mTextureDestructor;
    private ReentrantLock mLock;

    @AnyThread
    public SurfaceTextureHolder(int n2, int n3, @NonNull EventCallback objectArray, @NonNull TextureDestructorRunner textureDestructorRunner) {
        this.mOesTextureId = new int[1];
        this.mLock = new ReentrantLock();
        this.mContext = null;
        this.mEventCallback = objectArray;
        this.mTextureDestructor = textureDestructorRunner;
        this.mOesTextureId[0] = GLID.generateTexture();
        GLID.setTextureParameters(this.mOesTextureId[0], 36197, 33984);
        if (Platform.isLogLevel(5)) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.mOesTextureId[0];
            Platform.logInfo(String.format(Locale.CHINA, "Create.texture.%d", objectArray));
        }
        SurfaceTextureHolder surfaceTextureHolder = this;
        surfaceTextureHolder.mSurfaceTexture = new SurfaceTexture(this.mOesTextureId[0]);
        surfaceTextureHolder.mSurfaceTexture.setDefaultBufferSize(n2, n3);
        surfaceTextureHolder.mSurfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                EventCallback eventCallback = SurfaceTextureHolder.this.mEventCallback;
                if (eventCallback != null) {
                    eventCallback.onFrameAvailable(SurfaceTextureHolder.this, surfaceTexture);
                }
            }
        });
    }

    @AnyThread
    public SurfaceTextureHolder(int n2, int n3, @NonNull EventCallback objectArray, @NonNull EGLCoreContext eGLCoreContext) {
        int n4;
        EGLCoreContext eGLCoreContext2 = eGLCoreContext;
        object.mOesTextureId = new int[1];
        object.mLock = new ReentrantLock();
        eGLCoreContext2.retain();
        boolean bl = eGLCoreContext2.isCurrentContext();
        if (!bl && (n4 = eGLCoreContext.makeCurrent()) != 12288) {
            eGLCoreContext.release();
            Object[] objectArray2 = new Object[1];
            Object object = objectArray2;
            objectArray2[0] = EGLUtil.getEglErrorString(n4);
            object = String.format(Locale.CHINA, "makeCurrent.failed.%s", object);
            Platform.logError((String)object);
            throw new IllegalArgumentException((String)object);
        }
        object.mContext = eGLCoreContext;
        object.mEventCallback = objectArray;
        object.mTextureDestructor = null;
        object.mOesTextureId[0] = GLID.generateTexture();
        GLID.setTextureParameters(object.mOesTextureId[0], 36197, 33984);
        if (Platform.isLogLevel(5)) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = object.mOesTextureId[0];
            Platform.logInfo(String.format(Locale.CHINA, "glGenTextures.%d", objectArray));
        }
        object.mSurfaceTexture = new SurfaceTexture(object.mOesTextureId[0]);
        object.mSurfaceTexture.setDefaultBufferSize(n2, n3);
        object.mSurfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                EventCallback eventCallback = SurfaceTextureHolder.this.mEventCallback;
                if (eventCallback != null) {
                    eventCallback.onFrameAvailable(SurfaceTextureHolder.this, surfaceTexture);
                }
            }
        });
        if (!bl) {
            eGLCoreContext.detachCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public void updateTextureImage() {
        SurfaceTextureHolder surfaceTextureHolder = this;
        surfaceTextureHolder.mLock.lock();
        SurfaceTexture surfaceTexture = surfaceTextureHolder.mSurfaceTexture;
        if (surfaceTexture == null) {
            this.mLock.unlock();
            return;
        }
        EGLCoreContext eGLCoreContext = this.mContext;
        if (eGLCoreContext != null) {
            synchronized (eGLCoreContext) {
                int n2;
                boolean bl = this.mContext.isCurrentContext();
                if (!bl && (n2 = this.mContext.makeCurrent()) != 12288) {
                    Platform.logError(String.format(Locale.CHINA, "makeCurrent.failed.%s", EGLUtil.getEglErrorString(n2)));
                    this.mLock.unlock();
                    return;
                }
                this.mSurfaceTexture.updateTexImage();
                if (!bl) {
                    this.mContext.detachCurrent();
                }
            }
        } else {
            surfaceTexture.updateTexImage();
        }
        this.mLock.unlock();
    }

    @AnyThread
    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    @AnyThread
    public Surface getSurface() {
        if (this.mSurface == null) {
            this.mSurface = new Surface(this.mSurfaceTexture);
        }
        return this.mSurface;
    }

    @AnyThread
    public int lockTexture() {
        int[] nArray = this.mOesTextureId;
        int n2 = this.mOesTextureId != null ? nArray[0] : 0;
        if (n2 != 0) {
            this.mLock.lock();
        }
        return n2;
    }

    @AnyThread
    public void unlockTexture() {
        this.mLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @AnyThread
    public int release() {
        block25: {
            block27: {
                block26: {
                    var1_1 = super.release();
                    if (var1_1 > 0) {
                        return var1_1;
                    }
                    if (Platform.isDebugBuild) {
                        v0 = new Object[4];
                        var2_2 /* !! */  = v0;
                        var2_2 /* !! */ [0] = this;
                        var2_2 /* !! */ [1] = this.mSurfaceTexture;
                        var2_2 /* !! */ [2] = this.mTextureDestructor;
                        v0[3] = this.mContext;
                        Platform.logInfo(String.format(Locale.CHINA, "%h.release.mSurfaceTexture.%h.mTextureDestructor.%h.mContext.%h", (Object[])var2_2 /* !! */ ));
                    }
                    if ((var2_2 /* !! */  = this.mEventCallback) != null) {
                        var2_2 /* !! */ .onRelease(this);
                        this.mEventCallback = null;
                    }
                    v1 = this;
                    v1.mLock.lock();
                    var2_2 /* !! */  = v1.mSurfaceTexture;
                    if (var2_2 /* !! */  != null) {
                        var2_2 /* !! */ .release();
                        this.mSurfaceTexture = null;
                    }
                    v2 = this;
                    v2.mLock.unlock();
                    var2_2 /* !! */  = (SurfaceTexture)v2.mOesTextureId;
                    if (v2.mOesTextureId == null) break block25;
                    var3_3 = this.mTextureDestructor;
                    if (var3_3 == null) break block26;
                    var3_3.post(new TextureDestructor((int[])var2_2 /* !! */ ));
                    this.mTextureDestructor = null;
                    break block27;
                }
                v3 = this;
                var2_2 /* !! */  = v3.mContext;
                synchronized (var2_2 /* !! */ ) {
                    block24: {
                        block28: {
                            block23: {
                                var4_5 = 12288;
                                var3_4 = v3.mContext.isCurrentContext();
                                if (var3_4) break block23;
                                var4_5 = this.mContext.makeCurrent();
                                if (var4_5 == 12288) break block23;
                                v4 = Locale.CHINA;
                                v5 = new Object[1];
                                v5[0] = EGLUtil.getEglErrorString(var4_5);
                                Platform.logError(String.format(v4, "makeCurrent.failed.%s", v5));
                            }
                            if (var4_5 != 12288) break block28;
                            if (!Platform.isLogLevel(5)) ** GOTO lbl61
                            v6 = Locale.CHINA;
                            v7 = new Object[1];
                            v8 = this.mOesTextureId;
                            v7[0] = v8[0];
                            Platform.logInfo(String.format(v6, "glDeleteTextures.%d", v7));
lbl61:
                            // 2 sources

                            v9 = SurfaceTextureHolder.GLID;
                            v10 = this.mOesTextureId.length;
                            v11 = this.mOesTextureId;
                            v9.glDeleteTextures(v10, v11, 0);
                        }
                        if (!Platform.isLogLevel(5)) break block24;
                        v12 = Locale.CHINA;
                        v13 = new Object[1];
                        v14 = this.mOesTextureId;
                        v13[0] = v14[0];
                        Platform.logInfo(String.format(v12, "makeCurrent.fail.texture.%d", v13));
                    }
                    if (var3_4) ** GOTO lbl83
                    this.mContext.detachCurrent();
lbl83:
                    // 2 sources

                    this.mContext.release();
                }
            }
            this.mOesTextureId = null;
            break block25;
            {
                catch (Throwable v15) {
                    throw v15;
                }
            }
        }
        return var1_1;
    }

    private static class TextureDestructor
    implements Runnable {
        @NonNull
        final int[] mTexture;

        @AnyThread
        TextureDestructor(@NonNull int[] nArray) {
            this.mTexture = nArray;
        }

        @Override
        @WorkerThread
        public void run() {
            int[] nArray = ((TextureDestructor)((Object)stringBuilder2)).mTexture;
            GLID.glDeleteTextures(((TextureDestructor)((Object)stringBuilder2)).mTexture.length, nArray, 0);
            if (Platform.isLogLevel(5)) {
                StringBuilder stringBuilder;
                TextureDestructor textureDestructor = stringBuilder2;
                StringBuilder stringBuilder2 = stringBuilder;
                new StringBuilder().append("glDeleteTextures");
                nArray = textureDestructor.mTexture;
                int n2 = textureDestructor.mTexture.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = nArray[i2];
                    stringBuilder2.append('.');
                    stringBuilder2.append(n3);
                }
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append('.');
                Platform.logInfo(stringBuilder3.toString());
            }
        }
    }

    public static class HandlerDestructorRunner
    implements TextureDestructorRunner {
        @NonNull
        Handler mHandler;

        public HandlerDestructorRunner(@NonNull Handler handler) {
            this.mHandler = handler;
        }

        @Override
        public void post(@NonNull Runnable runnable) {
            if (Looper.myLooper() == this.mHandler.getLooper()) {
                runnable.run();
            } else {
                this.mHandler.post(runnable);
            }
        }
    }

    public static interface TextureDestructorRunner {
        public void post(@NonNull Runnable var1);
    }

    public static interface EventCallback {
        public void onFrameAvailable(SurfaceTextureHolder var1, SurfaceTexture var2);

        public void onRelease(SurfaceTextureHolder var1);
    }
}

