/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sharp.jni;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import java.util.StringTokenizer;

public class VivoKTVHelper {
    private static final String TAG = "VivoKTVHelper";
    private static final String KEY_KTV_MODE = "vivo_ktv_mode";
    private static final String KEY_VOL_MIC = "vivo_ktv_volume_mic";
    private static final String KEY_MIC_SRC = "vivo_ktv_rec_source";
    private static final String KEY_MIC_TYPE = "vivo_ktv_mic_type";
    private static final String KEY_PRESET = "vivo_ktv_preset_effect";
    private static final String KEY_PLAY_SRC = "vivo_ktv_play_source";
    private static final String KEY_EXT_SPKR = "vivo_ktv_ext_speaker";
    private static VivoKTVHelper mVivoKTVHelper;
    private final Object mParamLock = new Object();
    private AudioManager mAudioManager;
    private Context mContext;

    public VivoKTVHelper(Context context) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    public static VivoKTVHelper getInstance(Context context) {
        if (mVivoKTVHelper == null) {
            mVivoKTVHelper = new VivoKTVHelper(context);
        }
        return mVivoKTVHelper;
    }

    private int getKTVParam(String string) {
        if (Build.MODEL.trim().contains("vivo")) {
            StringTokenizer stringTokenizer;
            String string2 = ((VivoKTVHelper)((Object)string2)).mAudioManager.getParameters(string);
            StringTokenizer stringTokenizer2 = stringTokenizer;
            if (new StringTokenizer(string2, "=").countTokens() == 2 && string.equals(stringTokenizer2.nextToken())) {
                return Integer.parseInt(stringTokenizer2.nextToken().trim());
            }
        }
        return 0;
    }

    public boolean isDeviceSupportKaraoke() {
        if (Build.MODEL.trim().contains("vivo")) {
            int n2;
            StringTokenizer stringTokenizer;
            String string = ((VivoKTVHelper)((Object)string)).mAudioManager.getParameters(KEY_MIC_TYPE);
            StringTokenizer stringTokenizer2 = stringTokenizer;
            if (new StringTokenizer(string, "=").countTokens() != 2) {
                return false;
            }
            if (stringTokenizer2.nextToken().equals(KEY_MIC_TYPE) && ((n2 = Integer.parseInt(stringTokenizer2.nextToken())) == 1 || n2 == 0)) {
                return true;
            }
        }
        return false;
    }

    public void openKTVDevice() {
        VivoKTVHelper vivoKTVHelper = this;
        vivoKTVHelper.mAudioManager.setParameters("vivo_ktv_mode=1");
        vivoKTVHelper.isDeviceSupportKaraoke();
    }

    public void closeKTVDevice() {
        this.mAudioManager.setParameters("vivo_ktv_mode=0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMicVolParam(int n2) {
        VivoKTVHelper vivoKTVHelper = stringBuilder2;
        Object object = vivoKTVHelper.mParamLock;
        synchronized (object) {
            if (vivoKTVHelper.mAudioManager != null) {
                StringBuilder stringBuilder;
                VivoKTVHelper vivoKTVHelper2 = stringBuilder2;
                StringBuilder stringBuilder2 = stringBuilder;
                new StringBuilder().append(KEY_VOL_MIC).append("=").append(n2);
                vivoKTVHelper2.mAudioManager.setParameters(stringBuilder2.toString());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVoiceOutParam(int n2) {
        VivoKTVHelper vivoKTVHelper = this;
        Object object = vivoKTVHelper.mParamLock;
        synchronized (object) {
            if (vivoKTVHelper.mAudioManager != null) {
                this.mAudioManager.setParameters("vivo_ktv_rec_source=" + n2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPreModeParam(int n2) {
        VivoKTVHelper vivoKTVHelper = this;
        Object object = vivoKTVHelper.mParamLock;
        synchronized (object) {
            if (vivoKTVHelper.mAudioManager != null) {
                this.mAudioManager.setParameters("vivo_ktv_preset_effect=" + n2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPlayFeedbackParam(int n2) {
        VivoKTVHelper vivoKTVHelper = this;
        Object object = vivoKTVHelper.mParamLock;
        synchronized (object) {
            if (vivoKTVHelper.mAudioManager != null) {
                this.mAudioManager.setParameters("vivo_ktv_play_source=" + n2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setExtSpeakerParam(int n2) {
        VivoKTVHelper vivoKTVHelper = stringBuilder2;
        Object object = vivoKTVHelper.mParamLock;
        synchronized (object) {
            if (vivoKTVHelper.mAudioManager != null) {
                StringBuilder stringBuilder;
                VivoKTVHelper vivoKTVHelper2 = stringBuilder2;
                StringBuilder stringBuilder2 = stringBuilder;
                new StringBuilder().append(KEY_EXT_SPKR).append("=").append(n2);
                vivoKTVHelper2.mAudioManager.setParameters(stringBuilder2.toString());
            }
            return;
        }
    }

    public int getExtSpeakerParam() {
        return this.getKTVParam(KEY_EXT_SPKR);
    }

    public int getPlayFeedbackParam() {
        return this.getKTVParam(KEY_PLAY_SRC);
    }

    public int getPreModeParam() {
        return this.getKTVParam(KEY_PRESET);
    }

    public int getMicTypeParam() {
        return this.getKTVParam(KEY_MIC_TYPE);
    }

    public int getVoiceOutParam() {
        return this.getKTVParam(KEY_MIC_SRC);
    }

    public int getMicVolParam() {
        return this.getKTVParam(KEY_VOL_MIC);
    }
}

