package com.tencent.wecast;

import android.content.Context;
import android.content.SharedPreferences;

public class WeCastEnv {
    public static final int ENV_RELEASE = 0;
    public static final int ENV_PRE_RELEASE = 1;
    public static final int ENV_DEVELOP = 2;

    private static int currentEnv = ENV_RELEASE;

    public static int changeNextEnv() {
        currentEnv = currentEnv + 1;
        if (currentEnv > ENV_DEVELOP) {
            currentEnv = ENV_RELEASE;
        }
        SharedPreferences sp = WeCastAppContext.get()
                .getSharedPreferences("wecast_config", Context.MODE_PRIVATE);
        sp.edit().putInt("env", currentEnv).apply();
        return currentEnv;
    }

    public static int getCurrentEnv() {
        return currentEnv;
    }

    public static String getCurrentEnvDesc() {
        if (currentEnv == ENV_PRE_RELEASE) return "切换到预发布环境，关闭进程，重启应用后生效。";
        if (currentEnv == ENV_DEVELOP) return "切换到测试环境，关闭进程，重启应用后生效。";
        return "切换到正式环境，关闭进程，重启应用后生效。";
    }

    public static void initEnv() {
        SharedPreferences sp = WeCastAppContext.get()
                .getSharedPreferences("wecast_config", Context.MODE_PRIVATE);
        currentEnv = sp.getInt("env", currentEnv);
    }
}
