package com.tencent.wecast.c2c;

/**
 * C2C查询信息
 * 形如：{"dataType": 4, "data":"1"}
 */
public class C2CQueryMsg extends C2CMessage {
    private String data;

    public C2CQueryMsg(String data) {
        this.data = data;
    }

    @Override
    public C2CMsgType type() {
        return C2CMsgType.C2C_S2R_QUERY;
    }

    @Override
    public String getData() {
        return data;
    }

    @Override
    public String toString() {
        return "C2CQueryMsg{" +
                "dataType:" + type().getCmd() +
                ", data:" + data +
                '}';
    }

    public enum C2CS2RQueryType {
        UNKNOWN_QUERY_TYPE("0"),
        DLNA_QUERY_TYPE("1");

        private String queryType;

        C2CS2RQueryType(String queryType) {
            this.queryType = queryType;
        }

        public String getQueryType() {
            return queryType;
        }
    }

}