package com.tencent.wecast.sender.cloud.utils


import android.os.Build
import android.text.TextUtils
import com.tencent.wecast.utils.Logger
import java.io.BufferedReader
import java.io.IOException
import java.io.InputStreamReader

object RomUtils {
    private val TAG = "RomUtils"

    val ROM_MIUI = "MIUI"
    val ROM_EMUI = "EMUI"
    val ROM_FLYME = "FLYME"
    val ROM_OPPO = "OPPO"
    val ROM_VIVO = "VIVO"
    val ROM_SAMSUNG = "SAMSUNG"
    val ROM_GIONEE = "GIONEE"


    private val KEY_VERSION_MIUI = "ro.miui.ui.version.name"
    private val KEY_VERSION_EMUI = "ro.build.version.emui"
    private val KEY_VERSION_OPPO = "ro.build.version.opporom"
    private val KEY_VERSION_VIVO = "ro.vivo.os.version"

    val isEmui: Boolean
        get() = check(ROM_EMUI)

    val isMiui: Boolean
        get() = check(ROM_MIUI)

    val isVivo: Boolean
        get() = check(ROM_VIVO)

    val isOppo: Boolean
        get() = check(ROM_OPPO)

    val isFlyme: Boolean
        get() = check(ROM_FLYME)

    val isSamsung: Boolean
        get() = check(ROM_SAMSUNG)

    val isGionee: Boolean
        get() = check(ROM_GIONEE)


    private var sName: String? = null

    val name: String?
        get() {
            if (sName == null) {
                check("")
            }
            return sName
        }

    private var sVersion: String? = null

    private fun check(rom: String): Boolean {

        try {
            if (sName != null) {
                return sName == rom
            }

            if (!TextUtils.isEmpty(getProp(KEY_VERSION_MIUI))) {
                sName = ROM_MIUI
            } else if (!TextUtils.isEmpty(getProp(KEY_VERSION_EMUI))) {
                sName = ROM_EMUI
            } else if (!TextUtils.isEmpty(getProp(KEY_VERSION_OPPO))) {
                sName = ROM_OPPO
            } else if (!TextUtils.isEmpty(getProp(KEY_VERSION_VIVO))) {
                sName = ROM_VIVO
            } else {
                sVersion = Build.DISPLAY
                if (sVersion!!.toUpperCase().contains(ROM_FLYME)) {
                    sName = ROM_FLYME
                } else {
                    sVersion = Build.UNKNOWN
                    sName = Build.MANUFACTURER.toUpperCase()
                }
            }
            Logger.t(TAG).d("check sName = %s | manufacturer = %s", sName, Build.MANUFACTURER)
            return sName == rom
        } catch (t: Throwable) {
            Logger.t(TAG).e("check t = " + t)
            return false
        }
    }

    private fun getProp(name: String): String? {
        var line: String? = null
        var input: BufferedReader? = null
        try {
            val p = Runtime.getRuntime().exec("getprop $name")
            input = BufferedReader(InputStreamReader(p.inputStream), 1024)
            line = input.readLine()
            input.close()
        } catch (ex: IOException) {
            Logger.t(TAG).e("Unable to read prop $name", ex)
            return null
        } finally {
            if (input != null) {
                try {
                    input.close()
                } catch (e: IOException) {
                    e.printStackTrace()
                }

            }
        }
        return line
    }

    fun getBrand(): String {
        return when (name) {
            ROM_MIUI -> "Xiaomi"
            ROM_EMUI -> "Huawei"
            ROM_FLYME -> "Meizu"
            ROM_OPPO -> "Oppo"
            ROM_VIVO -> "Vivo"
            ROM_SAMSUNG -> "Samsung"
            ROM_GIONEE -> "Gionee"
            else -> "Other"
        }
    }
}