package com.tencent.wecast.sender.cloud.utils

import android.app.Dialog
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.text.TextUtils
import android.view.View
import android.widget.Toast
import com.tencent.wecast.WeCastUIConfigManager
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.utils.Logger
import com.tencent.wecast.utils.ReportUtils

object CommonUtils {
    private val TAG = "CommonUtils"

    fun createLoadingDialog(context: Context): Dialog {
        val result = Dialog(context, R.style.WeCastLoadingDialog)
        result.setContentView(R.layout.wecast_dialog_loading)
        result.setCancelable(false)
        return result
    }

    fun createSuccessDialog(context: Context): Dialog {
        val result = Dialog(context, R.style.WeCastLoadingDialog)
        result.setContentView(R.layout.wecast_dialog_success)
        result.setCancelable(false)
        return result
    }


    fun createChooseAppDialog(context: Context): Dialog {
        val result = Dialog(context, R.style.WeCastLoadingDialog)

        val rootView = WeCastUIConfigManager.getInstance().getLayoutRootView(
                WeCastUIConfigManager.ActivityLabel.SENDER_GUIDE, context)
        result.setContentView(rootView)
        WeCastUIConfigManager.getInstance().applyUIConfig(WeCastUIConfigManager.ActivityLabel.SENDER_GUIDE, rootView)

        result.setCancelable(true)

        try {
            val layoutQvideo = result.findViewById(R.id.layout_app_qvideo) as View?
            layoutQvideo?.setOnClickListener {
                launchAppOrInstall(context, "com.tencent.qqlive")
                ReportUtils.AddEventReport(ReportUtils.EVENT_TENCENT_VIDEO_CLICK, 0, "")
            }


            val layoutAiqiyi = result.findViewById(R.id.layout_app_aiqiyi) as View?
            layoutAiqiyi?.setOnClickListener {
                launchAppOrInstall(context, "com.qiyi.video")
                ReportUtils.AddEventReport(ReportUtils.EVENT_AIQIYI_CLICK, 0, "")
            }

            val layoutYouku = result.findViewById(R.id.layout_app_youku) as View?
            layoutYouku?.setOnClickListener {
                launchAppOrInstall(context, "com.youku.phone")
                ReportUtils.AddEventReport(ReportUtils.EVENT_YOUKU_CLICK, 0, "")
            }

            val btnCancel = result.findViewById(R.id.btn_cancel) as View?
            btnCancel?.setOnClickListener {
                result.dismiss()
            }

        } catch (e: Exception) {
            Logger.t(TAG).e("createChooseAppDialog e = $e")
        }

        return result
    }


    fun launchAppOrInstall(context: Context, packageName: String) {
        Logger.t(TAG).d("launchAppOrInstall packageName = $packageName")
        if (isAppInstalled(context, packageName)) {
            Logger.t(TAG).d("launchAppOrInstall app is installed, launch")
            launchApp(context, packageName, false)
        } else {
            Logger.t(TAG).d("launchAppOrInstall app is not installed, try to install")
            tryInstallInMarket(context, packageName)
        }
    }


    fun isAppInstalled(context: Context, packageName: String): Boolean {
        return try {
            val packageManager = context.applicationContext.packageManager
            packageManager.getApplicationInfo(packageName, 0) != null
        } catch (e: Exception) {
            Logger.t(TAG).e("isAppInstalled e = $e")
            false
        }
    }

    fun launchApp(context: Context, packageName: String, isNewTask: Boolean) {
        if (TextUtils.isEmpty(packageName)) {
            Logger.t(TAG).e("launchApp packageName is null")
            return
        }

        val intent: Intent? = getLaunchAppIntent(context, packageName, isNewTask)
        if (intent == null) {
            Logger.t(TAG).e("launchApp intent is null")
            return
        }

        context.applicationContext.startActivity(intent)
    }

    fun getLaunchAppIntent(context: Context, packageName: String, isNewTask: Boolean): Intent? {
        val intent = context.applicationContext.packageManager.getLaunchIntentForPackage(packageName)
                ?: return null
        return if (isNewTask) intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK) else intent
    }


    fun tryInstallInMarket(context: Context, packageName: String) {
        try {
            val uri = Uri.parse("market://details?id=$packageName")
            val intent = Intent(Intent.ACTION_VIEW, uri)
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            context.applicationContext.startActivity(intent)
        } catch (e: Exception) {
            Toast.makeText(context, context.getString(R.string.wecast_not_install_appstore), Toast.LENGTH_SHORT).show()
            Logger.t(TAG).e("tryInstallInMarket e = $e")
        }
    }

}