package com.tencent.wecast.sender.cloud.utils

import android.app.Activity
import android.content.Intent
import com.tencent.wecast.*
import com.tencent.wecast.jni.JniHelper
import com.tencent.wecast.jni.ParamsPackage
import com.tencent.wecast.sender.SenderJ2CppService
import com.tencent.wecast.sender.WeCastUserManager
import com.tencent.wecast.sender.cloud.activity.CloudMainActivity1
import com.tencent.wecast.sender.cloud.activity.CloudMainActivity2
import com.tencent.wecast.sender.cloud.activity.CloudSplashActivity
import com.tencent.wecast.sender.cloud.config.SenderCompileConfig
import com.tencent.wecast.sender.cloud.config.SenderUIIdMapping
import com.tencent.wecast.utils.DeviceInfoUtil
import com.tencent.wecast.utils.Logger

class CloudUtil {
    companion object {
        private const val TAG = "CloudUtil"

        /**
         * 跳转到WeCast SplashActivity
         */
        internal fun jump2WeCastPinPage(activity: Activity,
                                        corpId: String,
                                        authCode: String,
                                        userName: String,
                                        usingMirror: Boolean) {
            startWeCast(
                    corpId,
                    userName,
                    authCode,
                    activity,
                    false,
                    usingMirror)
        }

        /**
         * 直接跳转到WeCast MainActivity
         */
        internal fun jump2WeCastPage(activity: Activity) {
            if (WeCastConfigManager.getInstance().isLanScheme) {
                activity.startActivity(Intent(activity, CloudMainActivity1::class.java))
            } else {
                activity.startActivity(Intent(activity, CloudMainActivity2::class.java))
            }
        }

        internal fun setLimitSSID(ssid: String) {
            CloudMainActivity1.mLimitedSsidComb = ssid
        }

        private fun startWeCast(corpId: String, userName: String, authCode: String,
                                activity: Activity,
                                isInitialized: Boolean,
                                usingMirror: Boolean) {
            val context = activity.applicationContext
            WeCastAppContext.init(context)
            WeCastEnv.initEnv()
            WeCastConfigManager.getInstance().init(context, WeCastConfigManager.TYPE_SENDER)
            WeCastDeviceManager.getInstance().init(context)
            WeCastUserManager.getInstance().init(context)

            JniHelper.init(context)
            SenderJ2CppService.getInstance().register()

            WeCastUIConfigManager.getInstance().initialUIIdMapping(SenderUIIdMapping())
            WeCastUIConfigManager.getInstance().setTemplateId(SenderCompileConfig.getDefaultTId())
            WeCastUIConfigManager.getInstance().readLocalConfig()

            val deviceID = DeviceInfoUtil.getAndroidId(context)

            JniMethod.initSender(
                    SenderCompileConfig.SENDER_APP_TYPE,
                    corpId,
                    authCode,
                    WeCastConfigManager.getInstance().languageType,
                    SenderCompileConfig.SENDER_UI_VERSION,
                    usingMirror)

            val intent = Intent(activity, CloudSplashActivity::class.java)
            Logger.t(TAG).d("isInitialized: $isInitialized")
            intent.putExtra("isInitialized", isInitialized)
            intent.putExtra(CloudSplashActivity.DEVICE_NAME_KEY, userName)
            activity.startActivity(intent)

            Logger.t(TAG).d("initialed WeCastSender4Cloud. device id:$deviceID")
        }
    }


    class JniMethod {
        companion object {
            val TAG = "JniMethod"

            fun getSDKVersion(): String {
                Logger.t(TAG).d("getSDKVersion")
                val result: ParamsPackage.ParamsFromCpp? = JniHelper.callJniFunc("getSDKVersion")
                return result?.next.toString()
            }

            @JvmStatic
            fun initSender(appType: Int,
                           corpId: String,
                           auth: String,
                           language: Int,
                           uiVersion: Int,
                           usingMirror: Boolean) {
                Logger.t(TAG).d("initSender appType = $appType " +
                        "| corpId = $corpId | language = $language" +
                        "| uiVersion = $uiVersion" +
                        "| usingXCast = $usingMirror")
                JniHelper.callJniFunc("initSender", appType, corpId, auth, language, uiVersion, usingMirror)
            }

            fun unInitSender() {
                Logger.t(TAG).d("unInitSender")
                JniHelper.callJniFunc("unInitSender")
            }

            fun login(nickName: String) {
                Logger.t(TAG).d("login env = " + WeCastEnv.getCurrentEnv() + " | nickName = " + nickName)
                JniHelper.callJniFunc("login", WeCastEnv.getCurrentEnv(), nickName)
            }


            fun enterCast(pinCode: String) {
                Logger.t(TAG).d("enterCast pinCode = $pinCode")
                JniHelper.callJniFunc("enterCast", pinCode)
            }

            fun addCast(pinCode: String) {
                Logger.t(TAG).d("addCast pinCode = $pinCode")
                JniHelper.callJniFunc("addCast", pinCode)
            }

            fun exitCast(exitType: Int) {
                Logger.t(TAG).d("exitCast exitType = $exitType")
                JniHelper.callJniFunc("exitCast", exitType)
            }

            fun recoverCast(isCancel: Boolean) {
                Logger.t(TAG).d("recoverCast isCancel = $isCancel")
                JniHelper.callJniFunc("recoverCast", isCancel)
            }

            fun showFeatureGuide(guideType: Int) {
                Logger.t(TAG).d("showFeatureGuide guideType = $guideType")
                JniHelper.callJniFunc("showFeatureGuide", guideType)
            }
        }
    }
}