package com.tencent.wecast;

public class WeCastConstant {
    public static final String WECAST_VERSION = "2.1.0.15";

    public static class WeCastAppType {
        public final static int TYPE_UNKNOW = 0;
        public final static int TYPE_TENCENTIT = 1;
        public final static int TYPE_WXWORKTENCENT = 2;
        public final static int TYPE_WXWORKOPEN = 3;
        public final static int TYPE_WECASTOPEN = 4;
        public final static int TYPE_WECASTPRIVATE = 5;
    }

    public static class WeCastInsId {
        public final static int ID_DEFAULT = 0;
        public final static int ID_WINDOWS_SENDER = 1;
        public final static int ID_MACOS_SENDER = 2;
        public final static int ID_ANDROID_RECEIVER = 3;
        public final static int ID_IOS_SENDER = 4;
        public final static int ID_WEB_SENDER = 5;
        public final static int ID_ANDROID_SENDER = 6;
        public final static int ID_WINDOWS_RECEIVER = 7;
    }

    public static String getPlatform(int insId) {
        switch (insId) {
            case WeCastInsId.ID_WINDOWS_SENDER:
            case WeCastInsId.ID_WINDOWS_RECEIVER:
                return "Windows";
            case WeCastInsId.ID_ANDROID_RECEIVER:
            case WeCastInsId.ID_ANDROID_SENDER:
                return "Android";
            case WeCastInsId.ID_IOS_SENDER:
                return "iOS";
            case WeCastInsId.ID_MACOS_SENDER:
                return "Mac";
            case WeCastInsId.ID_WEB_SENDER:
                return "Web";
            default:
                return "unknown";
        }
    }

    public static boolean isReceiver(int insId) {
        return insId == WeCastInsId.ID_WINDOWS_RECEIVER || insId == WeCastInsId.ID_ANDROID_RECEIVER;
    }

    public static boolean isApplePlatform(int insId) {
        return insId == WeCastInsId.ID_IOS_SENDER
                || insId == WeCastInsId.ID_MACOS_SENDER;
    }

    public static class LanguageType {
        public final static int ZH_CN = 0;
        public final static int ZH_TW = 1;
        public final static int EN_US = 2;
    }

    public static class WeCastExitType {
        public final static int EXIT_NORMAL = 0;      //  正常退出
        public final static int BOOK_COVER = 80021;  //  合盖子退出
        public final static int INVITE_TIMEOUT = 80018;  //  tv邀请超时（5s）
        public final static int TERMINATE_APP = 80022;  //  app被强杀
        public final static int REPLAYKIT_STOP = 80025;  //  iosReplayKit停止
        public final static int IOS_SCREEN_LOCK = 80024;  //  ios锁屏
        public final static int HEARTBEAT_TIMEOUT = 80009;  //  心跳超时
        public final static int USER_CHANGE_AFTER_RECONNECT = 80052;  //  重连后发现对端断开
        public final static int EXIT_BY_COUNTDOWN = 80023;  //  10s
        public final static int MEMBER_LIST_CHANGE = 80017;
        public final static int WIN_LOCK = 80031;
        public static final int NO_FIRST_FRAME_EXIT = 80033;  // 接收端进房未出现首帧倒计时退出
    }


    public static class WeCastFeatureGuide {
        public final static int FEATURE_GUIDE_UNKNOWN = -1;
        public final static int FEATURE_HIDE = 0;
        // @deprecated
        public final static int FEATURE_GUIDE_ANDROID_STREAMING = 1;
        // @deprecated
        public final static int FEATURE_GUIDE_ANDROID_MIRRORING_LISTING = 2;
        public final static int FEATURE_GUIDE_ANDROID_MIRRORING_UNKNOWN = 3;
        public final static int FEATURE_DLNA_STREAMING = 4;
        public final static int FEATURE_AIRPLAY_STREAMING = 5;
        public final static int FEATURE_AIRPLAY_MIRRORING_UP = 6;
        public final static int FEATURE_AIRPLAY_MIRRORING_DOWN = 7;
        public final static int FEATURE_REPLAYKIT_MIRRORING_UP = 8;
        public final static int FEATURE_REPLAYKIT_MIRRORING_DOWN = 9;
        public final static int FEATURE_WAITING_RECOVERY = 10;
    }
}
