package com.tencent.wecast.utils;

import android.content.Context;
import android.os.Environment;

import java.io.File;

public class StorageUtil {
    private static final String XCAST_CONF_FILE_PREFIX = "wecast_";
    private static final String XCAST_CONF_DIR = "xcast_conf";
    private static final String XCAST_CONF_ASSETS_FILE_PATH = "wecast.conf";

    private static String getPackageName(Context context) {
        return context.getApplicationContext().getPackageName();
    }

    // 获取Wmp外置存储根路径
    public static String getWmpRootPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath()
                + File.separatorChar + "Tencent"
                + File.separatorChar + "Wmp";
    }

    // 获取Wmp外置存储的temp路径
    public static String getWmpTempPath() {
        return getWmpRootPath()
                + File.separatorChar + "temp";
    }

    // 获取Wmp外置存储的name的全路径
    public static String getWmpExternalPath(Context context, String name) {
        return getWmpRootPath()
                + File.separatorChar + getPackageName(context)
                + File.separatorChar + name;
    }

    // 获取xcast配置目录的路径
    public static String getXCastConfigDirPath(Context context) {
        return getWmpRootPath()
                + File.separatorChar + getPackageName(context)
                + File.separatorChar + XCAST_CONF_DIR;
    }

    // 获取外置存在中xcast配置文件所在路径
    public static String getXCastConfFilePath(Context context) {
        String sdkVersion = WeCastUtil.getWmpSdkVersion();
        return getXCastConfigDirPath(context)
                + File.separatorChar + XCAST_CONF_FILE_PREFIX + sdkVersion + ".conf";
    }

    // 获取assets中存储的xcast配置文件名
    public static String getAssetsXCastName() {
        return XCAST_CONF_ASSETS_FILE_PATH;
    }

    // log日志存储路径
    public static String getWmpLogDirPath(Context context) {
        return getWmpRootPath()
                + File.separatorChar + getPackageName(context)
                + File.separatorChar + "log";
    }

    // config存储路径
    public static String getWmpConfigDirPath(Context context) {
        return context.getFilesDir().getAbsolutePath();
    }

    // 获取db存储路径
    public static String getWmpDbDirPath(Context context) {
        return context.getDatabasePath("wmp").getAbsolutePath();
    }

    // 获取/data/data/package_name/dirName路径
    public static String getWmpDirPath(Context context, String dirName) {
        return context.getDir(dirName, Context.MODE_PRIVATE).getAbsolutePath();
    }

    // 获取Wmp/pkgName/conf路径
    @SuppressWarnings("ResultOfMethodCallIgnored")
    public static String getCloudConfigPath(Context context) {
        String configDirPath = getWmpExternalPath(context, "config");
        File configDir = new File(configDirPath);
        if (configDir.exists()) {
            if (configDir.isFile()) {
                configDir.delete();
                configDir.mkdirs();
            }
        } else {
            configDir.mkdirs();
        }
        return configDirPath;
    }
}
