package com.tencent.wecast.sender.eb;

import com.tencent.wecast.BaseEBHandle;
import com.tencent.wecast.jni.ParamsPackage;

import org.greenrobot.eventbus.EventBus;

import java.io.IOException;

public class SenderEventsHandle extends BaseEBHandle {
    @Override
    protected void handleEvent(int eventType, ParamsPackage.ParamsFromCpp params) throws IOException {
        switch (eventType) {
            case SenderEvents.TypeUIConfigUpdate:
                EventBus.getDefault().postSticky(SenderEvents.EUIConfigUpdate.from(params));
                break;
            case SenderEvents.TypeLoginSuccess:
                EventBus.getDefault().post(SenderEvents.ELoginSuccess.from(params));
                break;
            case SenderEvents.TypeEnterLoading:
                EventBus.getDefault().post(SenderEvents.EEnterLoading.from(params));
                break;
            case SenderEvents.TypeClearEdit:
                EventBus.getDefault().post(SenderEvents.EClearEdit.from(params));
                break;
            case SenderEvents.TypeEditFocus:
                EventBus.getDefault().post(SenderEvents.EEditFocus.from(params));
                break;
            case SenderEvents.TypeShowError:
                EventBus.getDefault().postSticky(SenderEvents.EShowError.from(params));
                break;
            case SenderEvents.TypePushToCastingView:
                EventBus.getDefault().post(SenderEvents.EPushToCastingView.from(params));
                break;
            case SenderEvents.TypeAppUpdate:
                EventBus.getDefault().post(SenderEvents.EAppUpdate.from(params));
                break;
            case SenderEvents.TypeLoginFailed:
                EventBus.getDefault().post(SenderEvents.ELoginFailed.from(params));
                break;
            case SenderEvents.TypeCanRecover:
                EventBus.getDefault().postSticky(SenderEvents.ECanRecover.from(params));
                break;
            case SenderEvents.TypeNetWorkStateTips:
                EventBus.getDefault().post(SenderEvents.ENetWorkStateTips.from(params));
                break;
            case SenderEvents.TypeDisconnectPopup:
                EventBus.getDefault().post(SenderEvents.EDisconnectPopup.from(params));
                break;
            case SenderEvents.TypeStreamReconnect:
                EventBus.getDefault().post(SenderEvents.EStreamReconnect.from(params));
                break;
            case SenderEvents.TypeNetworkStateGridChange:
                EventBus.getDefault().post(SenderEvents.ENetworkStateGridChange.from(params));
                break;
            case SenderEvents.TypeExitCastView:
                EventBus.getDefault().postSticky(SenderEvents.EExitCastView.from(params));
                break;
            case SenderEvents.TypeAddCastSuccess:
                EventBus.getDefault().post(SenderEvents.EAddCastSuccess.from(params));
                break;
            case SenderEvents.TypeAddCastFailed:
                EventBus.getDefault().post(SenderEvents.EAddCastFailed.from(params));
                break;
            case SenderEvents.TypeMemberListViewRefresh:
                EventBus.getDefault().post(SenderEvents.EMemberListViewRefresh.from(params));
                break;
            case SenderEvents.TypeUpdateReceiverMember:
                EventBus.getDefault().postSticky(SenderEvents.EUpdateReceiverMember.from(params));
                break;
            case SenderEvents.TypeMultiCastDiscovery:
                EventBus.getDefault().postSticky(SenderEvents.EMultiCastDiscovery.from(params));
                break;
            case SenderEvents.TypeC2CMessage:
                EventBus.getDefault().post(SenderEvents.EC2CMessage.from(params));
                break;
            case SenderEvents.TypeShowTips:
                EventBus.getDefault().post(SenderEvents.EShowTips.from(params));
                break;
            case SenderEvents.TypeXCastPause:
                EventBus.getDefault().postSticky(SenderEvents.EXCastPause.from(params));
                break;
            case SenderEvents.TypeAuthCodeError:
                EventBus.getDefault().post(SenderEvents.EAuthCodeError.from(params));
                break;
        }
    }


}
