/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.avlab.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.text.TextUtils;
import com.tencent.avlab.utils.QLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SoUtil {
    private static final String TAG = "SoUtil";
    private static final String SO_SP = "so_sp";
    private static final String KEY_APK_SIZE = "key_apk_size";
    private static final String KEY_APP_VERSION = "key_app_version";
    private static final String KEY_APK_UPDATE_TIME = "key_apk_update_time";
    private static Context ctx;
    private static boolean copySoFromAssets = false;
    private static int extractSoError = 0;
    public static String customLibPath;

    public static void setAppContext(Context context) {
        ctx = context;
    }

    public static Context getAppContext() {
        return ctx;
    }

    public static void releaseAppContext() {
        ctx = null;
    }

    public static void setCopySoInfo(boolean bl) {
        copySoFromAssets = bl;
    }

    public static boolean getCopySoInfo() {
        return copySoFromAssets;
    }

    public static boolean loadSo(String string) {
        block14: {
            if (customLibPath != null) {
                StringBuilder stringBuilder = new StringBuilder().append(customLibPath);
                StringBuilder stringBuilder2 = stringBuilder.append("/lib").append(string);
                try {
                    System.load(stringBuilder2.append(".so").toString());
                    return true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (!QLog.isColorLevel()) break block14;
                    String string2 = "loadSo from customLibPath(" + customLibPath + ") failed: " + unsatisfiedLinkError.getMessage();
                    QLog.d(TAG, 0, string2);
                }
            }
        }
        if (SoUtil.getCopySoInfo() && SoUtil.LoadExtractedSo(string)) {
            return true;
        }
        try {
            System.loadLibrary(string);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            StringBuilder stringBuilder;
            if (QLog.isColorLevel()) {
                String string3 = "loadSo from APP Path failed: " + unsatisfiedLinkError.getMessage();
                QLog.d(TAG, 0, string3);
            }
            try {
                stringBuilder = new StringBuilder();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                if (QLog.isColorLevel()) {
                    String string4 = "loadSo from System Path failed: " + unsatisfiedLinkError2.getMessage();
                    QLog.d(TAG, 0, string4);
                }
                return false;
            }
            StringBuilder stringBuilder3 = stringBuilder.append("/system/lib/lib").append(string);
            System.load(stringBuilder3.append(".so").toString());
            return true;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int extractAVModulesFromAssets() {
        block17: {
            block19: {
                block18: {
                    block16: {
                        var0 = SoUtil.ctx.getSharedPreferences("so_sp", 0);
                        var1_1 /* !! */  = SoUtil.ctx.getPackageManager();
                        var2_2 = var0.getString("key_app_version", "");
                        var3_3 = var0.getLong("key_apk_size", -1L);
                        var5_4 = var0.getLong("key_apk_update_time", -1L);
                        var7_5 = true;
                        var8_6 = "";
                        var9_7 = -1L;
                        var11_8 = -1L;
                        if (QLog.isColorLevel()) {
                            var13_9 /* !! */  = "local version = " + var2_2 + ", lastUpdateApkSize = " + var3_3 + ", lastUpdateApkTime = " + var5_4;
                            QLog.d("SoUtil", 0, (String)var13_9 /* !! */ );
                        }
                        try {
                            v0 = var1_1 /* !! */ ;
                            var1_1 /* !! */  = v0.getApplicationInfo(SoUtil.ctx.getPackageName(), 0);
                            var13_9 /* !! */  = v0.getPackageInfo(SoUtil.ctx.getPackageName(), 0);
                            var14_10 = v1;
                            if (!new File(var1_1 /* !! */ .sourceDir).exists()) break block16;
                            v2 = var14_10;
                            v3 = v2;
                            var14_11 = v2.length();
                        }
                        catch (PackageManager.NameNotFoundException v4) {
                            v5 = var9_7;
                            var9_7 = var11_8;
                            var14_11 = v5;
                            var1_1 /* !! */  = var8_6;
                            break block17;
                        }
                        try {
                            var9_7 = v3.lastModified();
                            break block18;
                        }
                        catch (PackageManager.NameNotFoundException v4) {
                            var9_7 = var11_8;
                            var1_1 /* !! */  = var8_6;
                            break block17;
                        }
                    }
                    v6 = var9_7;
                    var9_7 = var11_8;
                    var14_11 = v6;
                }
                if (var13_9 /* !! */  != null) {
                    try {
                        var1_1 /* !! */  = var13_9 /* !! */ .versionName + "." + var13_9 /* !! */ .versionCode;
                        break block19;
                    }
                    catch (PackageManager.NameNotFoundException v4) {
                        var1_1 /* !! */  = var8_6;
                        break block17;
                    }
                }
                var1_1 /* !! */  = var8_6;
            }
            if (var14_11 != var3_3) ** GOTO lbl55
            try {
                if (var2_2.equals(var1_1 /* !! */ ) && var9_7 == var5_4) {
                    var7_5 = false;
                }
lbl55:
                // 4 sources

                if (QLog.isColorLevel()) {
                    QLog.d("SoUtil", 0, "apk version = " + (String)var1_1 /* !! */  + ", apksize = " + var14_11 + ", apkTime = " + var9_7 + ", needupdate = " + var7_5);
                }
            }
            catch (PackageManager.NameNotFoundException v4) {
            }
        }
        v4.printStackTrace();
        if (SoUtil.extractLibraryFromAssert("hwcodec", var7_5) == false) return SoUtil.extractSoError;
        if (SoUtil.extractLibraryFromAssert("traeimp-armeabi-v7a", var7_5) == false) return SoUtil.extractSoError;
        if (SoUtil.extractLibraryFromAssert("qav_graphics", var7_5) == false) return SoUtil.extractSoError;
        if (SoUtil.extractLibraryFromAssert("qavsdk", var7_5) == false) return SoUtil.extractSoError;
        if (SoUtil.extractLibraryFromAssert("stlport_shared", var7_5) == false) return SoUtil.extractSoError;
        if (SoUtil.extractLibraryFromAssert("TcVpxDec", var7_5) == false) return SoUtil.extractSoError;
        if (SoUtil.extractLibraryFromAssert("TcVpxEnc", var7_5) == false) return SoUtil.extractSoError;
        if (SoUtil.extractLibraryFromAssert("xplatform", var7_5) == false) return SoUtil.extractSoError;
        if (SoUtil.extractLibraryFromAssert("UDT", var7_5) == false) return SoUtil.extractSoError;
        if (!TextUtils.isEmpty((CharSequence)var1_1 /* !! */ )) {
            var0.edit().putString("key_app_version", (String)var1_1 /* !! */ ).commit();
        }
        if (var14_11 > 0L) {
            var0.edit().putLong("key_apk_size", var14_11).commit();
        }
        if (var9_7 <= 0L) return 0;
        var0.edit().putLong("key_apk_update_time", var9_7).commit();
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean LoadExtractedSo(String string) {
        boolean bl;
        Object object;
        if (QLog.isColorLevel()) {
            object = "start LoadExtractedSo: " + string;
            QLog.i(TAG, 0, (String)object);
        }
        StringBuilder stringBuilder = new StringBuilder().append(ctx.getFilesDir().getParent());
        try {
            System.load(stringBuilder.append("/txav/").append(SoUtil.getLibActualName(string)).toString());
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            File file;
            object = file;
            if (new File(ctx.getFilesDir().getParent() + "/txav/" + SoUtil.getLibActualName(string)).exists()) {
                ((File)object).delete();
            }
            SoUtil.extractLibraryFromAssert(string, true);
            StringBuilder stringBuilder2 = new StringBuilder().append(ctx.getFilesDir().getParent());
            try {
                System.load(stringBuilder2.append("/txav/").append(SoUtil.getLibActualName(string)).toString());
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                bl = false;
            }
        }
        if (!bl) {
            if (QLog.isColorLevel()) {
                String string2 = "finally try to use system way to load so: " + string;
                QLog.d(TAG, 0, string2);
            }
            try {
                System.loadLibrary(string);
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        if (bl) return bl;
        string = "LoadExtractedSo failed: " + string;
        QLog.e(TAG, 1, string);
        return bl;
    }

    private static long getAvailableInternalMemorySize() {
        File file = Environment.getDataDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        return (long)statFs.getAvailableBlocks() * l2;
    }

    private static String getLibActualName(String string) {
        return "lib" + string + ".so";
    }

    private static String getLibPath() {
        return "lib/armeabi/";
    }

    private static String getTxlibPath() {
        File file = ctx.getFilesDir();
        if (file == null) {
            if (QLog.isColorLevel()) {
                QLog.i(TAG, 0, "getFilesDir is null");
            }
            return "";
        }
        return file.getParent() + "/txav/";
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized boolean extractLibraryFromAssert(String string, boolean bl) {
        boolean bl2;
        long l2;
        block56: {
            boolean bl3;
            block55: {
                void var0_5;
                FileOutputStream fileOutputStream;
                Object object;
                block51: {
                    block54: {
                        Object object2;
                        Object object3;
                        block52: {
                            Object var9_23;
                            FileOutputStream fileOutputStream2;
                            String string2;
                            block45: {
                                block48: {
                                    block53: {
                                        Object object4;
                                        block50: {
                                            block49: {
                                                boolean bl4;
                                                block46: {
                                                    block47: {
                                                        File file;
                                                        File file2;
                                                        bl3 = false;
                                                        string2 = "";
                                                        bl4 = false;
                                                        object4 = SoUtil.getTxlibPath();
                                                        if (TextUtils.isEmpty((CharSequence)object4)) {
                                                            return false;
                                                        }
                                                        object3 = file2;
                                                        file2 = new File((String)object4 + SoUtil.getLibActualName(string));
                                                        if (!bl && ((File)object3).exists()) {
                                                            boolean bl5;
                                                            if (!QLog.isColorLevel()) return bl5;
                                                            QLog.d(TAG, 0, "extractLibraryFromAssert, no need update");
                                                            bl5 = true;
                                                            return bl5;
                                                        }
                                                        File file3 = object3;
                                                        l2 = SystemClock.uptimeMillis();
                                                        file3.delete();
                                                        if (file3.exists()) break block55;
                                                        fileOutputStream2 = null;
                                                        var9_23 = null;
                                                        object = file;
                                                        if (!new File((String)object4).exists() && !((File)object).mkdir()) {
                                                            object = var9_23;
                                                            fileOutputStream = fileOutputStream2;
                                                            break block45;
                                                        }
                                                        if (QLog.isColorLevel()) {
                                                            QLog.d(TAG, 0, "extractLibraryFromAssert, getAssets = " + SoUtil.getLibPath() + SoUtil.getLibActualName(string));
                                                        }
                                                        object = ctx.getAssets().open(SoUtil.getLibPath() + SoUtil.getLibActualName(string));
                                                        try {
                                                            if (SoUtil.getAvailableInternalMemorySize() >= (long)((InputStream)object).available()) break block46;
                                                            bl4 = true;
                                                            extractSoError = -1;
                                                            if (QLog.isColorLevel()) {
                                                                QLog.d(TAG, 0, "extractLibraryFromAssert, memory is not enough, available = " + SoUtil.getAvailableInternalMemorySize() + ", so = " + ((InputStream)object).available());
                                                            }
                                                            break block46;
                                                        }
                                                        catch (FileNotFoundException fileNotFoundException) {
                                                            break block47;
                                                        }
                                                        catch (FileNotFoundException fileNotFoundException) {
                                                            object = var9_23;
                                                        }
                                                    }
                                                    bl3 = true;
                                                }
                                                if (bl4 || bl3) break block48;
                                                if (object == null) break block49;
                                                try {
                                                    FileOutputStream fileOutputStream3;
                                                    fileOutputStream = fileOutputStream3;
                                                    fileOutputStream3 = new FileOutputStream((String)object4 + SoUtil.getLibActualName(string), true);
                                                    break block50;
                                                }
                                                catch (Throwable throwable) {
                                                    fileOutputStream = fileOutputStream2;
                                                    break block51;
                                                }
                                                catch (IOException iOException) {
                                                    fileOutputStream = fileOutputStream2;
                                                    bl2 = bl3;
                                                    object2 = string2;
                                                    break block52;
                                                }
                                            }
                                            fileOutputStream = fileOutputStream2;
                                        }
                                        long l3 = 0L;
                                        try {
                                            int n2;
                                            object4 = new byte[32768];
                                            while (object != null && (n2 = ((InputStream)object).read((byte[])object4, 0, ((Object)object4).length)) != -1) {
                                                fileOutputStream.write((byte[])object4, 0, n2);
                                                l3 += (long)n2;
                                            }
                                            if (QLog.isColorLevel()) {
                                                QLog.d(TAG, 0, "extractLibraryFromAssert, copy success");
                                            }
                                            if (!((File)object3).exists()) break block45;
                                            if (l3 == ((File)object3).length()) break block53;
                                            ((File)object3).delete();
                                            object3 = string2 + "copy asset so fail. file size not match";
                                            bl3 = false;
                                        }
                                        catch (IOException iOException) {
                                            bl2 = bl3;
                                            object2 = string2;
                                            break block52;
                                        }
                                        try {
                                            if (QLog.isColorLevel()) {
                                                QLog.d(TAG, 0, (String)object3);
                                            }
                                            break block45;
                                        }
                                        catch (IOException iOException) {
                                            bl2 = bl3;
                                            object2 = object3;
                                            object3 = iOException;
                                            break block52;
                                        }
                                    }
                                    bl3 = true;
                                    if (QLog.isColorLevel()) {
                                        QLog.d(TAG, 0, "extractLibraryFromAssert " + string + " success");
                                    }
                                    break block45;
                                }
                                fileOutputStream = fileOutputStream2;
                            }
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (object != null) {
                                try {
                                    ((InputStream)object).close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block55;
                            catch (Throwable throwable) {
                                object = var9_23;
                                fileOutputStream = fileOutputStream2;
                                break block51;
                            }
                            catch (IOException iOException) {
                                object = var9_23;
                                fileOutputStream = fileOutputStream2;
                                bl2 = bl3;
                                object2 = string2;
                            }
                        }
                        if (QLog.isColorLevel()) {
                            QLog.d(TAG, 0, (String)object2, (Exception)object3);
                        }
                        if (QLog.isColorLevel()) {
                            QLog.d(TAG, 0, "extractLibraryFromAssert, e = " + ((Throwable)object3).toString());
                        }
                        extractSoError = -1;
                        if (fileOutputStream == null) break block54;
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block56;
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (object == null) throw var0_5;
                try {
                    ((InputStream)object).close();
                    throw var0_5;
                }
                catch (IOException iOException) {}
                throw var0_5;
            }
            bl2 = bl3;
        }
        long l4 = SystemClock.uptimeMillis() - l2;
        if (!QLog.isColorLevel()) return bl2;
        string = "extract so " + string + " from assets, spend time: " + l4;
        QLog.d(TAG, 0, string);
        return bl2;
    }
}

