/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sharp.jni;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import com.tencent.avlab.utils.QLog;
import com.tencent.sharp.jni.TraeAudioCodecList;
import com.tencent.sharp.jni.TraeAudioManager;
import com.tencent.sharp.jni.TraeAudioSession;
import com.tencent.sharp.jni.VivoKTVHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=16)
public class AudioDeviceInterface {
    private static boolean _dumpEnable = false;
    private static boolean _logEnable = true;
    private static String[] mDeviceList;
    private static VivoKTVHelper mVivoKTVHelper;
    private static boolean isSupportVivoKTVHelper = false;
    public static final int OUTPUT_MODE_HEADSET = 0;
    public static final int OUTPUT_MODE_SPEAKER = 1;
    private AudioTrack _audioTrack;
    private AudioRecord _audioRecord;
    private int _streamType;
    private int _playSamplerate;
    private int _channelOutType;
    private int _audioSource;
    private int _deviceStat;
    private int _sceneMode;
    private int _sessionId;
    private Context _context;
    private int _modePolicy;
    private int _audioSourcePolicy;
    private int _audioStreamTypePolicy;
    private AudioManager _audioManager;
    private ByteBuffer _playBuffer;
    private ByteBuffer _recBuffer;
    private ByteBuffer _decBuffer0;
    private ByteBuffer _decBuffer1;
    private ByteBuffer _decBuffer2;
    private ByteBuffer _decBuffer3;
    private ByteBuffer _decBuffer4;
    private ByteBuffer _decBuffer5;
    private ByteBuffer _decBuffer6;
    private ByteBuffer _decBuffer7;
    private ByteBuffer _decBuffer8;
    private ByteBuffer _decBuffer9;
    private ByteBuffer _decBuffer10;
    private byte[] _tempBufPlay;
    private byte[] _tempBufRec;
    private boolean _doPlayInit;
    private boolean _doRecInit;
    private boolean _isRecording;
    private boolean _isPlaying;
    private int _bufferedRecSamples;
    private int _bufferedPlaySamples;
    private int _playPosition;
    private File _rec_dump;
    private File _play_dump;
    private FileOutputStream _rec_out;
    private FileOutputStream _play_out;
    private int nRecordLengthMs;
    private int nPlayLengthMs;
    private TraeAudioCodecList _traeAudioCodecList;
    private TraeAudioSession _as;
    private String _connectedDev;
    private boolean _audioRouteChanged;
    private ReentrantLock _prelock;
    private Condition _precon;
    private boolean _preDone;
    private boolean usingJava;
    private int switchState;
    private String deviceConnectedName;
    private TraeAudioSession _asAudioManager;

    public AudioDeviceInterface() {
        String string;
        block18: {
            AudioDeviceInterface audioDeviceInterface = this;
            audioDeviceInterface._audioTrack = null;
            audioDeviceInterface._audioRecord = null;
            audioDeviceInterface._streamType = 0;
            audioDeviceInterface._playSamplerate = 8000;
            audioDeviceInterface._channelOutType = 4;
            audioDeviceInterface._audioSource = 0;
            audioDeviceInterface._deviceStat = 0;
            audioDeviceInterface._sceneMode = 0;
            audioDeviceInterface._sessionId = 0;
            audioDeviceInterface._context = null;
            audioDeviceInterface._modePolicy = -1;
            audioDeviceInterface._audioSourcePolicy = -1;
            audioDeviceInterface._audioStreamTypePolicy = -1;
            audioDeviceInterface._audioManager = null;
            audioDeviceInterface._doPlayInit = true;
            audioDeviceInterface._doRecInit = true;
            audioDeviceInterface._isRecording = false;
            audioDeviceInterface._isPlaying = false;
            audioDeviceInterface._bufferedRecSamples = 0;
            audioDeviceInterface._bufferedPlaySamples = 0;
            audioDeviceInterface._playPosition = 0;
            audioDeviceInterface._rec_dump = null;
            audioDeviceInterface._play_dump = null;
            audioDeviceInterface._rec_out = null;
            audioDeviceInterface._play_out = null;
            audioDeviceInterface.nRecordLengthMs = 0;
            audioDeviceInterface.nPlayLengthMs = 0;
            audioDeviceInterface._traeAudioCodecList = null;
            audioDeviceInterface._as = null;
            audioDeviceInterface._connectedDev = "DEVICE_NONE";
            audioDeviceInterface._audioRouteChanged = false;
            audioDeviceInterface._prelock = new ReentrantLock();
            audioDeviceInterface._precon = audioDeviceInterface._prelock.newCondition();
            audioDeviceInterface._preDone = false;
            audioDeviceInterface.usingJava = true;
            audioDeviceInterface.switchState = 0;
            audioDeviceInterface.deviceConnectedName = "";
            audioDeviceInterface._asAudioManager = null;
            audioDeviceInterface._playBuffer = ByteBuffer.allocateDirect(1920);
            audioDeviceInterface._recBuffer = ByteBuffer.allocateDirect(1920);
            audioDeviceInterface._decBuffer0 = ByteBuffer.allocateDirect(3840);
            audioDeviceInterface._decBuffer1 = ByteBuffer.allocateDirect(3840);
            audioDeviceInterface._decBuffer2 = ByteBuffer.allocateDirect(3840);
            audioDeviceInterface._decBuffer3 = ByteBuffer.allocateDirect(3840);
            audioDeviceInterface._decBuffer4 = ByteBuffer.allocateDirect(3840);
            audioDeviceInterface._decBuffer5 = ByteBuffer.allocateDirect(3840);
            audioDeviceInterface._decBuffer6 = ByteBuffer.allocateDirect(3840);
            audioDeviceInterface._decBuffer7 = ByteBuffer.allocateDirect(3840);
            audioDeviceInterface._decBuffer8 = ByteBuffer.allocateDirect(3840);
            audioDeviceInterface._decBuffer9 = ByteBuffer.allocateDirect(3840);
            try {
                audioDeviceInterface._decBuffer10 = ByteBuffer.allocateDirect(3840);
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block18;
                string = exception.getMessage();
                QLog.w("TRAE", 0, string);
            }
        }
        AudioDeviceInterface audioDeviceInterface = this;
        audioDeviceInterface._tempBufPlay = new byte[1920];
        audioDeviceInterface._tempBufRec = new byte[1920];
        audioDeviceInterface._traeAudioCodecList = new TraeAudioCodecList();
        int n2 = Build.VERSION.SDK_INT;
        if (QLog.isColorLevel()) {
            string = "AudioDeviceInterface apiLevel:" + n2;
            QLog.w("TRAE", 0, string);
        }
        if (QLog.isColorLevel()) {
            string = " SDK_INT:" + Build.VERSION.SDK_INT;
            QLog.w("TRAE", 0, string);
        }
        if (QLog.isColorLevel()) {
            String string2 = "manufacture:" + Build.MANUFACTURER;
            QLog.w("TRAE", 0, string2);
        }
        if (QLog.isColorLevel()) {
            String string3 = "MODEL:" + Build.MODEL;
            QLog.w("TRAE", 0, string3);
        }
    }

    private int getLowlatencySamplerate() {
        Context context = ((AudioDeviceInterface)((Object)string))._context;
        if (context != null && Build.VERSION.SDK_INT >= 9) {
            boolean bl = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
            if (QLog.isColorLevel()) {
                String string = "TRAE";
                int n2 = 0;
                StringBuilder stringBuilder = new StringBuilder().append("LOW_LATENCY:");
                String string2 = bl ? "Y" : "N";
                QLog.w(string, n2, stringBuilder.append(string2).toString());
            }
            if (Build.VERSION.SDK_INT < 17) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, "API Level too low not support PROPERTY_OUTPUT_SAMPLE_RATE");
                }
                return 0;
            }
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 0, "getLowlatencySamplerate not support right now!");
            }
            return 0;
        }
        if (QLog.isColorLevel()) {
            String string = "getLowlatencySamplerate err, _context:" + ((AudioDeviceInterface)((Object)string))._context + " api:" + Build.VERSION.SDK_INT;
            QLog.e("TRAE", 0, string);
        }
        return 0;
    }

    private int getLowlatencyFramesPerBuffer() {
        Context context = ((AudioDeviceInterface)((Object)string))._context;
        if (context != null && Build.VERSION.SDK_INT >= 9) {
            boolean bl = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
            if (QLog.isColorLevel()) {
                String string = "TRAE";
                int n2 = 0;
                StringBuilder stringBuilder = new StringBuilder().append("LOW_LATENCY:");
                String string2 = bl ? "Y" : "N";
                QLog.w(string, n2, stringBuilder.append(string2).toString());
            }
            if (Build.VERSION.SDK_INT < 17) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, "API Level too low not support PROPERTY_OUTPUT_SAMPLE_RATE");
                }
                return 0;
            }
            return 0;
        }
        if (QLog.isColorLevel()) {
            String string = "getLowlatencySamplerate err, _context:" + ((AudioDeviceInterface)((Object)string))._context + " api:" + Build.VERSION.SDK_INT;
            QLog.e("TRAE", 0, string);
        }
        return 0;
    }

    @TargetApi(value=16)
    private int getAudioSessionId(AudioRecord audioRecord) {
        return 0;
    }

    private int InitSetting(int n2, int n3, int n4, int n5, int n6) {
        ((AudioDeviceInterface)((Object)string))._audioSourcePolicy = n2;
        ((AudioDeviceInterface)((Object)string))._audioStreamTypePolicy = n3;
        ((AudioDeviceInterface)((Object)string))._modePolicy = n4;
        ((AudioDeviceInterface)((Object)string))._deviceStat = n5;
        ((AudioDeviceInterface)((Object)string))._sceneMode = n6;
        n2 = ((AudioDeviceInterface)((Object)string))._deviceStat;
        TraeAudioManager.IsMusicScene = n2 == 1 || n2 == 5 || n2 == 2 || n2 == 3;
        n2 = ((AudioDeviceInterface)((Object)string))._sceneMode;
        TraeAudioManager.IsEarPhoneSupported = n2 == 0 || n2 == 4;
        TraeAudioManager.IsUpdateSceneFlag = true;
        if (QLog.isColorLevel()) {
            String string = "InitSetting: _audioSourcePolicy:" + ((AudioDeviceInterface)((Object)string))._audioSourcePolicy + " _audioStreamTypePolicy:" + ((AudioDeviceInterface)((Object)string))._audioStreamTypePolicy + " _modePolicy:" + ((AudioDeviceInterface)((Object)string))._modePolicy + " DeviceStat:" + n5 + " isSupportVivoKTVHelper:" + isSupportVivoKTVHelper;
            QLog.w("TRAE", 0, string);
        }
        return 0;
    }

    private int InitRecording(int n2, int n3) {
        if (QLog.isColorLevel()) {
            String string = "InitRecording entry:" + n2;
            QLog.w("TRAE", 0, string);
        }
        if (!((AudioDeviceInterface)((Object)string))._isRecording && ((AudioDeviceInterface)((Object)string))._audioRecord == null && n3 <= 2) {
            Object object;
            int n4 = 16;
            if (n3 == 2) {
                n4 = 12;
            }
            int n5 = n2;
            int n6 = AudioRecord.getMinBufferSize((int)n5, (int)n4, (int)2);
            int n7 = n5 * 20 * n3 * 2 / 1000;
            if (QLog.isColorLevel()) {
                object = "InitRecording: min rec buf size is " + n6 + " sr:" + super.getLowlatencySamplerate() + " fp" + super.getLowlatencyFramesPerBuffer() + " 20msFZ:" + n7;
                QLog.w("TRAE", 0, (String)object);
            }
            ((AudioDeviceInterface)((Object)string))._bufferedRecSamples = n2 * 5 / 200;
            if (QLog.isColorLevel()) {
                object = "  rough rec delay set to " + ((AudioDeviceInterface)((Object)string))._bufferedRecSamples;
                QLog.w("TRAE", 0, (String)object);
            }
            if ((object = ((AudioDeviceInterface)((Object)string))._audioRecord) != null) {
                object.release();
                ((AudioDeviceInterface)((Object)string))._audioRecord = null;
            }
            int[] nArray = new int[4];
            Object object2 = object = (Object)nArray;
            object2[0] = (AudioRecord)false;
            object2[1] = (AudioRecord)true;
            object2[2] = (AudioRecord)5;
            object2[3] = (AudioRecord)false;
            nArray[0] = TraeAudioManager.getAudioSource(((AudioDeviceInterface)((Object)string))._audioSourcePolicy);
            int n8 = n6;
            block3: for (int i2 = 0; i2 < ((AudioRecord)object).length && ((AudioDeviceInterface)((Object)string))._audioRecord == null; ++i2) {
                ((AudioDeviceInterface)((Object)string))._audioSource = (int)object[i2];
                for (int i3 = 1; i3 <= 2; ++i3) {
                    Object object3;
                    AudioRecord audioRecord;
                    n8 = n6 * i3;
                    if (n8 < n7 * 4 && i3 < 2) continue;
                    ((AudioDeviceInterface)((Object)string)).nRecordLengthMs = n8 * 500 / (n2 * n3);
                    AudioRecord audioRecord2 = audioRecord;
                    AudioRecord audioRecord3 = audioRecord;
                    int n9 = ((AudioDeviceInterface)((Object)string))._audioSource;
                    try {
                        audioRecord2(n9, n2, n4, 2, n8);
                        ((AudioDeviceInterface)((Object)string))._audioRecord = audioRecord3;
                    }
                    catch (Exception exception) {
                        if (QLog.isColorLevel()) {
                            object3 = exception.getMessage() + " _audioRecord:" + ((AudioDeviceInterface)((Object)string))._audioRecord;
                            QLog.w("TRAE", 0, (String)object3);
                        }
                        if ((object3 = ((AudioDeviceInterface)((Object)string))._audioRecord) != null) {
                            object3.release();
                        }
                        ((AudioDeviceInterface)((Object)string))._audioRecord = null;
                    }
                    if (((AudioDeviceInterface)((Object)string))._audioRecord.getState() == 1) continue block3;
                    if (QLog.isColorLevel()) {
                        object3 = "InitRecording:  rec not initialized,try agine,  minbufsize:" + n8 + " sr:" + n2 + " as:" + ((AudioDeviceInterface)((Object)string))._audioSource;
                        QLog.w("TRAE", 0, (String)object3);
                    }
                    ((AudioDeviceInterface)((Object)string))._audioRecord.release();
                    ((AudioDeviceInterface)((Object)string))._audioRecord = null;
                    continue;
                }
            }
            if (((AudioDeviceInterface)((Object)string))._audioRecord == null) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 0, "InitRecording fail!!!");
                }
                return -1;
            }
            if (QLog.isColorLevel()) {
                String string = " [Config] InitRecording: audioSession:" + ((AudioDeviceInterface)((Object)string))._sessionId + " audioSource:" + ((AudioDeviceInterface)((Object)string))._audioSource + " rec sample rate set to " + n2 + " recBufSize:" + n8 + " nRecordLengthMs:" + ((AudioDeviceInterface)((Object)string)).nRecordLengthMs;
                QLog.w("TRAE", 0, string);
            }
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, "InitRecording exit");
            }
            return ((AudioDeviceInterface)((Object)string))._bufferedRecSamples;
        }
        if (QLog.isColorLevel()) {
            String string = "InitRecording _isRecording:" + ((AudioDeviceInterface)((Object)string))._isRecording;
            QLog.e("TRAE", 0, string);
        }
        return -1;
    }

    private int InitPlayback(int n2, int n3) {
        if (QLog.isColorLevel()) {
            String string = "InitPlayback entry: sampleRate " + n2;
            QLog.w("TRAE", 0, string);
        }
        if (!((AudioDeviceInterface)((Object)string))._isPlaying && ((AudioDeviceInterface)((Object)string))._audioTrack == null && n3 <= 2) {
            AudioManager audioManager;
            Object object;
            if (((AudioDeviceInterface)((Object)string))._audioManager == null) {
                Context context;
                try {
                    AudioDeviceInterface audioDeviceInterface = string;
                    AudioDeviceInterface audioDeviceInterface2 = audioDeviceInterface;
                    context = audioDeviceInterface._context;
                }
                catch (Exception exception) {
                    if (QLog.isColorLevel()) {
                        String string = exception.getMessage();
                        QLog.w("TRAE", 0, string);
                    }
                    return -1;
                }
                audioDeviceInterface2._audioManager = (AudioManager)context.getSystemService("audio");
            }
            ((AudioDeviceInterface)((Object)string))._channelOutType = n3 == 2 ? 12 : 4;
            ((AudioDeviceInterface)((Object)string))._playSamplerate = n2;
            int n4 = AudioTrack.getMinBufferSize((int)n2, (int)((AudioDeviceInterface)((Object)string))._channelOutType, (int)2);
            if (((AudioDeviceInterface)((Object)string))._channelOutType == 12) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 0, "InitPlayback, _channelOutType stero");
                } else if (((AudioDeviceInterface)((Object)string))._channelOutType == 4 && QLog.isColorLevel()) {
                    QLog.w("TRAE", 0, "InitPlayback, _channelOutType Mono");
                }
            }
            int n5 = n2 * 20 * 1 * 2 / 1000;
            if (((AudioDeviceInterface)((Object)string))._channelOutType == 12) {
                n5 *= 2;
            }
            if (QLog.isColorLevel()) {
                object = "InitPlayback: minPlayBufSize:" + n4 + " 20msFz:" + n5;
                QLog.w("TRAE", 0, (String)object);
            }
            ((AudioDeviceInterface)((Object)string))._bufferedPlaySamples = 0;
            object = ((AudioDeviceInterface)((Object)string))._audioTrack;
            if (object != null) {
                object.release();
                ((AudioDeviceInterface)((Object)string))._audioTrack = null;
            }
            String string = string;
            int[] nArray = new int[4];
            object = nArray;
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 3;
            nArray[3] = 1;
            ((AudioDeviceInterface)((Object)string))._streamType = TraeAudioManager.getAudioStreamType(((AudioDeviceInterface)((Object)string))._audioStreamTypePolicy);
            if (((AudioDeviceInterface)((Object)string))._audioRouteChanged) {
                if (QLog.isColorLevel()) {
                    String string2 = "_audioRouteChanged:" + ((AudioDeviceInterface)((Object)string))._audioRouteChanged + " _streamType:" + ((AudioDeviceInterface)((Object)string))._streamType;
                    QLog.w("TRAE", 0, string2);
                }
                ((AudioDeviceInterface)((Object)string))._streamType = ((AudioDeviceInterface)((Object)string))._audioManager.getMode() == 0 && ((AudioDeviceInterface)((Object)string))._connectedDev.equals("DEVICE_SPEAKERPHONE") ? 3 : 0;
                ((AudioDeviceInterface)((Object)string))._audioRouteChanged = false;
            }
            object[0] = (AudioTrack)((AudioDeviceInterface)((Object)string))._streamType;
            int n6 = n4;
            block6: for (int i2 = 0; i2 < ((AudioTrack)object).length && ((AudioDeviceInterface)((Object)string))._audioTrack == null; ++i2) {
                ((AudioDeviceInterface)((Object)string))._streamType = (int)object[i2];
                if (QLog.isColorLevel()) {
                    String string3 = "InitPlayback: min play buf size is " + n4 + " hw_sr:" + AudioTrack.getNativeOutputSampleRate((int)((AudioDeviceInterface)((Object)string))._streamType);
                    QLog.w("TRAE", 0, string3);
                }
                for (int i3 = 1; i3 <= 2; ++i3) {
                    Object object2;
                    AudioTrack audioTrack;
                    n6 = n4 * i3;
                    if (n6 < n5 * 4 && i3 < 2) continue;
                    ((AudioDeviceInterface)((Object)string)).nPlayLengthMs = n6 * 500 / (n2 * n3);
                    AudioTrack audioTrack2 = audioTrack;
                    AudioTrack audioTrack3 = audioTrack;
                    int n7 = ((AudioDeviceInterface)((Object)string))._streamType;
                    int n8 = ((AudioDeviceInterface)((Object)string))._playSamplerate;
                    int n9 = ((AudioDeviceInterface)((Object)string))._channelOutType;
                    try {
                        audioTrack2(n7, n8, n9, 2, n6, 1);
                        ((AudioDeviceInterface)((Object)string))._audioTrack = audioTrack3;
                    }
                    catch (Exception exception) {
                        if (QLog.isColorLevel()) {
                            object2 = exception.getMessage() + " _audioTrack:" + ((AudioDeviceInterface)((Object)string))._audioTrack;
                            QLog.w("TRAE", 0, (String)object2);
                        }
                        if ((object2 = ((AudioDeviceInterface)((Object)string))._audioTrack) != null) {
                            object2.release();
                        }
                        ((AudioDeviceInterface)((Object)string))._audioTrack = null;
                    }
                    if (((AudioDeviceInterface)((Object)string))._audioTrack.getState() == 1) continue block6;
                    if (QLog.isColorLevel()) {
                        object2 = "InitPlayback: play not initialized playBufSize:" + n6 + " sr:" + ((AudioDeviceInterface)((Object)string))._playSamplerate;
                        QLog.w("TRAE", 0, (String)object2);
                    }
                    ((AudioDeviceInterface)((Object)string))._audioTrack.release();
                    ((AudioDeviceInterface)((Object)string))._audioTrack = null;
                    continue;
                }
            }
            if (((AudioDeviceInterface)((Object)string))._audioTrack == null) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 0, "InitPlayback fail!!!");
                }
                return -1;
            }
            Object object3 = ((AudioDeviceInterface)((Object)string))._as;
            if (object3 != null && (audioManager = ((AudioDeviceInterface)((Object)string))._audioManager) != null) {
                object3.voiceCallAudioParamChanged(audioManager.getMode(), ((AudioDeviceInterface)((Object)string))._streamType);
            }
            ((AudioDeviceInterface)((Object)string))._playPosition = ((AudioDeviceInterface)((Object)string))._audioTrack.getPlaybackHeadPosition();
            if (QLog.isColorLevel()) {
                object3 = "InitPlayback exit: streamType:" + ((AudioDeviceInterface)((Object)string))._streamType + " samplerate:" + ((AudioDeviceInterface)((Object)string))._playSamplerate + " _playPosition:" + ((AudioDeviceInterface)((Object)string))._playPosition + " playBufSize:" + n6 + " nPlayLengthMs:" + ((AudioDeviceInterface)((Object)string)).nPlayLengthMs;
                QLog.w("TRAE", 0, (String)object3);
            }
            String string4 = string;
            object3 = ((AudioDeviceInterface)((Object)string4))._audioManager;
            int n10 = ((AudioDeviceInterface)((Object)string4))._connectedDev.equals("DEVICE_BLUETOOTHHEADSET") ? 6 : ((AudioDeviceInterface)((Object)string))._audioTrack.getStreamType();
            TraeAudioManager.forceVolumeControlStream((AudioManager)object3, n10);
            return 0;
        }
        if (QLog.isColorLevel()) {
            String string = "InitPlayback _isPlaying:" + ((AudioDeviceInterface)((Object)string))._isPlaying;
            QLog.e("TRAE", 0, string);
        }
        return -1;
    }

    private int getPlayRecordSysBufferMs() {
        return (this.nRecordLengthMs + this.nPlayLengthMs) * 2;
    }

    private String getDumpFilePath(String string, int n2) {
        String string2;
        if (QLog.isColorLevel()) {
            string2 = "manufacture:" + Build.MANUFACTURER;
            QLog.w("TRAE", 0, string2);
        }
        if (QLog.isColorLevel()) {
            string2 = "MODEL:" + Build.MODEL;
            QLog.w("TRAE", 0, string2);
        }
        String string3 = Environment.getExternalStorageDirectory().getPath() + "/MF-" + Build.MANUFACTURER + "-M-" + Build.MODEL + "-as-" + TraeAudioManager.getAudioSource(((AudioDeviceInterface)((Object)string3))._audioSourcePolicy) + "-st-" + ((AudioDeviceInterface)((Object)string3))._streamType + "-m-" + n2 + "-" + string;
        if (QLog.isColorLevel()) {
            string = "dump:" + (String)string3;
            QLog.w("TRAE", 0, string);
        }
        if (QLog.isColorLevel()) {
            string = "dump replace:" + string3.replace(" ", "_");
            QLog.w("TRAE", 0, string);
        }
        return string3.replace(" ", "_");
    }

    private int StartRecording() {
        block11: {
            int n2;
            String string;
            Object object;
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, "StartRecording entry");
            }
            if (((AudioDeviceInterface)object)._isRecording) {
                if (QLog.isColorLevel()) {
                    object = "StartRecording _isRecording:" + ((AudioDeviceInterface)object)._isRecording;
                    QLog.e("TRAE", 0, (String)object);
                }
                return -1;
            }
            Object object2 = ((AudioDeviceInterface)object)._audioRecord;
            if (object2 == null) {
                if (QLog.isColorLevel()) {
                    object = "StartRecording _audioRecord:" + ((AudioDeviceInterface)object)._audioRecord;
                    QLog.e("TRAE", 0, (String)object);
                }
                return -1;
            }
            try {
                object2.startRecording();
                if (!_dumpEnable) break block11;
                string = "jnirecord.pcm";
                AudioManager audioManager = ((AudioDeviceInterface)object)._audioManager;
                n2 = audioManager != null ? audioManager.getMode() : -1;
            }
            catch (IllegalStateException illegalStateException) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, "StartRecording fail");
                }
                illegalStateException.printStackTrace();
                return -1;
            }
            Object object3 = object;
            Object object4 = object2;
            object4(super.getDumpFilePath(string, n2));
            ((AudioDeviceInterface)object3)._rec_dump = object4;
            try {
                ((AudioDeviceInterface)object3)._rec_out = new FileOutputStream(((AudioDeviceInterface)object)._rec_dump);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        ((AudioDeviceInterface)object)._isRecording = true;
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 0, "StartRecording ok");
        }
        return 0;
    }

    private int StartPlayback() {
        block10: {
            int n2;
            String string;
            if (((AudioDeviceInterface)((Object)string2))._isPlaying) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, "StartPlayback _isPlaying");
                }
                return -1;
            }
            Object object = ((AudioDeviceInterface)((Object)string2))._audioTrack;
            if (object == null) {
                if (QLog.isColorLevel()) {
                    String string2 = "StartPlayback _audioTrack:" + ((AudioDeviceInterface)((Object)string2))._audioTrack;
                    QLog.e("TRAE", 0, string2);
                }
                return -1;
            }
            try {
                object.play();
                if (!_dumpEnable) break block10;
                string = "jniplay.pcm";
                AudioManager audioManager = ((AudioDeviceInterface)((Object)string2))._audioManager;
                n2 = audioManager != null ? audioManager.getMode() : -1;
            }
            catch (IllegalStateException illegalStateException) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, "StartPlayback fail");
                }
                illegalStateException.printStackTrace();
                return -1;
            }
            String string3 = string2;
            Object object2 = object;
            object2(super.getDumpFilePath(string, n2));
            ((AudioDeviceInterface)((Object)string3))._play_dump = object2;
            try {
                ((AudioDeviceInterface)((Object)string3))._play_out = new FileOutputStream(((AudioDeviceInterface)((Object)string2))._play_dump);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        ((AudioDeviceInterface)((Object)string2))._isPlaying = true;
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 0, "StartPlayback ok");
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int StopRecording() {
        AudioRecord audioRecord;
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 0, "StopRecording entry");
        }
        if ((audioRecord = ((AudioDeviceInterface)((Object)string))._audioRecord) == null) {
            if (QLog.isColorLevel()) {
                String string = "UnintRecord:" + ((AudioDeviceInterface)((Object)string))._audioRecord;
                QLog.e("TRAE", 0, string);
            }
            return -1;
        }
        if (audioRecord.getRecordingState() == 3) {
            try {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 0, "StopRecording stop... state:" + ((AudioDeviceInterface)((Object)string))._audioRecord.getRecordingState());
                }
                ((AudioDeviceInterface)((Object)string))._audioRecord.stop();
            }
            catch (IllegalStateException illegalStateException) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, "StopRecording  err");
                }
                illegalStateException.printStackTrace();
                return -1;
            }
        }
        if (QLog.isColorLevel()) {
            String string = "StopRecording releaseing... state:" + ((AudioDeviceInterface)((Object)string))._audioRecord.getRecordingState();
            QLog.w("TRAE", 0, string);
        }
        ((AudioDeviceInterface)((Object)string))._audioRecord.release();
        ((AudioDeviceInterface)((Object)string))._audioRecord = null;
        ((AudioDeviceInterface)((Object)string))._isRecording = false;
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 0, "StopRecording exit ok");
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int StopPlayback() {
        AudioTrack audioTrack;
        if (QLog.isColorLevel()) {
            String string = "StopPlayback entry _isPlaying:" + ((AudioDeviceInterface)((Object)string))._isPlaying;
            QLog.w("TRAE", 0, string);
        }
        if ((audioTrack = ((AudioDeviceInterface)((Object)string))._audioTrack) == null) {
            if (QLog.isColorLevel()) {
                String string = "StopPlayback _isPlaying:" + ((AudioDeviceInterface)((Object)string))._isPlaying + " " + ((AudioDeviceInterface)((Object)string))._audioTrack;
                QLog.e("TRAE", 0, string);
            }
            return -1;
        }
        if (audioTrack.getPlayState() == 3) {
            try {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 0, "StopPlayback stoping...");
                }
                ((AudioDeviceInterface)((Object)string))._audioTrack.stop();
            }
            catch (IllegalStateException illegalStateException) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 0, "StopPlayback err");
                }
                illegalStateException.printStackTrace();
                return -1;
            }
            if (QLog.isColorLevel()) {
                String string = "StopPlayback flushing... state:" + ((AudioDeviceInterface)((Object)string))._audioTrack.getPlayState();
                QLog.w("TRAE", 0, string);
            }
            ((AudioDeviceInterface)((Object)string))._audioTrack.flush();
        }
        if (QLog.isColorLevel()) {
            String string = "StopPlayback releaseing... state:" + ((AudioDeviceInterface)((Object)string))._audioTrack.getPlayState();
            QLog.w("TRAE", 0, string);
        }
        ((AudioDeviceInterface)((Object)string))._audioTrack.release();
        ((AudioDeviceInterface)((Object)string))._audioTrack = null;
        ((AudioDeviceInterface)((Object)string))._isPlaying = false;
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 0, "StopPlayback exit ok");
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int PlayAudio(int var1_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 92[TRYBLOCK] [189 : 1252->1255)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private int OpenslesNeedResetAudioTrack(boolean bl) {
        Throwable throwable2;
        block9: {
            block8: {
                try {
                    if (!TraeAudioManager.isCloseSystemAPM(this._modePolicy)) {
                        return -1;
                    }
                    if (this._audioRouteChanged || bl) {
                        if (this._audioManager == null && this._context != null) {
                            this._audioManager = (AudioManager)this._context.getSystemService("audio");
                        }
                        if (this._audioManager == null) {
                            return 0;
                        }
                        this._audioStreamTypePolicy = this._audioManager.getMode() == 0 && this._connectedDev.equals("DEVICE_SPEAKERPHONE") ? 3 : 0;
                        this._audioRouteChanged = false;
                    }
                    break block8;
                    catch (Throwable throwable2) {
                        break block9;
                    }
                }
                catch (Exception exception) {
                    if (!QLog.isColorLevel()) break block8;
                    QLog.e("TRAE", 0, "PlayAudio Exception: " + exception.getMessage());
                }
            }
            return this._audioStreamTypePolicy;
        }
        throw throwable2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int RecordAudio(int var1_4) {
        block16: {
            var2_5 = 0;
            if (!this._isRecording) {
                if (QLog.isColorLevel() == false) return -1;
                this = "RecordAudio: _isRecording " + this._isRecording;
                QLog.e("TRAE", 0, this);
                return -1;
            }
            if (this._audioRecord == null) {
                return -2;
            }
            if (this._doRecInit) {
            }
            ** GOTO lbl24
            {
                catch (Exception var0_2) {
                    var3_7 = var2_5;
                    break block16;
                }
                try {
                    Process.setThreadPriority((int)-19);
                    ** GOTO lbl23
                }
                catch (Exception var3_6) {}
                {
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 0, "Set rec thread priority failed: " + var3_6.getMessage());
                    }
lbl23:
                    // 4 sources

                    this._doRecInit = false;
lbl24:
                    // 2 sources

                    v0 = this;
                    v0._recBuffer.rewind();
                    var3_7 = v0._audioRecord.read(this._tempBufRec, 0, var1_4);
                    if (var3_7 >= 0) ** GOTO lbl33
                }
            }
            try {
                if (QLog.isColorLevel() == false) return -1;
                QLog.e("TRAE", 0, "Could not read data from sc (read = " + var3_7 + ", length = " + var1_4 + ")");
                return -1;
lbl33:
                // 1 sources

                this._recBuffer.put(this._tempBufRec, 0, var3_7);
                if (AudioDeviceInterface._dumpEnable && this._rec_out != null) {
                    try {
                        this._rec_out.write(this._tempBufRec, 0, var3_7);
                    }
                    catch (IOException v1) {
                        v1.printStackTrace();
                    }
                }
                if (var3_7 == var1_4) return var3_7;
                if (QLog.isColorLevel() == false) return -1;
                QLog.e("TRAE", 0, "Could not read all data from sc (read = " + var3_7 + ", length = " + var1_4 + ")");
                return -1;
            }
            catch (Exception var0_1) {
            }
        }
        if (QLog.isColorLevel() == false) return var3_7;
        QLog.e("TRAE", 0, "RecordAudio Exception: " + var0_3.getMessage());
        return var3_7;
    }

    private int SetPlayoutVolume(int n2) {
        Context context;
        if (this._audioManager == null && (context = this._context) != null) {
            this._audioManager = (AudioManager)context.getSystemService("audio");
        }
        int n3 = -1;
        context = this._audioManager;
        if (context != null) {
            context.setStreamVolume(0, n2, 0);
            n3 = 0;
        }
        return n3;
    }

    private int GetPlayoutVolume() {
        Context context;
        if (this._audioManager == null && (context = this._context) != null) {
            this._audioManager = (AudioManager)context.getSystemService("audio");
        }
        int n2 = -1;
        context = this._audioManager;
        if (context != null) {
            n2 = context.getStreamVolume(0);
        }
        return n2;
    }

    public static String getTraceInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int cfr_ignored_0 = stackTraceElementArray.length;
        stringBuffer.append("").append(stackTraceElementArray[2].getClassName()).append(".").append(stackTraceElementArray[2].getMethodName()).append(": ").append(stackTraceElementArray[2].getLineNumber());
        return stringBuffer.toString();
    }

    public static final void LogTraceEntry(String string) {
        if (!_logEnable) {
            return;
        }
        string = AudioDeviceInterface.getTraceInfo() + " entry:" + string;
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 0, string);
        }
    }

    public static final void LogTraceExit() {
        if (!_logEnable) {
            return;
        }
        String string = AudioDeviceInterface.getTraceInfo() + " exit";
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 0, string);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onOutputChanage(String charSequence, String string) {
        block11: {
            if (QLog.isColorLevel()) {
                String string2 = " onOutputChanage:" + (String)charSequence;
                QLog.w("TRAE", 0, string2);
            }
            AudioDeviceInterface audioDeviceInterface = this;
            audioDeviceInterface.setAudioRouteSwitchState((String)charSequence, string);
            if (!TraeAudioManager.isCloseSystemAPM(audioDeviceInterface._modePolicy)) {
                return;
            }
            int n2 = this._deviceStat;
            if (n2 == 1) return;
            if (n2 == 5) return;
            if (n2 == 2) return;
            if (n2 == 3) {
                return;
            }
            this._connectedDev = charSequence;
            if (QLog.isColorLevel()) {
                String string3 = "TRAE";
                int n3 = 0;
                StringBuilder stringBuilder = new StringBuilder().append(" onOutputChanage:").append((String)charSequence);
                String string4 = this._audioManager == null ? " am==null" : " mode:" + this._audioManager.getMode();
                StringBuilder stringBuilder2 = stringBuilder.append(string4).append(" st:").append(this._streamType);
                string4 = this._audioTrack == null ? "_audioTrack==null" : " at.st:" + this._audioTrack.getStreamType();
                QLog.w(string3, n3, stringBuilder2.append(string4).toString());
            }
            try {
                if (this._audioManager == null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                }
                if (QLog.isColorLevel()) {
                    void var4_15;
                    String string5 = "TRAE";
                    int n4 = 0;
                    charSequence = new StringBuilder().append(" curr mode:").append((String)charSequence);
                    if (this._audioManager == null) {
                        String string6 = "am==null";
                    } else {
                        String string7 = " mode:" + this._audioManager.getMode();
                    }
                    QLog.w(string5, n4, ((StringBuilder)charSequence).append((String)var4_15).toString());
                }
                if (this._audioManager != null && this._connectedDev.equals("DEVICE_SPEAKERPHONE")) {
                    this._audioManager.setMode(0);
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block11;
                String string8 = exception.getMessage();
                QLog.w("TRAE", 0, string8);
            }
        }
        this._audioRouteChanged = true;
    }

    private void setAudioRouteSwitchState(String string, String string2) {
        if (string.equals("DEVICE_EARPHONE")) {
            ((AudioDeviceInterface)((Object)string3)).switchState = 1;
        } else if (string.equals("DEVICE_SPEAKERPHONE")) {
            ((AudioDeviceInterface)((Object)string3)).switchState = 2;
        } else if (string.equals("DEVICE_WIREDHEADSET")) {
            ((AudioDeviceInterface)((Object)string3)).switchState = 3;
        } else if (string.equals("DEVICE_BLUETOOTHHEADSET")) {
            ((AudioDeviceInterface)((Object)string3)).switchState = 4;
            if (!string2.equals("")) {
                ((AudioDeviceInterface)((Object)string3)).deviceConnectedName = string2;
            }
        } else {
            ((AudioDeviceInterface)((Object)string3)).switchState = 0;
        }
        if (((AudioDeviceInterface)((Object)string3)).switchState != 4 && !string2.equals("")) {
            ((AudioDeviceInterface)((Object)string3)).deviceConnectedName = string;
        }
        if (QLog.isColorLevel()) {
            String string3 = "setAudioRouteSwitchState switchState: " + ((AudioDeviceInterface)((Object)string3)).switchState + ", deviceConnectedName: " + ((AudioDeviceInterface)((Object)string3)).deviceConnectedName;
            QLog.w("TRAE", 0, string3);
        }
    }

    private void initTRAEAudioManager() {
        Context context = this._context;
        if (context != null) {
            TraeAudioManager.init(context);
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, "initTRAEAudioManager , TraeAudioSession create");
            }
            if (this._asAudioManager == null) {
                this._asAudioManager = new TraeAudioSession(this._context, new TraeAudioSession.ITraeAudioCallback(){

                    @Override
                    public void onServiceStateUpdate(boolean bl) {
                    }

                    @Override
                    public void onDeviceListUpdate(String[] stringArray, String string, String string2, String string3) {
                        AudioDeviceInterface.access$302(stringArray);
                        if (AudioDeviceInterface.this.usingJava) {
                            AudioDeviceInterface.this.onOutputChanage(string, string3);
                        }
                    }

                    @Override
                    public void onDeviceChangabledUpdate(boolean bl) {
                    }

                    @Override
                    public void onGetDeviceListRes(int n2, String[] stringArray, String string, String string2, String string3) {
                        AudioDeviceInterface.access$302(stringArray);
                        if (AudioDeviceInterface.this.usingJava) {
                            AudioDeviceInterface.this.onOutputChanage(string, string3);
                        }
                    }

                    @Override
                    public void onConnectDeviceRes(int n2, String string, boolean bl) {
                    }

                    @Override
                    public void onIsDeviceChangabledRes(int n2, boolean bl) {
                    }

                    @Override
                    public void onGetConnectedDeviceRes(int n2, String string) {
                    }

                    @Override
                    public void onGetConnectingDeviceRes(int n2, String string) {
                    }

                    @Override
                    public void onRingCompletion(int n2, String string) {
                    }

                    @Override
                    public void onStreamTypeUpdate(int n2) {
                    }

                    @Override
                    public void onGetStreamTypeRes(int n2, int n3) {
                    }

                    @Override
                    public void onVoicecallPreprocessRes(int n2) {
                    }

                    @Override
                    public void onAudioRouteSwitchStart(String string, String string2) {
                    }

                    @Override
                    public void onAudioRouteSwitchEnd(String string, long l2) {
                    }
                });
            }
        }
    }

    private int startService(String string) {
        if (QLog.isColorLevel()) {
            String string2 = "initTRAEAudioManager , TraeAudioSession startService: " + (Object)((Object)((AudioDeviceInterface)this)._asAudioManager) + " deviceConfig:" + string;
            QLog.w("TRAE", 0, string2);
        }
        if ((this = ((AudioDeviceInterface)this)._asAudioManager) != null) {
            return ((TraeAudioSession)((Object)this)).startService(string);
        }
        return -1;
    }

    private int stopService() {
        if (QLog.isColorLevel()) {
            String string = "initTRAEAudioManager , TraeAudioSession stopService: " + (Object)((Object)((AudioDeviceInterface)this)._asAudioManager);
            QLog.w("TRAE", 0, string);
        }
        if ((this = ((AudioDeviceInterface)this)._asAudioManager) != null) {
            return ((TraeAudioSession)((Object)this)).stopService();
        }
        return -1;
    }

    private int SetAudioOutputMode(int n2) {
        if (QLog.isColorLevel()) {
            String string = "TraeAudioSession SetAudioOutputMode: " + n2;
            QLog.w("TRAE", 0, string);
        }
        if (n2 == 0) {
            if (mDeviceList != null && object._asAudioManager != null) {
                n2 = 0;
                block0: do {
                    String[] stringArray;
                    int n3 = 0;
                    while (true) {
                        stringArray = mDeviceList;
                        if (n3 >= mDeviceList.length || n2 != 0) break;
                        if ("DEVICE_WIREDHEADSET".equals(stringArray[n3])) {
                            object._asAudioManager.connectDevice("DEVICE_WIREDHEADSET");
                            n2 = 1;
                            break;
                        }
                        ++n3;
                    }
                    n3 = 0;
                    while (true) {
                        stringArray = mDeviceList;
                        if (n3 >= mDeviceList.length || n2 != 0) break;
                        if ("DEVICE_BLUETOOTHHEADSET".equals(stringArray[n3])) {
                            object._asAudioManager.connectDevice("DEVICE_BLUETOOTHHEADSET");
                            n2 = 1;
                            break;
                        }
                        ++n3;
                    }
                    n3 = 0;
                    while (true) {
                        stringArray = mDeviceList;
                        if (n3 >= mDeviceList.length || n2 != 0) continue block0;
                        if ("DEVICE_EARPHONE".equals(stringArray[n3])) {
                            object._asAudioManager.connectDevice("DEVICE_EARPHONE");
                            n2 = 1;
                            continue block0;
                        }
                        ++n3;
                    }
                } while (n2 == 0);
                return 0;
            }
            return -1;
        }
        if (1 == n2) {
            Object object = object._asAudioManager;
            if (object == null) {
                return -1;
            }
            ((TraeAudioSession)((Object)object)).connectDevice("DEVICE_SPEAKERPHONE");
            return 0;
        }
        return -1;
    }

    private int getAndroidSdkVersion() {
        return Build.VERSION.SDK_INT;
    }

    static boolean isHardcodeOpenSles() {
        if (Build.MANUFACTURER.equals("Xiaomi")) {
            if (Build.MODEL.equals("MI 5")) {
                return true;
            }
            if (Build.MODEL.equals("MI 5s")) {
                return true;
            }
            if (Build.MODEL.equals("MI 5s Plus")) {
                return true;
            }
        } else if (Build.MANUFACTURER.equals("samsung") && Build.MODEL.equals("SM-G9350")) {
            return true;
        }
        return false;
    }

    private int isSupportLowLatency() {
        return 0;
    }

    private int isSupportVivoKTVHelper() {
        Object object = ((AudioDeviceInterface)object)._context;
        if (object != null && (object = (mVivoKTVHelper = VivoKTVHelper.getInstance((Context)object))) != null) {
            isSupportVivoKTVHelper = ((VivoKTVHelper)object).isDeviceSupportKaraoke();
        }
        return isSupportVivoKTVHelper ? 1 : 0;
    }

    private int EnableVivoKTVLoopback(int n2) {
        if (QLog.isColorLevel()) {
            Object object = "EnableVivoKTVLoopback: " + n2 + " isSupportVivoKTVHelper:" + isSupportVivoKTVHelper + " mVivoKTVHelper:" + mVivoKTVHelper;
            QLog.w("TRAE", 0, (String)object);
        }
        if ((object = mVivoKTVHelper) != null && isSupportVivoKTVHelper) {
            ((VivoKTVHelper)object).setPlayFeedbackParam(n2);
            return 0;
        }
        return -1;
    }

    private int isVivoKTVLoopback() {
        VivoKTVHelper vivoKTVHelper = mVivoKTVHelper;
        if (vivoKTVHelper != null && isSupportVivoKTVHelper) {
            return vivoKTVHelper.getPlayFeedbackParam();
        }
        return 0;
    }

    private void uninitTRAEAudioManager() {
        if (this._context != null) {
            TraeAudioSession traeAudioSession;
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, "uninitTRAEAudioManager , stopService");
            }
            if ((traeAudioSession = this._asAudioManager) != null) {
                traeAudioSession.release();
                this._asAudioManager = null;
            }
        } else if (QLog.isColorLevel()) {
            QLog.w("TRAE", 0, "uninitTRAEAudioManager , context null");
        }
    }

    private int OpenMp3File(String string, int n2, int n3) {
        long l2 = n2;
        if (this._traeAudioCodecList.find(l2) == null) {
            TraeAudioCodecList.CodecInfo codecInfo = this._traeAudioCodecList.add(l2);
            codecInfo.audioDecoder.setIOPath(string);
            codecInfo.audioDecoder.setIndex(n2);
            int n4 = codecInfo.audioDecoder.prepare(n3);
            if (n4 != 0) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 0, "openFile mp3 Failed!!!");
                }
                codecInfo.audioDecoder.release();
                codecInfo.audioDecoder = null;
                this._traeAudioCodecList.remove(l2);
                return n4;
            }
            return 0;
        }
        return -1;
    }

    private ByteBuffer getDecBuffer(int n2) {
        switch (n2) {
            default: {
                String string = "getDecBuffer failed!! index:" + n2;
                QLog.w("TRAE", 0, string);
                return null;
            }
            case 10: {
                return ((AudioDeviceInterface)((Object)string))._decBuffer10;
            }
            case 9: {
                return ((AudioDeviceInterface)((Object)string))._decBuffer9;
            }
            case 8: {
                return ((AudioDeviceInterface)((Object)string))._decBuffer8;
            }
            case 7: {
                return ((AudioDeviceInterface)((Object)string))._decBuffer7;
            }
            case 6: {
                return ((AudioDeviceInterface)((Object)string))._decBuffer6;
            }
            case 5: {
                return ((AudioDeviceInterface)((Object)string))._decBuffer5;
            }
            case 4: {
                return ((AudioDeviceInterface)((Object)string))._decBuffer4;
            }
            case 3: {
                return ((AudioDeviceInterface)((Object)string))._decBuffer3;
            }
            case 2: {
                return ((AudioDeviceInterface)((Object)string))._decBuffer2;
            }
            case 1: {
                return ((AudioDeviceInterface)((Object)string))._decBuffer1;
            }
            case 0: 
        }
        return ((AudioDeviceInterface)((Object)string))._decBuffer0;
    }

    private int ReadMp3File(int n2) {
        TraeAudioCodecList.CodecInfo codecInfo = ((AudioDeviceInterface)this)._traeAudioCodecList.find(n2);
        if (codecInfo != null) {
            if ((this = ((AudioDeviceInterface)this).getDecBuffer(n2)) == null) {
                return -1;
            }
            TraeAudioCodecList.CodecInfo codecInfo2 = codecInfo;
            ((ByteBuffer)this).rewind();
            n2 = codecInfo2.audioDecoder.getFrameSize();
            int n3 = codecInfo2.audioDecoder.ReadOneFrame(codecInfo._tempBufdec, n2);
            ((ByteBuffer)this).put(codecInfo._tempBufdec, 0, n2);
            return n3;
        }
        return -1;
    }

    private int CloseMp3File(int n2) {
        long l2 = n2;
        TraeAudioCodecList.CodecInfo codecInfo = this._traeAudioCodecList.find(l2);
        if (codecInfo != null) {
            codecInfo.audioDecoder.release();
            codecInfo.audioDecoder = null;
            this._traeAudioCodecList.remove(l2);
            return 0;
        }
        return -1;
    }

    private int SeekMp3To(int n2, int n3) {
        TraeAudioCodecList.CodecInfo codecInfo = ((AudioDeviceInterface)((Object)codecInfo))._traeAudioCodecList.find(n2);
        if (codecInfo != null) {
            return codecInfo.audioDecoder.SeekTo(n3);
        }
        return 0;
    }

    private int getMp3SampleRate(int n2) {
        TraeAudioCodecList.CodecInfo codecInfo = ((AudioDeviceInterface)((Object)codecInfo))._traeAudioCodecList.find(n2);
        if (codecInfo != null) {
            return codecInfo.audioDecoder.getSampleRate();
        }
        return -1;
    }

    private int getMp3Channels(int n2) {
        TraeAudioCodecList.CodecInfo codecInfo = ((AudioDeviceInterface)((Object)codecInfo))._traeAudioCodecList.find(n2);
        if (codecInfo != null) {
            return codecInfo.audioDecoder.getChannels();
        }
        return -1;
    }

    private long getMp3FileTotalMs(int n2) {
        TraeAudioCodecList.CodecInfo codecInfo = ((AudioDeviceInterface)((Object)codecInfo))._traeAudioCodecList.find(n2);
        if (codecInfo != null) {
            return codecInfo.audioDecoder.getFileTotalMs();
        }
        return -1L;
    }

    static /* synthetic */ boolean access$102(AudioDeviceInterface audioDeviceInterface, boolean bl) {
        audioDeviceInterface._preDone = bl;
        return bl;
    }

    static /* synthetic */ String[] access$302(String[] stringArray) {
        mDeviceList = stringArray;
        return stringArray;
    }

    public void setContext(Context context) {
        this._context = context;
    }

    /*
     * Exception decompiling
     */
    public int call_preprocess() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[UNCONDITIONALDOLOOP]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int call_postprocess() {
        AudioDeviceInterface.LogTraceEntry("");
        this.switchState = 0;
        TraeAudioSession traeAudioSession = this._as;
        if (traeAudioSession != null) {
            traeAudioSession.voiceCallPostprocess();
            this._as.release();
            this._as = null;
        }
        TraeAudioManager.IsUpdateSceneFlag = false;
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    /*
     * Exception decompiling
     */
    public int call_preprocess_media() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[UNCONDITIONALDOLOOP]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int call_postprocess_media() {
        AudioDeviceInterface.LogTraceEntry("");
        ((AudioDeviceInterface)((Object)vivoKTVHelper)).switchState = 0;
        TraeAudioSession traeAudioSession = ((AudioDeviceInterface)((Object)vivoKTVHelper))._as;
        if (traeAudioSession != null) {
            traeAudioSession.release();
            ((AudioDeviceInterface)((Object)vivoKTVHelper))._as = null;
        }
        TraeAudioManager.IsUpdateSceneFlag = false;
        VivoKTVHelper vivoKTVHelper = mVivoKTVHelper;
        if (vivoKTVHelper != null && isSupportVivoKTVHelper) {
            vivoKTVHelper.closeKTVDevice();
        }
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public void setJavaInterface(int n2) {
        ((AudioDeviceInterface)((Object)string)).usingJava = n2 != 0;
        if (QLog.isColorLevel()) {
            String string = "setJavaInterface flg:" + n2;
            QLog.w("TRAE", 0, string);
        }
    }

    public int getAudioRouteSwitchState() {
        return this.switchState;
    }

    public String getAudioDeviceString() {
        return this.deviceConnectedName;
    }

    public int hasLightSensorManager() {
        block7: {
            SensorManager sensorManager;
            AudioDeviceInterface audioDeviceInterface = audioDeviceInterface._context;
            if (audioDeviceInterface == null) {
                return 1;
            }
            try {
                sensorManager = (SensorManager)audioDeviceInterface.getSystemService("sensor");
            }
            catch (Exception exception) {
                if (QLog.isColorLevel()) {
                    String string = exception.getMessage();
                    QLog.w("TRAE", 0, string);
                }
                return 1;
            }
            if (sensorManager.getDefaultSensor(5) != null) break block7;
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 0, "not hasLightSensorManager null == sensor8");
            }
            return 0;
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 0, "hasLightSensorManager");
        }
        return 1;
    }
}

