/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.av.mediacodec;

import android.view.Surface;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.EGLUtil;
import com.tencent.xcast.ExternalOESTexture;
import com.tencent.xcast.GLCanvas;
import com.tencent.xcast.GLES20Canvas;
import com.tencent.xcast.SurfaceTextureHolder;

public class MediaCodecEncodeSurface {
    private static final String TAG = "MediaCodecEncodeCapture";
    private Surface mSurface;
    private ExternalOESTexture mExternalOESTexture;
    private EGLCoreContext mEGLCoreContext;
    private GLCanvas mCanvas;
    private int mTextureWidth;
    private int mTextureHeight;

    private MediaCodecEncodeSurface(Surface surface) {
        MediaCodecEncodeSurface mediaCodecEncodeSurface = this;
        mediaCodecEncodeSurface.mSurface = surface;
        mediaCodecEncodeSurface.mEGLCoreContext = new EGLCore();
        mediaCodecEncodeSurface.mExternalOESTexture = new ExternalOESTexture();
    }

    public int eglSetup() {
        block6: {
            EGLCoreContext eGLCoreContext;
            EGLCoreContext eGLCoreContext2;
            try {
                eGLCoreContext2 = this.mEGLCoreContext;
                eGLCoreContext = EGLUtil.getOffscreenContext();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Platform.logError("createMediaCodecSurface.failed");
                return -1;
            }
            if (!eGLCoreContext2.createContext(eGLCoreContext, true)) break block6;
            if (!this.mEGLCoreContext.createSurface(this.mSurface)) {
                return -1;
            }
            this.mEGLCoreContext.makeCurrent();
            this.mCanvas = new GLES20Canvas();
            return 0;
        }
        throw new IllegalArgumentException("createContext.failed");
    }

    public int eglSwapBuffers(long l2) {
        if (this.mEGLCoreContext.swapBuffers(l2 * 1000L) == 12288) {
            return 0;
        }
        return -1;
    }

    public void setSurfaceTextureHolder(SurfaceTextureHolder surfaceTextureHolder) {
        this.mExternalOESTexture.setSurfaceTextureHolder(surfaceTextureHolder);
    }

    public void setParameters(int n2, int n3, int n4, int n5) {
        MediaCodecEncodeSurface mediaCodecEncodeSurface = this;
        mediaCodecEncodeSurface.mCanvas.setSize(this.mTextureWidth, this.mTextureHeight);
        mediaCodecEncodeSurface.mExternalOESTexture.setSize(n2, n3, this.mTextureWidth, this.mTextureHeight);
        mediaCodecEncodeSurface.mExternalOESTexture.setPadding(n4, n5);
    }

    public void drawOnEncodeSurface(int n2, int n3, int n4, int n5) {
        MediaCodecEncodeSurface mediaCodecEncodeSurface = this;
        this.mTextureWidth = n2 - n4 * 2;
        this.mTextureHeight = n3 - n5 * 2;
        mediaCodecEncodeSurface.setParameters(n2, n3, n4, n5);
        MediaCodecEncodeSurface mediaCodecEncodeSurface2 = this;
        int n6 = mediaCodecEncodeSurface2.mTextureWidth;
        n2 = mediaCodecEncodeSurface2.mTextureHeight;
        mediaCodecEncodeSurface.mCanvas.drawTexture(this.mExternalOESTexture, 0, 0, n6, n2);
    }

    public void release() {
        MediaCodecEncodeSurface mediaCodecEncodeSurface = this;
        mediaCodecEncodeSurface.mCanvas.release();
        mediaCodecEncodeSurface.mCanvas = null;
        mediaCodecEncodeSurface.mSurface.release();
        mediaCodecEncodeSurface.mSurface = null;
        mediaCodecEncodeSurface.mExternalOESTexture.release();
        mediaCodecEncodeSurface.mExternalOESTexture = null;
        mediaCodecEncodeSurface.mEGLCoreContext.release();
        mediaCodecEncodeSurface.mEGLCoreContext = null;
    }
}

