package com.tencent.wecast.sender.cloud.broadcast

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.net.ConnectivityManager
import android.net.NetworkInfo
import android.net.wifi.WifiManager
import android.os.Parcelable

class NetworkChangeReceiver : BroadcastReceiver() {
    private val TAG = "NetworkChangeReceiver"
    private var mOnNetWorkChangeListener: OnNetWorkChangeListener? = null
    private var mWifiConnect: Boolean = false
    private var mCellularConnect: Boolean = false

    interface OnNetWorkChangeListener {
        fun onNetConnected()
        fun onNetDisconnected()
    }

    internal fun addOnNetWorkChangeListener(onNetWorkChangeListener: OnNetWorkChangeListener) {
        this.mOnNetWorkChangeListener = onNetWorkChangeListener
    }

    override fun onReceive(context: Context, intent: Intent) {

        if (WifiManager.NETWORK_STATE_CHANGED_ACTION == intent.action) {
            val parcelableExtra = intent
                    .getParcelableExtra<Parcelable>(WifiManager.EXTRA_NETWORK_INFO)
            if (null != parcelableExtra) {
                val networkInfo = parcelableExtra as NetworkInfo
                val state = networkInfo.state
                val isConnected = state == NetworkInfo.State.CONNECTED
                if (isConnected) {
                    mWifiConnect = true
                    mOnNetWorkChangeListener?.onNetConnected()
                } else {
                    mWifiConnect = false
                    if (!mCellularConnect) {
                        mOnNetWorkChangeListener?.onNetDisconnected()
                    }
                }
            }
        }

        if (ConnectivityManager.CONNECTIVITY_ACTION == intent.action) {
            val manager = context
                    .getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager

            val activeNetwork = manager.activeNetworkInfo
            if (activeNetwork != null) { // connected to the internet
                if (activeNetwork.isConnected) {
                    mOnNetWorkChangeListener?.onNetConnected()
                    mCellularConnect = false
                    mWifiConnect = false
                    if (activeNetwork.type == ConnectivityManager.TYPE_WIFI) {
                        // connected to wifi
                        mWifiConnect = true
                    } else if (activeNetwork.type == ConnectivityManager.TYPE_MOBILE) {
                        // connected to the mobile provider's data plan
                        mCellularConnect = true
                    }
                } else {
                    mOnNetWorkChangeListener?.onNetDisconnected()
                    mWifiConnect = false
                    mCellularConnect = false
                }
            } else {   // not connected to the internet
                mOnNetWorkChangeListener?.onNetDisconnected()
                mWifiConnect = false
                mCellularConnect = false
            }
        }
    }
}