/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sharp.jni;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import com.tencent.avlab.utils.QLog;
import com.tencent.sharp.jni.RingBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AudioDecoder {
    private static final String TAG = "AudioDecoder";
    private String srcPath;
    private MediaCodec mediaDecode = null;
    private MediaExtractor mediaExtractor = null;
    private ByteBuffer[] decodeInputBuffers = null;
    private ByteBuffer[] decodeOutputBuffers = null;
    private MediaCodec.BufferInfo decodeBufferInfo = null;
    private OnCompleteListener onCompleteListener = null;
    private OnProgressListener onProgressListener = null;
    private long fileTotalMs = 0L;
    private RingBuffer decRingBuffer = null;
    int sampleRate = 0;
    int channels = 0;
    int nFrameSize = 3840;
    boolean IsTenFramesReady = false;
    int nFirstThreeFrameInfo = 3;
    int m_nIndex = 0;
    private boolean codeOver = true;

    private int initMediaDecode(int n2) {
        MediaCodec mediaCodec;
        block31: {
            block32: {
                AudioDecoder audioDecoder = this;
                audioDecoder.mediaExtractor = new MediaExtractor();
                audioDecoder.mediaExtractor.setDataSource(this.srcPath);
                if (audioDecoder.mediaExtractor.getTrackCount() <= 1) break block31;
                if (!QLog.isColorLevel()) break block32;
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = stringBuilder.append("m_nIndex: ").append(this.m_nIndex);
                QLog.w("TRAE", 0, stringBuilder2.append(" initMediaDecode mediaExtractor container video, getTrackCount: ").append(this.mediaExtractor.getTrackCount()).toString());
            }
            try {
                this.codeOver = true;
                return -2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.codeOver = true;
                return -1;
            }
        }
        int n3 = 0;
        while (true) {
            block34: {
                RingBuffer ringBuffer;
                MediaFormat mediaFormat;
                String string;
                block33: {
                    if (n3 >= this.mediaExtractor.getTrackCount()) break;
                    MediaFormat mediaFormat2 = this.mediaExtractor.getTrackFormat(n3);
                    string = mediaFormat2.getString("mime");
                    if (!QLog.isColorLevel()) break block33;
                    StringBuilder stringBuilder = new StringBuilder();
                    StringBuilder stringBuilder3 = stringBuilder.append("m_nIndex: ").append(this.m_nIndex);
                    QLog.w("TRAE", 0, stringBuilder3.append(" initMediaDecode mediaExtractor audio type:").append(string).toString());
                }
                if (!string.startsWith("audio/mpeg")) break block34;
                AudioDecoder audioDecoder = this;
                AudioDecoder audioDecoder2 = audioDecoder;
                AudioDecoder audioDecoder3 = audioDecoder;
                AudioDecoder audioDecoder4 = audioDecoder;
                AudioDecoder audioDecoder5 = audioDecoder;
                MediaFormat mediaFormat3 = mediaFormat;
                AudioDecoder audioDecoder6 = this;
                MediaFormat mediaFormat4 = mediaFormat;
                AudioDecoder audioDecoder7 = this;
                MediaFormat mediaFormat5 = mediaFormat;
                this.mediaExtractor.selectTrack(n3);
                MediaCodec mediaCodec2 = this.mediaDecode = MediaCodec.createDecoderByType((String)string);
                mediaCodec2.configure(mediaFormat, null, null, 0);
                audioDecoder7.sampleRate = mediaFormat5.getInteger("sample-rate");
                audioDecoder6.channels = mediaFormat4.getInteger("channel-count");
                long l2 = mediaFormat3.getLong("durationUs");
                audioDecoder2.fileTotalMs = l2 / 1000L;
                int n4 = audioDecoder3.sampleRate * this.channels;
                audioDecoder4.nFrameSize = n4 * 2 * 20 / 1000;
                RingBuffer ringBuffer2 = ringBuffer;
                RingBuffer ringBuffer3 = ringBuffer;
                int n5 = n2 * this.nFrameSize;
                ringBuffer2(n5);
                audioDecoder5.decRingBuffer = ringBuffer3;
                if (!QLog.isColorLevel()) break;
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder4 = stringBuilder.append("m_nIndex: ").append(this.m_nIndex);
                StringBuilder stringBuilder5 = stringBuilder4.append(" initMediaDecode open succeed, mp3 format:(").append(this.sampleRate);
                StringBuilder stringBuilder6 = stringBuilder5.append(",").append(this.channels);
                StringBuilder stringBuilder7 = stringBuilder6.append("), fileTotalMs:").append(this.fileTotalMs);
                QLog.w("TRAE", 0, stringBuilder7.append("ms RingBufferFrame:").append(n2).toString());
                break;
            }
            ++n3;
        }
        if ((mediaCodec = this.mediaDecode) == null) {
            Log.e((String)TAG, (String)("m_nIndex: " + this.m_nIndex + " initMediaDecode create mediaDecode failed"));
            this.codeOver = true;
            return -1;
        }
        if (this.decRingBuffer == null) {
            Log.e((String)TAG, (String)("m_nIndex: " + this.m_nIndex + " initMediaDecode create decRingBuffer failed"));
            this.codeOver = true;
            return -1;
        }
        AudioDecoder audioDecoder = this;
        mediaCodec.start();
        audioDecoder.decodeInputBuffers = audioDecoder.mediaDecode.getInputBuffers();
        audioDecoder.decodeOutputBuffers = audioDecoder.mediaDecode.getOutputBuffers();
        audioDecoder.decodeBufferInfo = new MediaCodec.BufferInfo();
        audioDecoder.codeOver = false;
        audioDecoder.IsTenFramesReady = false;
        audioDecoder.nFirstThreeFrameInfo = 3;
        return 0;
    }

    private void srcAudioFormatToPCM() {
        if (this.decodeInputBuffers.length <= 1) {
            if (QLog.isColorLevel()) {
                String string = "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM decodeInputBuffers.length to small," + this.decodeInputBuffers.length;
                QLog.w("TRAE", 0, string);
            }
            this.codeOver = true;
            return;
        }
        int n2 = this.mediaDecode.dequeueInputBuffer(-1L);
        if (n2 < 0) {
            if (QLog.isColorLevel()) {
                String string = "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM decodeInputBuffers.inputIndex <0";
                QLog.w("TRAE", 0, string);
            }
            this.codeOver = true;
            return;
        }
        int n3 = Build.VERSION.SDK_INT;
        ByteBuffer byteBuffer = n3 >= 21 ? this.mediaDecode.getInputBuffer(n2) : this.decodeInputBuffers[n2];
        byteBuffer.clear();
        int n4 = this.mediaExtractor.readSampleData(byteBuffer, 0);
        if (n4 < 0) {
            if (QLog.isColorLevel()) {
                String string = "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM readSampleData over,end";
                QLog.w("TRAE", 0, string);
            }
            this.codeOver = true;
        } else {
            AudioDecoder audioDecoder = this;
            audioDecoder.mediaDecode.queueInputBuffer(n2, 0, n4, 0L, 0);
            audioDecoder.mediaExtractor.advance();
        }
        int n5 = this.mediaDecode.dequeueOutputBuffer(this.decodeBufferInfo, 10000L);
        while (n5 >= 0) {
            int n6;
            Object object = n3 >= 21 ? this.mediaDecode.getOutputBuffer(n5) : this.decodeOutputBuffers[n5];
            ByteBuffer byteBuffer2 = object;
            byte[] byArray = new byte[this.decodeBufferInfo.size];
            object = byArray;
            try {
                byteBuffer2.get(byArray);
                byteBuffer2.clear();
            }
            catch (Exception exception) {
                if (QLog.isColorLevel()) {
                    String string = "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM wrong outputIndex: " + n5;
                    QLog.w("TRAE", 0, string);
                }
                this.codeOver = true;
                return;
            }
            RingBuffer ringBuffer = this.decRingBuffer;
            if (ringBuffer != null && (n6 = this.decodeBufferInfo.size) > 0) {
                ringBuffer.Push((byte[])object, n6);
                if (this.nFirstThreeFrameInfo-- > 0 && QLog.isColorLevel()) {
                    object = "m_nIndex: " + this.m_nIndex + " DecodeOneFrame size: " + this.decodeBufferInfo.size + " Remain: " + this.decRingBuffer.RemainRead() / this.nFrameSize;
                    QLog.w("TRAE", 0, (String)object);
                }
            }
            AudioDecoder audioDecoder = this;
            audioDecoder.mediaDecode.releaseOutputBuffer(n5, false);
            MediaCodec.BufferInfo bufferInfo = audioDecoder.decodeBufferInfo;
            if (bufferInfo.size > 0) break;
            n5 = this.mediaDecode.dequeueOutputBuffer(bufferInfo, 10000L);
        }
    }

    private void showLog(String string) {
        Log.e((String)"AudioCodec", (String)string);
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public long getFileTotalMs() {
        return this.fileTotalMs;
    }

    public int getFrameSize() {
        return this.nFrameSize;
    }

    public void setIOPath(String string) {
        this.srcPath = string;
    }

    public void setIndex(int n2) {
        this.m_nIndex = n2;
    }

    public int prepare(int n2) {
        if (this.srcPath == null) {
            return -1;
        }
        return this.initMediaDecode(n2);
    }

    public int SeekTo(int n2) {
        MediaExtractor mediaExtractor = ((AudioDecoder)((Object)string)).mediaExtractor;
        if (mediaExtractor != null) {
            long l2 = mediaExtractor.getSampleTime();
            n2 += ((AudioDecoder)((Object)string)).decRingBuffer.RemainRead() * 20 / ((AudioDecoder)((Object)string)).nFrameSize;
            if (QLog.isColorLevel()) {
                String string = "m_nIndex: " + ((AudioDecoder)((Object)string)).m_nIndex + " current PlayMs: " + l2 / 1000L + " SeekTo: " + n2;
                QLog.w("TRAE", 0, string);
            }
            AudioDecoder audioDecoder = string;
            audioDecoder.mediaExtractor.seekTo((long)(n2 * 1000), 2);
            long l3 = audioDecoder.mediaExtractor.getSampleTime();
            n2 = (int)((l3 - l2) / 1000L);
            if (QLog.isColorLevel()) {
                String string = "m_nIndex: " + ((AudioDecoder)((Object)string)).m_nIndex + " total SeekTo time: " + n2 + " t2:" + l3 / 1000L;
                QLog.w("TRAE", 0, string);
            }
            return n2;
        }
        return 0;
    }

    public int ReadOneFrame(byte[] byArray, int n2) {
        int n3 = -1;
        if (!this.IsTenFramesReady) {
            int n4 = 20;
            while (this.decRingBuffer.RemainRead() / this.nFrameSize < 10) {
                int n5 = n4;
                n4 = n5 + -1;
                if (n5 <= 0 || this.codeOver) break;
                this.srcAudioFormatToPCM();
            }
            if (QLog.isColorLevel()) {
                String string = "m_nIndex: " + this.m_nIndex + " 10 FramesReady Remain frame: " + this.decRingBuffer.RemainRead() / this.nFrameSize;
                QLog.w("TRAE", 0, string);
            }
            this.IsTenFramesReady = true;
        }
        int n6 = 20;
        while (!this.codeOver && this.decRingBuffer.RemainRead() / this.nFrameSize < 10) {
            int n7 = n6;
            n6 = n7 + -1;
            if (n7 <= 0) break;
            this.srcAudioFormatToPCM();
        }
        if (this.decRingBuffer.RemainRead() >= n2) {
            this.decRingBuffer.Pop(byArray, n2);
            n3 = n2;
        }
        return n3;
    }

    public void release() {
        MediaCodec mediaCodec = this.mediaDecode;
        if (mediaCodec != null) {
            mediaCodec.stop();
            this.mediaDecode.release();
            this.mediaDecode = null;
        }
        if ((mediaCodec = this.mediaExtractor) != null) {
            mediaCodec.release();
            this.mediaExtractor = null;
        }
        if (this.onCompleteListener != null) {
            this.onCompleteListener = null;
        }
        if (this.onProgressListener != null) {
            this.onProgressListener = null;
        }
        this.showLog("release");
    }

    public void setOnCompleteListener(OnCompleteListener onCompleteListener) {
        this.onCompleteListener = onCompleteListener;
    }

    public void setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
    }

    public static interface OnProgressListener {
        public void progress();
    }

    public static interface OnCompleteListener {
        public void completed();
    }
}

